import {Tooltip} from "react-tooltip";
import {showProModal} from "../ProModal";

const {Button} = wp.components || {};

export default function LiveEditButton({tab = '', isFloating = true}) {
    const isPro = dracula.isPro;

    return (
        <>
            <Button
                data-tooltip-content={!isPro ? wp.i18n.__('PRO Feature') : ''}
                data-tooltip-id={'live-edit'}
                href={`${dracula.homeUrl}?dracula-live-edit=1&tab=${tab}`}
                rel="noopener noreferrer"
                className={`dracula-btn live-edit-btn ${isFloating ? 'floating' : ''} ${!isPro ? 'disabled' : ''}`}
                onClick={(e) => {
                    if (!isPro) {
                        e.preventDefault();

                        showProModal(
                            wp.i18n.__('Upgrade to PRO to customize the dark mode appearance in a real-time preview.', 'dracula-dark-mode'),
                            {
                                id: 'cUizkL-VX3k',
                                title: wp.i18n.__('Dark Mode Appearance Live Edit', 'dracula-dark-mode')
                            }
                        );

                    }
                }}
                target={'_blank'}
                icon={'edit'}
                text={wp.i18n.__('Live Edit', 'dracula-dark-mode')}
                label={wp.i18n.__('Live Edit Dark Mode Appearance', 'dracula-dark-mode')}
            />

            {!isPro &&
                <Tooltip id={'live-edit'} place="left" effect="solid" className="dracula-tooltip" variant="warning"/>}
        </>
    )
}