import SettingsContext from "../../contexts/SettingsContext";
import LiveEditButton from "./LiveEditButton";

const { Button} = wp.components || {};

const {useContext} = React;

export default function Header({title}) {

    const {menu, updateSettings, isLoading} = useContext(SettingsContext);

    return (
        <div className="dracula-settings-content-header">
            <div className="header-title">
                <img src={dracula.pluginUrl + '/assets/images/settings/' + menu + '.svg'}/>
                <span>{title}</span>
            </div>

            <div className="header-actions">
                {!['general', 'advanced', 'reading', 'admin', 'analytics', 'tools'].includes(menu) &&
                    <LiveEditButton tab={menu} isFloating={false}/>}

                <Button
                    className={'dracula-btn btn-primary'}
                    onClick={updateSettings}
                    disabled={isLoading}
                    isBusy={isLoading}
                    icon={isLoading ? <div className="dracula-spinner"></div> : 'dashicons dashicons-saved'}
                    text={isLoading ?  wp.i18n.__('Saving...', 'dracula-dark-mode') : wp.i18n.__('Save Changes', 'dracula-dark-mode')}
                    label={wp.i18n.__('Save Settings', 'dracula-dark-mode')}
                />

            </div>

        </div>
    )
}