import Header from "./Header";
import SettingsContext from "../../contexts/SettingsContext";

const {FormToggle} = wp.components;

const {useContext} = React;

export default function General() {

    const context = useContext(SettingsContext);

    const {data, setData} = context;

    const {
        frontendDarkMode = true,
        defaultDarkMode = false,
        matchOsTheme = true,
    } = data;

    return (
        <div className="dracula-settings-content">

            <Header title={wp.i18n.__('General Settings', 'dracula-dark-mode')}/>

            <div className="settings-field">
                <h4 className={`settings-field-label`}>{wp.i18n.__('Enable Frontend Dark Mode', 'dracula-dark-mode')}</h4>
                <div className="settings-field-content">
                    <FormToggle
                        checked={frontendDarkMode}
                        onChange={() => setData({...data, frontendDarkMode: !frontendDarkMode})}
                    />

                    <p className="description">{wp.i18n.__('Enable/ disable the dark mode on site frontend.', 'dracula-dark-mode')}</p>
                </div>
            </div>

            {/* Default Dark Mode */}
            {frontendDarkMode &&
                <div className="settings-field">
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Default Dark Mode', 'dracula-dark-mode')}</h4>
                    <div className="settings-field-content">
                        <FormToggle
                            checked={defaultDarkMode}
                            onChange={() => setData({...data, defaultDarkMode: !defaultDarkMode})}
                        />

                        <p className="description">{wp.i18n.__('Set the dark mode as the default mode. Visitors will see the dark mode first visit.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/*OS Aware Mode*/}
            {frontendDarkMode &&
                <div className="settings-field">
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Auto Match OS Theme', 'dracula-dark-mode')}</h4>
                    <div className="settings-field-content">
                        <FormToggle
                            checked={matchOsTheme}
                            onChange={() => setData({...data, matchOsTheme: !matchOsTheme})}
                        />

                        <p className="description">{wp.i18n.__('Enable/ disable the OS aware mode. If enabled, the dark mode will be automatically enabled when the user\'s device is in dark mode.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

        </div>
    )
}