import {Tooltip} from "react-tooltip";
import ColorPickerWrapper from "../../includes/ColorPickerWrapper";
import {showProModal} from "../ProModal";

export function CustomColorField({value, onChange, label, description,}) {

    const {isPro} = dracula;

    return (
        <div className={`settings-field ${!isPro ? 'pro-feature' : ''}`}>
            <h4 className={`settings-field-label`}>{label}</h4>

            <div className="settings-field-content">
                <div className="settings-wrap"
                     data-tooltip-content={!isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                     onClick={() => !isPro && showProModal(wp.i18n.__(`Upgrade to PRO to set custom color`, 'dracula-dark-mode'))}
                >
                    <ColorPickerWrapper
                        value={value}
                        onChange={onChange}
                    />

                </div>

                {!isPro && <Tooltip effect="solid" place="left" backgroundColor="#ff9966" className={'dracula-tooltip'}/>}

                <p className="description">{description}</p>
            </div>
        </div>
    )
}