import {Tooltip} from "react-tooltip";
import Header from "./Header";
import SettingsContext from "../../contexts/SettingsContext";
import {handleAnimation, useMounted} from "../../includes/functions";
import LiveEditButton from "./LiveEditButton";
import {showProModal} from "../ProModal";

const {SelectControl} = wp.components;

const {useContext, useEffect} = React;

const {isPro} = dracula;

export default function Animation() {

    const context = useContext(SettingsContext);

    const {data, setData, isLiveEdit} = context;

    const {
        pageTransition = 'none',
    } = data;

    const isMounted = useMounted();

    useEffect(() => {
        if (!isMounted && isLiveEdit) return;

        const selector = isLiveEdit ? '' : '.transition-animation-preview-inner';
        handleAnimation('dark', selector, pageTransition);
    }, [pageTransition]);

    return (
        <div className="dracula-settings-content">

            <Header title={wp.i18n.__('Animation Settings', 'dracula-dark-mode')}/>

            {/* Page Transition Animation */}
            <div className={`settings-field field-transition-animation ${!isPro ? 'pro-feature' : ''}`}>
                <h4 className={`settings-field-label`}>
                    {wp.i18n.__('Page Transition Animation', 'dracula-dark-mode')}
                    {!isPro && <span className="dracula-pro-icon"><i className={`dracula-icon icon-pro`}/></span>}
                </h4>

                <div className={`settings-field-content`}>
                    {!isLiveEdit && <LiveEditButton tab={`animation`}/>}

                    <SelectControl
                        data-tooltip-id={`page-transition-animation`}
                        data-tooltip-content={!isPro ? wp.i18n.__('Pro Feature') : ''}
                        value={pageTransition}
                        options={[
                            {label: wp.i18n.__('None', 'dracula-dark-mode'), value: 'none'},
                            {label: wp.i18n.__('Fade', 'dracula-dark-mode'), value: 'fade'},
                            {label: wp.i18n.__('Scale & Fade', 'dracula-dark-mode'), value: 'scale-fade'},
                            {label: wp.i18n.__('Slide', 'dracula-dark-mode'), value: 'slide'},
                            {label: wp.i18n.__('Rotate', 'dracula-dark-mode'), value: 'rotate'},
                            {label: wp.i18n.__('Flip', 'dracula-dark-mode'), value: 'flip'},
                            {label: wp.i18n.__('Zoom', 'dracula-dark-mode'), value: 'zoom'},
                            {label: wp.i18n.__('Skew', 'dracula-dark-mode'), value: 'skew'},
                            {label: wp.i18n.__('Curtain', 'dracula-dark-mode'), value: 'curtain'},
                            {label: wp.i18n.__('Bounce', 'dracula-dark-mode'), value: 'bounce'},
                            {label: wp.i18n.__('Blur', 'dracula-dark-mode'), value: 'blur'},
                            {label: wp.i18n.__('Twist', 'dracula-dark-mode'), value: 'twist'},
                            {label: wp.i18n.__('Squeeze', 'dracula-dark-mode'), value: 'squeeze'},
                            {label: wp.i18n.__('Wave', 'dracula-dark-mode'), value: 'wave'},
                        ]}
                        onChange={pageTransition => {
                            if (!isPro) {
                                showProModal(wp.i18n.__(`Upgrade to PRO to enable page transition while activating/ deactivating dark mode.`, 'dracula-dark-mode'));
                                return;
                            }
                            setData({...data, pageTransition})
                        }}
                    />

                    {!isPro && <Tooltip id={`page-transition-animation`} variant="warning" place="right" effect="solid" backgroundColor="#ff9966"/>}


                    <p className="description">{wp.i18n.__('Select the animation for dark mode page transition.', 'dracula-dark-mode')}</p>
                </div>

                {(!!isPro && !isLiveEdit) &&
                    <div className="settings-field-sub">
                        <div className={`settings-field transition-animation-preview`}>
                            <h4 className={`settings-field-label`}>{wp.i18n.__('Preview', 'dracula-dark-mode')}</h4>

                            <div className="settings-field-content">
                                <div className={`transition-animation-preview-wrap`}>
                                    <div className={`browser-header`}>
                                        <span className={`browser-header-dot`}></span>
                                        <span className={`browser-header-dot`}></span>
                                        <span className={`browser-header-dot`}></span>
                                    </div>
                                    <div className={`transition-animation-preview-inner`}></div>
                                </div>
                            </div>
                        </div>
                    </div>
                }

            </div>

        </div>
    )
}