import Header from "./Header";
import SettingsContext from "../../contexts/SettingsContext";
import {showProModal} from "../ProModal";
import {Tooltip} from "react-tooltip";

const {FormToggle} = wp.components;
const {useContext} = React;

const {isPro} = dracula;

export default function AnalyticsSettings() {

    const context = useContext(SettingsContext);

    const {data, setData} = context;

    const {
        enableAnalytics,
        enableFeedback,
    } = data;

    return (
        <div className="dracula-settings-content">

            <Header title={wp.i18n.__('Analytics Settings', 'dracula-dark-mode')}/>

            {/* Enable Analytics */}
            <div className={`settings-field ${!isPro ? 'pro-feature' : ''}`}>
                <h4 className={`settings-field-label`}>
                    {wp.i18n.__('Enable Analytics', 'dracula-dark-mode')}
                    {!isPro && <span className="dracula-pro-icon"><i className={`dracula-icon icon-pro`}/></span>}
                </h4>
                <div className="settings-field-content">
                    <FormToggle
                        data-tooltip-id={`enable-analytics`}
                        data-tooltip-content={!isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                        checked={isPro && enableAnalytics}
                        onChange={() => {
                            if (!isPro) {
                                showProModal(wp.i18n.__(`Upgrade to PRO to Enable Analytics`, 'dracula-dark-mode'));
                                return;
                            }

                            setData(data => ({...data, enableAnalytics: !enableAnalytics}));
                        }}
                    />

                    {!isPro && <Tooltip id={`enable-analytics`} variant="warning" effect="solid" place="right" backgroundColor="#ff9966" className={'dracula-tooltip'}/>}


                    <p className="description">{wp.i18n.__('Enable dark mode usage analytics', 'dracula-dark-mode')}</p>
                </div>
            </div>

            {/* Enable User Feedback */}
            {(!isPro || !!enableAnalytics) &&
                <div className={`settings-field ${!isPro ? 'pro-feature' : ''}`}>
                    <h4 className={`settings-field-label`}>
                        {wp.i18n.__('Enable User Feedback', 'dracula-dark-mode')}
                        {!isPro && <span className="dracula-pro-icon"><i className={`dracula-icon icon-pro`}/></span>}
                    </h4>
                    <div className="settings-field-content">
                        <FormToggle
                            data-tooltip-content={!isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            checked={isPro && enableFeedback}
                            onChange={() => {
                                if (!isPro) {
                                    showProModal(wp.i18n.__(`Upgrade to PRO to Enable Analytics`, 'dracula-dark-mode'));
                                    return;
                                }

                                setData(data => ({...data, enableFeedback: !enableFeedback}));
                            }}
                        />

                        {!isPro && <Tooltip effect="solid" place="right" backgroundColor="#ff9966" className={'dracula-tooltip'}/>}

                        <p className="description">
                            {wp.i18n.__('Enable user feedback collection for dark mode usage.', 'dracula-dark-mode')}
                            <br/>
                            {wp.i18n.__('After toggling dark mode 4-5 times, users will be prompted with a feedback form.', 'dracula-dark-mode')}
                        </p>
                    </div>
                </div>
            }


        </div>
    )
}