import { Tooltip } from "react-tooltip";
import Select from 'react-select';
import SettingsContext from "../../contexts/SettingsContext";
import Header from "./Header";
import { showProModal } from "../ProModal";
import AdminToggle from "../AdminToggle";

const {
    __experimentalRadioGroup: RadioGroup,
    __experimentalRadio: Radio,
    FormToggle
} = wp.components;

const { useContext, useEffect } = React;

export default function Admin() {
    const { isPro } = dracula;

    const context = useContext(SettingsContext);

    const { data, setData } = context;

    const {
        adminDarkMode = true,
        adminDarkModePosition = 'adminbar',
        userRoles = ['administrator'],
        classicEditorDarkMode = true,
        blockEditorDarkMode = true,
    } = data;

    useEffect(() => {

        if (adminDarkModePosition === 'floating') {
            let toggleElement = document.querySelector('.dracula-toggle-wrap');

            if (!toggleElement) {
                const draculaToggleWrap = document.createElement('div');
                draculaToggleWrap.className = 'dracula-toggle-wrap floating position-right';

                const wpFooter = document.querySelector('#wpfooter');

                if (wpFooter) {
                    wpFooter.parentNode.insertBefore(draculaToggleWrap, wpFooter);
                }

                toggleElement = document.querySelector('.dracula-toggle-wrap');
            }

            // hide admin bar toggle
            const adminToggleElement = document.querySelector('#wp-admin-bar-dracula .dracula-toggle');
            if (adminToggleElement) {
                adminToggleElement.style.display = 'none';
            }

            // display admin bar toggle
            const adminFloatingToggleElement = document.querySelector('.dracula-toggle-wrap');
            if (adminFloatingToggleElement) {
                adminFloatingToggleElement.style.display = 'block';
            }

            // render admin floating toggle
            if (toggleElement) {
                ReactDOM.render(<AdminToggle type={adminDarkModePosition} />, toggleElement);
            }

        } else {

            // hide admin bar toggle
            const adminFloatingToggleElement = document.querySelector('.dracula-toggle-wrap');
            if (adminFloatingToggleElement) {
                adminFloatingToggleElement.style.display = 'none';
            }

            // display admin bar toggle
            const adminToggleElement = document.querySelector('#wp-admin-bar-dracula .dracula-toggle');
            if (adminToggleElement) {
                adminToggleElement.style.display = 'block';
            }

            const toggleElement = document.getElementById('wp-admin-bar-dracula');

            // render admin toggle
            if (toggleElement) {
                ReactDOM.render(<AdminToggle type={adminDarkModePosition} />, toggleElement);
            }
        }

    }, [adminDarkModePosition]);

    const userRolesOptions = Object.keys(dracula.userRoles).map(key => ({ value: key, label: dracula.userRoles[key] }));

    return (
        <div className="dracula-settings-content">

            <Header title={wp.i18n.__('Admin Dark Mode Settings', 'dracula-dark-mode')} />

            {/* Admin Dark Mode */}
            <div className="settings-field">
                <h4 className={`settings-field-label`}>{wp.i18n.__('Enable Admin Dark Mode', 'dracula-dark-mode')}</h4>
                <div className="settings-field-content">
                    <FormToggle
                        checked={adminDarkMode}
                        onChange={() => setData({ ...data, adminDarkMode: !adminDarkMode })}
                    />

                    <p className="description">
                        {wp.i18n.__('Enable/ disable the dark mode in the backend dashboard for the site admins.', 'dracula-dark-mode')}
                    </p>
                    <p className="description">
                        {wp.i18n.__('A new Dark Mode color scheme will be added to the admin color scheme settings in the user profile edit page.', 'dracula-dark-mode')}
                    </p>
                </div>
            </div>

            {/* Admin Dark Mode Position */}
            {adminDarkMode &&
                <div className={`settings-field align-base`}>
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Admin Dark Mode Position', 'dracula-dark-mode')}</h4>

                    <div className="settings-field-content">
                        <RadioGroup
                            onChange={adminDarkModePosition => {
                                setData({ ...data, adminDarkModePosition });
                            }}
                            checked={adminDarkModePosition}
                            className={'dracula-radio-group'}
                        >
                            <Radio value="floating">
                                <span>{wp.i18n.__('Floating ', 'dracula-dark-mode')}</span>
                            </Radio>
                            <Radio value="adminbar">
                                <span>{wp.i18n.__('Admin Bar', 'dracula-dark-mode')}</span>
                            </Radio>
                        </RadioGroup>

                        <p className="description">
                            {wp.i18n.__('Set admin dark monde position for display Admin Dark Mode Toggle Button in Dashboard.', 'dracula-dark-mode')}
                        </p>
                    </div>
                </div>
            }

            {/* Classic Editor Dark Mode*/}
            {adminDarkMode &&
                <div className="settings-field">
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Classic Editor Dark Mode', 'dracula-dark-mode')}</h4>
                    <div className="settings-field-content">
                        <FormToggle
                            checked={classicEditorDarkMode}
                            onChange={() => setData({ ...data, classicEditorDarkMode: !classicEditorDarkMode })}
                        />

                        <p className="description">{wp.i18n.__('Enable/ disable the dark mode in the classic editor.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Block Editor Dark Mode*/}
            {adminDarkMode &&
                <div className="settings-field">
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Block Editor Dark Mode', 'dracula-dark-mode')}</h4>
                    <div className="settings-field-content">
                        <FormToggle
                            checked={blockEditorDarkMode}
                            onChange={() => setData({ ...data, blockEditorDarkMode: !blockEditorDarkMode })}
                        />

                        <p className="description">{wp.i18n.__('Enable/ disable the dark mode in the block editor.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

            {/* Dark Mode User Roles */}
            {adminDarkMode &&
                <div className={`settings-field ${!isPro ? 'pro-feature' : ''}`}>
                    <h4 className={`settings-field-label`}>{wp.i18n.__('Dark Mode User Roles', 'dracula-dark-mode')}</h4>

                    <div className="settings-field-content">
                        <div className="settings-wrap"
                            data-tooltip-content={!isPro ? wp.i18n.__('PRO Feature', 'dracula-dark-mode') : ''}
                            onClick={() => !isPro && showProModal()}>
                            <Select
                                isDisabled={!isPro}
                                options={userRolesOptions}
                                value={userRolesOptions.filter(item => userRoles.includes(item.value))}
                                onChange={selected => {

                                    if (!isPro) {
                                        showProModal();
                                        return;
                                    }

                                    setData({ ...data, userRoles: selected.map(item => item.value) });
                                }}
                                className={`dracula-select`}
                                isMulti
                                isClearable={false}
                                styles={{
                                    multiValue: (base, state) => {
                                        return state.data.value === 'administrator' ? {
                                            ...base,
                                            backgroundColor: "gray"
                                        } : base;
                                    },
                                    multiValueLabel: (base, state) => {
                                        return state.data.value === 'administrator'
                                            ? { ...base, fontWeight: "bold", color: "white", paddingRight: 6 }
                                            : base;
                                    },
                                    multiValueRemove: (base, state) => {
                                        return state.data.value === 'administrator' ? { ...base, display: "none" } : base;
                                    }
                                }}
                            />
                        </div>

                        {!isPro && <Tooltip effect="solid" place="right" backgroundColor="#ff9966" className={'dracula-tooltip'} />}

                        <p className="description">{wp.i18n.__('Select the user roles that can use the dark mode in the backend dashboard.', 'dracula-dark-mode')}</p>
                    </div>
                </div>
            }

        </div>
    )
}