import fonts from "../../includes/google-fonts.json";

import Select from "react-select";

const {
    __experimentalRadioGroup: RadioGroup,
    __experimentalRadio: Radio,
} = wp.components;

import {isVisible} from "../../includes/functions";

const {useState} = wp.element;

export default function Appearance({data, setData}) {
    const systemFonts = fonts.filter(font => font.category);
    const googleFonts = fonts.filter(font => !font.category);

    const fontOptions = [
        {
            label: 'System Fonts',
            options: [{value: 'system', label: 'System'}, ...systemFonts],
        },
        {
            label: 'Google Fonts',
            options: googleFonts,
        }
    ];

    const [loaded, setLoaded] = useState([]);

    const {
        contentWidth = 'medium',
        theme = 'system',
        fontFamily = 'System',
        fontSize = '1',
    } = data;


    return (
        <>
            {/*Content Width*/}
            <div className="settings-field field-content-width">
                <span className="label">{wp.i18n.__('Content Width :', 'dracula-dark-mode')}</span>

                <div className="settings-field-content">
                    <RadioGroup label="Content Width"
                                onChange={contentWidth => {
                                    setData({...data, contentWidth});
                                    localStorage.setItem("reading-mode-content-width", contentWidth);
                                }}
                                checked={contentWidth}>
                        <Radio value="small">{wp.i18n.__('Small', 'dracula-dark-mode')}</Radio>
                        <Radio value="medium">{wp.i18n.__('Medium', 'dracula-dark-mode')}</Radio>
                        <Radio value="large">{wp.i18n.__('Large', 'dracula-dark-mode')}</Radio>
                    </RadioGroup>
                </div>
            </div>

            {/* Theme */}
            <div className="settings-field">
                <span className="label">{wp.i18n.__('Theme : ', 'dracula-dark-mode')}</span>

                <div className="settings-field-content">
                    <RadioGroup label="Color Theme"
                                onChange={theme => {
                                    setData({...data, theme});
                                    localStorage.setItem("reading-mode-theme", theme);
                                }}
                                checked={theme}>
                        <Radio value="light">
                            <span className="theme-option-icon icon-light"></span>
                            <span>{wp.i18n.__('Light', 'dracula-dark-mode')}</span>
                        </Radio>
                        <Radio value="dark">
                            <span className="theme-option-icon icon-dark"></span>
                            <span>{wp.i18n.__('Dark', 'dracula-dark-mode')}</span>
                        </Radio>
                        <Radio value="system">
                            <span className="theme-option-icon icon-system"></span>
                            <span>{wp.i18n.__('System', 'dracula-dark-mode')}</span>
                        </Radio>
                    </RadioGroup>
                </div>
            </div>

            {/*Font Family*/}
            <div className="settings-field">
                <span className="label">{wp.i18n.__('Font Family', 'dracula-dark-mode')}</span>
                <div className="settings-field-content">
                    <Select
                        options={fontOptions}
                        value={fonts.find(item => item.label === fontFamily)}
                        onChange={selected => {
                            setData({...data, fontFamily: selected.label});
                            localStorage.setItem("reading-mode-font-family", selected.label);
                        }}
                        className={`reading-mode-select select-font-family`}
                        classNamePrefix={`reading-mode-select`}
                        onMenuOpen={() => {

                            setTimeout(() => {
                                const $ = jQuery;

                                $('.reading-mode-select__menu-list').on('scroll', function () {
                                    $('.reading-mode-select__option').each((index, element) => {

                                        if (isVisible(element, this)) {
                                            const fontFamily = $(element).text();
                                            const id = `${fontFamily.replace(/ /g, '-')}-font`;

                                            $(element).css('font-family', fontFamily);

                                            if (!$(`#${id}`).length) {

                                                if (!loaded.includes(fontFamily)) {
                                                    setLoaded(loaded => [...loaded, fontFamily]);
                                                    // Load font family
                                                    $('head').append(`<link href="https://fonts.googleapis.com/css?family=${fontFamily.replace(/ /g, '+')}" rel="stylesheet" id="${id}" >`);
                                                }
                                            }
                                        }

                                    });
                                });

                            }, 10);
                        }}

                        onMenuClose={() => {
                            const $ = jQuery;
                            $('.reading-mode-select__menu-list').off('scroll');
                            setLoaded([]);
                        }}

                        styles={{
                            singleValue: (base, {data}) => ({
                                ...base,
                                fontFamily: data.label,
                                fontSize: '1.1rem',
                            }),
                        }}

                    />

                    <p className="description">{wp.i18n.__('Choose the font family for the reading mode.', 'dracula-dark-mode')}</p>
                </div>
            </div>

            {/*  Font Size */}
            <div className="settings-field">
                <span className="label">{wp.i18n.__('Font Size : ', 'dracula-dark-mode')}</span>
                <div className="settings-field-content">

                    <RadioGroup label="Toggle Position"
                                onChange={fontSize => {
                                    setData({...data, fontSize});
                                    localStorage.setItem("reading-mode-font-size", fontSize);
                                }}
                                checked={fontSize}>
                        <Radio value=".75">{wp.i18n.__('Small', 'dracula-dark-mode')}</Radio>
                        <Radio value="1">{wp.i18n.__('Medium', 'dracula-dark-mode')}</Radio>
                        <Radio value="1.2">{wp.i18n.__('Large', 'dracula-dark-mode')}</Radio>
                    </RadioGroup>

                </div>
            </div>
        </>
    )
}