export default function Menu({menu, setMenu}) {

    const items = [
        {
            key: 'colors',
            title: wp.i18n.__('Colors', 'dracula-dark-mode'),
        },
        {
            key: 'adjustments',
            title: wp.i18n.__('Adjustments', 'dracula-dark-mode'),
        },
        {
            key: 'toggle',
            title: wp.i18n.__('Toggle Switch', 'dracula-dark-mode'),
        },
        {
            key: 'animation',
            title: wp.i18n.__('Animation', 'dracula-dark-mode'),
        },
        {
            key: 'typography',
            title: wp.i18n.__('Typography', 'dracula-dark-mode'),
        },

        {
            key: 'excludes',
            title: wp.i18n.__('Excludes Elements', 'dracula-dark-mode'),
        },
        {
            key: 'images',
            title: wp.i18n.__('Image Settings', 'dracula-dark-mode'),
        },
        {
            key: 'videos',
            title: wp.i18n.__('Video Settings', 'dracula-dark-mode'),
        },
        {
            key: 'css',
            title: wp.i18n.__('Custom CSS', 'dracula-dark-mode'),
        }
    ]

    return (
        <div className="dracula-live-edit-menu">
            {
                items.map(item => {
                    const {key, title} = item;
                    const isActive = menu === key;
                    return (
                        !!menu && !isActive ? null :
                            <div className={`dracula-live-edit-menu-item ${isActive ? 'active' : ''}`} key={key}
                                 onClick={() => {
                                     setMenu(isActive ? '' : key)
                                 }}>
                                <img src={dracula.pluginUrl + '/assets/images/settings/' + key + '.svg'}/>
                                <span>{title}</span>
                                <i className={`dashicons dashicons-arrow-${isActive ? 'up' : 'down'}`}></i>
                            </div>
                    );
                })
            }
        </div>
    )
}