import {Tooltip} from "react-tooltip";
import SettingsContext from "../../contexts/SettingsContext";
import {saveSettings} from "../../includes/functions";

const {useState, useContext} = React;

export default function Header({setMenu, handleMouseDown}) {

    const {menu, data} = useContext(SettingsContext);

    const {options, edit_mode, pageId, pageType} = dracula.editDetails;

    const [editMode, setEditMode] = useState(edit_mode);
    const [isSaving, setIsSaving] = useState(false);

    const updateSettings = () => {
        setIsSaving(true);

        saveSettings({...data, editMode, pageId, pageType}).then(() => setIsSaving(false));
    }

    const types = [
        {
            key: 'single',
            label: wp.i18n.__('Current Page', 'dracula-dark-mode'),
            description: wp.i18n.__('Apply the settings to the current page only.', 'dracula-dark-mode'),
            icon: <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path
                    d="M19.9765 0H4.02353C1.8 0 0 1.8 0 4.02353V19.9765C0 22.2 1.8 24 4.02353 24H19.9765C22.2 24 24 22.2 24 19.9765V4.02353C24 1.8 22.2 0 19.9765 0ZM11.3294 2.22353C11.9647 2.22353 12.4588 2.71765 12.4588 3.35294C12.4588 3.98824 11.9647 4.48235 11.3294 4.48235C10.6941 4.48235 10.2 3.98824 10.2 3.35294C10.2 2.71765 10.6941 2.22353 11.3294 2.22353ZM7.83529 2.22353C8.47059 2.22353 8.96471 2.71765 8.96471 3.35294C8.96471 3.98824 8.47059 4.48235 7.83529 4.48235C7.2 4.48235 6.70588 3.98824 6.70588 3.35294C6.70588 2.71765 7.2 2.22353 7.83529 2.22353ZM4.34118 2.22353C4.97647 2.22353 5.47059 2.71765 5.47059 3.35294C5.47059 3.98824 4.97647 4.48235 4.34118 4.48235C3.70588 4.48235 3.21176 3.98824 3.21176 3.35294C3.21176 2.71765 3.70588 2.22353 4.34118 2.22353ZM4.76471 8.82353H13.9412C14.8235 8.82353 15.5294 9.52941 15.5294 10.4118C15.5294 11.2941 14.8235 12 13.9412 12H4.76471C3.88235 12 3.17647 11.2941 3.17647 10.4118C3.17647 9.52941 3.91765 8.82353 4.76471 8.82353ZM17.7529 17.7882H4.90588C4.02353 17.7882 3.31765 17.0824 3.31765 16.2C3.31765 15.3176 4.02353 14.6118 4.90588 14.6118H17.7176C18.6 14.6118 19.3059 15.3176 19.3059 16.2C19.3059 17.0824 18.6353 17.7882 17.7529 17.7882Z"
                    fill="#675ED5"/>
            </svg>,
        },
        {
            key: 'template',
            label: wp.i18n.__('Template', 'dracula-dark-mode'),
            description: wp.i18n.__('Apply the settings to all pages of current post type.', 'dracula-dark-mode'),
            icon: <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path
                    d="M6.83401 21.9187C4.2753 21.9187 2.20243 19.8374 2.20243 17.2683V3.83738C2.20243 3.2195 2.33198 2.60161 2.5587 2.04877C1.06883 2.53657 0 3.93495 0 5.59348V20.2927C0 22.3414 1.65182 24 3.69231 24H18.332C19.8866 24 21.247 23.0244 21.7652 21.626C21.2794 21.7886 20.7611 21.9187 20.2105 21.9187H6.83401Z"
                    fill="#675ED5"/>
                <path
                    d="M20.4373 0H7.67612C5.7328 0 4.14575 1.5935 4.14575 3.54472V16.3902C4.14575 18.3415 5.7328 19.935 7.67612 19.935H20.4696C22.413 19.935 24 18.3415 24 16.3902V3.54472C23.9676 1.5935 22.413 0 20.4373 0ZM13.5061 1.85366C14.0243 1.85366 14.4453 2.27642 14.4453 2.79675C14.4453 3.31707 14.0243 3.73984 13.5061 3.73984C12.9879 3.73984 12.5668 3.31707 12.5668 2.79675C12.5668 2.27642 12.9879 1.85366 13.5061 1.85366ZM10.6235 1.85366C11.1417 1.85366 11.5628 2.27642 11.5628 2.79675C11.5628 3.31707 11.1417 3.73984 10.6235 3.73984C10.1053 3.73984 9.68421 3.31707 9.68421 2.79675C9.68421 2.27642 10.1053 1.85366 10.6235 1.85366ZM7.7085 1.85366C8.22672 1.85366 8.64778 2.27642 8.64778 2.79675C8.64778 3.31707 8.22672 3.73984 7.7085 3.73984C7.19029 3.73984 6.76923 3.31707 6.76923 2.79675C6.76923 2.27642 7.19029 1.85366 7.7085 1.85366ZM8.09717 7.31707H15.6761C16.3887 7.31707 16.9717 7.90244 16.9717 8.61789C16.9717 9.33333 16.3887 9.9187 15.6761 9.9187H8.09717C7.38462 9.9187 6.80162 9.33333 6.80162 8.61789C6.80162 7.90244 7.35223 7.31707 8.09717 7.31707ZM18.8178 14.7642H8.19433C7.48178 14.7642 6.89879 14.1789 6.89879 13.4634C6.89879 12.748 7.48178 12.1626 8.19433 12.1626H18.7854C19.498 12.1626 20.081 12.748 20.081 13.4634C20.081 14.1789 19.5304 14.7642 18.8178 14.7642Z"
                    fill="#675ED5"/>
            </svg>,
        },
        {
            key: 'global',
            label: wp.i18n.__('Global', 'dracula-dark-mode'),
            description: wp.i18n.__('Apply the settings to the entire website.', 'dracula-dark-mode'),
            icon:
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path
                        d="M12.0102 15.2838C10.6045 15.2838 9.19873 15.2701 7.79299 15.2974C7.38355 15.3111 7.26072 15.1747 7.23343 14.7657C7.06965 12.9249 7.06965 11.0978 7.23343 9.25708C7.27437 8.86166 7.36991 8.72531 7.79299 8.72531C10.6045 8.73895 13.4296 8.73895 16.2411 8.72531C16.6505 8.72531 16.7733 8.84803 16.8006 9.25708C16.9644 11.0978 16.9644 12.9249 16.8006 14.752C16.7597 15.1474 16.6642 15.2974 16.2411 15.2838C14.8217 15.2565 13.4159 15.2838 12.0102 15.2838Z"
                        fill="#675ED5"/>
                    <path
                        d="M16.3366 6.54369C13.4296 6.54369 10.5908 6.54369 7.67017 6.54369C8.14784 4.45753 8.77565 2.48044 10.2496 0.89877C11.4097 -0.328387 12.6653 -0.301116 13.8117 0.994216C15.2311 2.54861 15.8453 4.4848 16.3366 6.54369Z"
                        fill="#675ED5"/>
                    <path
                        d="M16.3366 17.479C15.8999 19.3879 15.313 21.2014 14.0847 22.7422C12.7609 24.4193 11.2596 24.4193 9.93575 22.7422C8.70743 21.2014 8.12057 19.3879 7.68384 17.479C10.5772 17.479 13.4296 17.479 16.3366 17.479Z"
                        fill="#675ED5"/>
                    <path
                        d="M2.68865 15.2838C2.14273 15.2838 1.59681 15.2429 1.05089 15.2974C0.573214 15.3383 0.382142 15.1883 0.286607 14.7111C-0.0955356 12.9113 -0.0955356 11.1114 0.286607 9.31161C0.382142 8.86166 0.559566 8.69804 1.03724 8.71167C2.21097 8.75258 3.39834 8.73894 4.58571 8.71167C4.9815 8.69804 5.09068 8.82075 5.04974 9.20253C4.84502 11.0569 4.84502 12.9113 5.04974 14.7656C5.09068 15.1338 5.0088 15.2974 4.59936 15.2701C3.9579 15.2565 3.31645 15.2838 2.68865 15.2838Z"
                        fill="#675ED5"/>
                    <path
                        d="M21.2226 15.2838C20.6084 15.2838 19.9943 15.2565 19.3801 15.2974C18.998 15.3247 18.9161 15.1747 18.957 14.8338C19.1618 12.9522 19.1618 11.0705 18.957 9.20252C18.9161 8.86165 18.998 8.7253 19.3801 8.73893C20.6221 8.7662 21.8777 8.7662 23.1197 8.73893C23.4472 8.73893 23.5701 8.83438 23.6519 9.16162C24.116 11.0705 24.116 12.9658 23.6519 14.8747C23.5701 15.202 23.4472 15.311 23.1197 15.2974C22.4919 15.2565 21.8504 15.2838 21.2226 15.2838Z"
                        fill="#675ED5"/>
                    <path
                        d="M16.7324 1.1033C19.3665 2.12593 21.2772 3.9803 22.6966 6.55733C21.3318 6.55733 20.0625 6.57097 18.7796 6.5437C18.3702 6.5437 18.493 6.12101 18.4521 5.90285C18.0836 4.23937 17.524 2.6577 16.7324 1.1033Z"
                        fill="#675ED5"/>
                    <path
                        d="M1.31006 6.55732C2.62026 4.103 4.43544 2.34408 6.86477 1.17146C6.97396 1.11692 7.08314 1.04875 7.17868 1.13056C7.31515 1.25327 7.20597 1.37599 7.15138 1.48507C6.34615 2.97129 5.85482 4.55296 5.48633 6.18917C5.43174 6.40733 5.41809 6.55732 5.13148 6.55732C3.88952 6.54368 2.64756 6.55732 1.31006 6.55732Z"
                        fill="#675ED5"/>
                    <path
                        d="M7.19242 22.9467C5.00875 22.1968 2.3474 19.7288 1.36475 17.4654C2.63401 17.4654 3.86232 17.479 5.09064 17.4518C5.50007 17.4381 5.44548 17.7108 5.50007 17.929C5.89586 19.647 6.44178 21.3105 7.31525 22.8512C7.27431 22.8785 7.23336 22.9194 7.19242 22.9467Z"
                        fill="#675ED5"/>
                    <path
                        d="M16.7324 22.9331C17.5786 21.3105 18.1382 19.6061 18.5203 17.8472C18.5885 17.5336 18.7114 17.4518 18.998 17.4654C20.199 17.479 21.4 17.4654 22.6966 17.4654C21.3045 20.0288 19.3801 21.8695 16.7324 22.9331Z"
                        fill="#675ED5"/>
                </svg>,
        }
    ].filter(({key}) => options.includes(key));

    // Handle type tooltip
    const [isTooltipOpen, setTooltipOpen] = useState(false);

    return (
        <div className="dracula-live-edit-header">
            <i
                className={`dashicons dashicons-${!!menu ? 'menu-alt' : 'no-alt'}`}
                onClick={() => {

                    if (menu) {
                        setMenu('');
                    } else {
                        sessionStorage.removeItem('dracula-live-edit');
                        document.getElementById('dracula-live-edit').remove();

                        // Remove dracula-live-edit query from URL
                        const url = new URL(window.location.href);
                        url.searchParams.delete('dracula-live-edit');
                        window.history.pushState({}, '', url.toString());
                    }
                }}
            ></i>


            <div className="customize-type-wrap">
                <div
                    className="selected-type"
                    onClick={() => setTooltipOpen(!isTooltipOpen)}
                >
                    <span>{types.find(type => type.key === editMode).label}</span>
                    <i className="dashicons dashicons-arrow-down-alt2"></i>
                </div>


                <Tooltip
                    anchorSelect={`.selected-type`}
                    isOpen={isTooltipOpen}
                    setIsOpen={setTooltipOpen}
                    openEvents={['click']}
                    place="bottom"
                    variant="light"
                    clickable={true}
                    resizeHide={false}
                    className="dracula-tooltip"
                >
                    <div className="customize-types">
                        {types.map(type => (
                            <div
                                key={type.key}
                                className={`type-item ${editMode === type.key ? 'active' : ''}`}
                                onClick={() => {
                                    setEditMode(type.key);

                                    setTooltipOpen(false);
                                }}
                            >

                                <span className="type-icon">{type.icon}</span>

                                <div className="item-content">
                                    <span className="item-label">{type.label}</span>
                                    <span className="item-description">{type.description}</span>
                                </div>
                            </div>
                        ))}
                    </div>
                </Tooltip>
            </div>

            <i onMouseDown={handleMouseDown}
               onTouchStart={handleMouseDown}
               className="drag-handle dashicons dashicons-move"></i>

            <button type={'button'} className={'igd-btn btn-primary'} onClick={updateSettings}>
                {isSaving ? <div className="dracula-spinner"></div> : <i className="dashicons dashicons-saved"></i>}
                <span>{isSaving ? wp.i18n.__('Saving..', 'dracula-dark-mode') : wp.i18n.__('Save', 'dracula-dark-mode')}</span>
            </button>
        </div>
    )
}