import {motion} from "framer-motion";

const spring = {
    type: "spring",
    stiffness: 500,
    damping: 30,
    duration: .5,
}

export default function Layout5({data}) {

    const {
        lightLabel,
        darkLabel,
    } = data;

    return (
        <>
            <div className="dracula-toggle-icon-wrap">
                <motion.div layout transition={spring} className="dracula-toggle-icon"></motion.div>
            </div>

            <span className={`dracula-toggle-label --light`}>{lightLabel}</span>
            <span className={`dracula-toggle-label --dark`}>{darkLabel}</span>
        </>
    )
}