import {motion} from "framer-motion";

const spring = {
    type: "spring",
    stiffness: 500,
    damping: 30,
    duration: .5,
}

export default function Layout4({data}) {
    const{
        lightLabel,
        darkLabel,
    } = data;

    return (
        <>
            <motion.div className="dracula-toggle-icon-wrap" layout transition={spring}>
                <div className="dracula-toggle-icon"></div>
            </motion.div>

            <motion.div className="dracula-toggle-label" layout transition={spring}>
                <span className={'--light'}>{lightLabel}</span>
                <span className={'--dark'}>{darkLabel}</span>
            </motion.div>
        </>
    )
}