export default function UsageOverview({data}) {

    const {total_user = 0, dark_mode_user = 0} = data;

    return (
        <div className="analytics-box usage-overview">
            <div className="analytics-box-title">
                <span>{wp.i18n.__('Usage Summary', 'dracula-dark-mode')}</span>
            </div>

            <div className="analytics-box-content">
                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/total-users.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Total Users', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{total_user}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of users who visited the site.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/dark-mode-users.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Dark Mode Users', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{dark_mode_user}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of users who used dark mode.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/dark-mode-users-percentage.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Percentage of Dark Mode Users', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{parseInt((dark_mode_user / total_user) * 100)}%</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Percentage of users who used dark mode.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

            </div>
        </div>
    )
}