export default function PageViews({data}) {
    const {total_view = 0, dark_view = 0} = data;

    return (
        <div className="analytics-box page-views">
            <div className="analytics-box-title">
                <span>{wp.i18n.__('Page View Summary', 'dracula-dark-mode')}</span>
            </div>

            <div className="analytics-box-content">
                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/total-views.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Total Page Views', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{total_view}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of page views.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/dark-mode-views.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Dark Mode Page Views', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{dark_view}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of page views in dark mode.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/dark-mode-views-percentage.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Percentage of Dark Mode Page Views', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{parseInt((dark_view / total_view) * 100)}%</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Percentage of page views in dark mode.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

            </div>
        </div>
    )
}