import {Tooltip} from "react-tooltip";

import {showProModal} from "../ProModal";

const {useEffect} = React;

const {isPro} = dracula;

export default function Header({startDate, endDate, setStartDate, setEndDate, setData}) {

    useEffect(() => {
        const $ = jQuery;

        $('.dracula-date-field').each(function () {
            let defaultDate = $(this).hasClass('end-date') ? endDate : startDate;

            $(this).datepicker({
                defaultDate: defaultDate,
                dateFormat: "yy-mm-dd",
                nextText: '',
                prevText: '',

                beforeShow: function (input, inst) {
                    $(inst.dpDiv).addClass('dracula-datepicker');
                }
            });
        });

    }, []);

    return (
        <div className="analytics-header">

            <div className="analytics-header-title">
                <img src={dracula.pluginUrl + '/assets/images/analytics/analytics-icon.svg'}/>
                <span>{wp.i18n.__('Dark Mode Analytics', 'dracula-dark-mode')}</span>
            </div>

            <div className="analytics-range">

                <div className="date-field-wrap">
                    <label className={`date-field-prefix`} htmlFor="start-date">
                        <i className="dashicons dashicons-calendar-alt"></i>
                        <span>{wp.i18n.__('From', 'dracula-dark-mode')}</span>
                    </label>

                    <input type="text" id={`start-date`} className="dracula-date-field start-date" value={startDate}
                           onChange={(e) => setStartDate(e.target.value)}/>

                    <label className="date-field-suffix" htmlFor={`start-date`}>
                        <i className="dashicons dashicons-arrow-down"></i>
                    </label>
                </div>

                <div className="date-field-wrap">
                    <label className={`date-field-prefix`} htmlFor="end-date">
                        <i className="dashicons dashicons-calendar-alt"></i>
                        <span>{wp.i18n.__('To', 'dracula-dark-mode')}</span>
                    </label>
                    <input type="text" id={`end-date`} className="dracula-date-field end-date" value={endDate}
                           onChange={(e) => setEndDate(e.target.value)}/>
                    <label className="date-field-suffix" htmlFor={`end-date`}>
                        <i className="dashicons dashicons-arrow-down"></i>
                    </label>
                </div>

                <button type="button" className="dracula-btn btn-primary"
                        onClick={() => {
                            if (!isPro) {
                                showProModal('Upgrade to Pro to access analytics.');

                                return;
                            }

                            const startDate = jQuery('.start-date').val();
                            const endDate = jQuery('.end-date').val();

                            setStartDate(startDate);
                            setEndDate(endDate);
                        }}
                >
                    <i className="dashicons dashicons-filter"></i>
                    <span>{wp.i18n.__('Filter', 'dracula-dark-mode')}</span>
                </button>

                <i data-tooltip-id="clear-analytics"
                   className="clear-analytics dashicons dashicons-ellipsis"></i>

                <Tooltip
                    id="clear-analytics"
                    place="left"
                    variant="light"
                    effect="solid"
                    openOnClick="click"
                    globalEventOff="click"
                    className="dracula-tooltip clear-analytics-tooltip"
                    clickable={true}
                    border={`1px solid #ddd`}
                >

                    <button
                        type="button"
                        className="dracula-btn btn-info"
                        onClick={() => {
                            if (!isPro) {
                                showProModal('Upgrade to Pro to access analytics.');

                                return;
                            }

                            wp.ajax.post('dracula_export_analytics', {
                                start_date: startDate,
                                end_date: endDate,
                            }).done((response) => {
                                if (response.success) {
                                    window.location.href = response.url;
                                } else {
                                    Swal.fire({
                                        title: wp.i18n.__('Error!', 'dracula-dark-mode'),
                                        text: wp.i18n.__('Something went wrong.', 'dracula-dark-mode'),
                                        icon: 'error',
                                        toast: true,
                                        timer: 2000,
                                        timerProgressBar: true,
                                        showConfirmButton: false,
                                        customClass: {
                                            container: 'dracula-swal',
                                        },
                                    });
                                }
                            });

                        }}
                    >
                        <i className="dashicons dashicons-download"></i>
                        {wp.i18n.__('Export Analytics', 'dracula-dark-mode')}
                    </button>

                    <button type="button"
                            className="dracula-btn btn-danger"
                            onClick={() => {
                                if (!isPro) {
                                    showProModal('Upgrade to Pro to access analytics.');

                                    return;
                                }

                                Swal.fire({
                                    title: wp.i18n.__('Deleted!', 'dracula-dark-mode'),
                                    text: wp.i18n.__('All analytics data has been deleted.', 'dracula-dark-mode'),
                                    icon: 'success',
                                    toast: true,
                                    timer: 2000,
                                    timerProgressBar: true,
                                    showConfirmButton: false,
                                    customClass: {
                                        container: 'dracula-swal',
                                    },
                                });

                                setData({
                                    total_user: 0,
                                    dark_mode_user: 0,
                                    total_view: 0,
                                    dark_view: 0,
                                    total_activation: 0,
                                    total_deactivation: 0,
                                    activations: [],
                                    feedbacks: [],
                                });

                                wp.ajax.post('dracula_clear_analytics', {nonce: dracula.nonce,});

                            }}>
                        <i className="dashicons dashicons-trash"></i>
                        {wp.i18n.__('Clear Analytics', 'dracula-dark-mode')}
                    </button>
                </Tooltip>
            </div>

        </div>
    )
}