export default function ActivationDeactivation({data}) {
    const {total_activation = 0, total_deactivation = 0} = data;

    return (
        <div className="analytics-box activation-deactivation">
            <div className="analytics-box-title">
                <span>{wp.i18n.__('Dark Mode Activation & Deactivation Summary', 'dracula-dark-mode')}</span>
            </div>

            <div className="analytics-box-content">
                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/total-activation.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Total Activation', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{total_activation}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of dark mode activation.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

                <div className="analytics-box-item">
                    <img src={dracula.pluginUrl + '/assets/images/analytics/total-deactivation.svg'} className={`analytics-box-item-icon`}/>

                    <div className="analytics-box-item-content">
                        <h4 className="analytics-box-item-title">{wp.i18n.__('Total Deactivation', 'dracula-dark-mode')}</h4>
                        <span className="analytics-box-item-value">{total_deactivation}</span>
                        <p className="analytics-box-item-description">{wp.i18n.__('Total number of dark mode deactivation.', 'dracula-dark-mode')}</p>
                    </div>
                </div>

            </div>
        </div>
    )
}