const {Button} = wp.components;

export default function AdminToggle({type = 'adminbar'}) {

    const draculaDarkMode = window.draculaDarkMode;

    if(window.dracula.settings.adminDarkMode === false) return null;

    return 'adminbar' === type ?

        <Button
            className={`dracula-toggle dracula-ignore style-14`}
            onClick={(e) => {
                e.preventDefault();
                draculaDarkMode.toggle();
            }}
            label={wp.i18n.__('Toggle Dark Mode', 'dracula-dark-mode')}
        >
            <i className="dracula-toggle-icon"></i>
        </Button>
        :
        <Button
            className={`dracula-toggle dracula-ignore style-2`}
            onClick={() => draculaDarkMode.toggle()}
            label={wp.i18n.__('Toggle Dark Mode', 'dracula-dark-mode')}
        >
            <div className="dracula-toggle-icon-wrap %size%">
                <div className="dracula-toggle-icon"></div>
            </div>

            <div className="dracula-toggle-label">
                <span className="--light">{wp.i18n.__('Light', 'dracula-dark-mode')}</span>
                <span className="--dark">{wp.i18n.__('Dark', 'dracula-dark-mode')}</span>
            </div>
        </Button>


}