<?php
    
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$features = [
	[
		'title' => esc_html__( 'Frontend Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Admin Dashboard Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Auto Match OS-Theme', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Time-based Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Default Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'WordPress Login & Register Page Dark Mode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Multiple Toggle Button Styles', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Floating Dark Mode Toggle Button', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Darken Background Images', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Image Brightness, Grayscale and Insert Control', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Dynamic Dark Mode Colors', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Classic Editor Dark Mode Compatibility', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Gutenberg Editor Dark Mode Compatibility', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Toggle Button Shortcode', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Save User Choice', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Keyboard Shortcut', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Gutenberg Toggle Button Block (Coming Soon)', 'dracula-dark-mode' ),
	],
	[
		'title' => esc_html__( 'Elementor Toggle Button Block (Coming Soon)', 'dracula-dark-mode' ),
	],

	//PRO Features

	[
		'title'   => esc_html__( 'Reading Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Display Toggle Button in Menu', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Dark Mode Based Image Support', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Dark Mode Based Video Support', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Dark Mode Color Brightness, Contrast, Sepia, and Grayscale Adjustments', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Toggle Button Size Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Toggle Button Position Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Customize Toggle Button Text & Colors', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Dark Mode Colors Customization and Multiple Color Presets', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Excludes Specific Sections & Elements in a Page', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Exclude Pages/ Posts/ Custom Post Types', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Custom CSS For Dark Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( '8+ Dark Mode Toggle Button Styles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Enable/ Disable Dark Mode by URL Parameter', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Draggable Floating Switch', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Dark Mode Based Typography (Font Family + Font Size + Text Stroke)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title' => esc_html__( 'Performance Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],

	[
		'title'   => esc_html__( 'Realtime Dark Mode Customization', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( 'Page Wise Dark Mode', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( 'Custom Dark Mode Toggle Button Builder', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( '14+ Dark Mode Toggle Button Styles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( 'Dashboard Dark Mode for Specific User Roles', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( 'Usage Analytics & Email Report (Coming Soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],

	[
		'title'   => esc_html__( 'Dark Mode Page Transition Animation (coming soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
	[
		'title'   => esc_html__( 'Toggle Button Attention Effect Animation (coming soon)', 'dracula-dark-mode' ),
		'isPro' => true,
	],
];

?>

<div id="get-pro" class="getting-started-content content-get-pro">

    <div class="content-heading heading-get-pro">
        <h2>
            <?php esc_html_e('Get Access to Exclusive Features with ', 'dracula-dark-mode'); ?>
            <br>
            <mark><?php esc_html_e('Dracula Dark Mode PRO', 'dracula-dark-mode') ?></mark>
        </h2>

        <p><?php esc_html_e('The amazing premium features will take your website to the next level.', 'dracula-dark-mode'); ?></p>

        <a href="https://www.softlabbd.com/dracula-dark-mode-pricing" class="dracula-btn btn-primary get-pro-btn">
            <img src="<?php echo esc_url(DRACULA_ASSETS) ?>/images/getting-started/menu/get-pro.svg" />
            <?php esc_html_e('Upgrade Now', 'dracula-dark-mode'); ?>
        </a>

    </div>

    <div class="content-heading compare-pans">
        <h2><?php esc_html_e('Compare Plans', 'dracula-dark-mode'); ?></h2>
        <h3>
            <span class="plan-name plan-free"><?php esc_html_e('Free', 'dracula-dark-mode'); ?></span>
            <span class="vs"><?php esc_html_e('vs', 'dracula-dark-mode'); ?></span>
            <span class="plan-name plan-pro"><?php esc_html_e('Pro', 'dracula-dark-mode'); ?></span>
    </div>

    <div class="features-list">
        <div class="list-header">
            <div class="feature-title"><?php esc_html_e('Features', 'dracula-dark-mode'); ?></div>
            <div class="feature-free"><?php esc_html_e('Free', 'dracula-dark-mode'); ?></div>
            <div class="feature-pro"><?php esc_html_e('Pro', 'dracula-dark-mode'); ?></div>
        </div>

		<?php foreach ( $features as $feature ) : ?>
            <div class="feature">
                <div class="feature-title"><?php echo esc_html( $feature['title'] ); ?></div>
                <div class="feature-free">
					<?php if ( ! empty( $feature['isPro'] )) : ?>
                        <i class="dashicons dashicons-no-alt"></i>
					<?php else : ?>
                        <i class="dashicons dashicons-saved"></i>
					<?php endif; ?>
                </div>

                <div class="feature-pro">
                    <i class="dashicons dashicons-saved"></i>
                </div>
            </div>
		<?php endforeach; ?>

    </div>

    <div class="get-pro-cta">
        <div class="cta-content">
            <h2>
				<?php
					echo wp_kses_post(
						/* translators: 1: opening mark, 2: closing mark */
						sprintf(
							esc_html__('Why wait? Get the %sPRO version%s now!', 'dracula-dark-mode'),
							'<mark>',
							'</mark>'
						)
					);
				?>
			</h2>
            <p>
				<?php echo esc_html__('Upgrade to Dracula Dark Mode premium now and experience a whole new level of darkness. Get exclusive
                features and support the development of this awesome plugin. Don\'t miss out on the ultimate dark mode experience. Buy now!', 'dracula-dark-mode'); ?>
            </p>
        </div>

        <div class="cta-btn">
            <a href="https://www.softlabbd.com/dracula-dark-mode-pricing" target="_blank" class="dracula-btn btn-primary">
                <i class="dashicons dashicons-cart"></i>
                <?php esc_html_e('Get PRO', 'dracula-dark-mode'); ?></a>
        </div>

    </div>

    <div class="demo-cta">
        <div class="cta-content">
            <h2><?php esc_html_e('Try all the PRO features, before purchase', 'dracula-dark-mode'); ?></h2>
            <p><?php esc_html_e('You can try our instant ready-made demo. The demo allows you to experiment with all the functionality of
                the plugins on both Front-End and Back-End. Feel free to explore the possibilities and limits of our
                plugins to see if it fits your requirements!', 'dracula-dark-mode'); ?></p>
        </div>

        <div class="cta-btn">
            <a href="https://demo.softlabbd.com/demo-portal" class="dracula-btn btn-primary" target="_blank">
                <i class="dashicons dashicons-admin-site"></i>
                <?php esc_html_e('Try Live Demo', 'dracula-dark-mode'); ?>
            </a>
        </div>

    </div>

</div>