<?php

namespace Dracula;

defined('ABSPATH') || exit();

class Update_1_3_3 {

	private static $instance = null;

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->migrate_options();
	}

    public function migrate_options() {
        $settings               = get_option('dracula_settings');
        $template_excluded      = get_option('dracula_template_excluded', []);
        $setup_complete         = get_option('dracula_setup_complete');
        $rating_notice_intval   = get_transient('dracula_rating_notice_interval');

        if (!empty($settings)) {
            update_option('dracula_settings', $settings);
            delete_option('dracula_settings');
        }

        if (!empty($template_excluded)) {
            update_option('dracula_template_excluded', $template_excluded);
            delete_option('dracula_template_excluded');
        }

        if (!empty($setup_complete)) {
            update_option('dracula_setup_complete', $setup_complete);
            delete_option('dracula_setup_complete');
        }

        if (!empty($rating_notice_intval)) {
            set_transient('dracula_rating_notice_interval', $rating_notice_intval);
            delete_transient('dracula_rating_notice_interval');
        }
    }

	public static function instance() {
		if (is_null(self::$instance)) {
			self::$instance = new self();
		}

		return self::$instance;
	}
}

Update_1_3_3::instance();