<?php

namespace Dracula;

defined('ABSPATH') || exit;

class Update {

    /**
     * The upgrades
     *
     * @var array
     */
    private static $upgrades = array('1.3.3');

    public function installed_version() {
        return get_option('dracula_version');
    }

    /**
     * Check if the plugin needs any update
     *
     * @return boolean
     */
    public function needs_update() {

        // may be it's the first install
        if (empty($this->installed_version())) {
            return false;
        }

        //if previous version is lower
        if (version_compare($this->installed_version(), DRACULA_VERSION, '<')) {
            return true;
        }

        return false;
    }

    /**
     * Perform all the necessary upgrade routines
     *
     * @return void
     */
    public function perform_updates() {

        foreach (self::$upgrades as $version) {
            if (version_compare($this->installed_version(), $version, '<')) {
                $file = DRACULA_INCLUDES . "/updates/Update-$version.php";

                if (file_exists($file)) {
                    include_once $file;
                }

                update_option('dracula_version', $version);
                delete_option('dracula_version');
            }
        }
        
        update_option('dracula_db_version', DRACULA_DB_VERSION);
    }
}
