<?php

namespace Dracula;

defined('ABSPATH') or die('No script kiddies please!');

class Shortcode
{

    private static $instance = null;

    public function __construct()
    {
        add_shortcode('dracula_toggle', array($this, 'render_toggle'));
    }

    public function render_toggle($atts)
    {

        $atts = shortcode_atts(array(
            'style' => 1,
            'id' => '',
            'floating' => '',
        ), $atts, 'dracula_toggle');

        $style      = apply_filters('dracula_toggle_style', $atts['style']);
        $floating   = $atts['floating'];
        $id         = $atts['id'];

        $class = 'dracula-toggle-wrap';

        if ($floating) {
            $class .= ' floating';

            $position = dracula_get_settings('togglePosition', 'right');
            if ('custom' == $position) {
                $class .= ' position-custom';
                $position = dracula_get_settings('toggleSide', 'right');
            }

            $class .= " position-$position";
        }

        if( ! empty( $id ) ) {
            return apply_filters('dracula_custom_toggle_switch', '', $id, $class);
        }

        return sprintf('<div class="%s" data-style="%s"></div>', esc_attr($class), esc_attr($style));

    }

    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

}

Shortcode::instance();