<?php

namespace Dracula;

defined('ABSPATH') || exit();

class Metabox
{

    private static $instance = null;

    public function __construct()
    {
        add_action('add_meta_boxes', [$this, 'dark_mode_meta_box']);
    }

    public function dark_mode_meta_box()
    {
        $post_types = get_post_types(array('public' => true));

        foreach ($post_types as $post_type) {
            add_meta_box(
                    'dark_mode_meta_box',
                    esc_html__('Dark Mode Settings', 'dracula-dark-mode'),
                    [$this, 'render_settings_meta_box'],
                    $post_type,
                    'side'
            );
        }
    }

    public function render_settings_meta_box($post)
    { ?>
        <div id="dracula-settings-metabox" class="dracula-live-edit-wrap"></div>
    <?php }

    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

}

Metabox::instance();