<?php

namespace Dracula;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

//final class
final class Main {

	/**
	 * The single instance of the class.
	 *
	 * @var Main
	 */
	protected static $_instance = null;

	/**
	 * Main Instance.
	 *
	 * Ensures only one instance of Main is loaded or can be loaded.
	 *
	 * @return Main - Main instance.
	 * @since 1.0.0
	 * @static
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Cloning is forbidden.
	 *
	 * @since 1.0.0
	 */
	public function __clone() {
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheating huh?', 'dracula-dark-mode' ), '1.0.0' );
	}

	/**
	 * Unserializing instances of this class is forbidden.
	 *
	 * @since 1.0.0
	 */
	public function __wakeup() {
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cheating huh?', 'dracula-dark-mode' ), '1.0.0' );
	}

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->includes();
		$this->init_hooks();

		register_activation_hook( DRACULA_FILE, array( $this, 'activate' ) );

		do_action( 'dracula_loaded' );
	}

	public function activate() {

		if ( ! class_exists( 'DRACULA\Install' ) ) {
			include_once DRACULA_INCLUDES . '/class-install.php';
		}

		Install::activate();
	}

	public function includes() {
		include_once DRACULA_INCLUDES . '/functions.php';
		include_once DRACULA_INCLUDES . '/class-enqueue.php';
		include_once DRACULA_INCLUDES . '/class-shortcode.php';
		include_once DRACULA_INCLUDES . '/class-hooks.php';
		include_once DRACULA_INCLUDES . '/class-ajax.php';
		include_once DRACULA_INCLUDES . '/class-metabox.php';


		// blocks
		include_once DRACULA_PATH . '/blocks/class-blocks.php';

		// Elementor
		include_once DRACULA_PATH . '/elementor/class-elementor.php';

		if ( is_admin() ) {
			include_once DRACULA_INCLUDES . '/class-admin.php';
		}

	}

	public function init_hooks() {

		//plugin action links
		add_filter( 'plugin_action_links_' . plugin_basename( DRACULA_FILE ), array( $this, 'plugin_action_links' ) );
	}

	public function plugin_action_links( $links ) {
		$plugin_links = array(
			'<a href="' . admin_url( 'admin.php?page=dracula' ) . '">' . esc_html__( 'Settings', 'dracula-dark-mode' ) . '</a>',
		);

		return array_merge( $plugin_links, $links );
	}

	public function is_pro_active() {
		return function_exists( 'ddm_fs' ) && ddm_fs()->can_use_premium_code__premium_only();
	}

}

if ( ! function_exists( 'dracula' ) ) {
	function dracula() {
		return Main::instance();
	}
}

dracula();