<?php

namespace Dracula;

defined( 'ABSPATH' ) || exit;

/**
 * Class Install
 */
class Install {

	/**
	 * Plugin activation stuffs
	 *
	 * @since 1.0.0
	 */
	public static function activate() {
		self::create_default_data();

		add_option( 'dracula_do_activation_redirect', true );
	}


	public static function deactivate() {
	}

	/**
	 * Create plugin settings default data
	 *
	 * @since 1.0.0
	 */
	private static function create_default_data() {

		$version      = get_option( 'dracula_version', '0' );
		$install_time = get_option( 'dracula_install_time', '' );

		if ( empty( $version ) ) {
			update_option( 'dracula_version', DRACULA_VERSION );
		}

		if ( empty( $install_time ) ) {
			update_option( 'dracula_install_time', time() );
		}

		set_transient( 'dracula_rating_notice_interval', 'off', 10 * DAY_IN_SECONDS );

	}

}