<?php
namespace Dracula;

defined('ABSPATH') or die('No script kiddies please!');

class Hooks {

    private static $instance = null;

    public function __construct() {

        // Frontend Hooks
        if (!is_admin()) {

            if (dracula_get_settings('frontendDarkMode', true)) {

                add_action('wp_head', array($this, 'render_header_scripts'));
                add_action('login_head', array($this, 'render_header_scripts'));
                
                // frontend init hook
                add_action('init', function () {
                    do_action('dracula_frontend_hook_init');
                });

                // Render Floating Toggle
                add_action('wp_footer', array($this, 'render_floating_toggle'));
                add_action('login_footer', array($this, 'render_floating_toggle'));
            }
        }

        // admin init hook
        do_action('dracula_hook_init');

        add_filter('autoptimize_filter_js_exclude', array($this, 'exclude_js_from_cache_plugins'));

        // Render Nav Toggle
        add_filter('walker_nav_menu_start_el', array($this, 'render_nav_toggle'), 10, 4);
    }

    public function exclude_js_from_cache_plugins($excludes) {
        $excludes .= ', dracula-dark-mode,dracula-frontend';

        return $excludes;
    }

    public function render_header_scripts() {
        include_once DRACULA_INCLUDES . '/header-scripts.php';
    }

    public function render_floating_toggle() {
        $show_toggle = dracula_get_settings('showToggle', true);

        if (!$show_toggle) {
            return;
        }

        $display_on = dracula_get_settings('floatingDevices', ['mobile', 'tablet', 'desktop']);

        $device = wp_is_mobile() ? (dracula_is_tablet() ? 'tablet' : 'mobile') : 'desktop';

        if (!in_array($device, $display_on, true)) {
            return;
        }

        $style = dracula_get_settings('toggleStyle', '1');

        $id = '';
        if (str_contains($style, 'custom-')) {
            $id = str_replace('custom-', '', $style);
        }

        // Check if the toggle is excluded on the current page or taxonomy
        $show = apply_filters('dracula_toggle_excluded', true);

        if( !$show ) {
            return;
        }

        echo do_shortcode(sprintf('[dracula_toggle style="%1$s" id="%2$s" floating="1" ]', $style, $id));
    }

    public function render_nav_toggle($item_output, $menu_item, $depth, $args) {

        // return if menu-item-object is not dracula-dark-mode-switch
        if ($menu_item->object !== 'dracula-dark-mode-switch') {
            return $item_output;
        }

        // status 
        $status = dracula_get_settings('displayInMenu', false);

        if (!$status) {
            return '';
        }

        $style_id = apply_filters('dracula_menu_toggle_style', get_post_meta($menu_item->ID, 'dracula_dark_mode_switch', true)) ?? 1;

        return do_shortcode(wp_sprintf('[dracula_toggle style="%s"]', esc_attr($style_id)));
    }

    public static function instance() {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }
}

Hooks::instance();
