<?php

namespace Dracula;

defined('ABSPATH') || exit;

class Ajax
{

    private static $instance = null;

    public function __construct()
    {

        // Save Settings
        add_action('wp_ajax_dracula_save_settings', array($this, 'save_settings'));

        // Handle admin notice
        add_action('wp_ajax_dracula_hide_review_notice', [$this, 'hide_review_notice']);
        add_action('wp_ajax_dracula_review_feedback', [$this, 'handle_review_feedback']);
    }

    public function hide_review_notice()
    {

        $nonce = !empty($_REQUEST['nonce']) ? sanitize_text_field(wp_unslash($_REQUEST['nonce'])) : '';

        // Verify nonce
        if (!wp_verify_nonce($nonce, 'dracula')) {
            wp_send_json_error('Invalid nonce');
        }

        update_option('dracula_rating_notice', 'off');
    }

    public function handle_review_feedback()
    {

        $nonce = !empty($_POST['nonce']) ? sanitize_textarea_field(wp_unslash($_POST['nonce'])) : '';

        // Verify nonce
        if (!wp_verify_nonce($nonce, 'dracula')) {
            wp_send_json_error('Invalid nonce');
        }

        $feedback = !empty($_POST['feedback']) ? sanitize_textarea_field(wp_unslash($_POST['feedback'])) : '';
        if (!empty($feedback)) {
            $feedback = sanitize_textarea_field($feedback);
            $website_url = get_bloginfo('url');
            /* translators: %s: User feedback */
            $feedback = sprintf(esc_html__('Feedback: %s', 'dracula-dark-mode'), $feedback);
            $feedback .= '<br>';
            /* translators: %s: Website URL */
            $feedback .= sprintf(esc_html__('Website URL: %s', 'dracula-dark-mode'), $website_url);
            /* translators: %s: Plugin name */
            $subject = sprintf(esc_html__('Feedback for %s', 'dracula-dark-mode'), 'Radio Player');
            $to = 'contact@softlabbd.com';

            $headers = [
                'Content-Type: text/html; charset=UTF-8',
                'From: ' . get_bloginfo('name') . ' <' . get_bloginfo('admin_email') . '>',
            ];

            wp_mail($to, $subject, $feedback, $headers);
            $this->hide_review_notice();
            wp_send_json_success();

        } else {
            wp_send_json_error();
        }
    }

    public function save_settings()
    {

        $nonce = !empty($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';

        //verify nonce
        if (!wp_verify_nonce($nonce, 'dracula')) {
            wp_send_json_error('Invalid nonce');
        }

        if (!current_user_can('manage_options')) {
            wp_send_json_error('Invalid user');
        }

        $settings = !empty($_POST['data']) ? json_decode(base64_decode(sanitize_text_field(wp_unslash($_POST['data']))), 1) : [];

        $settings_name = 'dracula_settings';

        $settings = apply_filters('dracula_save_settings', $settings);

        update_option($settings_name, $settings);

        wp_send_json_success($settings);
    }

    public static function instance()
    {
        if (null === self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }
}

Ajax::instance();
