<?php
/**
 * DooFinder Polylang methods.
 *
 * @package Doofinder\WP\Multilanguage
 */

namespace Doofinder\WP\Multilanguage;

/**
 * Handles the languages generated by Polylang plugin.
 *
 * Unfinished class
 */
class Polylang extends Language_Plugin {


	/**
	 * There is a built in method "pll_the_languages" but it only works
	 * on the frontend. Even if we try to extract from it functionalities
	 * that just grab languages from DB it still fails on the backend
	 * because some functions are missing (due to Polylang including
	 * different files on the backend and different on the front).
	 *
	 * Therefore we have to grab the languages from the taxonomy terms manually.
	 *
	 * @inheritdoc
	 */
	public function get_languages() {
		$language_slugs = array();

		$languages = get_terms( array( 'taxonomy' => 'language' ) );
		foreach ( $languages as $language ) {
			$language_slugs[ $language->slug ] = $language->name;
		}

		return $language_slugs;
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 */
	public function get_formatted_languages() {
		return $this->get_languages();
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 *
	 * @param string $language Language.
	 *
	 * @return string
	 */
	public function get_home_url( $language ) {
		// Sometimes even if Polylang constant exists the function does not.
		if ( ! function_exists( 'pll_home_url' ) ) {
			return '';
		}
		return (string) \pll_home_url( $language );
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 */
	public function get_active_language() {
		// Sometimes even if Polylang constant exists the function does not.
		if ( ! function_exists( 'pll_current_language' ) ) {
			return '';
		}

		// There's "Show all languages" option. When selected we want to treat
		// it as if no language was selected. Luckily Polylang already
		// returns empty string for it so we don't have to do anything else.
		return \pll_current_language();
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 */
	public function get_current_language() {
		// Sometimes even if Polylang constant exists the function does not.
		if ( ! function_exists( 'pll_current_language' ) ) {
			return '';
		}

		// There's "Show all languages" option. When selected we want to treat
		// it as if no language was selected. Luckily Polylang already
		// returns empty string for it so we don't have to do anything else.
		return \pll_current_language();
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 */
	public function get_base_language() {
		return \pll_default_language();
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @inheritdoc
	 */
	public function get_default_language() {
		return \pll_default_language();
	}

	/**
	 * Inherited from Language_Plugin.
	 *
	 * @param string $locale The locale string with underscore to search for (e.g. 'en_US', 'es_ES', 'zh_CN').
	 * @inheritdoc
	 */
	public function get_lang_code_by_locale( $locale ) {
		return $locale;
	}
}
