<?php

/**
 * ODF2HTML5
 *
 * @copyright  Copyright(c) No-nonsense Labs (http://www.nononsenselabs.com)
 */

/*
Plugin Name: Docxpresso
Plugin URI: http://www.docxpresso.com
Description: Docxpresso inserts content from a document file (.odt).
Version: 2.1
Author: No-nonsense Labs
License: GPLv2 or later
*/

namespace Docxpresso\ODF2HTML5;


use Docxpresso;


class Resources
{
 /**
     * dr3d namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $dr3d_attributes = array(
	'dr3d:ambient-color' => 0,
	'dr3d:back-scale' => 0,
	'dr3d:backface-culling' => 0,
	'dr3d:center' => 0,
	'dr3d:close-back' => 0,
	'dr3d:close-front' => 0,
	'dr3d:depth' => 0,
	'dr3d:diffuse-color' => 0,
	'dr3d:direction' => 0,
	'dr3d:distance' => 0,
	'dr3d:edge-rounding' => 0,
	'dr3d:edge-rounding-mode' => 0,
	'dr3d:emissive-color' => 0,
	'dr3d:enabled' => 0,
	'dr3d:end-angle' => 0,
	'dr3d:focal-length' => 0,
	'dr3d:horizontal-segments' => 0,
	'dr3d:lighting-mode' => 0,
	'dr3d:lighting-mode' => 0,
	'dr3d:max-edge' => 0,
	'dr3d:min-edge' => 0,
	'dr3d:normals-direction' => 0,
	'dr3d:normals-kind' => 0,
	'dr3d:projection' => 0,
	'dr3d:shade-mode' => 0,
	'dr3d:shadow' => 0,
	'dr3d:shadow-slant' => 0,
	'dr3d:shininess' => 0,
	'dr3d:size' => 0,
	'dr3d:specular' => 0,
	'dr3d:specular-color' => 0,
	'dr3d:texture-filter' => 0,
	'dr3d:texture-generation-mode-x' => 0,
	'dr3d:texture-generation-mode-y' => 0,
	'dr3d:texture-kind' => 0,
	'dr3d:texture-mode' => 0,
	'dr3d:transform' => 0,
	'dr3d:vertical-segments' => 0,
	'dr3d:vpn' => 0,
	'dr3d:vrp' => 0,
	'dr3d:vup' => 0,
        );
    /**
     * dr3d namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $dr3d_elements = array(
	'dr3d:cube' => 0,
	'dr3d:extrude' => 0,
	'dr3d:light' => 0,
	'dr3d:rotate' => 0,
	'dr3d:scene' => 0,
	'dr3d:sphere' => 0,
        );
    /**
     * draw namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $draw_attributes = array(
	'draw:align' => 0,
	'draw:angle' => 0,
	'draw:archive' => 0,
	'draw:auto-grow-height' => 0,
	'draw:auto-grow-width' => 0,
	'draw:background-size' => 0,
	'draw:blue' => 0,
	'draw:border' => 0,
	'draw:caption-angle' => 0,
	'draw:caption-angle-type' => 0,
	'draw:caption-escape' => 0,
	'draw:caption-escape-direction' => 0,
	'draw:caption-fit-line-length' => 0,
	'draw:caption-gap' => 0,
	'draw:caption-id' => 0,
	'draw:caption-line-length' => 0,
	'draw:caption-point-x' => 0,
	'draw:caption-point-y' => 0,
	'draw:caption-type' => 0,
	'draw:chain-next-name' => 0,
	'draw:class-id' => 0,
	'draw:class-names' => 0,
	'draw:code' => 0,
	'draw:color' => 1,
	'draw:color-inversion' => 0,
	'draw:color-mode' => 0,
	'draw:concave' => 0,
	'draw:concentric-gradient-fill-allowed' => 0,
	'draw:contrast' => 0,
	'draw:control' => 0,
	'draw:copy-of' => 0,
	'draw:corner-radius' => 1,
	'draw:corners' => 1,
	'draw:cx' => 1,
	'draw:cy' => 1,
	'draw:data' => 0,
	'draw:decimal-places' => 0,
	'draw:display' => 1,
	'draw:display-name' => 0,
	'draw:distance' => 0,
	'draw:dots1' => 0,
	'draw:dots1-length' => 0,
	'draw:dots2' => 0,
	'draw:dots2-length' => 0,
	'draw:end' => 0,
	'draw:end-angle' => 0,
	'draw:end-color' => 0,
	'draw:end-glue-point' => 0,
	'draw:end-guide' => 0,
	'draw:end-intensity' => 0,
	'draw:end-line-spacing-horizontal' => 0,
	'draw:end-line-spacing-vertical' => 0,
	'draw:end-shape' => 0,
	'draw:engine' => 0,
	'draw:enhanced-path' => 0,
	'draw:escape-direction' => 0,
	'draw:extrusion' => 0,
	'draw:extrusion-allowed' => 0,
	'draw:extrusion-brightness' => 0,
	'draw:extrusion-color' => 0,
	'draw:extrusion-depth' => 0,
	'draw:extrusion-diffusion' => 0,
	'draw:extrusion-first-light-direction' => 0,
	'draw:extrusion-first-light-harsh' => 0,
	'draw:extrusion-first-light-level' => 0,
	'draw:extrusion-light-face' => 0,
	'draw:extrusion-metal' => 0,
	'draw:extrusion-number-of-line-segments' => 0,
	'draw:extrusion-origin' => 0,
	'draw:extrusion-rotation-angle' => 0,
	'draw:extrusion-rotation-center' => 0,
	'draw:extrusion-second-light-direction' => 0,
	'draw:extrusion-second-light-harsh' => 0,
	'draw:extrusion-second-light-level' => 0,
	'draw:extrusion-shininess' => 0,
	'draw:extrusion-skew' => 0,
	'draw:extrusion-specularity' => 0,
	'draw:extrusion-viewpoint' => 0,
	'draw:fill' => array('method' => '_parseFill'),
	'draw:fill-color' => 'fill',
	'draw:fill-gradient-name' => 0,
	'draw:fill-hatch-name' => 0,
	'draw:fill-hatch-solid' => 0,
	'draw:fill-image-height' => 0,
	'draw:fill-image-name' => array('method' => '_parseSVGBackgroundImage'),
	'draw:fill-image-ref-point' => 0,
	'draw:fill-image-ref-point-x' => 0,
	'draw:fill-image-ref-point-y' => 0,
	'draw:fill-image-width' => 0,
	'draw:filter-name' => 0,
	'draw:fit-to-contour' => 0,
	'draw:fit-to-size' => 0,
	'draw:formula' => 0,
	'draw:frame-display-border' => 1,
	'draw:frame-display-scrollbar' => 1,
	'draw:frame-margin-horizontal' => 1,
	'draw:frame-margin-vertical' => 1,
	'draw:frame-name' => 0,
	'draw:gamma' => 0,
	'draw:glue-point-leaving-directions' => 0,
	'draw:glue-point-type' => 0,
	'draw:glue-points' => 0,
	'draw:gradient-step-count' => 0,
	'draw:green' => 0,
	'draw:guide-distance' => 0,
	'draw:guide-overhang' => 0,
	'draw:handle-mirror-horizontal' => 0,
	'draw:handle-mirror-vertical' => 0,
	'draw:handle-polar' => 0,
	'draw:handle-position' => 0,
	'draw:handle-radius-range-maximum' => 0,
	'draw:handle-radius-range-minimum' => 0,
	'draw:handle-range-x-maximum' => 0,
	'draw:handle-range-x-minimum' => 0,
	'draw:handle-range-y-maximum' => 0,
	'draw:handle-range-y-minimum' => 0,
	'draw:handle-switched' => 0,
	'draw:id' => 0,
	'draw:image-opacity' => 0,
	'draw:kind' => 0,
	'draw:layer' => 0,
	'draw:line-distance' => 0,
	'draw:line-skew' => 0,
	'draw:luminance' => 0,
	'draw:marker-end' => 0,
	'draw:marker-end-center' => 0,
	'draw:marker-end-width' => 0,
	'draw:marker-start' => 0,
	'draw:marker-start-center' => 0,
	'draw:marker-start-width' => 0,
	'draw:master-page-name' => 0,
	'draw:may-script' => 0,
	'draw:measure-align' => 0,
	'draw:measure-vertical-align' => 0,
	'draw:mime-type' => 0,
	'draw:mirror-horizontal' => 0,
	'draw:mirror-vertical' => 0,
	'draw:modifiers' => 0,
	'draw:name' => 0,
	'draw:nav-order' => 0,
	'draw:nohref' => 0,
	'draw:notify-on-update-of-ranges' => 0,
	'draw:object' => 0,
	'draw:ole-draw-aspect' => 0,
	'draw:opacity' => array('method' => '_parseOpacity'),
	'draw:opacity-name' => 0,
	'draw:page-number' => 0,
	'draw:parallel' => 0,
	'draw:path-stretchpoint-x' => 0,
	'draw:path-stretchpoint-y' => 0,
	'draw:placing' => 0,
	'draw:points' => 0,
	'draw:protected' => 0,
	'draw:recreate-on-edit' => 0,
	'draw:red' => 0,
	'draw:rotation' => 0,
	'draw:secondary-fill-color' => 0,
	'draw:shadow' => 1,
	'draw:shadow-color' => 1,
	'draw:shadow-offset-x' => 1,
	'draw:shadow-offset-y' => 1,
	'draw:shadow-opacity' => 1,
	'draw:shape-id' => 0,
	'draw:sharpness' => 0,
	'draw:show-unit' => 0,
	'draw:start' => 0,
	'draw:start-angle' => 0,
	'draw:start-color' => 0,
	'draw:start-glue-point' => 0,
	'draw:start-guide' => 0,
	'draw:start-intensity' => 0,
	'draw:start-line-spacing-horizontal' => 0,
	'draw:start-line-spacing-vertical' => 0,
	'draw:start-shape' => 0,
	'draw:stroke' => 0,
	'draw:stroke-dash' => 0,
	'draw:stroke-dash-names' => 0,
	'draw:stroke-linejoin' => 0,
	'draw:style' => 0,
	'draw:style-name' => 0,
	'draw:symbol-color' => 0,
	'draw:text-areas' => 0,
	'draw:text-path' => 0,
	'draw:text-path-allowed' => 0,
	'draw:text-path-mode' => 0,
	'draw:text-path-same-letter-heights' => 0,
	'draw:text-path-scale' => 0,
	'draw:text-rotate-angle' => 0,
	'draw:text-style-name' => 0,
	'draw:textarea-horizontal-align' => array('method' => '_parseTAH'),
	'draw:textarea-vertical-align' => 'vertical-align',
	'draw:tile-repeat-offset' => 0,
	'draw:transform' => 0,
	'draw:type' => 0,
	'draw:unit' => 0,
	'draw:value' => 0,
	'draw:visible-area-height' => 0,
	'draw:visible-area-left' => 0,
	'draw:visible-area-top' => 0,
	'draw:visible-area-width' => 0,
	'draw:wrap-influence-on-position' => 0,
	'draw:z-index' => 'z-index',
        );
    
    /**
     * draw namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $draw_elements = array(
	'draw:a' => 0,
	'draw:applet' => 0,
	'draw:area-circle' => 0,
	'draw:area-polygon' => 0,
	'draw:area-rectangle' => 0,
	'draw:caption' => 0,
	'draw:circle' => 0,
	'draw:connector' => 0,
	'draw:contour-path' => 0,
	'draw:contour-polygon' => 0,
	'draw:control' => 0,
	'draw:custom-shape' => 0,
	'draw:ellipse' => 0,
	'draw:enhanced-geometry' => 0,
	'draw:equation' => 0,
	'draw:fill-image' => 0,
	'draw:floating-frame' => 0,
	'draw:frame' => 0,
	'draw:g' => 0,
	'draw:glue-point' => 0,
	'draw:gradient' => 0,
	'draw:handle' => 0,
	'draw:hatch' => 0,
	'draw:image' => 0,
	'draw:image-map' => 0,
	'draw:layer' => 0,
	'draw:layer-set' => 0,
	'draw:line' => 0,
	'draw:marker' => 0,
	'draw:measure' => 0,
	'draw:object' => 0,
	'draw:object-ole' => 0,
	'draw:opacity' => array('method' => '_parseOpacity'),
	'draw:page' => 0,
	'draw:page-thumbnail' => 0,
	'draw:param' => 0,
	'draw:path' => 0,
	'draw:plugin' => 0,
	'draw:polygon' => 0,
	'draw:polyline' => 0,
	'draw:rect' => 0,
	'draw:regular-polygon' => 0,
	'draw:stroke-dash' => 0,
	'draw:text-box' => 0,
        );
    //<style:chart-properties> 17.22, <style:drawing-page-properties> 17.25, <style:graphic-properties> 17.21, <style:map> 16.3, <style:paragraph-properties> 17.6, <style:ruby-properties> 17.10, <style:section-properties> 17.11, <style:table-cell-properties> 17.18, <style:table-column-properties> 17.16, <style:table-properties> 17.15, <style:table-row-properties> 17.17, <style:text-properties> 16.27.28.
    /**
     * style elements childs
     * @access public
     * @static
     * @var array
     */
    public static $style_childs = array(
	'style:chart-properties' => 'canvas',
        'style:graphic-properties' => 'div',
        'style:page-layout-properties' => 'div',
        'style:paragraph-properties' => 'p',
        'style:section-properties' => 'div',
        'style:table-properties' => 'table',
        'style:table-cell-properties' => 'td',
        'style:table-column-properties' => 'col',
        'style:table-row-properties' => 'tr',
        'style:text-properties' => 'span',
    );
    
    /**
     * style families
     * @access public
     * @static
     * @var array
     */
    public static $style_family = array(
	'chart' => 'canvas',
        'graphic' => 'div',
        'paragraph' => 'p',
        'table' => 'table',
        'table-cell' => 'td',
        'table-column' => 'col',
        'table-row' => 'tr',
        'section' => 'div',
        'text' => 'span',
    );
    
    /**
     * This array controls that certain style properties of certain style
     * nodes are not parsed
     * @access public
     * @static
     * @var array
     */
    public static $stop_parsing_child = array(
	'style:default-style' => array('style:graphic-properties' => true),
        'style:default-page-layout' => array('style:page-layout-properties' => true),
    );
    
    /**
     * fo namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $fo_attributes = array(
	'fo:background-color' => 'background-color',
	'fo:border' => array('method' => '_parseBorders'),
	'fo:border-bottom' => array('method' => '_parseBorders'),
	'fo:border-left' => array('method' => '_parseBorders'),
	'fo:border-right' => array('method' => '_parseBorders'),
	'fo:border-top' => array('method' => '_parseBorders'),
	'fo:break-after' => 'break-after',
	'fo:break-before' => 'break-before',
	'fo:clip' => array('composedProp' => '_parseClip'),
	'fo:color' => 'color',
	'fo:column-count' => array('method' => '_parseColumnCount'),
	'fo:column-gap' => 'column-gap',
	'fo:country' => 'country',
	'fo:end-indent' => 'end-indent',
	'fo:font-family' => array('method' => '_parseFontFamily'),
	'fo:font-size' => 'font-size',
	'fo:font-style' => 'font-style',
	'fo:font-variant' => 'font-variant',
	'fo:font-weight' => 'font-weight',
	'fo:height' => 'height',
	'fo:hyphenate' => 'hyphenate',
	'fo:hyphenation-keep' => 'hyphenation-keep',
	'fo:hyphenation-ladder-count' => 'hyphenation-ladder-count',
	'fo:hyphenation-push-char-count' => 'hyphenation-push-char-count',
	'fo:hyphenation-remain-char-count' => 'hyphenation-remain-char-count',
	'fo:keep-together' => 'keep-together',
	'fo:keep-with-next' => 'keep-with-next',
	'fo:language' => 'language',
	'fo:letter-spacing' => 'letter-spacing',
	'fo:line-height' => array('method' => '_parseLineHeight'),
	'fo:margin' => 'margin',
	'fo:margin-bottom' => 'margin-bottom',
	'fo:margin-left' => 'margin-left',
	'fo:margin-right' => 'margin-right',
	'fo:margin-top' => 'margin-top',
	'fo:max-height' => 'max-height',
	'fo:max-width' => 'max-width',
	'fo:min-height' => 'min-height',
	'fo:min-height' => 'min-height',
	'fo:min-width' => 'min-width',
	'fo:orphans' => 'orphans',
	'fo:padding' => 'padding',
	'fo:padding-bottom' => 'padding-bottom',
	'fo:padding-left' => 'padding-left',
	'fo:padding-right' => 'padding-right',
	'fo:padding-top' => 'padding-top',
	'fo:page-height' => 0,
	'fo:page-width' => 'data-width',
	'fo:space-after' => 'space-after',
	'fo:space-before' => 'space-before',
	'fo:start-indent' => 'start-indent',
	'fo:text-align' => array('method' => '_parseTextAlign'),
	'fo:text-align-last' => 'text-align-last',
	'fo:text-indent' => 'text-indent',
	'fo:text-shadow' => 'text-shadow',
	'fo:text-transform' => 'text-transform',
	'fo:widows' => 'widows',
	'fo:width' => 'width',
	'fo:wrap-option' => 'wrap-option',
        );
    /**
     * form namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $form_attributes = array(
	'form:allow-deletes' => 0,
	'form:allow-inserts' => 0,
	'form:allow-updates' => 0,
	'form:apply-design-mode' => 0,
	'form:apply-filter' => 0,
	'form:auto-complete' => 0,
	'form:automatic-focus' => 0,
	'form:bound-column' => 0,
	'form:button-type' => 0,
	'form:command' => 0,
	'form:command-type' => 0,
	'form:control-implementation' => 0,
	'form:convert-empty-to-null' => 0,
	'form:current-selected' => 0,
	'form:current-state' => 0,
	'form:current-value' => 0,
	'form:data-field' => 0,
	'form:datasource' => 0,
	'form:default-button' => 0,
	'form:delay-for-repeat' => 0,
	'form:detail-fields' => 0,
	'form:disabled' => 0,
	'form:dropdown' => 0,
	'form:echo-char' => 0,
	'form:enctype' => 0,
	'form:escape-processing' => 0,
	'form:filter' => 0,
	'form:focus-on-click' => 0,
	'form:for' => 0,
	'form:id' => 0,
	'form:ignore-result' => 0,
	'form:image-align' => 0,
	'form:image-data' => 0,
	'form:image-position' => 0,
	'form:is-tristate' => 0,
	'form:label' => 0,
	'form:list-source' => 0,
	'form:list-source-type' => 0,
	'form:master-fields' => 0,
	'form:max-length' => 0,
	'form:max-value' => 0,
	'form:max-value' => 0,
	'form:max-value' => 0,
	'form:max-value' => 0,
	'form:method' => 0,
	'form:min-value' => 0,
	'form:min-value' => 0,
	'form:min-value' => 0,
	'form:min-value' => 0,
	'form:multi-line' => 0,
	'form:multiple' => 0,
	'form:name' => 0,
	'form:navigation-mode' => 0,
	'form:order' => 0,
	'form:orientation' => 0,
	'form:page-step-size' => 0,
	'form:printable' => 0,
	'form:property-name' => 0,
	'form:readonly' => 0,
	'form:selected' => 0,
	'form:size' => 0,
	'form:state' => 0,
	'form:step-size' => 0,
	'form:tab-cycle' => 0,
	'form:tab-index' => 0,
	'form:tab-stop' => 0,
	'form:text-style-name' => 0,
	'form:title' => 0,
	'form:toggle' => 0,
	'form:validation' => 0,
	'form:value' => 0,
	'form:visual-effect' => 0,
	'form:xforms-list-source' => 0,
	'form:xforms-submission' => 0,
        );
    /**
     * form namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $form_elements = array(
	'form:button' => 0,
	'form:checkbox' => 0,
	'form:column' => 0,
	'form:combobox' => 0,
	'form:connection-resource' => 0,
	'form:date' => 0,
	'form:file' => 0,
	'form:fixed-text' => 0,
	'form:form' => 0,
	'form:formatted-text' => 0,
	'form:frame' => 0,
	'form:generic-control' => 0,
	'form:grid' => 0,
	'form:hidden' => 0,
	'form:image' => 0,
	'form:image-frame' => 0,
	'form:item' => 0,
	'form:list-property' => 0,
	'form:list-value' => 0,
	'form:listbox' => 0,
	'form:number' => 0,
	'form:option' => 0,
	'form:password' => 0,
	'form:properties' => 0,
	'form:property' => 0,
	'form:radio' => 0,
	'form:text' => 0,
	'form:textarea' => 0,
	'form:time' => 0,
	'form:value-range' => 0,
        );
    /**
     * number namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $number_attributes = array(
	'number:automatic-order' => 0,
	'number:calendar' => 0,
	'number:country' => 0,
	'number:decimal-places' => 0,
	'number:decimal-replacement' => 0,
	'number:denominator-value' => 0,
	'number:display-factor' => 0,
	'number:format-source' => 0,
	'number:grouping' => 0,
	'number:language' => 0,
	'number:min-denominator-digits' => 0,
	'number:min-exponent-digits' => 0,
	'number:min-integer-digits' => 0,
	'number:min-numerator-digits' => 0,
	'number:position' => 0,
	'number:possessive-form' => 0,
	'number:style' => 0,
	'number:textual' => 0,
	'number:title' => 0,
	'number:transliteration-country' => 0,
	'number:transliteration-format' => 0,
	'number:transliteration-language' => 0,
	'number:transliteration-style' => 0,
	'number:truncate-on-overflow' => 0,
        );
    /**
     * number namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $number_elements = array(
	'number:am-pm' => 0,
	'number:boolean' => 0,
	'number:boolean-style' => 0,
	'number:currency-style' => 0,
	'number:currency-symbol' => 0,
	'number:date-style' => 0,
	'number:day' => 0,
	'number:day-of-week' => 0,
	'number:embedded-text' => 0,
	'number:era' => 0,
	'number:fraction' => 0,
	'number:hours' => 0,
	'number:minutes' => 0,
	'number:month' => 0,
	'number:number' => 0,
	'number:number-style' => 0,
	'number:percentage-style' => 0,
	'number:quarter' => 0,
	'number:scientific-number' => 0,
	'number:seconds' => 0,
	'number:text' => 0,
	'number:text-content' => 0,
	'number:text-style' => 0,
	'number:time-style' => 0,
	'number:week-of-year' => 0,
	'number:year' => 0,
        );
    /**
     * style namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $style_attributes = array(
	'style:adjustment' => 0,
	'style:apply-style-name' => 0,
	'style:auto-text-indent' => 0,
	'style:auto-update' => 0,
	'style:background-transparency' => 0,
	'style:base-cell-address' => 0,
	'style:border-line-width' => 0,
	'style:border-line-width-bottom' => 0,
	'style:border-line-width-left' => 0,
	'style:border-line-width-right' => 0,
	'style:border-line-width-top' => 0,
	'style:cell-protect' => 0,
	'style:char' => 0,
	'style:class' => 0,
	'style:color' => 0,
	'style:column-width' => 'width',
	'style:condition' => 0,
	'style:country-asian' => 0,
	'style:country-complex' => 0,
	'style:data-style-name' => 0,
	'style:decimal-places' => 0,
	'style:default-outline-level' => 0,
	'style:diagonal-bl-tr' => 0,
	'style:diagonal-bl-tr-widths' => 0,
	'style:diagonal-tl-br' => 0,
	'style:diagonal-tl-br-widths' => 0,
	'style:direction' => 0,
	'style:display' => 0,
	'style:display-name' => 0,
	'style:distance' => 0,
	'style:distance-after-sep' => 0,
	'style:distance-before-sep' => 0,
	'style:dynamic-spacing' => 0,
	'style:editable' => 0,
	'style:family' => 0,
	'style:filter-name' => 0,
	'style:first-page-number' => 0,
	'style:flow-with-text' => 0,
	'style:font-adornments' => 0,
	'style:font-charset' => 0,
	'style:font-charset-asian' => 0,
	'style:font-charset-complex' => 0,
	'style:font-family-asian' => 0,
	'style:font-family-complex' => 0,
	'style:font-family-generic' => 0,
	'style:font-family-generic-asian' => 0,
	'style:font-family-generic-complex' => 0,
	'style:font-independent-line-spacing' => 0,
	'style:font-name' => array('method' => '_parseFontFamily'),
	'style:font-name-asian' => 0,
	'style:font-name-complex' => 0,
	'style:font-pitch' => 0,
	'style:font-pitch-asian' => 0,
	'style:font-pitch-complex' => 0,
	'style:font-relief' => 0,
	'style:font-size-asian' => 0,
	'style:font-size-complex' => 0,
	'style:font-size-rel' => 0,
	'style:font-size-rel-asian' => 0,
	'style:font-size-rel-complex' => 0,
	'style:font-style-asian' => 0,
	'style:font-style-complex' => 0,
	'style:font-style-name' => 0,
	'style:font-style-name-asian' => 0,
	'style:font-style-name-complex' => 0,
	'style:font-weight-asian' => 0,
	'style:font-weight-complex' => 0,
	'style:footnote-max-height' => 0,
	'style:glyph-orientation-vertical' => 0,
	'style:height' => 0,
        'style:horizontal-pos' => array('composedProp' => '_parseHorizPos'),
	'style:horizontal-rel' => 0,
	'style:justify-single-word' => 0,
	'style:language-asian' => 0,
	'style:language-complex' => 0,
	'style:layout-grid-base-height' => 0,
	'style:layout-grid-color' => 0,
	'style:layout-grid-display' => 0,
	'style:layout-grid-lines' => 0,
	'style:layout-grid-mode' => 0,
	'style:layout-grid-print' => 0,
	'style:layout-grid-ruby-below' => 0,
	'style:layout-grid-ruby-height' => 0,
	'style:leader-char' => 0,
	'style:leader-color' => 0,
	'style:leader-style' => 0,
	'style:leader-text' => 0,
	'style:leader-text-style' => 0,
	'style:leader-type' => 0,
	'style:leader-width' => 0,
	'style:legend-expansion' => 0,
	'style:legend-expansion-aspect-ratio' => 0,
	'style:length' => 0,
	'style:letter-kerning' => 0,
	'style:line-break' => 0,
	'style:line-height-at-least' => 0,
	'style:line-spacing' => 0,
	'style:line-style' => 0,
	'style:lines' => 0,
	'style:list-style-name' => 0,
	'style:master-page-name' => 0,
	'style:may-break-between-rows' => 0,
	'style:min-row-height' => 'height',//browsers do not parse min-height
	'style:mirror' => array('method' => '_parseMirror'),
	'style:name' => 0,
	'style:next-style-name' => 0,
	'style:num-format' => 0,
	'style:num-letter-sync' => 0,
	'style:num-prefix' => 0,
	'style:num-suffix' => 0,
	'style:number-wrapped-paragraphs' => 0,
	'style:overflow-behavior' => 0,
	'style:page-layout-name' => 0,
	'style:page-number' => 0,
	'style:page-usage' => 0,
	'style:paper-tray-name' => 0,
	'style:parent-style-name' => 0,
	'style:position' => 0,
	'style:print' => 0,
	'style:print-content' => 0,
	'style:print-orientation' => 0,
	'style:print-page-order' => 0,
	'style:protect' => 0,
	'style:punctuation-wrap' => 0,
	'style:register-true' => 0,
	'style:register-truth-ref-style-name' => 0,
	'style:rel-column-width' => 0,
	'style:rel-height' => 0,
	'style:rel-width' => 0,
	'style:repeat' => array('method' => '_parseBackgroundRepeat'),
	'style:repeat-content' => 0,
	'style:rotation-align' => 0,
	'style:rotation-angle' => 0,
	'style:row-height' => 'height',
	'style:ruby-align' => 0,
	'style:ruby-position' => 0,
	'style:run-through' => array('composedProp' => '_parseRunThrough'),
	'style:scale-to' => 0,
	'style:scale-to-pages' => 0,
	'style:script-type' => 0,
	'style:shadow' => 0,
	'style:shrink-to-fit' => 0,
	'style:snap-to-layout-grid' => 0,
	'style:style' => 0,
	'style:style-name' => 0,
	'style:tab-stop-distance' => 0,
	'style:table-centering' => 0,
	'style:text-align-source' => 0,
	'style:text-autospace' => 0,
	'style:text-blinking' => 0,
	'style:text-combine' => 0,
	'style:text-combine-end-char' => 0,
	'style:text-combine-start-char' => 0,
	'style:text-emphasize' => 0,
	'style:text-line-through-color' => 'text-decoration-color',
	'style:text-line-through-mode' => 0,
	'style:text-line-through-style' => array('method' => '_parseDecoration'),
	'style:text-line-through-text' => 0,
	'style:text-line-through-text-style' => array('method' => '_parseDecoration'),
	'style:text-line-through-type' => 0,
	'style:text-line-through-width' => 0,
	'style:text-outline' => 0,
        'style:text-overline-color' => 'text-decoration-color',
	'style:text-overline-mode' => 0,
	'style:text-overline-style' => array('method' => '_parseDecoration'),
	'style:text-overline-type' => 0,
	'style:text-overline-width' => 0,
	'style:text-position' => array('method' => '_parseTextPosition'),
	'style:text-rotation-angle' => 0,
	'style:text-rotation-scale' => 0,
	'style:text-scale' => 0,
	'style:text-underline-color' => 'text-decoration-color',
	'style:text-underline-mode' => 0,
	'style:text-underline-style' => array('method' => '_parseDecoration'),
	'style:text-underline-type' => 'text-decoration',
	'style:text-underline-width' => 0,
	'style:type' => 0,
	'style:use-optimal-column-width' => 0,
	'style:use-optimal-row-height' => 0,
	'style:use-window-font-color' => array('composedProp' => '_parseWindowFont'),
	'style:vertical-align' => 'vertical-align',
	'style:vertical-pos' => 0,
	'style:vertical-rel' => 0,
	'style:volatile' => 0,
	'style:width' => 0,
	'style:width' => 'width',
	'style:wrap' => array('composedProp' => '_parseWrap'),
	'style:wrap-contour' => 0,
	'style:wrap-contour-mode' => 0,
	'style:wrap-dynamic-threshold' => 0,
	'style:writing-mode' => array('composedProp' => '_parseWritingMode'),
	'style:writing-mode-automatic' => 0,
        );
    /**
     * style namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $style_elements = array(
	'style:background-image' => 0,
	'style:chart-properties' => 0,
	'style:column' => 0,
	'style:column-sep' => 0,
	'style:columns' => 0,
	'style:default-style' => 0,
	'style:drawing-page-properties' => 0,
	'style:drop-cap' => 0,
	'style:font-face' => 0,
	'style:footer' => 0,
	'style:footer-left' => 0,
	'style:footer-style' => 0,
	'style:footnote-sep' => 0,
	'style:graphic-properties' => 0,
	'style:handout-master' => 0,
	'style:header' => 0,
	'style:header-footer-properties' => 0,
	'style:header-left' => 0,
	'style:header-style' => 0,
	'style:list-level-properties' => 0,
	'style:map' => 0,
	'style:master-page' => 0,
	'style:page-layout' => 0,
	'style:page-layout-properties' => 0,
	'style:paragraph-properties' => 0,
	'style:presentation-page-layout' => 0,
	'style:region-center' => 0,
	'style:region-left' => 0,
	'style:region-right' => 0,
	'style:ruby-properties' => 0,
	'style:section-properties' => 0,
	'style:style' => 0,
	'style:tab-stop' => 0,
	'style:tab-stops' => 0,
	'style:table-cell-properties' => 0,
	'style:table-column-properties' => 0,
	'style:table-properties' => 0,
	'style:table-row-properties' => 0,
	'style:text-properties' => 0,
        );
    /**
     * svg namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $svg_attributes = array(
	'svg:accent-height' => 0,
	'svg:alphabetic' => 0,
	'svg:ascent' => 0,
	'svg:bbox' => 0,
	'svg:cap-height' => 0,
	'svg:cx' => 'left',
	'svg:cy' => 'top',
	'svg:d' => 0,
	'svg:descent' => 0,
	'svg:fill-rule' => 0,
	'svg:font-family' => array('method' => '_parseFontFamily'),
	'svg:font-size' => 'font-size',
	'svg:font-stretch' => 'font-stretch',
	'svg:font-style' => 'font-style',
	'svg:font-variant' => 'font-variant',
	'svg:font-weight' => 'font-weight',
	'svg:fx' => 0,
	'svg:fy' => 0,
	'svg:gradientTransform' => 0,
	'svg:gradientUnits' => 0,
	'svg:hanging' => 'text-indent',
	'svg:height' => 'height',
	'svg:ideographic' => 0,
	'svg:mathematical' => 0,
	'svg:name' => 0,
	'svg:offset' => 0,
	'svg:origin' => 0,
	'svg:overline-position' => 0,
	'svg:overline-thickness' => 0,
	'svg:panose-1' => 0,
	'svg:path' => 0,
	'svg:r' => 0,
	'svg:rx' => 0,
	'svg:ry' => 0,
	'svg:slope' => 0,
	'svg:spreadMethod' => 0,
	'svg:stemh' => 0,
	'svg:stemv' => 0,
	'svg:stop-color' => 0,
	'svg:stop-opacity' => 0,
	'svg:strikethrough-position' => 0,
	'svg:strikethrough-thickness' => 0,
	'svg:string' => 0,
	'svg:stroke-color' => 'stroke',
	'svg:stroke-opacity' => array('method' => '_parseOpacity'),
	'svg:stroke-width' => 'stroke-width',
	'svg:type' => 0,
	'svg:underline-position' => 0,
	'svg:underline-thickness' => 0,
	'svg:unicode-range' => 0,
	'svg:units-per-em' => 0,
	'svg:v-alphabetic' => 0,
	'svg:v-hanging' => 0,
	'svg:v-ideographic' => 0,
	'svg:v-mathematical' => 0,
	'svg:viewBox' => 0,
	'svg:width' => 'width',
	'svg:widths' => 0,
	'svg:x' => 0,
	'svg:x-height' => 0,
	'svg:x1' => 0,
	'svg:x2' => 0,
	'svg:y' => 0,
	'svg:y1' => 0,
	'svg:y2' => 0,
        );
    /**
     * svg namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $svg_elements = array(
	'svg:definition-src' => 0,
	'svg:desc' => 0,
	'svg:font-face-format' => 0,
	'svg:font-face-name' => 0,
	'svg:font-face-src' => 0,
	'svg:font-face-uri' => 0,
	'svg:linearGradient' => 0,
	'svg:radialGradient' => 0,
	'svg:stop' => 0,
	'svg:title' => 0,
        );
    
    /**
     * table namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $table_attributes = array(
	'table:acceptance-state' => 0,
	'table:add-empty-lines' => 0,
	'table:algorithm' => 0,
	'table:align' => array('method' => '_tableAlign'),
	'table:allow-empty-cell' => 0,
	'table:application-data' => 0,
	'table:automatic-find-labels' => 0,
	'table:base-cell-address' => 0,
	'table:bind-styles-to-content' => 0,
	'table:border-color' => 0,
	'table:border-model' => array('name' => 'border-collapse',
                                      'collapsing' => 'collapse',
                                      'separating' => 'separate',
                                      ),
	'table:buttons' => 0,
	'table:case-sensitive' => 0,
	'table:cell-address' => 0,
	'table:cell-range' => 0,
	'table:cell-range-address' => 0,
	'table:column' => 0,
	'table:comment' => 0,
	'table:condition' => 0,
	'table:condition-source' => 0,
	'table:condition-source-range-address' => 0,
	'table:contains-error' => 0,
	'table:contains-header' => 0,
	'table:content-validation-name' => 0,
	'table:copy-back' => 0,
	'table:copy-formulas' => 0,
	'table:copy-styles' => 0,
	'table:count' => 0,
	'table:country' => 0,
	'table:data-cell-range-address' => 0,
	'table:data-field' => 0,
	'table:data-type' => 0,
	'table:database-name' => 0,
	'table:database-table-name' => 0,
	'table:date-end' => 0,
	'table:date-start' => 0,
	'table:date-value' => 0,
	'table:default-cell-style-name' => 0,
	'table:direction' => 0,
	'table:display' => 0,
	'table:display-border' => 0,
	'table:display-duplicates' => 0,
	'table:display-filter-buttons' => 0,
	'table:display-list' => 0,
	'table:display-member-mode' => 0,
	'table:drill-down-on-double-click' => 0,
	'table:enabled' => 0,
	'table:end' => 0,
	'table:end-cell-address' => 0,
	'table:end-column' => 0,
	'table:end-position' => 0,
	'table:end-row' => 0,
	'table:end-table' => 0,
	'table:end-x' => 0,
	'table:end-y' => 0,
	'table:execute' => 0,
	'table:expression' => 0,
	'table:field-name' => 0,
	'table:field-number' => 0,
	'table:filter-name' => 0,
	'table:filter-options' => 0,
	'table:formula' => 0,
	'table:function' => 0,
	'table:grand-total' => 0,
	'table:group-by-field-number' => 0,
	'table:grouped-by' => 0,
	'table:has-persistent-data' => 0,
	'table:id' => 0,
	'table:identify-categories' => 0,
	'table:ignore-empty-rows' => 0,
	'table:index' => 0,
	'table:is-active' => 0,
	'table:is-data-layout-field' => 0,
	'table:is-selection' => 0,
	'table:is-sub-table' => 0,
	'table:label-cell-range-address' => 0,
	'table:language' => 0,
	'table:last-column-spanned' => 0,
	'table:last-row-spanned' => 0,
	'table:layout-mode' => 0,
	'table:link-to-source-data' => 0,
	'table:marked-invalid' => 0,
	'table:matrix-covered' => 0,
	'table:maximum-difference' => 0,
	'table:member-count' => 0,
	'table:member-name' => 0,
	'table:member-type' => 0,
	'table:message-type' => 0,
	'table:mode' => 0,
	'table:multi-deletion-spanned' => 0,
	'table:name' => 0,
	'table:null-year' => 0,
	'table:number-columns-repeated' => 0,
	'table:number-columns-spanned' => 0,
	'table:number-matrix-columns-spanned' => 0,
	'table:number-matrix-rows-spanned' => 0,
	'table:number-rows-repeated' => 0,
	'table:number-rows-spanned' => 0,
	'table:object-name' => 0,
	'table:on-update-keep-size' => 0,
	'table:on-update-keep-styles' => 0,
	'table:operator' => 0,
	'table:order' => 0,
	'table:orientation' => 0,
	'table:page-breaks-on-group-change' => 0,
	'table:parse-sql-statement' => 0,
	'table:password' => 0,
	'table:position' => 0,
	'table:precision-as-shown' => 0,
	'table:print' => 0,
	'table:print-ranges' => 0,
	'table:protect' => 0,
	'table:protected' => 0,
	'table:protection-key' => 0,
	'table:query-name' => 0,
	'table:range-usable-as' => 0,
	'table:refresh-delay' => 0,
	'table:refresh-delay' => 0,
	'table:rejecting-change-id' => 0,
	'table:row' => 0,
	'table:scenario-ranges' => 0,
	'table:search-criteria-must-apply-to-whole-cell' => 0,
	'table:selected-page' => 0,
	'table:show-details' => 0,
	'table:show-empty' => 0,
	'table:show-filter-button' => 0,
	'table:sort-mode' => 0,
	'table:source-cell-range-addresses' => 0,
	'table:source-field-name' => 0,
	'table:source-name' => 0,
	'table:sql-statement' => 0,
	'table:start' => 0,
	'table:start-column' => 0,
	'table:start-position' => 0,
	'table:start-row' => 0,
	'table:start-table' => 0,
	'table:status' => 0,
	'table:step' => 0,
	'table:steps' => 0,
	'table:structure-protected' => 0,
	'table:style-name' => 0,
	'table:table' => 0,
	'table:table-background' => 0,
	'table:table-name' => 0,
	'table:target-cell-address' => 0,
	'table:target-range-address' => 0,
	'table:title' => 0,
	'table:track-changes' => 0,
	'table:type' => 0,
	'table:type' => 0,
	'table:use-labels' => 0,
	'table:use-regular-expressions' => 0,
	'table:used-hierarchy' => 0,
	'table:user-name' => 0,
	'table:value' => 0,
	'table:value-type' => 0,
	'table:visibility' => 0,
        );
    /**
     * HTML inline tags
     * @access public
     * @static
     * @var array
     */
    public static $table_elements = array(
	'table:body' => 0,
	'table:calculation-settings' => 0,
	'table:cell-address' => 0,
	'table:cell-content-change' => 0,
	'table:cell-content-deletion' => 0,
	'table:cell-range-source' => 0,
	'table:change-deletion' => 0,
	'table:change-track-table-cell' => 0,
	'table:consolidation' => 0,
	'table:content-validation' => 0,
	'table:content-validations' => 0,
	'table:covered-table-cell' => 0,
	'table:cut-offs' => 0,
	'table:data-pilot-display-info' => 0,
	'table:data-pilot-field' => 0,
	'table:data-pilot-field-reference' => 0,
	'table:data-pilot-group' => 0,
	'table:data-pilot-group-member' => 0,
	'table:data-pilot-groups' => 0,
	'table:data-pilot-layout-info' => 0,
	'table:data-pilot-level' => 0,
	'table:data-pilot-member' => 0,
	'table:data-pilot-members' => 0,
	'table:data-pilot-sort-info' => 0,
	'table:data-pilot-subtotal' => 0,
	'table:data-pilot-subtotals' => 0,
	'table:data-pilot-table' => 0,
	'table:data-pilot-tables' => 0,
	'table:database-range' => 0,
	'table:database-ranges' => 0,
	'table:database-source-query' => 0,
	'table:database-source-sql' => 0,
	'table:database-source-table' => 0,
	'table:dde-link' => 0,
	'table:dde-links' => 0,
	'table:deletion' => 0,
	'table:deletions' => 0,
	'table:dependencies' => 0,
	'table:dependency' => 0,
	'table:detective' => 0,
	'table:error-macro' => 0,
	'table:error-message' => 0,
	'table:even-columns' => 0,
	'table:even-rows' => 0,
	'table:filter' => 0,
	'table:filter-and' => 0,
	'table:filter-condition' => 0,
	'table:filter-or' => 0,
	'table:first-column' => 0,
	'table:first-row' => 0,
	'table:help-message' => 0,
	'table:highlighted-range' => 0,
	'table:insertion' => 0,
	'table:insertion-cut-off' => 0,
	'table:iteration' => 0,
	'table:label-range' => 0,
	'table:label-ranges' => 0,
	'table:last-column' => 0,
	'table:last-row' => 0,
	'table:movement' => 0,
	'table:movement-cut-off' => 0,
	'table:named-expression' => 0,
	'table:named-expressions' => 0,
	'table:named-range' => 0,
	'table:null-date' => 0,
	'table:odd-columns' => 0,
	'table:odd-rows' => 0,
	'table:operation' => 0,
	'table:previous' => 0,
	'table:scenario' => 0,
	'table:shapes' => 0,
	'table:sort' => 0,
	'table:sort-by' => 0,
	'table:sort-groups' => 0,
	'table:source-cell-range' => 0,
	'table:source-range-address' => 0,
	'table:source-service' => 0,
	'table:subtotal-field' => 0,
	'table:subtotal-rule' => 0,
	'table:subtotal-rules' => 0,
	'table:table' => 0,
	'table:table-cell' => 0,
	'table:table-column' => 0,
	'table:table-column-group' => 0,
	'table:table-columns' => 0,
	'table:table-header-columns' => 0,
	'table:table-header-rows' => 0,
	'table:table-row' => 0,
	'table:table-row-group' => 0,
	'table:table-rows' => 0,
	'table:table-source' => 0,
	'table:table-template' => 0,
	'table:target-range-address' => 0,
	'table:tracked-changes' => 0,
        );
    /**
     * text namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $text_attributes = array(
        'text:active' => 0,
        'text:address' => 0,
        'text:alphabetical-separators' => 0,
        'text:anchor-page-number' => 0,
        'text:anchor-type' => 0,
        'text:animation' => 0,
        'text:animation-delay' => 0,
        'text:animation-direction' => 0,
        'text:animation-repeat' => 0,
        'text:animation-start-inside' => 0,
        'text:animation-steps' => 0,
        'text:animation-stop-inside' => 0,
        'text:annote' => 0,
        'text:author' => 0,
        'text:bibliography-data-field' => 0,
        'text:bibliography-type' => 0,
        'text:booktitle' => 0,
        'text:bullet-char' => 0,
        'text:bullet-relative-size' => 0,
        'text:c' => 0,
        'text:capitalize-entries' => 0,
        'text:caption-sequence-format' => 0,
        'text:caption-sequence-name' => 0,
        'text:change-id' => 0,
        'text:chapter' => 0,
        'text:citation-body-style-name' => 0,
        'text:citation-style-name' => 0,
        'text:class-names' => 0,
        'text:column-name' => 0,
        'text:combine-entries' => 0,
        'text:combine-entries-with-dash' => 0,
        'text:combine-entries-with-pp' => 0,
        'text:comma-separated' => 0,
        'text:cond-style-name' => 0,
        'text:condition' => 0,
        'text:connection-name' => 0,
        'text:consecutive-numbering' => 0,
        'text:continue-numbering' => 0,
        'text:copy-outline-levels' => 0,
        'text:count-empty-lines' => 0,
        'text:count-in-text-boxes' => 0,
        'text:current-value' => 0,
        'text:custom1' => 0,
        'text:custom2' => 0,
        'text:custom3' => 0,
        'text:custom4' => 0,
        'text:custom5' => 0,
        'text:database-name' => 0,
        'text:date-adjust' => 0,
        'text:date-value' => 0,
        'text:date-value' => 0,
        'text:default-style-name' => 0,
        'text:description' => 0,
        'text:display' => 'display',
        'text:display-levels' => 0,
        'text:display-outline-level' => 0,
        'text:dont-balance-text-columns' => 0,
        'text:duration' => 0,
        'text:edition' => 0,
        'text:editor' => 0,
        'text:filter-name' => 0,
        'text:first-row-end-column' => 0,
        'text:first-row-start-column' => 0,
        'text:fixed' => 0,
        'text:footnotes-position' => 0,
        'text:formula' => 0,
        'text:global' => 0,
        'text:howpublished' => 0,
        'text:id' => 0,
        'text:identifier' => 0,
        'text:ignore-case' => 0,
        'text:increment' => 0,
        'text:index-name' => 0,
        'text:index-scope' => 0,
        'text:institution' => 0,
        'text:is-hidden' => 0,
        'text:is-list-header' => 0,
        'text:isbn' => 0,
        'text:issn' => 0,
        'text:journal' => 0,
        'text:key' => 0,
        'text:key1' => 0,
        'text:key1-phonetic' => 0,
        'text:key2' => 0,
        'text:key2-phonetic' => 0,
        'text:kind' => 0,
        'text:label' => 0,
        'text:last-row-end-column' => 0,
        'text:last-row-start-column' => 0,
        'text:level' => 0,
        'text:line-break' => 0,
        'text:line-number' => 0,
        'text:main-entry' => 0,
        'text:main-entry-style-name' => 0,
        'text:master-page-name' => 0,
        'text:min-label-distance' => 0,
        'text:min-label-width' => 0,
        'text:month' => 0,
        'text:name' => 0,
        'text:note' => 0,
        'text:note-class' => 0,
        'text:number' => 0,
        'text:number-lines' => 0,
        'text:number-position' => 0,
        'text:numbered-entries' => 0,
        'text:offset' => 0,
        'text:organizations' => 0,
        'text:outline-level' => 0,
        'text:page-adjust' => 0,
        'text:pages' => 0,
        'text:paragraph-style-name' => 0,
        'text:placeholder-type' => 0,
        'text:prefix' => 0,
        'text:protected' => 0,
        'text:protection-key' => 0,
        'text:publisher' => 0,
        'text:ref-name' => 0,
        'text:reference-format' => 0,
        'text:relative-tab-stop-position' => 0,
        'text:report-type' => 0,
        'text:restart-numbering' => 0,
        'text:restart-on-page' => 0,
        'text:row-number' => 0,
        'text:school' => 0,
        'text:section-name' => 0,
        'text:select-page' => 0,
        'text:separation-character' => 0,
        'text:series' => 0,
        'text:sort-algorithm' => 0,
        'text:sort-ascending' => 0,
        'text:sort-by-position' => 0,
        'text:space-before' => 0,
        'text:start-numbering-at' => 0,
        'text:start-value' => 0,
        'text:string-value' => 0,
        'text:string-value-if-false' => 0,
        'text:string-value-if-true' => 0,
        'text:string-value-phonetic' => 0,
        'text:style-name' => 0,
        'text:suffix' => 0,
        'text:tab-ref' => 0,
        'text:table-name' => 0,
        'text:table-type' => 0,
        'text:time-adjust' => 0,
        'text:time-value' => 0,
        'text:title' => 0,
        'text:track-changes' => 0,
        'text:url' => 0,
        'text:use-caption' => 0,
        'text:use-chart-objects' => 0,
        'text:use-draw-objects' => 0,
        'text:use-floating-frames' => 0,
        'text:use-graphics' => 0,
        'text:use-index-marks' => 0,
        'text:use-index-source-styles' => 0,
        'text:use-keys-as-entries' => 0,
        'text:use-math-objects' => 0,
        'text:use-objects' => 0,
        'text:use-other-objects' => 0,
        'text:use-outline-level' => 0,
        'text:use-soft-page-breaks' => 0,
        'text:use-spreadsheet-objects' => 0,
        'text:use-tables' => 0,
        'text:value' => 0,
        'text:visited-style-name' => 0,
        'text:volume' => 0,
        'text:year' => 0,
        );
        
    /**
     * text namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $text_elements = array(
        'text:a' => 0,
        'text:alphabetical-index' => 0,
        'text:alphabetical-index-auto-mark-file' => 0,
        'text:alphabetical-index-entry-template' => 0,
        'text:alphabetical-index-mark' => 0,
        'text:alphabetical-index-mark-end' => 0,
        'text:alphabetical-index-mark-start' => 0,
        'text:alphabetical-index-source' => 0,
        'text:animation-element' => 0,
        'text:any-number' => 0,
        'text:author-initials' => 0,
        'text:author-name' => 0,
        'text:bibliography' => 0,
        'text:bibliography-configuration' => 0,
        'text:bibliography-entry-template' => 0,
        'text:bibliography-mark' => 0,
        'text:bibliography-source' => 0,
        'text:bookmark' => 0,
        'text:bookmark-end' => 0,
        'text:bookmark-ref' => 0,
        'text:bookmark-start' => 0,
        'text:change' => 0,
        'text:change-end' => 0,
        'text:change-marks' => 0,
        'text:change-start' => 0,
        'text:changed-region' => 0,
        'text:chapter' => 0,
        'text:character-count' => 0,
        'text:column-controls' => 0,
        'text:conditional-text' => 0,
        'text:controls' => 0,
        'text:creation-date' => 0,
        'text:creation-time' => 0,
        'text:creator' => 0,
        'text:database-display' => 0,
        'text:database-name' => 0,
        'text:database-next' => 0,
        'text:database-row-number' => 0,
        'text:database-row-select' => 0,
        'text:date' => 0,
        'text:dde-connection' => 0,
        'text:dde-connection-decl' => 0,
        'text:dde-connection-decls' => 0,
        'text:deletion' => 0,
        'text:description' => 0,
        'text:editing-cycles' => 0,
        'text:editing-duration' => 0,
        'text:execute-macro' => 0,
        'text:expression' => 0,
        'text:file-name' => 0,
        'text:form-property' => 0,
        'text:format-change' => 0,
        'text:h' => 0,
        'text:hidden-paragraph' => 0,
        'text:hidden-text' => 0,
        'text:illustration-index' => 0,
        'text:illustration-index-entry-template' => 0,
        'text:illustration-index-source' => 0,
        'text:image-count' => 0,
        'text:index-body' => 0,
        'text:index-entry-bibliography' => 0,
        'text:index-entry-chapter' => 0,
        'text:index-entry-link-end' => 0,
        'text:index-entry-link-start' => 0,
        'text:index-entry-page-number' => 0,
        'text:index-entry-span' => 0,
        'text:index-entry-tab-stop' => 0,
        'text:index-entry-text' => 0,
        'text:index-source-style' => 0,
        'text:index-source-styles' => 0,
        'text:index-title' => 0,
        'text:index-title-template' => 0,
        'text:initial-creator' => 0,
        'text:insertion' => 0,
        'text:keywords' => 0,
        'text:line-break' => 0,
        'text:linenumbering-configuration' => 0,
        'text:linenumbering-separator' => 0,
        'text:list' => 0,
        'text:list-header' => 0,
        'text:list-item' => 0,
        'text:list-level-style-bullet' => 0,
        'text:list-level-style-image' => 0,
        'text:list-level-style-number' => 0,
        'text:list-style' => 0,
        'text:measure' => 0,
        'text:modification-date' => 0,
        'text:modification-time' => 0,
        'text:note' => 0,
        'text:note-body' => 0,
        'text:note-citation' => 0,
        'text:note-continuation-notice-backward' => 0,
        'text:note-continuation-notice-forward' => 0,
        'text:note-ref' => 0,
        'text:notes-configuration' => 0,
        'text:number' => 0,
        'text:numbered-paragraph' => 0,
        'text:object-count' => 0,
        'text:object-index' => 0,
        'text:object-index-entry-template' => 0,
        'text:object-index-source' => 0,
        'text:office-body-content' => 0,
        'text:office-chart-content-main' => 0,
        'text:office-meta-data' => 0,
        'text:outline-level-style' => 0,
        'text:outline-style' => 0,
        'text:p' => 1,
        'text:page' => 0,
        'text:page-continuation' => 0,
        'text:page-count' => 0,
        'text:page-number' => 0,
        'text:page-sequence' => 0,
        'text:page-variable-get' => 0,
        'text:page-variable-set' => 0,
        'text:paragraph-count' => 0,
        'text:placeholder' => 0,
        'text:presentation-animation-elements' => 0,
        'text:presentation-decl' => 0,
        'text:print-date' => 0,
        'text:print-time' => 0,
        'text:printed-by' => 0,
        'text:reference-mark' => 0,
        'text:reference-mark-end' => 0,
        'text:reference-mark-start' => 0,
        'text:reference-ref' => 0,
        'text:ruby' => 0,
        'text:ruby-base' => 0,
        'text:ruby-text' => 0,
        'text:s' => 0,
        'text:script' => 0,
        'text:section' => 0,
        'text:section-source' => 0,
        'text:sender-city' => 0,
        'text:sender-company' => 0,
        'text:sender-country' => 0,
        'text:sender-email' => 0,
        'text:sender-fax' => 0,
        'text:sender-firstname' => 0,
        'text:sender-initials' => 0,
        'text:sender-lastname' => 0,
        'text:sender-phone-private' => 0,
        'text:sender-phone-work' => 0,
        'text:sender-position' => 0,
        'text:sender-postal-code' => 0,
        'text:sender-state-or-province' => 0,
        'text:sender-street' => 0,
        'text:sender-title' => 0,
        'text:sequence' => 0,
        'text:sequence-decl' => 0,
        'text:sequence-decls' => 0,
        'text:sequence-ref' => 0,
        'text:shapes3d' => 0,
        'text:sheet-name' => 0,
        'text:soft-page-break' => 0,
        'text:sort-key' => 0,
        'text:span' => 1,
        'text:subject' => 0,
        'text:tab' => 0,
        'text:table-count' => 0,
        'text:table-formula' => 0,
        'text:table-index' => 0,
        'text:table-index-entry-template' => 0,
        'text:table-index-source' => 0,
        'text:table-of-content' => 0,
        'text:table-of-content-entry-template' => 0,
        'text:table-of-content-source' => 0,
        'text:template-name' => 0,
        'text:text-changed-region-content' => 0,
        'text:text-input' => 0,
        'text:text-list-style-content' => 0,
        'text:text-section-source-dde' => 0,
        'text:text-table-of-content-children' => 0,
        'text:time' => 0,
        'text:title' => 0,
        'text:toc-mark' => 0,
        'text:toc-mark-end' => 0,
        'text:toc-mark-start' => 0,
        'text:tracked-changes' => 0,
        'text:user-defined' => 0,
        'text:user-field-decl' => 0,
        'text:user-field-decls' => 0,
        'text:user-field-get' => 0,
        'text:user-field-input' => 0,
        'text:user-index' => 0,
        'text:user-index-entry-template' => 0,
        'text:user-index-mark' => 0,
        'text:user-index-mark-end' => 0,
        'text:user-index-mark-start' => 0,
        'text:user-index-source' => 0,
        'text:variable-decl' => 0,
        'text:variable-decls' => 0,
        'text:variable-get' => 0,
        'text:variable-input' => 0,
        'text:variable-set' => 0,
        'text:word-count' => 0,
        );
    
    /**
     * text namespace group elements
     * @access public
     * @static
     * @var array
     */
    public static $text_groups = array(
        'text:any-date' => 0,
        'text:any-time' => 0,
        'text:anyAttListOrElements' => 0,
        'text:anyElements' => 0,
        'text:common-field-database-name' => 0,
        'text:common-field-database-table' => 0,
        'text:currency-symbol-and-text' => 0,
        'text:draw-text' => 0,
        'text:index-content-main' => 0,
        'text:number-and-text' => 0,
        'text:office-automatic-styles' => 0,
        'text:office-chart-content-epilogue' => 0,
        'text:office-chart-content-prelude' => 0,
        'text:office-drawing-content-epilogue' => 0,
        'text:office-drawing-content-main' => 0,
        'text:office-drawing-content-prelude' => 0,
        'text:office-font-face-decls' => 0,
        'text:office-forms' => 0,
        'text:office-master-styles' => 0,
        'text:office-presentation-content-epilogue' => 0,
        'text:office-presentation-content-main' => 0,
        'text:office-presentation-content-prelude' => 0,
        'text:office-scripts' => 0,
        'text:office-settings' => 0,
        'text:office-spreadsheet-content-epilogue' => 0,
        'text:office-spreadsheet-content-main' => 0,
        'text:office-spreadsheet-content-prelude' => 0,
        'text:office-styles' => 0,
        'text:office-text-content-epilogue' => 0,
        'text:office-text-content-main' => 0,
        'text:office-text-content-prelude' => 0,
        'text:paragraph-content' => 0,
        'text:presentation-decls' => 0,
        'text:presentation-settings' => 0,
        'text:shape' => 0,
        'text:style-background-image' => 0,
        'text:style-columns' => 0,
        'text:style-drop-cap' => 0,
        'text:style-footnote-sep' => 0,
        'text:style-properties-content' => 0,
        'text:style-tab-stops' => 0,
        'text:styles' => 0,
        'text:table-columns' => 0,
        'text:table-columns-and-groups' => 0,
        'text:table-columns-no-group' => 0,
        'text:table-decls' => 0,
        'text:table-functions' => 0,
        'text:table-rows' => 0,
        'text:table-rows-and-groups' => 0,
        'text:table-rows-no-group' => 0,
        'text:text-content' => 0,
        'text:text-decls' => 0,
        'text:text-tracked-changes' => 0,
    );
    /**
     * xforms namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $xforms_attributes = array(
	'xforms:model        ' => 0,
        );
    /**
     * xforms namespace elements
     * @access public
     * @static
     * @var array
     */
    public static $xforms_elements = array(
	'xforms:bind        ' => 0,
        );
    /**
     * xlink namespace attributes
     * @access public
     * @static
     * @var array
     */
    public static $xlink_attributes = array(
	'xlink:actuate' => 0,
	'xlink:href' => array('method' => '_parseBackgroundURL'),
	'xlink:show' => 0,
	'xlink:title' => 0,
	'xlink:type' => 0,
        );

    
    public function __construct()
    {        
        //Do nothing 
    }

}