<?php
/*
	Plugin Name: Disable Media Sizes
	Plugin URI: https://perishablepress.com/wordpress-disable-media-sizes/
	Description: Provides options to disable the extra images generated by WordPress.
	Tags: media, images, disable, disable image sizes, uploads
	Author: Jeff Starr
	Author URI: https://plugin-planet.com/
	Donate link: https://monzillamedia.com/donate.html
	Contributors: specialk
	Requires at least: 5.3
	Tested up to: 6.9
	Stable tag: 2.4
	Version:    2.4
	Requires PHP: 5.6.20
	Text Domain: disable-media-sizes
	Domain Path: /languages
	License: GPL v2 or later
*/

/*
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 
	2 of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	with this program. If not, visit: https://www.gnu.org/licenses/
	
	Copyright 2025 Monzilla Media. All rights reserved.
*/

if (!defined('ABSPATH')) exit;

if (!defined('DISABLE_MEDIA_SIZES_VERSION')) define('DISABLE_MEDIA_SIZES_VERSION', '2.4');
if (!defined('DISABLE_MEDIA_SIZES_URL'))     define('DISABLE_MEDIA_SIZES_URL', plugin_dir_url(__FILE__));

register_activation_hook(__FILE__, 'disable_media_sizes_dismiss_notice_activate');

require_once(plugin_dir_path(__FILE__) .'inc/settings.php');
require_once(plugin_dir_path(__FILE__) .'inc/core.php');

add_action('admin_menu',    'disable_media_sizes_menu_page');
add_action('admin_init',    'disable_media_sizes_register_settings');
add_action('admin_init',    'disable_media_sizes_dismiss_notice_save');
add_action('admin_init',    'disable_media_sizes_dismiss_notice_version');
add_action('admin_init',    'disable_media_sizes_reset_options');
add_action('admin_notices', 'disable_media_sizes_admin_notice');

add_action('intermediate_image_sizes_advanced', 'disable_media_sizes_intermediate_image_sizes');
add_filter('big_image_size_threshold', 'disable_media_sizes_big_image_size');

add_filter('plugin_action_links',   'disable_media_sizes_plugin_action_links', 10, 2);
add_filter('plugin_row_meta',       'disable_media_sizes_plugin_row_meta',     10, 2);
add_filter('admin_footer_text',     'disable_media_sizes_admin_footer_text',   10, 1);
add_action('admin_print_scripts',   'disable_media_sizes_admin_print_scripts');
add_action('admin_enqueue_scripts', 'disable_media_sizes_enqueue_resources_admin');