<tr valign="top">
    <th scope="row" class="titledesc">
        <label for="<?php echo esc_attr( $option->get_id_attribute() ); ?>"><?php echo esc_html( $option->get_label() ); ?></label>
    </th>
    <td class="forminp forminp-text">

        <?php foreach($option->get_arg('options', []) as $key => $label) { ?>
            <div>
                <label>
                    <input name="<?php echo esc_attr($option->get_name_attribute()); ?>" id="<?php echo esc_attr($option->get_id_attribute()); ?>" type="radio" value="<?php echo esc_attr( $key ); ?>" <?php checked($key, $option->get_value_attribute()); ?>>
                    <?php echo esc_html( $label ); ?>
                </label>
            </div>
        <?php } ?>

        <?php if($description = $option->get_arg('description')) { ?>
            <p class="description"><?php echo esc_html( $description ); ?></p>
        <?php } ?>

        <?php if($error = $option->has_error()) { ?>
            <div class="wps-error-feedback"><?php echo esc_html( $error ); ?></div>
        <?php } ?>
    </td>
</tr>