/**
 * WordPress dependencies
 */
import { Component, createElement } from '@wordpress/element';
import { Icon } from '@wordpress/components';

export default class MVXIcon extends Component {
	render() {
		const { icon, size = 20, className } = this.props;
		let path, mvxIcon;

		switch ( icon ) {
			case 'top-vendor':
				path =
					'M15.573,11.624c0.568-0.478,0.947-1.219,0.947-2.019c0-1.37-1.108-2.569-2.371-2.569s-2.371,1.2-2.371,2.569c0,0.8,0.379,1.542,0.946,2.019c-0.253,0.089-0.496,0.2-0.728,0.332c-0.743-0.898-1.745-1.573-2.891-1.911c0.877-0.61,1.486-1.666,1.486-2.812c0-1.79-1.479-3.359-3.162-3.359S4.269,5.443,4.269,7.233c0,1.146,0.608,2.202,1.486,2.812c-2.454,0.725-4.252,2.998-4.252,5.685c0,0.218,0.178,0.396,0.395,0.396h16.203c0.218,0,0.396-0.178,0.396-0.396C18.497,13.831,17.273,12.216,15.573,11.624 M12.568,9.605c0-0.822,0.689-1.779,1.581-1.779s1.58,0.957,1.58,1.779s-0.688,1.779-1.58,1.779S12.568,10.427,12.568,9.605 M5.06,7.233c0-1.213,1.014-2.569,2.371-2.569c1.358,0,2.371,1.355,2.371,2.569S8.789,9.802,7.431,9.802C6.073,9.802,5.06,8.447,5.06,7.233 M2.309,15.335c0.202-2.649,2.423-4.742,5.122-4.742s4.921,2.093,5.122,4.742H2.309z M13.346,15.335c-0.067-0.997-0.382-1.928-0.882-2.732c0.502-0.271,1.075-0.429,1.686-0.429c1.828,0,3.338,1.385,3.535,3.161H13.346z';
				break;
			case 'products':
				path =
					'M18.6,12.9c-0.2-0.1-0.5-0.1-0.7-0.1c-0.1,0-0.2,0-0.3,0h-0.1v-0.3c0-0.2,0-0.3,0-0.5c0-0.4,0-0.8,0-1.2  c0-0.7-0.3-1.2-0.9-1.5C16.4,9.2,16.2,9.1,16,9C16,9,15.9,9,15.8,9h-2.2v3c0,0.6-0.3,0.9-0.9,0.9H8.5v6.4h9.1c0.2,0,0.4,0,0.6,0 c0.9-0.1,1.7-0.8,1.7-1.7c0-0.9,0-1.8,0-2.8C20.1,13.8,19.5,13.1,18.6,12.9z M12.5,18.1H9.6V14h2.8V18.1z M19.1,17.4    c0,0.4-0.3,0.7-0.7,0.7c-0.5,0-1.1,0-1.7,0c-0.6,0-1.2,0-1.8,0h-1c-0.1,0-0.1,0-0.1,0L13.6,18V17c0-0.9,0-1.9,0-2.8 c0-0.1,0.1-0.3,0.3-0.4c0.7-0.3,1.1-0.9,1.1-1.7c0-0.5,0-0.9,0-1.3c0-0.2,0-0.4,0-0.6v-0.1H15c0.1,0,0.1,0,0.3,0c0.1,0,0.3,0,0.5,0  c0.4,0,0.7,0.3,0.7,0.8c0,0.7,0,1.3,0,2.1v1.1h0.7c0.3,0,0.7,0,1.1,0c0.5,0,0.7,0.3,0.7,0.7C19.1,15.6,19.1,16.4,19.1,17.4z M4,4.8  v14h2.8v-1.1H5.1v-12h13.7v1.3h1.1V4.7C17.8,4.8,8.6,4.8,4,4.8z';
				break;
			case 'contact-vendor':
				path =
					'M16.3,4.1c1.4,0.2,2.4,1.3,2.4,2.7c0,2.7,0,5.3,0,7.9c0,1.5-1.2,2.7-2.8,2.7c-0.7,0-1.3,0-2.1,0c-0.1,0-0.1,0.1-0.2,0.1    c-0.4,0.7-0.8,1.3-1.2,2c-0.1,0.1-0.2,0.3-0.4,0.4c-0.1,0-0.1,0-0.3,0c-0.2-0.1-0.3-0.2-0.4-0.4c-0.4-0.7-0.8-1.3-1.2-2 c-0.1-0.1-0.1-0.1-0.2-0.1c-0.7,0-1.4,0-2.1,0c-1.5,0-2.7-1.3-2.7-2.7c0-2.7,0-5.4,0-8c0-1.3,0.7-2.3,1.9-2.7   C7.9,3.8,16.3,4,16.3,4.1z M11.9,18.6c0.1-0.1,0.7-1.3,1.1-1.8c0.1-0.2,0.3-0.3,0.5-0.3c0.8,0,1.5,0,2.3,0c1.1,0,1.8-0.7,1.8-1.8    c0-2.6,0-5.3,0-7.8c0-1.1-0.7-1.9-1.8-1.9c-2.7,0-5.3,0-7.9,0c-1.1,0-1.8,0.7-1.8,1.8c0,2.6,0,5.3,0,7.8c0,1.1,0.7,1.9,1.8,1.9  c0.8,0,1.5,0,2.3,0c0.3,0,0.4,0.1,0.5,0.3C11.1,17.3,11.9,18.5,11.9,18.6z M7.7,8.7c0-0.5,0.1-0.9,0.5-1.3c0.3-0.3,0.7-0.6,0.9-0.9  c0.3-0.3,0.5-0.3,0.8,0c0.6,0.6,1.3,1.3,1.9,1.9c0.3,0.3,0.3,0.5,0,0.7s-0.5,0.5-0.8,0.8c-0.1,0.1-0.1,0.1-0.1,0.3  c0.4,0.7,0.9,1.2,1.6,1.6c0.1,0.1,0.1,0.1,0.2-0.1c0.3-0.3,0.5-0.5,0.8-0.8c0.3-0.3,0.5-0.3,0.8,0c0.7,0.6,1.3,1.3,1.9,1.9  c0.3,0.3,0.3,0.5,0,0.7c-0.3,0.3-0.7,0.6-0.9,0.9c-0.5,0.5-1,0.6-1.6,0.5c-0.8-0.1-1.5-0.5-2.3-0.9c-1.3-0.9-2.5-2.1-3.3-3.5    C7.9,9.9,7.7,9.3,7.7,8.7z M10.7,8.7c-0.4-0.4-0.8-0.9-1.2-1.3C9.3,7.7,9.2,7.9,8.9,8.1C8.7,8.2,8.7,8.5,8.7,8.7    C8.7,9.2,8.8,9.6,9,9.9c0.8,1.5,1.9,2.7,3.5,3.5c0.4,0.3,0.9,0.4,1.3,0.5c0.3,0.1,0.5,0.1,0.7-0.1c0.3-0.3,0.5-0.5,0.7-0.7  c-0.4-0.4-0.8-0.8-1.3-1.3c-0.2,0.2-0.5,0.5-0.7,0.7c-0.2,0.2-0.4,0.3-0.7,0.2c-0.2-0.1-0.5-0.1-0.6-0.3c-0.6-0.3-1.1-0.9-1.5-1.4   c-0.3-0.3-0.5-0.6-0.5-1c-0.1-0.3,0-0.5,0.2-0.8C10.3,9.1,10.5,8.9,10.7,8.7z';
				break;
			case 'product-search':
				path =
					'M18.5,4H5.7c-1,0-1.6,0.6-1.6,1.7v10.1c0,0.9,0,1.9,0,2.7c0,0.7,0.5,1.3,1.2,1.5c0.3,0,0.5,0,0.7,0h0.2c1.3,0,2.7,0,3.9,0  c0.2,0,0.3-0.1,0.5-0.2c0.1-0.1,0.1-0.3,0.1-0.5c-0.1-0.3-0.3-0.4-0.6-0.4c-1.1,0-2.1,0-3.1,0H5.1V5.1h13.8v1.7c0,1.1,0,2.1,0,3.3   c0,0.1,0.1,0.3,0.1,0.5c0.1,0.2,0.4,0.2,0.5,0.1c0.3-0.1,0.3-0.3,0.3-0.5c0-1.3,0-2.7,0-3.9V5.7C20.1,4.6,19.5,4,18.5,4z M18.2,17.4 c-0.5-0.5-0.9-0.9-1.3-1.3c-0.3-0.3-0.3-0.5-0.1-0.9c0.7-1.2,0.7-2.6-0.1-3.7c-0.7-1.2-1.9-1.9-3.3-1.9h-0.1c-0.1,0-0.3,0-0.3,0.1   c-1,0.1-1.9,0.7-2.6,1.5c-0.6,0.9-0.9,1.9-0.7,2.9c0.3,1.3,1,2.3,2.1,2.8c1.1,0.5,2.4,0.5,3.5-0.1c0.1-0.1,0.2-0.1,0.3-0.1  c0.1,0,0.3,0.1,0.5,0.2c0.6,0.6,1.2,1.2,1.8,1.8l0.2,0.2c0.1,0.1,0.1,0.1,0.1,0.1c0.1,0.1,0.3,0.1,0.5,0.1c0.1-0.1,0.3-0.1,0.3-0.3  c0.1-0.1,0.1-0.3-0.1-0.6L18.2,17.4z M15.3,15.3c-0.5,0.5-1.2,0.8-1.9,0.8l0,0c-0.7,0-1.4-0.3-1.9-0.8s-0.8-1.2-0.8-1.9 c0-1.5,1.2-2.7,2.7-2.7l0,0c0.7,0,1.4,0.3,1.9,0.8c0.5,0.5,0.8,1.2,0.8,1.9C16.1,14.1,15.9,14.8,15.3,15.3z';
				break;
			case 'quick-info':
				path =
					'M15,4.6c-0.7-0.3-1.5-0.5-2.4-0.5C12.5,4,12.5,4,12.4,4h-0.9l-0.3,0.1c-0.2,0-0.4,0.1-0.7,0.1 C7.9,4.6,5.9,6.2,4.7,8.6C4.3,9.5,4.1,10.4,4,11.4c0,0.1,0,0.1,0,0.1v0.9l0.1,0.3c0,0.2,0.1,0.4,0.1,0.7c0.5,2.7,2.1,4.6,4.5,5.8    c1.1,0.5,2.5,0.8,3.7,0.7c2.8-0.2,5-1.5,6.5-3.9c0.9-1.3,1.2-2.8,1.1-4.4C19.7,8.3,18,5.9,15,4.6z M12,18.8c-0.1,0-0.1,0-0.1,0l0,0  c-3.8-0.1-6.8-3.2-6.7-7C5.2,10,5.9,8.2,7.3,7c1.3-1.3,3.1-1.9,4.9-1.9C14,5.2,15.8,5.9,17,7.3c1.3,1.3,1.9,3.1,1.9,4.9 C18.8,15.8,15.7,18.8,12,18.8z M11.4,10.4c0,1.4,0,2.8,0,4.2v1.2h1.1v-1.7c0-1.3,0-3.7,0-3.7S11.8,10.4,11.4,10.4z M11.4,8.2h1.1    v1.1h-1.1V8.2z';
				break;
			case 'vendor-list':
				path =
					'M17.1,4.1C16.8,4,16.4,4,16,4h-0.1c-1.9,0-3.9,0-5.8,0H7.8C7.7,4,7.6,4,7.5,4C6.2,3.9,5.1,4.7,4.8,5.9 C4.7,6.2,4.7,6.6,4.7,7v0.1c0,1.2,0,2.4,0,3.6v1.5v1.5c0,1.3,0,2.5,0,3.7c0,1.2,0.9,2.4,2.1,2.6C7.1,20,7.4,20,7.8,20h0.1   c1.5,0,3.1,0,4.6,0H15c0.5,0,0.9,0,1.5,0h0.1c1.3,0,2.4-0.9,2.6-2.1c0.1-0.3,0.1-0.7,0.1-1.1v-0.1c0-2.2,0-4.4,0-6.5V6.8    C19.1,5.4,18.3,4.4,17.1,4.1z M18,16.9c0,0.3,0,0.5-0.1,0.7c-0.1,0.8-0.6,1.2-1.4,1.3C16.4,19,16.2,19,16,19c-1.3,0-2.8,0-4.1,0 s-2.8,0-4.1,0c-0.3,0-0.5,0-0.7-0.1c-0.8-0.1-1.3-0.7-1.3-1.5c0-0.2-0.1-0.4-0.1-0.7c0-1.3,0-2.5,0-3.7v-2.3c0-1.3,0-2.5,0-3.7  c0-0.3,0-0.5,0.1-0.8C6,5.6,6.4,5.1,7.2,5c0.2,0,0.5-0.1,0.7-0.1c2.8,0,5.5,0,8.3,0c0.3,0,0.5,0,0.7,0.1c0.8,0.1,1.3,0.7,1.3,1.5    c0,0.2,0.1,0.4,0.1,0.6C18,10.3,18,13.6,18,16.9z M15.2,8.2c-0.5,0-1,0-1.5,0H13l0,0h-0.3c-0.1,0-0.3,0-0.5,0c-0.3,0-0.7,0-1,0  c-0.1,0-0.1,0-0.3,0.1c-0.3,0.1-0.3,0.3-0.3,0.5c0.1,0.3,0.3,0.4,0.5,0.4c1.4,0,2.8,0,4.2,0c0.1,0,0.1-0.1,0.3-0.1  c0.2-0.1,0.3-0.3,0.3-0.5C15.6,8.3,15.4,8.2,15.2,8.2z M15.1,14.9c-1.3,0-2.7,0-4.1,0c-0.1,0-0.3,0.1-0.3,0.1   c-0.1,0.1-0.3,0.3-0.1,0.5c0.1,0.2,0.3,0.3,0.5,0.3c0.5,0,1,0,1.5,0h0.6h0.5c0.5,0,1,0,1.5,0c0.3,0,0.5-0.2,0.5-0.5 C15.7,15.1,15.5,14.9,15.1,14.9z M15.1,11.5h-1.4h-0.6h-0.6h-1.4c-0.3,0-0.5,0.2-0.5,0.5c0,0.1,0.1,0.3,0.1,0.3s0.3,0.1,0.4,0.1 c1.3,0,2.7,0,4,0c0.3,0,0.5-0.2,0.5-0.5C15.7,11.7,15.5,11.5,15.1,11.5z M8.5,8.2L8.5,8.2C8.2,8.2,8,8.4,8,8.6  c0,0.3,0.2,0.5,0.5,0.5C8.6,9.1,8.8,9,8.8,9S9,8.8,9,8.6C9,8.4,8.8,8.2,8.5,8.2z M8.5,14.9c-0.1,0-0.3,0.1-0.3,0.1S8,15.2,8,15.4    c0,0.3,0.2,0.5,0.5,0.5c0.3,0,0.5-0.2,0.5-0.5c0-0.1-0.1-0.3-0.1-0.3S8.6,14.9,8.5,14.9z M8.4,11.5L8.4,11.5C8.2,11.5,8,11.7,8,12   c0,0.1,0.1,0.3,0.1,0.3s0.3,0.1,0.4,0.1C8.8,12.5,9,12.2,9,12C9,11.7,8.8,11.5,8.4,11.5z';
				break;
			case 'on-sale':
				path =
					'M18.1,12.2c-0.3-0.6-0.7-1.2-1.1-1.8c-0.4-0.5-0.9-1.1-1.3-1.5C15.3,8.4,15,8,14.6,7.6c-0.9-1.1-1.3-2-1.4-3.1 c-0.1-0.3-0.1-0.4-0.3-0.5C12.7,4,12.5,4,12.3,4.2c-1.1,1-1.8,2.3-2.1,3.7c-0.2,0.7-0.3,1.5-0.2,2.5l0.1,0.9l-0.7-0.5   c-0.5-0.4-1.1-0.9-1.2-1.5C8.1,8.9,8,8.8,7.7,8.7c-0.1,0-0.1,0-0.1,0C7.5,8.7,7.3,8.8,7.1,9c-1.5,1.9-2.1,3.9-1.5,6.1   c0.7,2.9,3.5,5.6,7.9,4.9c2.1-0.3,3.7-1.7,4.7-3.9C18.7,14.7,18.7,13.4,18.1,12.2z M16.9,16.2c-0.9,1.7-2.2,2.5-3.8,2.7 c-0.3,0.1-0.6,0.1-0.9,0.1c-2.8,0-5-1.6-5.6-4.3c-0.3-1.3-0.1-2.6,0.5-3.9l0.3-0.5l0.4,0.4c0.5,0.5,1.1,1,1.7,1.3   c0.3,0.1,0.7,0.3,1.1,0.5l0.1,0.1c0.2,0.1,0.4,0.1,0.5-0.1c0.1-0.1,0.2-0.3,0.1-0.6c-0.3-0.7-0.3-1.5-0.3-2.4   c0.1-1.1,0.3-2.1,0.9-3.1l0.4-0.7l0.3,0.7c0.6,1.3,1.5,2.3,2.4,3.4c0.2,0.2,0.4,0.5,0.5,0.7c0.5,0.7,0.9,1.1,1.3,1.7    C17.7,13.4,17.7,14.8,16.9,16.2z';
				break;
			case 'review':
				path =
					'M12.1,4C12,4,12,4,12.1,4C9.9,4,7.9,4.8,6.4,6.3S4,9.9,4,12c0,4.4,3.5,8,7.9,8c0,0,0,0,0.1,0c4.4,0,8-3.5,8-8  C20,7.6,16.5,4,12.1,4z M12,19L12,19c-1.9,0-3.7-0.7-4.9-2.1C5.7,15.6,5,13.9,5,12c0-1.9,0.7-3.7,2.1-4.9C8.4,5.7,10.1,5,12,5   c0,0,0,0,0.1,0c1.9,0,3.6,0.7,4.9,2.1s2,3.1,2,4.9C19,15.9,15.9,19,12,19z M16.1,10.5c-0.7-0.1-1.5-0.2-2.3-0.3 c-0.1,0-0.2-0.1-0.3-0.2c-0.1-0.3-0.3-0.6-0.5-0.9c-0.3-0.3-0.4-0.7-0.6-1.1c-0.1-0.3-0.3-0.3-0.5-0.3l0,0c-0.3,0-0.4,0.1-0.5,0.3   c-0.3,0.7-0.7,1.3-1,2.1c-0.1,0.1-0.1,0.1-0.3,0.2c-0.8,0.1-1.6,0.3-2.3,0.3c-0.3,0.1-0.5,0.1-0.5,0.3c-0.1,0.2,0,0.4,0.2,0.6   c0.5,0.5,1.1,1.1,1.7,1.6c0.1,0.1,0.1,0.2,0.1,0.3C9.1,14.3,9,15,8.9,15.7c-0.1,0.3,0,0.5,0.2,0.6c0.1,0.1,0.3,0.1,0.6,0    c0.3-0.1,0.6-0.3,0.9-0.5c0.4-0.2,0.7-0.4,1.1-0.6c0.1-0.1,0.1-0.1,0.2-0.1c0.1,0,0.1,0,0.2,0.1c0.5,0.3,1.1,0.6,1.7,0.9l0.3,0.2    c0.2,0.1,0.4,0.1,0.5-0.1c0.1-0.1,0.2-0.3,0.2-0.5l-0.1-0.6c-0.1-0.5-0.2-1.1-0.3-1.7c-0.1-0.1,0-0.3,0.1-0.3c0.3-0.3,0.7-0.7,1.1-1 c0.2-0.2,0.4-0.4,0.6-0.6c0.1-0.1,0.2-0.3,0.2-0.4l0,0C16.6,10.7,16.3,10.6,16.1,10.5z M14.8,11.5c-0.1,0.1-0.2,0.2-0.3,0.3 c-0.2,0.3-0.5,0.5-0.7,0.7c-0.3,0.3-0.3,0.5-0.3,0.8c0.1,0.3,0.1,0.7,0.1,1c0,0.1,0.1,0.3,0.1,0.5v0.1l-0.2-0.1 c-0.1,0-0.1-0.1-0.1-0.1l-0.3-0.1c-0.3-0.1-0.7-0.3-0.9-0.5c-0.2-0.1-0.4-0.1-0.6,0c-0.3,0.2-0.7,0.3-1,0.5L10.1,15l0.1-0.4 c0.1-0.2,0.1-0.4,0.1-0.6c0.1-0.3,0.1-0.5,0.1-0.7c0.1-0.3,0-0.4-0.2-0.6c-0.3-0.3-0.5-0.5-0.7-0.8c-0.1-0.1-0.2-0.2-0.3-0.3L9,11.5 l1.1-0.1c0.1-0.1,0.3-0.1,0.5-0.1c0.2-0.1,0.3-0.1,0.5-0.3c0.1-0.3,0.3-0.7,0.5-1l0.1-0.3c0-0.1,0.1-0.1,0.1-0.1l0.1-0.2l0.4,0.7    c0.1,0.3,0.3,0.5,0.4,0.8c0.1,0.2,0.3,0.3,0.5,0.3c0.3,0.1,0.7,0.1,1.1,0.1l0.3,0.1c0.1,0,0.1,0,0.1,0L14.8,11.5L14.8,11.5z';
				break;
			case 'recent-product':
				path =
					'M16.9,4.1c-0.1,0-2.7,0-5,0c-2.3,0-4.6,0-4.8,0C5.2,4.5,4,6,4,7.8c0,1,0,1.9,0,2.9V12v1c0,1.1,0,2.1,0,3.1 c0,0.3,0,0.5,0.1,0.7c0.3,1.6,1.4,2.7,3,3.1c0.3,0.1,9.6,0.1,9.9,0c1.8-0.3,3.1-1.8,3.1-3.7c0-2.7,0-5.6,0-8.4  C19.9,5.9,18.7,4.5,16.9,4.1z M18.8,16.2c0,1.6-1.1,2.7-2.7,2.7c-0.5,0-1.1,0-1.6,0c-0.5,0-0.9,0-1.3,0H12h-1.3c-0.9,0-1.9,0-2.9,0  c-1.2,0-2.2-0.7-2.5-1.7c-0.1-0.3-0.1-0.6-0.1-0.9c0-2.5,0-5.1,0-8.4c0-1.5,1.1-2.7,2.7-2.7c2.7,0,5.4,0,8.4,0  c1.5,0,2.7,1.1,2.7,2.7C18.8,10.6,18.8,13.4,18.8,16.2z M14.6,13.3c-0.1-0.1-0.3-0.2-0.4-0.3c-0.4-0.3-0.8-0.7-1.2-0.9  c-0.3-0.2-0.5-0.5-0.5-0.9c0-0.7,0-1.5,0-2.1c0-0.3,0-0.7,0-1.1c0-0.3-0.1-0.5-0.3-0.5c-0.1-0.1-0.3-0.1-0.5,0  c-0.1,0.1-0.3,0.3-0.3,0.5c0,0.5,0,0.9,0,1.5v0.7l0,0v0.5c0,0.5,0,0.9,0,1.4c0,0.3,0.1,0.5,0.3,0.5c0.1,0.1,0.1,0.1,0.2,0.1l0.7,0.5 c0.5,0.3,0.9,0.7,1.5,1.1c0.1,0.1,0.3,0.1,0.5,0.1c0.1-0.1,0.3-0.2,0.3-0.3C14.9,13.7,14.8,13.5,14.6,13.3z';
				break;
			case 'policies':
				path =
					'M18.3,6.1c-0.7-0.3-1.5-0.5-2.3-0.7c-1.3-0.5-2.5-0.9-3.8-1.3C12.1,4,11.8,4,11.7,4C10,4.6,8.5,5.2,6.8,5.7L5.7,6.1    C5.3,6.2,5.1,6.4,5.1,6.8v0.3c0,1.5,0,3,0,4.5c0,0.8,0.1,1.6,0.5,2.4c0.5,1.5,1.6,2.8,3.1,4.1c0.9,0.7,1.9,1.3,3.1,1.9h0.3  c1.3-0.6,2.4-1.3,3.4-2.1c1.6-1.4,2.6-2.8,3-4.5c0.1-0.3,0.1-0.5,0.2-0.9c0-0.1,0.1-0.3,0.1-0.4V6.6C18.7,6.3,18.6,6.2,18.3,6.1z     M17.7,9.9L17.7,9.9c0,0.1,0,0.3,0,0.4c0,0.5,0,1.1,0,1.6c-0.1,1.3-0.7,2.5-1.7,3.8c-0.9,1.1-2.1,2.1-3.6,2.8   c-0.1,0.1-0.2,0.1-0.3,0.1c-0.1,0-0.1,0-0.3-0.1c-2.2-1.2-3.7-2.5-4.6-4.2c-0.5-0.9-0.8-1.9-0.8-3c0-1.3,0-2.5,0-3.8    c0-0.3,0.1-0.5,0.5-0.7c0.9-0.3,1.7-0.5,2.5-0.9c0.8-0.3,1.6-0.5,2.4-0.8c0.2-0.1,0.4-0.1,0.6,0c0.9,0.3,1.7,0.5,2.5,0.9    c0.8,0.3,1.6,0.5,2.3,0.8c0.3,0.1,0.5,0.3,0.5,0.7c0,0.5,0,1,0,1.5L17.7,9.9z M15.2,8.7c-0.1,0-0.3,0.1-0.5,0.3 c-0.3,0.3-0.5,0.7-0.7,1l-2.3,3.1L11,12.5c-0.4-0.4-0.7-0.7-1.1-1.1c-0.1-0.1-0.3-0.2-0.5-0.2l0,0c-0.1,0-0.3,0.1-0.4,0.2   c-0.3,0.3-0.2,0.6,0.1,0.9c0.7,0.8,1.5,1.5,2.3,2.3c0.1,0.1,0.3,0.2,0.5,0.2c0.1,0,0.3-0.1,0.5-0.3c1.1-1.5,2.3-3.1,3.5-4.7 c0.2-0.3,0.2-0.7-0.1-0.9C15.5,8.7,15.3,8.7,15.2,8.7z';
				break;
			case 'location':
				path =
					'M13.4,4.2c-0.2-0.1-0.4-0.1-0.7-0.1c-0.1,0-0.1-0.1-0.3-0.1h-0.8l0,0c-0.1,0-0.1,0-0.1,0c-0.1,0-0.3,0.1-0.3,0.1   c-0.3,0.1-0.5,0.1-0.7,0.1c-2.3,0.7-3.9,2.7-4,5.1c-0.1,1.3,0.3,2.5,1.1,3.7c1,1.3,2,2.7,3,4c0.1,0.1,0.3,0.3,0.3,0.3   c0.4,0.3,0.9,0.5,1.3,0.3c0.5-0.1,0.9-0.3,1.2-0.7c1.2-1.6,2.1-2.9,3.1-4c0.9-1.2,1.3-2.6,1.1-4.1C17.3,6.6,15.7,4.8,13.4,4.2z   M15.7,12.4c-1,1.3-1.9,2.7-2.9,3.9c-0.2,0.3-0.5,0.4-0.7,0.4c-0.3,0-0.5-0.1-0.7-0.4c-1-1.3-1.9-2.7-2.9-3.9   c-0.7-0.9-0.9-1.7-0.9-2.7c0-1.3,0.5-2.5,1.4-3.3c0.9-0.9,2.1-1.3,3.4-1.3c2.3,0.1,4.1,1.9,4.3,4.1C16.7,10.4,16.5,11.4,15.7,12.4z   M14.6,19.1c-0.8,0-1.5,0-2.3,0h-1h-0.5c-0.4,0-0.8,0-1.2,0c-0.3,0-0.5,0.1-0.5,0.4C9,19.7,9.2,19.9,9.4,20h0.1h5.3 c0.2-0.1,0.3-0.1,0.3-0.3c0.1-0.1,0.1-0.3,0-0.5C15,19.1,14.8,19.1,14.6,19.1z M12.1,7.9L12.1,7.9c-0.5,0-0.9,0.2-1.3,0.5   s-0.5,0.8-0.5,1.3c0,1,0.8,1.7,1.7,1.7l0,0c0.5,0,0.9-0.2,1.3-0.5s0.5-0.8,0.5-1.3c0-0.5-0.2-0.9-0.5-1.3C13,8,12.5,7.9,12.1,7.9z    M12.1,10.4L12.1,10.4c-0.4,0-0.7-0.3-0.7-0.7S11.7,9,12.1,9l0,0c0.2,0,0.4,0.1,0.5,0.3c0.1,0.1,0.2,0.3,0.2,0.5    C12.9,10,12.5,10.4,12.1,10.4z';
				break;
			case 'coupon':
				path =
					'M12,18.4c-1.5,0-2.9,0-4.4,0c-1.6,0-2.9-0.9-3.4-2.5c-0.1-0.3-0.1-0.6-0.1-0.9C4,14.8,4,14.5,4,14.2c0-0.5,0.1-0.7,0.7-0.9 c0.4-0.1,0.7-0.5,0.8-0.9c0.1-0.7-0.1-1.3-0.7-1.5c-0.1-0.1-0.3-0.1-0.3-0.2c-0.1-0.1-0.3-0.3-0.3-0.5c0-0.7-0.1-1.3,0.1-2  C4.6,6.6,6,5.6,7.6,5.6c2.9,0,5.7,0,8.6,0c0.2,0,0.4,0,0.5,0c1.5,0.1,2.9,1.4,3.1,2.9c0.1,0.5,0.1,1.1,0.1,1.6  c0,0.4-0.3,0.6-0.6,0.7c-0.4,0.1-0.7,0.5-0.8,0.9c-0.2,0.7,0.1,1.3,0.8,1.5c0.1,0.1,0.3,0.1,0.5,0.3c0.1,0.1,0.2,0.3,0.2,0.4    c0.1,0.7,0.1,1.3-0.1,1.9c-0.4,1.6-1.8,2.7-3.5,2.7C14.9,18.4,13.4,18.4,12,18.4z M12,17.4c1.5,0,2.9,0,4.4,0c1.2,0,2.1-0.7,2.4-1.9 c0.1-0.4,0.1-0.8,0.1-1.2c0-0.1-0.1-0.1-0.1-0.1c-0.1-0.1-0.3-0.2-0.5-0.3c-1.3-1.1-1.1-3.2,0.5-4c0.1-0.1,0.1-0.1,0.1-0.2  c0-0.3,0-0.5,0-0.7c-0.1-1.1-1-2.1-2.1-2.3c-0.1,0-0.3,0-0.5,0c-2.9,0-5.7,0-8.6,0C6.5,6.7,5.5,7.4,5.3,8.6C5.2,8.9,5.2,9.3,5.2,9.7 c0,0.1,0.1,0.2,0.1,0.3c0.9,0.5,1.5,1.5,1.3,2.6c-0.1,0.8-0.6,1.3-1.3,1.7c-0.1,0.1-0.1,0.1-0.1,0.1c0,0.4,0,0.8,0.1,1.2    c0.3,1.1,1.2,1.9,2.4,1.9C9.1,17.4,10.5,17.4,12,17.4z M13.1,9.3c0.3-0.2,0.4-0.3,0.7-0.2c0.2,0.1,0.3,0.3,0.4,0.5  c0,0.1,0,0.1,0,0.1c0,1.5,0,3,0.1,4.5c0,0.2-0.1,0.4-0.3,0.5c-0.3,0.3-0.9,0-0.9-0.4c0-0.1,0-0.1,0-0.2c0-1.5,0-3,0-4.4 C13,9.5,13.1,9.4,13.1,9.3z';
				break;
			case 'product-categories':
				path =
					'M18.2,4c-1.2,0-2.4,0-3.6,0c-1.1,0-1.9,0.8-1.9,1.9c0,1.3,0,2.5,0,3.7v1.1c0,0.4,0.2,0.6,0.6,0.6c0.5,0,1.1,0,1.7,0h0.7h0.7    c0.5,0,1.1,0,1.7,0c1.1,0,1.9-0.8,1.9-1.9c0-1.2,0-2.4,0-3.6C20,4.7,19.3,4,18.2,4z M19,9.5c0,0.5-0.3,0.7-0.7,0.7  c-0.7,0-1.3,0-1.9,0c-0.5,0-0.9,0-1.3,0H14h-0.1h-0.1V7c0-0.4,0-0.8,0-1.1c0-0.5,0.3-0.7,0.7-0.7c1.2,0,2.4,0,3.7,0 c0.5,0,0.7,0.3,0.7,0.7C19,7.1,19,8.3,19,9.5z M9.5,4C8.8,4,8.2,4,7.6,4S6.5,4,5.9,4C4.8,4,4,4.8,4,5.9c0,1.2,0,2.4,0,3.6   c0,1.1,0.7,1.9,1.9,1.9c0.5,0,1.1,0,1.6,0H9c0.6,0,1.1,0,1.7,0c0.4,0,0.7-0.2,0.7-0.7V9.9c0-1.3,0-2.7,0-4.1C11.4,4.7,10.6,4,9.5,4z  M10.2,10.2H9H5.9c-0.5,0-0.8-0.3-0.8-0.8c0-1.2,0-2.4,0-3.5c0-0.5,0.3-0.8,0.8-0.8c1.2,0,2.4,0,3.5,0c0.5,0,0.8,0.3,0.8,0.7    c0,1,0,1.9,0,2.9V10.2z M10.7,12.7c-0.6,0-1.2,0-1.8,0H8.3H7.6c-0.3,0-0.5,0-0.7,0c-0.3,0-0.7,0-1,0c-1.1,0-1.9,0.7-1.9,1.9 c0,1.2,0,2.4,0,3.5S4.8,20,5.9,20c1.2,0,2.3,0,3.5,0c1.1,0,1.9-0.7,1.9-1.9c0-1.5,0-2.9,0-4.4v-0.3C11.4,12.9,11.1,12.7,10.7,12.7z   M10.2,18.1c0,0.5-0.3,0.8-0.8,0.8c-0.6,0-1.2,0-1.8,0s-1.2,0-1.8,0c-0.5,0-0.8-0.3-0.8-0.8c0-1.2,0-2.4,0-3.5  c0-0.5,0.3-0.8,0.8-0.8h4.3v1.9C10.2,16.5,10.2,17.3,10.2,18.1z M16.4,12.7c-0.9,0-1.8,0.3-2.5,1c-0.7,0.7-1.1,1.5-1.1,2.6  c-0.1,2,1.5,3.6,3.6,3.7c1.7,0,3.6-1.3,3.7-3.6C20,14.7,18.7,12.8,16.4,12.7L16.4,12.7z M19,16.3c0,0.7-0.3,1.3-0.8,1.8 c-0.5,0.5-1.1,0.7-1.8,0.7l0,0c-0.7,0-1.3-0.3-1.9-0.9c-0.5-0.5-0.7-1.1-0.7-1.7c0-0.7,0.3-1.3,0.7-1.7c0.5-0.5,1.2-0.8,1.9-0.8l0,0 c0.7,0,1.3,0.3,1.8,0.8S19,15.7,19,16.3z';
				break;
		}

		if ( ! path ) {
			return null;
		}

		const iconClass = [ 'mvx-icon', 'mvx-icon-' + icon, className ]
			.filter( Boolean )
			.join( ' ' );
		const viewbox = '0 0 ' + size + ' ' + size;

		return createElement(
			'svg',
			{
				className: iconClass,
				width: size,
				height: size,
				viewBox: viewbox,
				role: 'img',
			},
			createElement( 'path', { d: path } )
		);
	}
}
