<?php
/**
 * Top Rated Vendors block.
 *
 * @package MVX/Blocks
 */

defined( 'ABSPATH' ) || exit;

/**
 * VendorLists class.
 */
class VendorLists extends AbstractBlock {

	/**
	 * Block name.
	 *
	 * @var string
	 */
	protected $block_name = 'list-vendors';

	/**
	 * Get block attributes.
	 *
	 * @return array
	 */
	protected function get_attributes() {
		return array_merge(
			parent::get_attributes(),
			array(
				'block_title'    		=> $this->get_schema_string(),
				'block_rows'     	=> $this->get_schema_number( 1 ),
				'contentVisibility' => $this->get_schema_content_visibility(),
			)
		);
	}

	/**
	 * Render the Product Categories List block.
	 *
	 * @param array  $attributes Block attributes. Default empty array.
	 * @param string $content    Block content. Default empty string.
	 * @return string Rendered block type output.
	 */
	public function render( $attributes = array(), $content = '' ) {
		global $MVX, $post;
		wp_enqueue_script( 'frontend_js' );
		$block_vendors = wp_list_pluck(mvx_get_all_blocked_vendors(), 'id');
		$vendors = get_mvx_vendors(apply_filters( 'mvx_widget_vendor_list_query_args', array('exclude'   => $block_vendors)));
		$output = '';
    	ob_start();
    	
        ?>
        <div class="mvx-block-wrapper <?php echo isset ($attributes['className'] ) ? esc_attr($attributes['className']) : ''; ?>">
		<?php if( $attributes['block_title'] ) echo '<h4 class="mvx-block-heading">' . $attributes['block_title'] . '</h4>';
		if (!empty($vendors) && is_array($vendors)) {
			$MVX->template->get_template('widget/vendor-list.php', array('vendors' => $vendors));
		}
		?></div><?php

    	$output = ob_get_contents();
    	ob_end_clean();
		return $output;
	}

	/**
	 * Get the schema for the contentVisibility attribute
	 *
	 * @return array List of block attributes with type and defaults.
	 */
	protected function get_schema_content_visibility() {
		return array(
			'type'       => 'object',
			'properties' => array(
			),
		);
	}
}
