<?php

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;

if ( !class_exists('CUAR_AddressHelper')) :

    /**
     * Gathers some helper functions to facilitate some coding
     */
    class CUAR_AddressHelper
    {
        public static $DEFAULT_HOME_ADDRESS_ID = 'home_address';
        public static $DEFAULT_BILLING_ADDRESS_ID = 'billing_address';

        /**
         * Compare two addresses
         *
         * @param array $a
         * @param array $b
         *
         * @return bool true if addresses are the same
         */
        public static function compare_addresses($a, $b)
        {
            return 0 == strcmp($a['name'], $b['name'])
            && 0 == strcmp($a['company'], $b['company'])
            && 0 == strcmp($a['vat_number'], $b['vat_number'])
            && 0 == strcmp($a['logo_url'], $b['logo_url'])
            && 0 == strcmp($a['line1'], $b['line1'])
            && 0 == strcmp($a['line2'], $b['line2'])
            && 0 == strcmp($a['zip'], $b['zip'])
            && 0 == strcmp($a['city'], $b['city'])
            && 0 == strcmp($a['country'], $b['country'])
            && 0 == strcmp($a['state'], $b['state']);
        }

        /**
         * Make sure we always have a proper address
         *
         * @param array $address
         *
         * @return array
         */
        public static function sanitize_address($address)
        {
            if (!is_array($address)) $address = array();
            
            if ( !empty($address['vat-number'])) $address['vat_number'] = $address['vat-number'];
            if ( !empty($address['logo-url'])) $address['logo_url'] = $address['logo-url'];

            $address = array_merge(array(
                'name'       => '',
                'company'    => '',
                'vat_number' => '',
                'logo_url'   => '',
                'line1'      => '',
                'line2'      => '',
                'zip'        => '',
                'city'       => '',
                'country'    => '',
                'state'      => '',
            ), $address);

            if (empty($address['country'])) $address['state'] = '';

	        $address = apply_filters('cuar/core/address', $address);

            return map_deep($address, function ($item)
            {
	            return sanitize_text_field($item);
            });
        }

        /**
         * @param array  $address
         * @param string $input_name
         *
         * @return string
         */
        public static function get_address_as_hidden_input($address, $input_name = 'cuar_address')
        {
            $fields = array('name', 'company', 'vat_number', 'logo_url', 'line1', 'line2', 'zip', 'city', 'country', 'state');
            $out = '';
            foreach ($fields as $f)
            {
                $out .= sprintf('<input type="hidden" name="%1$s[%2$s]" value="%3$s" />',
                    esc_attr($input_name),
                    esc_attr($f),
                    isset($address[$f]) ? esc_attr($address[$f]) : '');
                $out .= "\n";
            }

            return apply_filters('cuar/core/address-as-hidden-input', $out, $address, $input_name);
        }

        /**
         * @param $address
         *
         * @return string
         */
        public static function get_address_as_string($address)
        {
            $out = '';
            if ( !empty($address['name']))
            {
                $out .= $address['name'];
            }

            if ( !empty($address['company']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['company'];
            }

            if ( !empty($address['vat_number']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['vat_number'];
            }

            if ( !empty($address['line1']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['line1'];
            }

            if ( !empty($address['line2']))
            {
                $out .= $address['line2'];
            }

            if ( !empty($address['zip']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['zip'];
            }

            if ( !empty($address['city']))
            {
                if ( !empty($address['zip'])) $out .= ' ';
                $out .= $address['city'];
            }

            if ( !empty($address['state']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['state'];
            }

            if ( !empty($address['country']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['country'];
            }

            return apply_filters('cuar/core/address-as-string', $out, $address);
        }

        /**
         * @param $address
         *
         * @return string
         */
        public static function get_address_as_short_string($address)
        {
            $out = '';
            if ( !empty($address['line1']))
            {
                $out .= $address['line1'];
            }

            if ( !empty($address['line2']))
            {
                $out .= $address['line2'];
            }

            if ( !empty($address['zip']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['zip'];
            }

            if ( !empty($address['city']))
            {
                if ( !empty($address['zip'])) $out .= ' ';
                $out .= $address['city'];
            }

            if ( !empty($address['country']))
            {
                if ( !empty($out)) $out .= ', ';
                $out .= $address['country'];
            }

            return apply_filters('cuar/core/address-as-short-string', $out, $address);
        }
    }

endif; // class_exists CUAR_AddressHelper