<?php

$settings_structure = array(
    array(
        'id' => 'documentation',
        'name' => __( 'Documentation', 'custom-related-posts' ),
        'description' => __( 'With Custom Related Posts you have full control. Manually set the related posts when editing one and display these related posts using the shortcode, block or widget.', 'custom-related-posts' ),
        'documentation' => 'https://help.bootstrapped.ventures/category/159-getting-started',
        'icon' => 'support',
    ),
    array(
        'id' => 'general',
        'name' => __( 'General', 'custom-related-posts' ),
        'icon' => 'cog',
        'settings' => array(
            array(
                'id' => 'general_post_types',
                'name' => __( 'Post Types', 'custom-related-posts' ),
                'description' => __( 'Which post types do you want to enable the Related Posts for?', 'custom-related-posts' ),
                'type' => 'dropdownMultiselect',
                'optionsCallback' => function() { return get_post_types( '', 'names' ); },
                'default' => array( 'post', 'page' ),
            ),
            array(
                'id' => 'cache_relations',
                'name' => __( 'Cache Relations', 'custom-related-posts' ),
                'description' => __( 'In normal cases you want this enabled for speed improvements.', 'custom-related-posts' ),
                'type' => 'toggle',
                'default' => true,
            ),
        ),
    ),
    array(
        'id' => 'search',
        'name' => __( 'Search', 'custom-related-posts' ),
        'icon' => 'search',
        'description' => __( 'Settings to finetune the search for related posts in the backend.', 'custom-related-posts' ),
        'settings' => array(
            array(
                'id' => 'search_number_of_posts',
                'name' => __( 'Number of Posts', 'custom-related-posts' ),
                'type' => 'number',
                'default' => 15,
            ),
            array(
                'id' => 'search_post_status',
                'name' => __( 'Post Status', 'custom-related-posts' ),
                'type' => 'dropdown',
                'options' => array(
                    'any' => __('Any', 'custom-related-posts'),
                    'publish' => __('Published only', 'custom-related-posts'),
                ),
                'default' => 'any',
            ),
        ),
    ),
    array(
        'id' => 'relations',
        'name' => __( 'Relations', 'custom-related-posts' ),
        'icon' => 'link',
        'settings' => array(
            array(
                'id' => 'output_open_in_new_tab',
                'name' => __( 'Open in New Tab', 'custom-related-posts' ),
                'description' => __( 'Open links to related posts in a new tab.', 'custom-related-posts' ),
                'type' => 'toggle',
                'default' => false,
            ),
            array(
                'name' => __( 'Update Cached Data', 'custom-related-posts' ),
                'description' => __( 'Update the cached relation data in all relations. Use this after domain migrations, permalink structure changes or other changes that might affect the relation data.', 'custom-related-posts' ),
                'type' => 'button',
                'button' => __( 'Update Cached Data', 'custom-related-posts' ),
                'link' => admin_url( 'options-general.php?page=crp_update_permalinks' ),
            ),
        ),
    ),
    array(
        'id' => 'template',
        'name' => __( 'Template', 'custom-related-posts' ),
        'icon' => 'brush',
        'subGroups' => array(
            array(
                'name' => __( 'Style', 'custom-related-posts' ),
                'settings' => array(
                    array(
                        'id' => 'template_container',
                        'name' => __( 'Container', 'custom-related-posts' ),
                        'type' => 'dropdown',
                        'options' => array(
                            'div' => __( 'Normal', 'custom-related-posts' ),
                            'ul' => __( 'Unordered List', 'custom-related-posts' ),
                            'ol' => __( 'Ordered List', 'custom-related-posts' ),
                        ),
                        'default' => 'ul',
                    ),
                    array(
                        'id' => 'template_title_tag',
                        'name' => __( 'Title Tag', 'custom-related-posts' ),
                        'description' => __( 'Choose the HTML tag for the list title.', 'custom-related-posts' ),
                        'type' => 'dropdown',
                        'options' => array(
                            'h1' => 'h1',
                            'h2' => 'h2',
                            'h3' => 'h3',
                            'h4' => 'h4',
                            'h5' => 'h5',
                            'h6' => 'h6',
                            'p' => 'p',
                            'div' => 'div',
                            'span' => 'span',
                        ),
                        'default' => 'h3',
                    ),
                    array(
                        'id' => 'template_image',
                        'name' => __( 'Image', 'custom-related-posts' ),
                        'type' => 'dropdown',
                        'options' => array(
                            'none' => __( "Don't show", 'custom-related-posts' ),
                            'above' => __( 'Above Text', 'custom-related-posts' ),
                            'below' => __( 'Below Text', 'custom-related-posts' ),
                            'left' => __( 'Floated Left', 'custom-related-posts' ),
                            'right' => __( 'Floated Right', 'custom-related-posts' ),
                        ),
                        'default' => 'none',
                    ),
                    array(
                        'id' => 'template_image_size',
                        'name' => __( 'Image Size', 'custom-related-posts' ),
                        'description' => __( 'Enter a thumbnail name or specific size.', 'custom-related-posts' ),
                        'documentation' => 'https://help.bootstrapped.ventures/article/163-changing-the-look-of-the-relations',
                        'type' => 'text',
                        'default' => '50x50',
                        'dependency' => array(
                            'id' => 'template_image',
                            'value' => 'none',
                            'type' => 'inverse',
                        ),
                    ),
                    array(
                        'id' => 'template_image_nopin',
                        'name' => __( 'Disable pinning of images', 'custom-related-posts' ),
                        'description' => __( 'Add the nopin attribute to the related posts images.', 'custom-related-posts' ),
                        'type' => 'toggle',
                        'default' => true,
                        'dependency' => array(
                            'id' => 'template_image',
                            'value' => 'none',
                            'type' => 'inverse',
                        ),
                    ),
                ),
            ),
            array(
                'name' => __( 'Fields to Display', 'custom-related-posts' ),
                'description' => __( 'Choose which fields to display in the related posts. Make sure to update the cached data after changing this.', 'custom-related-posts' ),
                'settings' => array(
                    array(
                        'id' => 'template_show_author',
                        'name' => __( 'Show Post Author', 'custom-related-posts' ),
                        'description' => __( 'Display the post author in related posts.', 'custom-related-posts' ),
                        'type' => 'toggle',
                        'default' => false,
                    ),
                    array(
                        'id' => 'template_show_date',
                        'name' => __( 'Show Post Date', 'custom-related-posts' ),
                        'description' => __( 'Display the post date in related posts.', 'custom-related-posts' ),
                        'type' => 'toggle',
                        'default' => false,
                    ),
                    array(
                        'id' => 'template_date_format',
                        'name' => __( 'Date Format', 'custom-related-posts' ),
                        'description' => __( 'Format for displaying the post date. Use WordPress date format codes like F j, Y for "January 1, 2024".', 'custom-related-posts' ),
                        'documentation' => 'https://wordpress.org/documentation/article/customize-date-and-time-format/',
                        'type' => 'text',
                        'default' => 'F j, Y',
                        'dependency' => array(
                            'id' => 'template_show_date',
                            'value' => true,
                        ),
                    ),
                    array(
                        'id' => 'template_show_excerpt',
                        'name' => __( 'Show Post Excerpt', 'custom-related-posts' ),
                        'description' => __( 'Display the post excerpt in related posts.', 'custom-related-posts' ),
                        'type' => 'toggle',
                        'default' => false,
                    ),
                    array(
                        'id' => 'template_excerpt_length',
                        'name' => __( 'Excerpt Length', 'custom-related-posts' ),
                        'description' => __( 'Maximum number of words in the excerpt.', 'custom-related-posts' ),
                        'type' => 'number',
                        'default' => 20,
                        'dependency' => array(
                            'id' => 'template_show_excerpt',
                            'value' => true,
                        ),
                    ),
                    array(
                        'id' => 'template_field_layout',
                        'name' => __( 'Field Layout Template', 'custom-related-posts' ),
                        'description' => __( 'Define the layout using placeholders. Each line becomes a new div.', 'custom-related-posts' ) . ' ' . __( 'Available placeholders:', 'custom-related-posts' ) . ' [title], [author], [date], [excerpt]',
                        'type' => 'textarea',
                        'default' => '[title]',
                    ),
                    array(
                        'name' => __( 'Update Cached Data', 'custom-related-posts' ),
                        'description' => __( 'Update the cached relation data in all relations. Use this after domain migrations, permalink structure changes or other changes that might affect the relation data.', 'custom-related-posts' ),
                        'type' => 'button',
                        'button' => __( 'Update Cached Data', 'custom-related-posts' ),
                        'link' => admin_url( 'options-general.php?page=crp_update_permalinks' ),
                        'dependency' => array(
                            'id' => 'template_field_layout',
                            'value' => '[title]',
                            'type' => 'inverse',
                        ),
                    ),
                ),
            ),
            array(
                'name' => __( 'Advanced', 'custom-related-posts' ),
                'settings' => array(
                    array(
                        'id' => 'output_self_reference_links',
                        'name' => __( 'Use Self-Reference Links', 'custom-related-posts' ),
                        'description' => __( 'Also use links when a post references itself in related posts.', 'custom-related-posts' ),
                        'type' => 'toggle',
                        'default' => true,
                    ),
                    array(
                        'id' => 'custom_code_public_css',
                        'name' => __( 'CSS', 'custom-related-posts' ),
                        'description' => __( 'This custom styling will be output on your website.', 'custom-related-posts' ),
                        'type' => 'code',
                        'code' => 'css',
                        'default' => '',
                    ),
                ),
            ),
        ),  
    ),
    array(
        'id' => 'import',
        'name' => __( 'Import Relations', 'custom-related-posts' ),
        'icon' => 'import',
        'settings' => array(
            array(
                'name' => __( 'Import from XML', 'custom-related-posts' ),
                'documentation' => 'https://help.bootstrapped.ventures/article/161-importing-relations-from-xml',
                'type' => 'button',
                'button' => __( 'Import XML', 'custom-related-posts' ),
                'link' => admin_url( 'options-general.php?page=crp_import_xml' ),
            ),
        ),
    ),
);