<?php
if (!defined('WPINC')) {
    die('Closed');
}
wp_enqueue_style( 'rm_material_icons', RM_BASE_URL . 'admin/css/material-icons.css' );
$form = new RM_PFBC_Form($data->form_type);

$form->configure(array(
    "prevent" => array("bootstrap", "jQuery"),
    "action" => "",
     "style" => isset($data->design['style_form'])?$data->design['style_form']:null
));

if(isset($data->design['placeholder_css'])){		
    $p_css = $data->design['placeholder_css'];
    echo "<style>".wp_kses_post((string)$p_css)."</style>";
    //$form->addElement(new Element_HTML($p_css));		
}
if(isset($data->design['style_label'])){	
    echo "<style>#".wp_kses_post((string)$data->password_form_slug)." .rmrow .rmfield label { ".wp_kses_post((string)$data->design['style_label'])." }</style>";
    //$form->addElement(new Element_HTML($p_css));		
}

if(isset($data->buttons['align']) && ($data->buttons['align']=='left' || $data->buttons['align']=='right')){
    if(empty($data->design['style_btnfield'])){
        $data->design['style_btnfield']='float:'.$data->buttons['align'];
    }
    else
    {
        $data->design['style_btnfield']=$data->design['style_btnfield'].';float:'.$data->buttons['align'];
    }
}

if($data->form_type=='rm_recovery_form'){
    if(isset($data->expired_token) && $data->expired_token==1){
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_warning_msg"><span class="rm_waring_symbol">&excl;</span>'.wpautop($data->options['rec_link_exp_err']).'</div></div>'));
    }
    
    if(isset($data->valid_email) && $data->valid_email==1){
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_success_msg"><span class="rm_green_tik">&#10003;</span>'.$data->options['rec_link_sent_msg'].'</div></div>'));
    }else{
        if(isset($data->valid_email) && $data->valid_email==0){
            $form->addElement(new Element_HTML('<div class="rm-response-message rm-alert rm-alert-error rm-alret-box-wrap"><span class="close">&times;</span>'.$data->options['rec_email_not_found_msg'].'</div>'));
        }
        $form->addElement(new Element_Email($data->options['rec_email_label'], "user_email", array("required" => "1","class"=>'', "placeholder" => '','style'=>isset($data->design['style_textfield'])?$data->design['style_textfield']:null)));
        if (get_option('rm_option_enable_captcha') == "yes")
            $form->addElement(new Element_Captcha());

        $btn_label= !empty($data->options['rec_btn_label'])?$data->options['rec_btn_label']:__('Reset Password', 'custom-registration-form-builder-with-submission-manager');
        $form->addElement(new Element_Button($btn_label, "submit", array("id" => "rm_submit_btn", "class" => "rm_btn", "name" => "submit",'style'=>isset($data->design['style_btnfield'])?$data->design['style_btnfield']:null)));
    }
}else if($data->form_type=='rm_token_form'){
    if(isset($data->invalid_copy_token) && $data->invalid_copy_token==1){
        $page_id= $data->options['recovery_page'];
        $recovery_link= get_permalink($page_id);
        $rec_invalid_tok_err= wpautop(str_replace('{{password_recovery_link}}',$recovery_link,$data->options['rec_invalid_tok_err']));
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_error_msg"><span class="rm_red_cross">&times;</span>'.$rec_invalid_tok_err.'</div></div>'));
    }else if(isset($data->invalid_token) && $data->invalid_token==1){
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_warning_msg"><span class="rm_waring_symbol">&excl;</span>'.wpautop($data->options['rec_invalid_reset_err']).'</div></div>'));
    }
    
    $form->addElement(new Element_Textbox(__('Security Token', 'custom-registration-form-builder-with-submission-manager'), "token_val", array("required" => "1","class"=>'', "placeholder" => '','style'=>isset($data->design['style_textfield'])?$data->design['style_textfield']:null)));
    
    $btn_label= !empty($data->options['rec_tok_sub_label'])?$data->options['rec_tok_sub_label']:__('Proceed', 'custom-registration-form-builder-with-submission-manager');
    $form->addElement(new Element_Button($btn_label, "submit", array("id" => "rm_submit_btn", "class" => "rm_btn", "name" => "submit",'style'=>isset($data->design['style_btnfield'])?$data->design['style_btnfield']:null)));
    
}else if($data->form_type=='rm_reset_password_form'){
    if(empty($data->password_updated)){
        $gopt = new RM_Options();
        $form->addElement(new Element_Password($data->options['rec_new_pass_label'], "password", array("required" => "1","class"=>'', "placeholder" => '','style'=>isset($data->design['style_textfield'])?$data->design['style_textfield']:null,'minLength'=> $gopt->get_value_of('enable_custom_pw_rests')!='yes' ? '7': '')));
        $form->addElement(new Element_Password($data->options['rec_conf_pass_label'], "confirm_password", array("required" => "1","class"=>'', "placeholder" => '','style'=>isset($data->design['style_textfield'])?$data->design['style_textfield']:null,'minLength'=> $gopt->get_value_of('enable_custom_pw_rests')!='yes' ? '7': '')));
        $form->addElement(new Element_Hidden("token_val",$data->sec_token,array()));
        $btn_label= !empty($data->options['rec_pass_btn_label'])?$data->options['rec_pass_btn_label']:__('Change Password', 'custom-registration-form-builder-with-submission-manager');
        $form->addElement(new Element_Button($btn_label, "submit", array("id" => "rm_submit_btn", "class" => "rm_btn", "name" => "submit",'style'=>isset($data->design['style_btnfield'])?$data->design['style_btnfield']:null)));
    }
 
   
    if(isset($data->password_mismatch) && $data->password_mismatch==1){
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_error_msg"><span class="rm_red_cross">&times;</span>'.$data->options['rec_pass_match_err'].'</div></div>'));
    }
    else if(!empty($data->error)){
        $form->addElement(new Element_HTML('<div class="rm_error_msg">'.$data->error.'</div>'));
    }
    else if(isset($data->password_updated) && $data->password_updated==1){
        $form->addElement(new Element_HTML('<div class="rm_error_msg-wrap"><div class="rm_pr_success_msg"><span class="rm_green_tik">&#10003;</span>'.$data->options['rec_pas_suc_message'].'</div></div>'));
    }
}
/*
 * Render the form if user is not logged in
 */
?>
<div class='rmagic'>    
    <div class='rmcontent rm-login-wrapper'>
        <?php if (!is_user_logged_in() || (isset($_GET['form_prev']) && $_GET['form_prev']==1 && $_GET['form_type']=='login')) : ?>
            <?php
            $form->render();
            ?>
        <?php endif; ?>
    </div>
</div>