<?php
if (!defined('WPINC')) {
    die('Closed');
}
wp_enqueue_script('chart_js');
if(defined('REGMAGIC_ADDON')) include_once(RM_ADDON_ADMIN_DIR . 'views/template_rm_login_sett_manage.php'); else {
wp_enqueue_style('rm_form_dashboard_css', RM_BASE_URL . 'admin/css/style_rm_form_dashboard.css');
    if(defined('REGMAGIC_ADDON')) {
        wp_enqueue_style('rm_addon_form_dashboard_css', RM_ADDON_BASE_URL . 'admin/css/style_rm_form_dashboard.css');
    }
wp_enqueue_style( 'rm_material_icons', RM_BASE_URL . 'admin/css/material-icons.css' );
?>
<pre class="rm-pre-wrapper-for-script-tags"><?php wp_enqueue_script('rm_form_dashboard_js', RM_BASE_URL . 'admin/js/script_rm_form_dashboard.js', array(), RM_PLUGIN_VERSION, false); wp_localize_script('rm_form_dashboard_js', 'rm_admin_vars', array('nonce'=>wp_create_nonce('rm_ajax_secure'))); ?></pre>
<pre class='rm-pre-wrapper-for-script-tags'><script>
    //Takes value of various status variables (form_id, timeline_range) and reloads page with those parameteres updated.
    function rm_refresh_stats(){
    var trange = jQuery('#rm_stat_timerange').val();
    if(typeof trange == 'undefined')
        trange = <?php echo esc_html($data->timerange); ?>;
    window.location = '?page=rm_login_sett_manage&rm_tr='+trange;
}
</script></pre>
<div class="rm-form-configuration-wrapper rm-login-configuration-wrap" style="display:none">
    <div class="rm-grid-top dbfl">
        <div class="rm-grid-title difl"><?php _e('Login Form', 'custom-registration-form-builder-with-submission-manager'); ?><span class="rm-login-form-guide"><a href="https://registrationmagic.com/wordpress-user-login-plugin-guide/" target="_blank"><?php _e('Login Form Guide', 'custom-registration-form-builder-with-submission-manager'); ?><span class="dashicons dashicons-book-alt"></span></a></span></div>
        <!--    Forms toggle-->
    <div class="rm-fd-form-toggle difr" id="rm_form_toggle">
        <?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_TOGGLE_FORM')); ?>
        <select onchange="rm_fd_switch_form(jQuery(this).val())">
            <?php
            echo "<option selected value='rm_login_form'>".__('Login Form','custom-registration-form-builder-with-submission-manager')."</option>";
            foreach ($data->all_forms as $form_id => $form_name):
                echo "<option value='".esc_attr($form_id)."'>".wp_kses_post((string)$form_name)."</option>";
            endforeach;
            ?>
        </select>
    </div>
        
    </div>
   
    <div class="rm-grid difl">
        <div class="rm-grid-section dbfl" id="rm_tour_timewise_stats">
            <div class="rm-grid-section-title dbfl rm-box-title"><?php _e('Login Success vs. Failures Graph over time', 'custom-registration-form-builder-with-submission-manager'); ?></div>
            <div class="rm-timerange-toggle rm-fd-form-toggle rm-timerange-dashboard">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_SELECT_TIMERANGE')); ?>
                <select id="rm_stat_timerange" onchange="rm_refresh_stats()">
                    <?php
                    $trs = array(7,30,60,90);
                    foreach($trs as $tr){
                        echo "<option value=".esc_attr($tr);
                        if($data->timerange == $tr)
                            echo " selected";
                        printf(">".RM_UI_Strings::get("STAT_TIME_RANGES")."</option>",$tr);
                    }
                    ?>
                </select>
            </div>
            <canvas class="rm-box-graph" id="rm_subs_over_time_chart_div"></canvas>
        </div>

        
        <div class="rm-grid-section dbfl">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_SEC_1_TITLE')); ?>
            </div>

            <div class="rm-grid-icon difl" id="rm-customfields-icon">
                <a href="<?php echo admin_url('admin.php?page=rm_login_field_manage'); ?>" class="rm_fd_link">    
                    <div class="rm-grid-icon-area dbfl">
                        <div class="rm-grid-icon-badge"><?php echo esc_html($data->field_count); ?></div>
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>form-custom-fields.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_LOGIN_FORM_FIELDS')); ?></div>
                </a>
            </div>

            <div class="rm-grid-icon difl" id="rm-design-icon"> 
                <a href="<?php echo admin_url('admin.php?page=rm_login_field_view_sett'); ?>" class="rm_fd_link">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>form-view.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_DESIGN')); ?></div>
                </a>
            </div>

            <div class="rm-grid-icon difl" id="rm-logged-in-view"> 
                <a href="<?php echo admin_url('admin.php?page=rm_login_view'); ?>" class="rm_fd_link">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>rm-loggedin-view.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Logged In View', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>

        </div>

        <!-- Configure  -->
        <div class="rm-grid-section dbfl" id="rm-general-icon">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_SEC_2_TITLE')); ?>               
            </div>

            <div class="rm-grid-icon difl" id="rm-general-settings">
                <a href="<?php echo admin_url('admin.php?page=rm_login_sett_redirections') ?>" class="rm_fd_link">    
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>rm-login-redirections.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Redirections', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>


            <div class="rm-grid-icon difl" id="rm-accounts-icon">
                <a href="<?php echo admin_url('admin.php?page=rm_login_val_sec') ?>" class="rm_fd_link">    
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>rm-validation-and-security.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Validation & Security', 'custom-registration-form-builder-with-submission-manager'); ?></div>

                </a>
            </div>  

            <div class="rm-grid-icon difl" id="rm-postsubmit-icon">
                <a href="<?php echo admin_url('admin.php?page=rm_login_recovery') ?>" class="rm_fd_link">    
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>rm-password-recovery.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Password Recovery', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>  

            <div class="rm-grid-icon difl" id="rm-limits-icon">
                <a href="<?php echo admin_url('admin.php?page=rm_login_email_temp') ?>" class="rm_fd_link">    
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>email_templates.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Email Templates', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>
            
            <div class="rm-grid-icon difl rm_dash_popup_link" id="rm_dash_popup_link_config"> 
                <a href="javascript:void(0)" class="rm_fd_link">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>dash-more-options.jpg">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_MORE')); ?></div>
                </a>
            </div>
        </div>
        <!-- Configure  Ends here-->

        <!-- Publish Section -->
        <div class="rm-grid-section dbfl" id="rm-publish-section">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_SEC_4_TITLE')); ?>
            </div>            

            <div class="rm-grid-icon difl">
                <a href="javascript:void(0)" class="rm_fd_link rm_publish_popup_link" data-publish_type="login">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>publish_login.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Login Box', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>
            <div class="rm-grid-icon difl">
                <a href="javascript:void(0)" class="rm_fd_link rm_publish_popup_link" data-publish_type="loginbtn">
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>login_btn.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Login Button', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>
            <div class="rm-grid-icon difl">
                <a href="javascript:void(0)" class="rm_fd_link rm_publish_popup_link" data-publish_type="otp">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>publish_otp.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('OTP Login', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div> 
            <div class="rm-grid-icon difl">
                <a href="javascript:void(0)" class="rm_fd_link rm_publish_popup_link" data-publish_type="magicpopup">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>publish_magicpopup.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Magic Popup', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div> 
            <?php echo  do_action('rm_login_setting_publish_icons');?>
            <div class="rm-grid-icon difl rm_dash_popup_link" id="rm_dash_popup_link_publish"> 
                <a href="javascript:void(0)" class="rm_fd_link">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>dash-more-options.jpg">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_MORE')); ?></div>
                </a>
            </div>
        </div>
        <!-- Publish ends here -->

        <!-- Integrate section -->
        <div class="rm-grid-section dbfl" id="rm-thirdparty-section">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_SEC_3_TITLE')); ?>
            </div>
            
            <div class="rm-grid-icon difl">  
                <a href="<?php echo admin_url('admin.php?page=rm_login_integrations&type=fb'); ?>" class="rm_fd_link">  
                    <div class="rm-grid-icon-area rm-grid-icon-fb dbfl">
                        <svg xmlns="http://www.w3.org/2000/svg" height="16" width="14" viewBox="0 0 448 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64h98.2V334.2H109.4V256h52.8V222.3c0-87.1 39.4-127.5 125-127.5c16.2 0 44.2 3.2 55.7 6.4V172c-6-.6-16.5-1-29.6-1c-42 0-58.2 15.9-58.2 57.2V256h83.6l-14.4 78.2H255V480H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z"/></svg>
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Facebook', 'custom-registration-form-builder-with-submission-manager'); ?></div>

                </a>
            </div>
            
            <div class="rm-grid-icon difl rm_dash_popup_link" id="rm_dash_popup_link_integrate"> 
                <a href="javascript:void(0)" class="rm_fd_link">   
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>dash-more-options.jpg">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_MORE')); ?></div>
                </a>
            </div>
        </div>
        <!-- Integrate ends here -->
        

        <!-- Analyze section -->
        <div class="rm-grid-section dbfl" id="rm-login_analytics-section">
            <div class="rm-grid-section-title dbfl">
                <?php _e('Analyze', 'custom-registration-form-builder-with-submission-manager'); ?>
            </div>

            <div class="rm-grid-icon difl">  
                <a href="?page=rm_login_analytics" class="rm_fd_link">  
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>form-analytics.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Login Analytics', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div> 
            
            <div class="rm-grid-icon difl">  
                <a href="?page=rm_login_retention" class="rm_fd_link">  
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>rm-logs-retention.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('Logs Retention', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>
            
            <div class="rm-grid-icon difl">
                <a href="javascript:void(0)" class="rm_fd_link rm_timeline_popup_link" data-publish_type="timelinepopup">
                    <div class="rm-grid-icon-area dbfl">
                        <img class="rm-grid-icon dibfl" src="<?php echo esc_url(RM_IMG_URL); ?>login-timeline.png">
                    </div>
                    <div class="rm-grid-icon-label dbfl"><?php _e('User Login Timeline', 'custom-registration-form-builder-with-submission-manager'); ?></div>
                </a>
            </div>
        </div>    
    </div>
    
    <div class="rm-grid-sidebar-1 difl">
        <div class="rm-grid-section-cards dbfl">        
            <?php
            if($data->login_count == 0):
                ?>
            <div class="rm-grid-sidebar-card dbfl">
                <div class='rmnotice-container'><div class="rmnotice-container"><div class="rm-counter-box">0</div><div class="rm-counter-label"><?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_REGISTRATIONS')); ?></div></div></div>  
            </div>
                <?php
            endif;
            foreach ($data->login_log as $login_detail):
                ?>
                <div class="rm-grid-sidebar-card dbfl">
                    <a href="javascript:void(0)" class="fd_sub_link">
                    <div class="rm-grid-card-profile-image dbfl">
                        <?php echo get_avatar($login_detail->email)?get_avatar($login_detail->email):'<img src="'.esc_url(RM_IMG_URL).'default_person.png">'; ?>
                    </div>
                    <div class="rm-grid-card-content difl">
                        <?php $user = get_user_by( 'email', $login_detail->email ); ?>
                        <div class="dbfl"><?php echo $user ? esc_html((string)$user->display_name) : esc_html((string)$login_detail->email); ?></div>
                        <div class="rm-grid-card-content-subtext dbfl"><?php echo esc_html(date('F d Y @ g:i a',strtotime((string)$login_detail->time))); ?></div></div>
                    </a>
                </div>
                <?php
            endforeach;
            ?>
            <div class="rm-grid-quick-tasks dbfl">
                <div class="rm-grid-sidebar-row dbfl">
                    <div class="rm-grid-sidebar-row-label difl">
                        <a class="<?php echo $data->login_count ? '' : 'rm_deactivated'?>" href="?page=rm_login_analytics"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_VIEW_ALL')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="rm-grid-sidebar-2 difl">
        <div class="rm-grid-section dbfl">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_STATUS')); ?>
                <span class="rm-grid-section-toggle rm-collapsible"></span>
            </div>
            <div class="rm-grid-sidebar-row dbfl">
                <div class="rm-grid-sidebar-row-icon difl" id="rm-sidebar-sc-icon">
                    <img src="<?php echo esc_url(RM_IMG_URL); ?>shortcode.png">
                </div>
                <div class="rm-grid-sidebar-row-label difl"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_FORM_SHORTCODE')); ?>:</div>
                <div class="rm-grid-sidebar-row-value difl"><span id="rmformshortcode">[RM_Login]</span><a href="javascript:void(0)" onclick="rm_copy_to_clipboard(document.getElementById('rmformshortcode'))" id="rm-copy-sc"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_COPY')); ?></a>
                    <div style="display:none" id="rm_msg_copied_to_clipboard"><?php _e('Copied to clipboard', 'custom-registration-form-builder-with-submission-manager'); ?></div><div style="display:none" id="rm_msg_not_copied_to_clipboard"><?php _e('Could not be copied. Please try manually.', 'custom-registration-form-builder-with-submission-manager'); ?></div></div>
            </div>
        </div>

        <div class="rm-grid-section dbfl">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_CONTENT')); ?>
                <span class="rm-grid-section-toggle rm-collapsible"></span>
            </div>
            <div class="rm-grid-sidebar-row dbfl">
                <div class="rm-grid-sidebar-row-icon difl">
                    <img src="<?php echo esc_url(RM_IMG_URL); ?>field.png">
                </div>
                <div class="rm-grid-sidebar-row-label difl" id="rm-sidebar-fields"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_F_FIELDS')); ?>:</div>
                <div class="rm-grid-sidebar-row-value difl"><?php echo isset($data->field_count)?esc_html($data->field_count):''; ?></div>
            </div>
            <div class="rm-grid-sidebar-row dbfl">
                <div class="rm-grid-sidebar-row-icon difl">
                    <img src="<?php echo esc_url(RM_IMG_URL); ?>submit.png">
                </div>
                <div class="rm-grid-sidebar-row-label difl" id="rm-sidebar-add-submit"><?php echo wp_kses_post((string)RM_UI_Strings::get('FD_FORM_SUBMIT_BTN_LABEL')); ?>:</div>
               <div class="rm-grid-sidebar-row-value difl"><div class="difl" id="rm-submit-label"><?php echo isset($data->buttons->login_btn) ? esc_html($data->buttons->login_btn) : 'Submit'; ?></div><a href='javascript:;' onclick='edit_label()' ><?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_FIELD_ICON_CHANGE')); ?></a></div>
                <div id="rm-submit-label-textbox" style="display:none"><input type="text" id="submit_label_textbox"/><div><input type="button" value ="Save" onclick="save_submit_label()"><input type="button" value ="Cancel" onclick="cancel_edit_label()"></div></div>
            </div>
        </div>
        <div class="rm-grid-section dbfl">
            <div class="rm-grid-section-title dbfl">
                <?php echo wp_kses_post((string)RM_UI_Strings::get('FD_LABEL_STATS')); ?>
                <span class="rm-grid-section-toggle rm-collapsible"></span>
            </div>
            <div class="rm-grid-sidebar-row dbfl">
                <div class="rm-grid-sidebar-row-icon difl">
                    <img src="<?php echo esc_url(RM_IMG_URL); ?>submissions.png">
                </div>
                <div class="rm-grid-sidebar-row-label difl" id="rm-sidebar-submissions"><?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_RECORDS')); ?>:</div>
                <div class="rm-grid-sidebar-row-value difl"><?php echo isset($data->login_count)?esc_html($data->login_count):''; ?></div>
            </div>

            <div class="rm-grid-sidebar-row dbfl">
                <div class="rm-grid-sidebar-row-icon difl">
                    <img src="<?php echo esc_url(RM_IMG_URL); ?>conversion.png">
                </div>
                <div class="rm-grid-sidebar-row-label difl" id="rm-sidebar-conversion"><?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_SUCCESS_RATE')); ?>:</div>
                <div class="rm-grid-sidebar-row-value difl"><?php echo isset($data->success_rate)?esc_html($data->success_rate):0; ?>%</div>
            </div>

            <div class="rm-grid-quick-tasks dbfl">
                <div class="rm-grid-sidebar-row dbfl">
                    <div class="rm-grid-sidebar-row-label difl">
                        <a id="rm-sidebar-reset" href="javascript:void(0)" onclick="jQuery.rm_do_action_with_alert('<?php _e('You are going to delete all stats for login form. Do you want to proceed?','custom-registration-form-builder-with-submission-manager'); ?>', 'rm_fd_action_form', 'rm_login_log_reset')"><?php echo wp_kses_post((string)RM_UI_Strings::get('LABEL_RESET')); ?></a>
                    </div>
                </div>
            </div>
        </div>

        

    </div>
    
    
</div>

<!-- Dashboard-Promo popup -->
    <div class="rmagic rm-hide-version-number">
    <div id="rm_fd_promo_popup" class="rm-modal-view" style="display: none;">
        <div class="rm-modal-overlay"></div>
        <div class="rm-modal-wrap rm-fd-promo-popup">

            <div class="rm-modal-titlebar ">
                <div class="rm-modal-title">
                <?php _e("Extend Power of RegistrationMagic",'custom-registration-form-builder-with-submission-manager'); ?>
                </div>
                <span class="rm-modal-close">&times;</span>
            </div>
            <div class="rm-modal-container">
                <?php include_once RM_ADMIN_DIR . 'views/template_rm_login_fd_promo.php'; ?>
            </div>
            
            <div class="rm-modal-footer"><a href="?page=rm_support_premium_page" target="_blank"><?php _e("More Information",'custom-registration-form-builder-with-submission-manager'); ?></a></div>
        </div>

    </div>
    </div>
<!-- End Dashboard-promo pop-up  -->


<!-- Form Publish Pop-up -->
    <div class="rmagic rm-hide-version-number">
    <div id="rm_form_publish_popup" class="rm-modal-view" style="display: none;">
        <div class="rm-modal-overlay"></div>
        <div class="rm-modal-wrap rm-publish-form-popup">

            <div class="rm-modal-titlebar rm-new-form-popup-header">
                <div class="rm-modal-title">
                    <?php _e('Publish', 'custom-registration-form-builder-with-submission-manager'); ?>
                </div>
                <span class="rm-modal-close">&times;</span>
            </div>
            <div class="rm-modal-container">
                <?php $form_id_to_publish = 'login_form'; ?>
                <?php include_once RM_ADMIN_DIR . 'views/template_rm_formflow_publish.php'; ?>
            </div>
        </div>

    </div>
    </div>
<!-- End Form Publish Pop-up -->

<!-- Timeline Pop-up -->
    <div class="rmagic rm-hide-version-number">
    <div id="rm_timeline_popup" class="rm-modal-view" style="display: none;">
        <div class="rm-modal-overlay"></div>
        <div class="rm-modal-wrap rm-publish-form-popup">

            <div class="rm-modal-titlebar rm-new-form-popup-header">
                <div class="rm-modal-title">
                    <?php _e('User Login timeline', 'custom-registration-form-builder-with-submission-manager'); ?>
                </div>
                <span class="rm-modal-close">&times;</span>
            </div>
            <div class="rm-modal-container">
                <?php include_once RM_ADMIN_DIR . 'views/template_rm_formflow_timeline.php'; ?>
            </div>
        </div>

    </div>
    </div>
<!-- End Timeline Pop-up -->
<?php
            wp_enqueue_script('jquery-ui-tooltip',array('jquery'));
?>
<pre class='rm-pre-wrapper-for-script-tags'><script>
    function edit_label(){
        jQuery('#rm-submit-label-textbox').show();
    }
    
    function cancel_edit_label(){
        jQuery('#submit_label_textbox').val('');
        jQuery('#rm-submit-label-textbox').hide();
    }
    
    function save_submit_label(){
        var data = {
                        'register_btn_label': '<?php echo esc_html($data->buttons->register_btn) ?>',
                        'login_btn_label': jQuery("#submit_label_textbox").val().trim(),
                        'btn_align': '<?php echo esc_html($data->buttons->align) ?>',
                        'display_register': '<?php echo esc_html($data->buttons->display_register) ?>'
                    };

        var data = {
                        'action': 'rm_update_login_button',
                        'rm_sec_nonce': '<?php echo wp_create_nonce('rm_ajax_secure'); ?>',
                        'data': data,
                    };
        jQuery.post(ajaxurl, data, function (response) {
            jQuery('#rm-submit-label').text(jQuery("#submit_label_textbox").val().trim());
            jQuery('#rm-submit-label-textbox').hide();
        });
    }
    
    jQuery(function () {
        jQuery(document).tooltip({
            content: function () {
                return jQuery(this).prop('title');
            },
            show: null, 
            close: function (event, ui) {
                ui.tooltip.hover(

                function () {
                    jQuery(this).stop(true).fadeTo(400, 1);
                },

                function () {
                    jQuery(this).fadeOut("400", function () {
                       jQuery(this).remove();
                    })
                });
            }
        });
        
        
        jQuery(".rm_dash_popup_link").each(function(){
            jQuery(this).click(function(){
                var target = jQuery(this).attr("id").substr("rm_dash_popup_link_".length);
                if(typeof target !== "undefined") {
                    jQuery(".rm-fd-promo-section").hide();
                    jQuery(".rm-fd-promo-section#rm-fd-promo-"+target).show();
                    jQuery("#rm_fd_promo_popup").show();
                }
            });
            
        });
    });   
</script></pre>

<?php
/* * ****************************************************************
 * *************     Chart drawing - Line Chart        **************
 * **************************************************************** */
$show_chart=0;
$date_labels= array();
$success_data= array();
$failure_data= array();
foreach ($data->day_wise_stat as $date => $per_day) {
    array_push($date_labels,$date);
    array_push($success_data,$per_day->success);
    array_push($failure_data,$per_day->fail);
    if(empty($show_chart) && (!empty($per_day->success) || !empty($per_day->fail))){
        $show_chart=1;
    }
}
$date_labels= json_encode($date_labels);
$success_data= json_encode($success_data);
$failure_data= json_encode($failure_data);
?>

<pre class='rm-pre-wrapper-for-script-tags'><script>
    function drawTimewiseStat()
    {
        if('<?php echo wp_kses_post((string)$show_chart); ?>'==0){
            jQuery("#rm_subs_over_time_chart_div,#rm_tour_timewise_stats").remove();
            return;
        }
        
       var data = {
           labels: <?php echo wp_kses_post((string)$date_labels); ?>,
           datasets:[{
                label: 'Login Success',
                data: <?php echo wp_kses_post((string)$success_data); ?>,
                fill: false,
                borderColor: 'rgb(53,167,227)',
                backgroundColor: 'rgb(53,167,227)'
            },
            {
                label: 'Login Failures',
                data: <?php echo wp_kses_post((string)$failure_data); ?>,
                fill: false,
                borderColor: 'rgb(72,84,104)',
                backgroundColor: 'rgb(72,84,104)'
            }]
        }
        var config = {
            type: 'line',
            data: data,
            options: {}
        };
        var ctx = document.getElementById('rm_subs_over_time_chart_div');
        //ctx.height = 5000;
        var myLineChart = new Chart(ctx, config);
    }
</script></pre>

<script>
    jQuery(document).ready(function(){
        jQuery(".rm_publish_popup_link").each(function(){
            jQuery(this).click(function(){
                rm_set_publish_popup('login_form',jQuery(this).data("publish_type"));
                jQuery("#rm_form_publish_popup").show();
            });
            
        });
        
        jQuery(".rm_timeline_popup_link").each(function(){
            jQuery(this).click(function(){
                rm_set_publish_popup('login_form',jQuery(this).data("publish_type"));
                jQuery("#rm_timeline_popup").show();
            });
        });
        
        jQuery('.rm-modal-close, .rm-modal-overlay').click(function () {
            jQuery(this).parents('.rm-modal-view').hide();
        });
        
        jQuery('.rm-grid-sidebar-row-value .rm-premium-option').on('click', function(e) {
            jQuery('.rm-premium-option-popup').toggle();
        });
        
        jQuery('.rm-form-configuration-wrapper').fadeIn();
        
    });
    
    
    

</script>    

<!-- action form to execute rm_slug_actions -->
<form style="display:none" method="post" action="" id="rm_fd_action_form">
    <input type="hidden" name="action" value="" id="rm_slug_input_field">
</form>

<?php } ?>