# Contributing
Hi, and thanks for considering contributing! Before you do though, here's a few
notes on how best to contribute. Don't worry, I'll keep it short!

## Best Practices

### Commit Messages
Commit messages should follow the standard laid out in the git manual; that is,
a one-line summary ()

	Short (50 chars or less) summary of changes

	More detailed explanatory text, if necessary.  Wrap it to about 72
	characters or so.  In some contexts, the first line is treated as the
	subject of an email and the rest of the text as the body.  The blank
	line separating the summary from the body is critical (unless you omit
	the body entirely); tools like rebase can get confused if you run the
	two together.

	Further paragraphs come after blank lines.

	 - Bullet points are okay, too

	 - Typically a hyphen or asterisk is used for the bullet, preceded by a
	   single space, with blank lines in between, but conventions vary here

## Commit Process
Changes are proposed in the form of pull requests by you, the contributor! After
submitting your proposed changes, a member of the API team will review your
commits and mark them for merge by assigning it to themselves. Your pull request
will then be merged after final review by another member.
