<?php if( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
return [
    'USD' => [
        'symbol' => '$',
        'name' => 'Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'USD',
        'name_plural' => 'Dollars',
        'bank_name' => 'Federal Reserve System',
        'desc_1' => 'The American dollar was first authorized and created in 1785, replacing the “continental currency” that had been used as money prior to the nation’s status as a British colony.',
        'desc_2' => 'The American dollar is now the dominant form of money, and, in fact, is used as a “global currency,” accepted in all nations. This is due to the strength of the US economy in the world market.',
        'country' => 'United States',
    ],
    'EUR' => [
        'symbol' => '€',
        'name' => 'Euro',
        'symbol_native' => '€',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'EUR',
        'name_plural' => 'Euros',
        'bank_name' => 'European Central Bank',
        'desc_1' => 'The “Euro” as it is commonly called, first went into circulation in 1999, and marks the first time in European history that a standard currency is acceptable in 12 nations of the continent.',
        'desc_2' => 'The Euro has coins, with 100 cents making one Euro. One side is standard, showing the value of the coin, while the other can be customized by each issuing nation, to represent their culture.',
        'country' => 'the Eurozone',
    ],
    'GBP' => [
        'symbol' => '£',
        'name' => 'British Pound Sterling',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GBP',
        'name_plural' => 'British Pounds Sterling',
        'bank_name' => 'Bank of England',
        'desc_1' => 'The Pound Sterling is the oldest currency in the world that is still in active use. It first came into circulation in the 8th century and was originally based on 240 silver pennies.',
        'desc_2' => 'The Pound Sterling has two bill denominations nicknamed “the giant,” and “the titan.” These are the £1 million and £100 million notes, respectively, which are used between banks and not meant for public circulation.',
        'country' => 'United Kingdom',
    ],
    'CAD' => [
        'symbol' => 'CA$',
        'name' => 'Canadian Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CAD',
        'name_plural' => 'Canadian Dollars',
        'bank_name' => 'Bank of Canada',
        'desc_1' => 'The Canadian Dollar first came to be in 1871, as the former colonies of Canada, New Brunswick, and Nova Scotia formed a Federation of provinces in 1867. More provinces followed, formally adopting this currency.',
        'desc_2' => 'With the elimination of one dollar bills, the nickname for the Canadian dollar became “the loonie,” a reference to the Loon that appeared on one side of the coin. Two dollar coins are called “toonies.”',
        'country' => 'Canada',
    ],
    'JPY' => [
        'symbol' => '¥',
        'name' => 'Japanese Yen',
        'symbol_native' => '￥',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'JPY',
        'name_plural' => 'Japanese yen',
        'bank_name' => 'Bank of Japan',
        'desc_1' => 'The Japanese Yen came into use both within Japan and the rest of the world in 1871, as the country attempted to enter the global economy and peg its currency to the gold standard at that time.',
        'desc_2' => 'There is now only one currency in Japan, the Yen. However, in the past, the Yen used to be made up of smaller units, with 100 “Sen” making up one Yen.',
        'country' => 'Japan',
    ],
    'MXN' => [
        'symbol' => 'MX$',
        'name' => 'Mexican Peso',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MXN',
        'name_plural' => 'Mexican Pesos',
        'bank_name' => 'Bank of Mexico',
        'desc_1' => 'The Mexican Peso has been an official currency for Mexico since 1863, and, amongst Latin countries of Central and South America, widely used in the 20th century due to Mexico’s economic stability.',
        'desc_2' => 'The term “pieces of eight” actually comes from the Peso, as the coin was sometimes cut into pieces to make the change, when ways to use cash were far less formalized as they are today.',
        'country' => 'Mexico',
    ],
    'CHF' => [
        'symbol' => 'CHF',
        'name' => 'Swiss Franc',
        'symbol_native' => 'CHF',
        'decimal_digits' => 2,
        'rounding' => 0.05,
        'code' => 'CHF',
        'name_plural' => 'Swiss Francs',
        'bank_name' => 'Swiss National Bank',
        'desc_1' => 'The Swiss Franc was originally conceived in 1798 and underwent many incarnations and standards of meas-urement, but finally pegged itself with the Bretton Woods system to the US dollar for its value in 1945.',
        'desc_2' => 'The Swiss Franc, like many older currencies, didn’t always have its cash produced by the government. For the first half of the 19th century, 8000 different coins types existed, and only 15% were government issued.',
        'country' => 'Liechtenstein,  Switzerland',
    ],
    'BTC' => [
        'symbol' => '₿',
        'name' => 'Bitcoin',
        'symbol_native' => '₿‏',
        'decimal_digits' => 8,
        'rounding' => 0,
        'code' => 'BTC',
        'name_plural' => 'Bitcoins',
        'bank_name' => 'Decentralized',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Worldwide',
    ],
    'AED' => [
        'symbol' => 'AED',
        'name' => 'United Arab Emirates Dirham',
        'symbol_native' => 'د.إ.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'AED',
        'name_plural' => 'UAE Dirhams',
        'bank_name' => 'Central Bank of the United Arab Emirates',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'United Arab Emirates',
    ],
    'AFN' => [
        'symbol' => 'Af',
        'name' => 'Afghan Afghani',
        'symbol_native' => '؋',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'AFN',
        'name_plural' => 'Afghan Afghanis',
        'bank_name' => 'Da Afghanistan Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Afghanistan',
    ],
    'ALL' => [
        'symbol' => 'ALL',
        'name' => 'Albanian Lek',
        'symbol_native' => 'Lek',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'ALL',
        'name_plural' => 'Albanian Lekë',
        'bank_name' => 'Bank of Albania',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Albania',
    ],
    'AMD' => [
        'symbol' => 'AMD',
        'name' => 'Armenian Dram',
        'symbol_native' => 'դր.',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'AMD',
        'name_plural' => 'Armenian Drams',
        'bank_name' => 'Central Bank of Armenia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Armenia',
    ],
    'ANG' => [
        'symbol' => 'NAƒ',
        'name' => 'Guilder',
        'symbol_native' => 'NAƒ',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ANG',
        'name_plural' => 'Guilders',
        'bank_name' => 'Central Bank of CuraÃ§ao and Sint Maarten',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'CURAÇAO',
    ],
    'AOA' => [
        'symbol' => 'Kz',
        'name' => 'Kwanza',
        'symbol_native' => 'Kz',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'AOA',
        'name_plural' => 'Kwanzas',
        'bank_name' => 'Banco Nacional de Angola',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Angola',
    ],
    'ARS' => [
        'symbol' => 'AR$',
        'name' => 'Argentine Peso',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ARS',
        'name_plural' => 'Argentine Pesos',
        'bank_name' => 'Central Bank of Argentina',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Argentina',
    ],
    'AUD' => [
        'symbol' => 'AU$',
        'name' => 'Australian Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'AUD',
        'name_plural' => 'Australian Dollars',
        'bank_name' => 'Reserve Bank of Australia',
        'desc_1' => 'The Australian Dollar has been in circulation throughout the country and the rest of the world since 1966 and derived its value from the original Australian Pound.',
        'desc_2' => 'When it was decided to create a new Australian currency, the dollar was not the first name, and they ran a contest for citizens.  Australians toyed with “the Royal,” “the Austral” and even “the Roo.”',
        'country' => 'Australia',
    ],
    'AWG' => [
        'symbol' => 'Afl',
        'name' => 'Florin',
        'symbol_native' => 'Afl',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'AWG',
        'name_plural' => 'Florins',
        'bank_name' => 'Central Bank of Aruba',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Aruba',
    ],
    'AZN' => [
        'symbol' => 'man.',
        'name' => 'Azerbaijani Manat',
        'symbol_native' => 'ман.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'AZN',
        'name_plural' => 'Azerbaijani Manats',
        'bank_name' => 'Central Bank of Azerbaijan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Azerbaijan',
    ],
    'BAM' => [
        'symbol' => 'KM',
        'name' => 'Bosnia-Herzegovina Convertible Mark',
        'symbol_native' => 'KM',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BAM',
        'name_plural' => 'Bosnia-Herzegovina Convertible Marks',
        'bank_name' => 'Central Bank of Bosnia and Herzegovina',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bosnia and Herzegovina',
    ],
    'BBD' => [
        'symbol' => 'Bds$',
        'name' => 'Bajan Dollar',
        'symbol_native' => 'Bds$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BBD',
        'name_plural' => 'Bajan Dollars',
        'bank_name' => 'Central Bank of Barbados',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Barbados',
    ],
    'BDT' => [
        'symbol' => 'Tk',
        'name' => 'Bangladeshi Taka',
        'symbol_native' => '৳',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BDT',
        'name_plural' => 'Bangladeshi Takas',
        'bank_name' => 'Bangladesh Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bangladesh',
    ],
    'BGN' => [
        'symbol' => 'BGN',
        'name' => 'Bulgarian Lev',
        'symbol_native' => 'лв.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BGN',
        'name_plural' => 'Bulgarian Leva',
        'bank_name' => 'Bulgarian National Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bulgaria',
    ],
    'BHD' => [
        'symbol' => 'BD',
        'name' => 'Bahraini Dinar',
        'symbol_native' => 'د.ب.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'BHD',
        'name_plural' => 'Bahraini Dinars',
        'bank_name' => 'Central Bank of Bahrain',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bahrain',
    ],
    'BIF' => [
        'symbol' => 'FBu',
        'name' => 'Burundian Franc',
        'symbol_native' => 'FBu',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'BIF',
        'name_plural' => 'Burundian Francs',
        'bank_name' => 'Banque de la Republique du Burudi (Ibanki ya Republika Y\'UBurundi)',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Burundi',
    ],
    'BMD' => [
        'symbol' => 'BD$',
        'name' => 'Bermudan Dollar',
        'symbol_native' => 'BD$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BMD',
        'name_plural' => 'Bermudan Dollars',
        'bank_name' => 'Bermuda Monetary Authority',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bermuda',
    ],
    'BND' => [
        'symbol' => 'BN$',
        'name' => 'Brunei Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BND',
        'name_plural' => 'Brunei Dollars',
        'bank_name' => 'Autoriti Monetari Brunei Darussalam (Monetary Authority of Brunei Darussalam)',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Brunei',
    ],
    'BOB' => [
        'symbol' => 'Bs',
        'name' => 'Bolivian Boliviano',
        'symbol_native' => 'Bs',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BOB',
        'name_plural' => 'Bolivian Bolivianos',
        'bank_name' => 'Banco Central de Bolivia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bolivia',
    ],
    'BRL' => [
        'symbol' => 'R$',
        'name' => 'Brazilian Real',
        'symbol_native' => 'R$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BRL',
        'name_plural' => 'Brazilian Reals',
        'bank_name' => 'Central Bank of Brazil',
        'desc_1' => 'The Brazilian Real in its current form went into circulation in currency markets in 1994, with 100 centavos making up one Real. It was part of a plan to stabilize the Brazilian economy.',
        'desc_2' => 'The Brazilian Real is not the only currency originally used in Brazil, with other money such as the original, colonial Portuguese Real, many versions of the Cruzeiro, and an earlier version of the Brazilian Real.',
        'country' => 'Brazil',
    ],
    'BSD' => [
        'symbol' => 'B$',
        'name' => 'Bahamian Dollar',
        'symbol_native' => 'B$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BSD',
        'name_plural' => 'Bahamian Dollars',
        'bank_name' => 'The Central Bank of The Bahamas',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bahamas',
    ],
    'BTN' => [
        'symbol' => 'Nu.',
        'name' => 'Ngultrum',
        'symbol_native' => 'Nu.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BTN',
        'name_plural' => 'Ngultrums',
        'bank_name' => 'Royal Monetary Authority of Bhutan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Bhutan',
    ],
    'BWP' => [
        'symbol' => 'BWP',
        'name' => 'Botswanan Pula',
        'symbol_native' => 'P',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BWP',
        'name_plural' => 'Botswanan Pulas',
        'bank_name' => 'Bank of Botswana',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Botswana',
    ],
    'BYN' => [
        'symbol' => 'BYN',
        'name' => 'Belarusian Ruble',
        'symbol_native' => 'BYN',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'BYN',
        'name_plural' => 'Belarusian Rubles',
        'bank_name' => 'National Bank of the Republic of Belarus',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Belarus',
    ],
    'BZD' => [
        'symbol' => 'BZ$',
        'name' => 'Belize Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'BZD',
        'name_plural' => 'Belize Dollars',
        'bank_name' => 'Central Bank of Belize',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Belize',
    ],
    'CDF' => [
        'symbol' => 'CDF',
        'name' => 'Congolese Franc',
        'symbol_native' => 'FrCD',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CDF',
        'name_plural' => 'Congolese Francs',
        'bank_name' => 'Central Bank of the Congo',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Democratic Republic of the Congo',
    ],
    'CLP' => [
        'symbol' => 'CL$',
        'name' => 'Chilean Peso',
        'symbol_native' => '$',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'CLP',
        'name_plural' => 'Chilean Pesos',
        'bank_name' => 'Banco Central de Chile',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Chile',
    ],
    'CNY' => [
        'symbol' => 'CN¥',
        'name' => 'Chinese Yuan',
        'symbol_native' => 'CN¥',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CNY',
        'name_plural' => 'Chinese Yuan',
        'bank_name' => 'People\'s Bank of China',
        'desc_1' => 'The Chinese Yuan Renminbi is a “younger” currency, having entered both Chinese and global use only back in 1948. It has quickly risen in importance thanks to China’s strong global economic position.',
        'desc_2' => 'The Yuan Renminbi is one of the rare currencies in the world that had paper issued before coins appeared. When the Yuan debuted in the 1940s, it first appeared only as notes.',
        'country' => 'China',
    ],
    'COP' => [
        'symbol' => 'CO$',
        'name' => 'Colombian Peso',
        'symbol_native' => '$',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'COP',
        'name_plural' => 'Colombian Pesos',
        'bank_name' => 'Banco de la Repablica',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Colombia',
    ],
    'CRC' => [
        'symbol' => '₡',
        'name' => 'Costa Rican Colón',
        'symbol_native' => '₡',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'CRC',
        'name_plural' => 'Costa Rican Colóns',
        'bank_name' => 'Central Bank of Costa Rica',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Costa Rica',
    ],
    'CUC' => [
        'symbol' => 'CUC$',
        'name' => 'Peso',
        'symbol_native' => 'CUC$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CUC',
        'name_plural' => 'Pesos',
        'bank_name' => 'Central Bank of Cuba',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Cuba',
    ],
    'CUP' => [
        'symbol' => '$MN',
        'name' => 'Peso',
        'symbol_native' => '$MN',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CUP',
        'name_plural' => 'Pesos',
        'bank_name' => 'Central Bank of Cuba',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Cuba',
    ],
    'CVE' => [
        'symbol' => 'CV$',
        'name' => 'Cape Verdean Escudo',
        'symbol_native' => 'CV$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CVE',
        'name_plural' => 'Cape Verdean Escudos',
        'bank_name' => 'Bank of Cape Verde',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Cape Verde',
    ],
    'CZK' => [
        'symbol' => 'Kč',
        'name' => 'Czech Republic Koruna',
        'symbol_native' => 'Kč',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'CZK',
        'name_plural' => 'Czech Republic Korunas',
        'bank_name' => 'Czech National Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Czech Republic',
    ],
    'DJF' => [
        'symbol' => 'Fdj',
        'name' => 'Djiboutian Franc',
        'symbol_native' => 'Fdj',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'DJF',
        'name_plural' => 'Djiboutian Francs',
        'bank_name' => 'Central Bank of Djibouti',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Djibouti',
    ],
    'DKK' => [
        'symbol' => 'Dkr',
        'name' => 'Danish Krone',
        'symbol_native' => 'kr',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'DKK',
        'name_plural' => 'Danish Kroner',
        'bank_name' => 'Danmarks Nationalbank',
        'desc_1' => 'The Danish Krone has been in use in Denmark since 1875, and although a referendum held in 2000 rejected the adoption of the Euro, the Krone is still pegged to the Euro for its value.',
        'desc_2' => 'The Danish Krone was a replacement for the previous currency, known as the Rigsdaler, a derivation of the Thaler, used in Germany, which eventually became the basis for the dollar.',
        'country' => 'Denmark',
    ],
    'DOP' => [
        'symbol' => 'RD$',
        'name' => 'Dominican Peso',
        'symbol_native' => 'RD$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'DOP',
        'name_plural' => 'Dominican Pesos',
        'bank_name' => 'Central Bank of the Dominican Republic',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Dominican Republic',
    ],
    'DZD' => [
        'symbol' => 'DA',
        'name' => 'Algerian Dinar',
        'symbol_native' => 'د.ج.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'DZD',
        'name_plural' => 'Algerian Dinars',
        'bank_name' => 'Bank of Algeria',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Algeria',
    ],
    'EGP' => [
        'symbol' => 'EGP',
        'name' => 'Egyptian Pound',
        'symbol_native' => 'ج.م.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'EGP',
        'name_plural' => 'Egyptian Pounds',
        'bank_name' => 'Central Bank of Egypt',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Egypt',
    ],
    'ERN' => [
        'symbol' => 'Nfk',
        'name' => 'Eritrean Nakfa',
        'symbol_native' => 'Nfk',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ERN',
        'name_plural' => 'Eritrean Nakfas',
        'bank_name' => 'Bank of Eritrea',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Eritrea',
    ],
    'ETB' => [
        'symbol' => 'Br',
        'name' => 'Ethiopian Birr',
        'symbol_native' => 'Br',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ETB',
        'name_plural' => 'Ethiopian Birrs',
        'bank_name' => 'National Bank of Ethiopia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Ethiopia',
    ],
    'FJD' => [
        'symbol' => 'FJ$',
        'name' => 'Fijian Dollar',
        'symbol_native' => 'FJ$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'FJD',
        'name_plural' => 'Fijian Dollars',
        'bank_name' => 'Reserve Bank of Fiji',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Fiji',
    ],
    'FKP' => [
        'symbol' => '£',
        'name' => 'Pound',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'FKP',
        'name_plural' => 'Livres',
        'bank_name' => 'Government of the Falkland Islands',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Frankland Islands',
    ],
    'GEL' => [
        'symbol' => 'GEL',
        'name' => 'Georgian Lari',
        'symbol_native' => 'GEL',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GEL',
        'name_plural' => 'Georgian Laris',
        'bank_name' => 'National Bank of Georgia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Georgia',
    ],
    'GGP' => [
        'symbol' => '£',
        'name' => 'Pound',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GGP',
        'name_plural' => 'Livres',
        'bank_name' => 'Guernsey pound, Treasury and Resources Department, States of Guernsey',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Guernsey',
    ],
    'GHS' => [
        'symbol' => 'GH₵',
        'name' => 'Ghanaian Cedi',
        'symbol_native' => 'GH₵',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GHS',
        'name_plural' => 'Ghanaian Cedis',
        'bank_name' => 'Bank of Ghana',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Ghana',
    ],
    'GIP' => [
        'symbol' => '£',
        'name' => 'Pound',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GIP',
        'name_plural' => 'Livres',
        'bank_name' => 'Government of Gibraltar',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Gibraltar',
    ],
    'GMD' => [
        'symbol' => 'D',
        'name' => 'Dalasi',
        'symbol_native' => 'D',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GMD',
        'name_plural' => 'Dalasis',
        'bank_name' => 'Central Bank of The Gambia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Gambia',
    ],
    'GNF' => [
        'symbol' => 'FG',
        'name' => 'Guinean Franc',
        'symbol_native' => 'FG',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'GNF',
        'name_plural' => 'Guinean Francs',
        'bank_name' => 'Central Bank of the Republic of Guinea',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Guinea',
    ],
    'GTQ' => [
        'symbol' => 'GTQ',
        'name' => 'Guatemalan Quetzal',
        'symbol_native' => 'Q',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GTQ',
        'name_plural' => 'Guatemalan Quetzals',
        'bank_name' => 'Bank of Guatemala',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Guatemala',
    ],
    'GYD' => [
        'symbol' => 'G$',
        'name' => 'Guyanaese Dollar',
        'symbol_native' => 'G$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'GYD',
        'name_plural' => 'Guyanaese Dollars',
        'bank_name' => 'Bank of Guyana',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Guyana',
    ],
    'HKD' => [
        'symbol' => 'HK$',
        'name' => 'Hong Kong Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'HKD',
        'name_plural' => 'Hong Kong Dollars',
        'bank_name' => 'Hong Kong Monetary Authority',
        'desc_1' => 'The Hong Kong Dollar entered into usage in Hong Kong back in 1941, replacing a system of different currencies in use in various British colonies in the Southeast Asia region.',
        'desc_2' => 'The Hong Kong Dollar came into being as a result of the need for reliable currencies in the region of Southeast Asia that weren’t dependent on a British supply of cash.',
        'country' => 'Hong Kong',
    ],
    'HNL' => [
        'symbol' => 'HNL',
        'name' => 'Honduran Lempira',
        'symbol_native' => 'L',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'HNL',
        'name_plural' => 'Honduran Lempiras',
        'bank_name' => 'Central Bank of Honduras',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Honduras',
    ],
    'HRK' => [
        'symbol' => 'kn',
        'name' => 'Croatian Kuna',
        'symbol_native' => 'kn',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'HRK',
        'name_plural' => 'Croatian Kunas',
        'bank_name' => 'Croatian National Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Croatia',
    ],
    'HTG' => [
        'symbol' => 'G',
        'name' => 'Gourde',
        'symbol_native' => 'G',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'HTG',
        'name_plural' => 'Gourdes',
        'bank_name' => 'Bank of the Republic of Haiti',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Haiti',
    ],
    'HUF' => [
        'symbol' => 'Ft',
        'name' => 'Hungarian Forint',
        'symbol_native' => 'Ft',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'HUF',
        'name_plural' => 'Hungarian Forints',
        'bank_name' => 'Magyar Nemzeti Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Hungary',
    ],
    'IDR' => [
        'symbol' => 'Rp',
        'name' => 'Indonesian Rupiah',
        'symbol_native' => 'Rp',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'IDR',
        'name_plural' => 'Indonesian Rupiahs',
        'bank_name' => 'Bank Indonesia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Indonesia',
    ],
    'ILS' => [
        'symbol' => '₪',
        'name' => 'Israeli New Sheqel',
        'symbol_native' => '₪',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ILS',
        'name_plural' => 'Israeli New Sheqels',
        'bank_name' => 'Bank of Israel',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Israel',
    ],
    'IMP' => [
        'symbol' => 'M£',
        'name' => 'Pound',
        'symbol_native' => 'M£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'IMP',
        'name_plural' => 'Livres',
        'bank_name' => 'Isle of Man Treasury',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Isle of Man',
    ],
    'INR' => [
        'symbol' => 'Rs',
        'name' => 'Indian Rupee',
        'symbol_native' => 'টকা',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'INR',
        'name_plural' => 'Indian Rupees',
        'bank_name' => 'Reserve Bank of India',
        'desc_1' => 'The Indian Rupee is one of the older currencies in the world, believed to have first come into use in the 15th century. The ₹500 and ₹1000 notes were recently discontinued in 2016.',
        'desc_2' => 'The Indian Rupee was co-opted by the British Empire during its colonial period in the 18th and 19th centuries to provide a usable currency for its colonial interests in the India-Asia region.',
        'country' => 'India',
    ],
    'IQD' => [
        'symbol' => 'IQD',
        'name' => 'Iraqi Dinar',
        'symbol_native' => 'د.ع.‏',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'IQD',
        'name_plural' => 'Iraqi Dinars',
        'bank_name' => 'Central Bank of Iraq',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Iraq',
    ],
    'IRR' => [
        'symbol' => 'IRR',
        'name' => 'Iranian Rial',
        'symbol_native' => '﷼',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'IRR',
        'name_plural' => 'Iranian Rials',
        'bank_name' => 'Central Bank of the Islamic Republic of Iran',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Iran',
    ],
    'ISK' => [
        'symbol' => 'Ikr',
        'name' => 'Icelandic Króna',
        'symbol_native' => 'kr',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'ISK',
        'name_plural' => 'Icelandic Krónur',
        'bank_name' => 'Central Bank of Iceland',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Iceland',
    ],
    'JEP' => [
        'symbol' => '£',
        'name' => 'Pound',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'JEP',
        'name_plural' => 'Livres',
        'bank_name' => 'Treasury and Resources Department, States of Jersey',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Jersey',
    ],
    'JMD' => [
        'symbol' => 'J$',
        'name' => 'Jamaican Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'JMD',
        'name_plural' => 'Jamaican Dollars',
        'bank_name' => 'Bank of Jamaica',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Jamaica',
    ],
    'JOD' => [
        'symbol' => 'JD',
        'name' => 'Jordanian Dinar',
        'symbol_native' => 'د.أ.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'JOD',
        'name_plural' => 'Jordanian Dinars',
        'bank_name' => 'Central Bank of Jordan  ',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Jordan',
    ],
    'KES' => [
        'symbol' => 'Ksh',
        'name' => 'Kenyan Shilling',
        'symbol_native' => 'Ksh',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KES',
        'name_plural' => 'Kenyan Shillings',
        'bank_name' => 'Central Bank of Jordan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Kenya',
    ],
    'KGS' => [
        'symbol' => 'Лв',
        'name' => 'Som',
        'symbol_native' => 'Лв',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KGS',
        'name_plural' => 'Soms',
        'bank_name' => 'National Bank of the Kyrgyz Republic',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Kyrgyzstan',
    ],
    'KHR' => [
        'symbol' => 'KHR',
        'name' => 'Cambodian Riel',
        'symbol_native' => '៛',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KHR',
        'name_plural' => 'Cambodian Riels',
        'bank_name' => 'National Bank of Cambodia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Cambodia',
    ],
    'KMF' => [
        'symbol' => 'CF',
        'name' => 'Comorian Franc',
        'symbol_native' => 'FC',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'KMF',
        'name_plural' => 'Comorian Francs',
        'bank_name' => 'Banque Centrale des Comores',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Comoros',
    ],
    'KPW' => [
        'symbol' => '₩',
        'name' => 'Won',
        'symbol_native' => '₩',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KPW',
        'name_plural' => 'Wons',
        'bank_name' => 'Central Bank of the Democratic Peoples Republic of Korea',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'North Korea',
    ],
    'KRW' => [
        'symbol' => '₩',
        'name' => 'South Korean Won',
        'symbol_native' => '₩',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'KRW',
        'name_plural' => 'South Korean Won',
        'bank_name' => 'Bank of Korea',
        'desc_1' => 'The South Korean Won, in its current form, was first introduced to both South Korea and the currency markets of the world in 1962. It wasn’t until 1997 that it went to a floating exchange rate.',
        'desc_2' => 'The South Korean Won gets its name from a combination of two different words and currencies. “Won” is actually a combination between the Chinese “Yuan,” and the Japanese “Yen.”',
        'country' => 'South Korea',
    ],
    'KWD' => [
        'symbol' => 'KD',
        'name' => 'Kuwaiti Dinar',
        'symbol_native' => 'د.ك.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'KWD',
        'name_plural' => 'Kuwaiti Dinars',
        'bank_name' => 'Central Bank of Kuwait',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Kuwait',
    ],
    'KYD' => [
        'symbol' => '$',
        'name' => 'Cayman Islands Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KYD',
        'name_plural' => 'Cayman Islands Dollars',
        'bank_name' => 'Cayman Islands Monetary Authority',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Cayman Islands',
    ],
    'KZT' => [
        'symbol' => 'KZT',
        'name' => 'Kazakhstani Tenge',
        'symbol_native' => 'тңг.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'KZT',
        'name_plural' => 'Kazakhstani Tenges',
        'bank_name' => 'The National Bank of Kazakhstan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Kazakhstan',
    ],
    'LAK' => [
        'symbol' => '₭',
        'name' => 'Kip',
        'symbol_native' => '₭',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'LAK',
        'name_plural' => 'Kips',
        'bank_name' => 'Bank of the Lao P.D.R.',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Laos',
    ],
    'LBP' => [
        'symbol' => 'LB£',
        'name' => 'Lebanese Pound',
        'symbol_native' => 'ل.ل.‏',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'LBP',
        'name_plural' => 'Lebanese Pounds',
        'bank_name' => 'Banque du Liban',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Lebanon',
    ],
    'LKR' => [
        'symbol' => 'SLRs',
        'name' => 'Sri Lankan Rupee',
        'symbol_native' => 'SL Re',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'LKR',
        'name_plural' => 'Sri Lankan Rupees',
        'bank_name' => 'Central Bank of Sri Lanka',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Sri Lanka',
    ],
    'LRD' => [
        'symbol' => 'L$',
        'name' => 'Liberian Dollar',
        'symbol_native' => 'L$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'LRD',
        'name_plural' => 'Liberian Dollars',
        'bank_name' => 'Central Bank of Liberia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Liberia',
    ],
    'LSL' => [
        'symbol' => 'L',
        'name' => 'Loti',
        'symbol_native' => 'L',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'LSL',
        'name_plural' => 'Lotis',
        'bank_name' => 'Central Bank of Lesotho',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Lesotho',
    ],
    'LTL' => [
        'symbol' => 'Lt',
        'name' => 'Lithuanian Litas',
        'symbol_native' => 'Lt',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'LTL',
        'name_plural' => 'Lithuanian Litai',
        'bank_name' => 'Bank of Lithuania',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Lithuania',
    ],
    'LYD' => [
        'symbol' => 'LD',
        'name' => 'Libyan Dinar',
        'symbol_native' => 'د.ل.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'LYD',
        'name_plural' => 'Libyan Dinars',
        'bank_name' => 'Central Bank of Libya',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Libya',
    ],
    'MAD' => [
        'symbol' => 'MAD',
        'name' => 'Moroccan Dirham',
        'symbol_native' => 'د.م.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MAD',
        'name_plural' => 'Moroccan Dirhams',
        'bank_name' => 'Bank Al-Maghrib',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Morocco',
    ],
    'MDL' => [
        'symbol' => 'MDL',
        'name' => 'Moldovan Leu',
        'symbol_native' => 'MDL',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MDL',
        'name_plural' => 'Moldovan Lei',
        'bank_name' => 'National Bank of Moldova',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Moldova',
    ],
    'MGA' => [
        'symbol' => 'MGA',
        'name' => 'Malagasy Ariary',
        'symbol_native' => 'MGA',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'MGA',
        'name_plural' => 'Malagasy Ariaries',
        'bank_name' => 'Banque Centrale de Madagascar',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Madagascar',
    ],
    'MKD' => [
        'symbol' => 'MKD',
        'name' => 'Macedonian Denar',
        'symbol_native' => 'MKD',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MKD',
        'name_plural' => 'Macedonian Denari',
        'bank_name' => 'National Bank of the Republic of Macedonia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Macedonia',
    ],
    'MNT' => [
        'symbol' => '₮',
        'name' => 'T',
        'symbol_native' => '₮',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MNT',
        'name_plural' => 'T',
        'bank_name' => 'Bank of Mongolia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Mongolia',
    ],
    'MMK' => [
        'symbol' => 'MMK',
        'name' => 'Myanma Kyat',
        'symbol_native' => 'K',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'MMK',
        'name_plural' => 'Myanma Kyats',
        'bank_name' => 'Central Bank of Myanmar',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Myanmar',
    ],
    'MOP' => [
        'symbol' => 'MOP$',
        'name' => 'Macanese Pataca',
        'symbol_native' => 'MOP$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MOP',
        'name_plural' => 'Macanese Patacas',
        'bank_name' => 'Monetary Authority of Macao',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Macao',
    ],
    'MUR' => [
        'symbol' => 'MURs',
        'name' => 'Mauritian Rupee',
        'symbol_native' => 'MURs',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'MUR',
        'name_plural' => 'Mauritian Rupees',
        'bank_name' => 'Bank of Mauritius',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Mauritius',
    ],
    'MYR' => [
        'symbol' => 'RM',
        'name' => 'Malaysian Ringgit',
        'symbol_native' => 'RM',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MYR',
        'name_plural' => 'Malaysian Ringgits',
        'bank_name' => 'Bank Negara Malaysia',
        'desc_1' => 'The Malaysian Ringgit has been in use since 1967. But it officially got its legal name in 1975, when other names for the currency, such as the dollar, were discontinued in favor of just one name.',
        'desc_2' => 'The word Ringgit in Malay is an older, discontinued word for “jagged,” and is a reference to the older, serrated, silver Spanish dollars that were in use around the region as currency.',
        'country' => 'Malaysia',
    ],
    'MRO' => [
        'symbol' => 'UM',
        'name' => 'Ouguiya',
        'symbol_native' => 'UM',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'MRO',
        'name_plural' => 'Ouguiyas',
        'bank_name' => 'Banque Centrale de Mauritanie',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Mauritania',
    ],
    'MVR' => [
        'symbol' => 'Rf',
        'name' => 'Rufiyaa',
        'symbol_native' => 'Rf',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MVR',
        'name_plural' => 'Rufiyaas',
        'bank_name' => 'Maldives Monetary Authority',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Maldives',
    ],
    'MWK' => [
        'symbol' => 'MK',
        'name' => 'Kwacha',
        'symbol_native' => 'MK',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MWK',
        'name_plural' => 'Kwachas',
        'bank_name' => 'Reserve Bank of Malawi',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Malawi',
    ],
    'MZN' => [
        'symbol' => 'MTn',
        'name' => 'Mozambican Metical',
        'symbol_native' => 'MTn',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'MZN',
        'name_plural' => 'Mozambican Meticals',
        'bank_name' => 'Banco de MoÃ§ambique',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Mozambique',
    ],
    'NAD' => [
        'symbol' => 'N$',
        'name' => 'Namibian Dollar',
        'symbol_native' => 'N$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NAD',
        'name_plural' => 'Namibian Dollars',
        'bank_name' => 'Bank of Namibia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Namibia',
    ],
    'NGN' => [
        'symbol' => '₦',
        'name' => 'Nigerian Naira',
        'symbol_native' => '₦',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NGN',
        'name_plural' => 'Nigerian Nairas',
        'bank_name' => 'Central Bank of Nigeria',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Nigeria',
    ],
    'NIO' => [
        'symbol' => 'C$',
        'name' => 'Nicaraguan Córdoba',
        'symbol_native' => 'C$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NIO',
        'name_plural' => 'Nicaraguan Córdobas',
        'bank_name' => 'Central Bank of Nicaragua',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Nicaragua',
    ],
    'NOK' => [
        'symbol' => 'Nkr',
        'name' => 'Norwegian Krone',
        'symbol_native' => 'kr',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NOK',
        'name_plural' => 'Norwegian Kroner',
        'bank_name' => 'Bank Norwegian AS',
        'desc_1' => 'The Norwegian Krone was created and went into circulation in 1875, as part of a monetary alliance of Scandinavian nations like Sweden and Denmark striving for currency stability.',
        'desc_2' => 'The Norwegian Krone was taken off the fixed exchange rate in 1990, due to heavy currency speculation in the 1990s that was having dramatic effects on the value of the currency.',
        'country' => 'Norway',
    ],
    'NPR' => [
        'symbol' => 'NPRs',
        'name' => 'Nepalese Rupee',
        'symbol_native' => 'नेरू',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NPR',
        'name_plural' => 'Nepalese Rupees',
        'bank_name' => 'Nepal Rastra Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Nepal',
    ],
    'NZD' => [
        'symbol' => 'NZ$',
        'name' => 'New Zealand Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'NZD',
        'name_plural' => 'New Zealand Dollars',
        'bank_name' => 'Reserve Bank of New Zealand',
        'desc_1' => 'The New Zealand Dollar is another relatively young currency, having only debuted in its country of origin and the world currency market in 1965, after moving away from the Pound.',
        'desc_2' => 'The New Zealand Dollar is also known as the “Kiwi” or “Kiwi Dollar” thanks to one of the most well-known of the country’s bird species, the kiwi. The bird appears on the dollar coin.',
        'country' => 'New Zealand',
    ],
    'OMR' => [
        'symbol' => 'OMR',
        'name' => 'Omani Rial',
        'symbol_native' => 'ر.ع.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'OMR',
        'name_plural' => 'Omani Rials',
        'bank_name' => 'Central Bank of Oman',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Oman',
    ],
    'PAB' => [
        'symbol' => 'B/.',
        'name' => 'Panamanian Balboa',
        'symbol_native' => 'B/.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'PAB',
        'name_plural' => 'Panamanian Balboas',
        'bank_name' => 'National Bank of Panama',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Panama',
    ],
    'PEN' => [
        'symbol' => 'S/.',
        'name' => 'Peruvian Nuevo Sol',
        'symbol_native' => 'S/.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'PEN',
        'name_plural' => 'Peruvian Nuevos Soles',
        'bank_name' => 'Central Reserve Bank of Peru',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Peru',
    ],
    'PGK' => [
        'symbol' => 'K',
        'name' => 'Kina',
        'symbol_native' => 'K',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'PGK',
        'name_plural' => 'Kinas',
        'bank_name' => 'Bank of Papua New Guinea',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Papua New Guinea',
    ],
    'PHP' => [
        'symbol' => '₱',
        'name' => 'Philippine Peso',
        'symbol_native' => '₱',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'PHP',
        'name_plural' => 'Philippine Pesos',
        'bank_name' => 'Bangko Sentral ng Pilipinas',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Philippines',
    ],
    'PKR' => [
        'symbol' => 'PKRs',
        'name' => 'Pakistani Rupee',
        'symbol_native' => '₨',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'PKR',
        'name_plural' => 'Pakistani Rupees',
        'bank_name' => 'State Bank of Pakistan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Pakistan',
    ],
    'PLN' => [
        'symbol' => 'zł',
        'name' => 'Polish Zloty',
        'symbol_native' => 'zł',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'PLN',
        'name_plural' => 'Polish Zlotys',
        'bank_name' => 'National Bank of Poland',
        'desc_1' => 'The Polish Zloty first came into usage in Poland around the 14th century for managing different types of gold currencies. The latest iteration of the currency was revalued for the currency market in 1995.',
        'desc_2' => 'The word Zloty means “golden” in Polish and was the generic term for any different number of coins and other cash that was made with gold but still acceptable for use in Poland.',
        'country' => 'Poland',
    ],
    'PYG' => [
        'symbol' => '₲',
        'name' => 'Paraguayan Guarani',
        'symbol_native' => '₲',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'PYG',
        'name_plural' => 'Paraguayan Guaranis',
        'bank_name' => 'Banco Central del Paraguay',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Paraguay',
    ],
    'QAR' => [
        'symbol' => 'QR',
        'name' => 'Qatari Rial',
        'symbol_native' => 'ر.ق.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'QAR',
        'name_plural' => 'Qatari Rials',
        'bank_name' => 'Qatar Central Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Qatar',
    ],
    'RON' => [
        'symbol' => 'RON',
        'name' => 'Romanian Leu',
        'symbol_native' => 'RON',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'RON',
        'name_plural' => 'Romanian Lei',
        'bank_name' => 'National Bank of Romania',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Romania',
    ],
    'RSD' => [
        'symbol' => 'din.',
        'name' => 'Serbian Dinar',
        'symbol_native' => 'дин.',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'RSD',
        'name_plural' => 'Serbian Dinars',
        'bank_name' => 'National Bank of Serbia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Serbia',
    ],
    'RUB' => [
        'symbol' => 'RUB',
        'name' => 'Russian Ruble',
        'symbol_native' => 'руб.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'RUB',
        'name_plural' => 'Russian Rubles',
        'bank_name' => 'Bank of Russia',
        'desc_1' => 'The Russian Ruble is the second oldest currency in the world, having been in continuous use since the 13th century. The latest version of the Ruble entered the currency market in 1998.',
        'desc_2' => 'The Russian Ruble is the world’s first decimal currency, meaning that it was the very first money to divide itself into units of 10 or 100. Previous currencies were based on arbitrary precious metal values.',
        'country' => 'Russia',
    ],
    'RWF' => [
        'symbol' => 'RWF',
        'name' => 'Rwandan Franc',
        'symbol_native' => 'FR',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'RWF',
        'name_plural' => 'Rwandan Francs',
        'bank_name' => 'National Bank of Rwanda',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Rwanda',
    ],
    'SAR' => [
        'symbol' => 'SR',
        'name' => 'Saudi Riyal',
        'symbol_native' => 'ر.س.‏',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SAR',
        'name_plural' => 'Saudi Riyals',
        'bank_name' => 'Saudi Arabian Monetary Agency',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Saudi Arabia',
    ],
    'SBD' => [
        'symbol' => 'SI$',
        'name' => 'Solomon Islands Dollar',
        'symbol_native' => 'SI$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SBD',
        'name_plural' => 'Solomon Islands Dollars',
        'bank_name' => 'Central Bank of Solomon Islands',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Solomon Islands',
    ],
    'SCR' => [
        'symbol' => 'SR',
        'name' => 'Rupee',
        'symbol_native' => 'SR',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SCR',
        'name_plural' => 'Roupies',
        'bank_name' => 'Central Bank of Seychelles',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Seychelles',
    ],
    'SDG' => [
        'symbol' => 'SDG',
        'name' => 'Sudanese Pound',
        'symbol_native' => 'SDG',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SDG',
        'name_plural' => 'Sudanese Pounds',
        'bank_name' => 'Central Bank of Sudan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Sudan',
    ],
    'SEK' => [
        'symbol' => 'Skr',
        'name' => 'Swedish Krona',
        'symbol_native' => 'kr',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SEK',
        'name_plural' => 'Swedish Kronor',
        'bank_name' => 'Sveriges Riksbank',
        'desc_1' => 'The Swedish Krona came into circulation in 1876 and was originally part of a monetary alliance between other Scandinavian countries like Norway and Denmark that shared currency standards until WWI.',
        'desc_2' => 'The Swedish Krona was originally made up of 100 sub-units, known as “Ore.” But Ore was discontinued when it started to cost more money to manufacture the coins than what they were legally worth.',
        'country' => 'Sweden',
    ],
    'SGD' => [
        'symbol' => 'S$',
        'name' => 'Singapore Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SGD',
        'name_plural' => 'Singapore Dollars',
        'bank_name' => 'Monetary Authority of Singapore',
        'desc_1' => 'The Singapore Dollar is not much older the nation of Singapore itself. The country was formed in 1965, and the Singapore dollar entered circulation just two years later in 1967.',
        'desc_2' => 'The Singapore Dollar is one of the few currencies on the planet that has the lyrics to its own national anthem on the currency itself. But only on the S$1000 bills.',
        'country' => 'Singapore',
    ],
    'SHP' => [
        'symbol' => '£',
        'name' => 'Livre',
        'symbol_native' => '£',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SHP',
        'name_plural' => 'Livres',
        'bank_name' => 'Government of Saint Helena',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Saint Helena and Ascension',
    ],
    'SLL' => [
        'symbol' => 'Le',
        'name' => 'Leone',
        'symbol_native' => 'Le',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SLL',
        'name_plural' => 'Leones',
        'bank_name' => 'Bank of Sierra Leone',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Sierra Leone',
    ],
    'SOS' => [
        'symbol' => 'Ssh',
        'name' => 'Somali Shilling',
        'symbol_native' => 'Ssh',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'SOS',
        'name_plural' => 'Somali Shillings',
        'bank_name' => 'Central Bank of Somalia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Somalia',
    ],
    'SRD' => [
        'symbol' => '$',
        'name' => 'Surinamese Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SRD',
        'name_plural' => 'Surinamese Dollars',
        'bank_name' => 'Central Bank of Suriname',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Suriname',
    ],
    'SVC' => [
        'symbol' => '₡',
        'name' => 'Col',
        'symbol_native' => '₡',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SVC',
        'name_plural' => 'Cols',
        'bank_name' => 'Central Reserve Bank of El Salvador',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'El Salvador',
    ],
    'SYP' => [
        'symbol' => 'SY£',
        'name' => 'Syrian Pound',
        'symbol_native' => 'ل.س.‏',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'SYP',
        'name_plural' => 'Syrian Pounds',
        'bank_name' => 'Central Bank of Syria',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Syria',
    ],
    'SZL' => [
        'symbol' => 'L',
        'name' => 'Lilangeni',
        'symbol_native' => 'L',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'SZL',
        'name_plural' => 'Lilangenis',
        'bank_name' => 'Central Bank of Swaziland',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Swaziland',
    ],
    'THB' => [
        'symbol' => '฿',
        'name' => 'Thai Baht',
        'symbol_native' => '฿',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'THB',
        'name_plural' => 'Thai Baht',
        'bank_name' => 'Bank of Thailand',
        'desc_1' => 'The Thai Baht has been in use in Thailand since roughly the 14th century and is a strong currency for the region, widely accepted in Myanmar, Laos, and Cambodia.',
        'desc_2' => 'The Thai people love the king of their country so much, that it is considered impolite to store banknotes in the back pockets, as that would mean sitting on an image of the king.',
        'country' => 'Thailand',
    ],
    'TJS' => [
        'symbol' => 'ЅM',
        'name' => 'Somoni',
        'symbol_native' => 'ЅM',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TJS',
        'name_plural' => 'Somonis',
        'bank_name' => 'National Bank of Tajikistan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Tajikistan',
    ],
    'TMT' => [
        'symbol' => 'm',
        'name' => 'Manat',
        'symbol_native' => 'm',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TMT',
        'name_plural' => 'Manats',
        'bank_name' => 'Central Bank of Turkmenistan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Turkmenistan',
    ],
    'TND' => [
        'symbol' => 'DT',
        'name' => 'Tunisian Dinar',
        'symbol_native' => 'د.ت.‏',
        'decimal_digits' => 3,
        'rounding' => 0,
        'code' => 'TND',
        'name_plural' => 'Tunisian Dinars',
        'bank_name' => 'Central Bank of Tunisia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Tunisia',
    ],
    'TOP' => [
        'symbol' => 'T$',
        'name' => 'Tongan Paʻanga',
        'symbol_native' => 'T$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TOP',
        'name_plural' => 'Tongan Paʻanga',
        'bank_name' => 'National Reserve Bank of Tonga',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Tonga',
    ],
    'TRY' => [
        'symbol' => 'TL',
        'name' => 'Turkish Lira',
        'symbol_native' => 'TL',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TRY',
        'name_plural' => 'Turkish Lira',
        'bank_name' => 'Central Bank of the Republic of Turkey',
        'desc_1' => 'The current Turkish Lira is one of the younger forms of currency, having been reintroduced to both Turkey and the global currency market in 2005, after redefining its value and “losing” six zeroes.',
        'desc_2' => 'The Turkish Lira has gone through three iterations. The Ottoman Lira was first introduced in 1844 and was replaced by the first Turkish Lira in 1923. By 2001, USD$1=1.65 million Lira.',
        'country' => 'Turkey',
    ],
    'TTD' => [
        'symbol' => 'TT$',
        'name' => 'Trinidad and Tobago Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TTD',
        'name_plural' => 'Trinidad and Tobago Dollars',
        'bank_name' => 'Central Bank of Trinidad and Tobago',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Trinidad and Tobago',
    ],
    'TWD' => [
        'symbol' => 'NT$',
        'name' => 'New Taiwan Dollar',
        'symbol_native' => 'NT$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'TWD',
        'name_plural' => 'New Taiwan Dollars',
        'bank_name' => 'Central Bank of the Republic of China',
        'desc_1' => 'The New Taiwan Dollar entered into usage in Taiwan back in 1949 and was a way to deal with the hyperinflation of the “Old” Taiwan dollar that had only been in use for three years.',
        'desc_2' => 'The New Taiwan Dollar is most commonly referred to as “kuai” among locals, despite the fact that the formal name is “yuan,” because kuai is easier to pronounce repeatedly than yuan.',
        'country' => 'Taiwan',
    ],
    'TZS' => [
        'symbol' => 'TSh',
        'name' => 'Tanzanian Shilling',
        'symbol_native' => 'TSh',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'TZS',
        'name_plural' => 'Tanzanian Shillings',
        'bank_name' => 'Bank of Tanzania',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Tanzania',
    ],
    'UAH' => [
        'symbol' => '₴',
        'name' => 'Ukrainian Hryvnia',
        'symbol_native' => '₴',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'UAH',
        'name_plural' => 'Ukrainian Hryvnias',
        'bank_name' => 'National Bank of Ukraine',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Ukraine',
    ],
    'UGX' => [
        'symbol' => 'USh',
        'name' => 'Ugandan Shilling',
        'symbol_native' => 'USh',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'UGX',
        'name_plural' => 'Ugandan Shillings',
        'bank_name' => 'Bank of Uganda',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Uganda',
    ],
    'UYU' => [
        'symbol' => '$U',
        'name' => 'Uruguayan Peso',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'UYU',
        'name_plural' => 'Uruguayan Pesos',
        'bank_name' => 'Central Bank of Uruguay',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Uruguay',
    ],
    'UZS' => [
        'symbol' => 'UZS',
        'name' => 'Uzbekistan Som',
        'symbol_native' => 'UZS',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'UZS',
        'name_plural' => 'Uzbekistan Som',
        'bank_name' => 'Central Bank of the Republic of Uzbekistan',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Uzbekistan',
    ],
    'VEF' => [
        'symbol' => 'Bs.F.',
        'name' => 'Venezuelan Bolívar',
        'symbol_native' => 'Bs.F.',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'VEF',
        'name_plural' => 'Venezuelan Bolívars',
        'bank_name' => 'Banco Central de Venezuela',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Venezuela',
    ],
    'VND' => [
        'symbol' => '₫',
        'name' => 'Vietnamese Dong',
        'symbol_native' => '₫',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'VND',
        'name_plural' => 'Vietnamese Dong',
        'bank_name' => 'State Bank of Vietnam',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Vietnam',
    ],
    'VUV' => [
        'symbol' => 'VT',
        'name' => 'Vatu',
        'symbol_native' => 'VT',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'VUV',
        'name_plural' => 'Vatus',
        'bank_name' => 'Reserve Bank of Vanuatu',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Vanuatu',
    ],
    'WST' => [
        'symbol' => 'WS$',
        'name' => 'Tala',
        'symbol_native' => 'WS$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'WST',
        'name_plural' => 'Talas',
        'bank_name' => 'Central Bank of Samoa',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Samoa',
    ],
    'XAF' => [
        'symbol' => 'FCFA',
        'name' => 'CFA Franc BEAC',
        'symbol_native' => 'FCFA',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'XAF',
        'name_plural' => 'CFA Francs BEAC',
        'bank_name' => 'Bank of Central African States',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Chad',
    ],
    'XCD' => [
        'symbol' => '$',
        'name' => 'Caribbean Dollar',
        'symbol_native' => '$',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'XCD',
        'name_plural' => 'Caribbean Dollars',
        'bank_name' => 'Eastern Caribbean Central Bank',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Antigua and Barbuda, Anguilla, Dominica, Grenada, Montserrat, Saint Kitts and Nevis, Saint Lucia, Saint Vincent, and the Grenadines',
    ],
    'XOF' => [
        'symbol' => 'CFA',
        'name' => 'CFA Franc BCEAO',
        'symbol_native' => 'CFA',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'XOF',
        'name_plural' => 'CFA Francs BCEAO',
        'bank_name' => 'Central Bank of West African States',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Togo',
    ],
    'YER' => [
        'symbol' => 'YR',
        'name' => 'Yemeni Rial',
        'symbol_native' => 'ر.ي.‏',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'YER',
        'name_plural' => 'Yemeni Rials',
        'bank_name' => 'Central Bank of Yemen',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Yemen',
    ],
    'ZAR' => [
        'symbol' => 'R',
        'name' => 'South African Rand',
        'symbol_native' => 'R',
        'decimal_digits' => 2,
        'rounding' => 0,
        'code' => 'ZAR',
        'name_plural' => 'South African Rand',
        'bank_name' => 'South African Reserve Bank',
        'desc_1' => 'The South African Rand was first circulated in 1961, just months before the Republic of South Africa itself was established, and continues to have its value affected by political events such as Brexit.',
        'desc_2' => 'The South African Rand gets its unusual name from “Witwatersrand,” which is the ridge that the capital city of Johannesburg is built on, and where the country’s source of wealth, gold, is found.',
        'country' => 'South Africa',
    ],
    'ZMW' => [
        'symbol' => 'ZK',
        'name' => 'Zambian Kwacha',
        'symbol_native' => 'ZK',
        'decimal_digits' => 0,
        'rounding' => 0,
        'code' => 'ZMW',
        'name_plural' => 'Zambian Kwachas',
        'bank_name' => 'Bank of Zambia',
        'desc_1' => '',
        'desc_2' => '',
        'country' => 'Zambia',
    ],
];
?>