<?php
// don't load directly
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'BCC_Admin_Notices' ) ) {

    class BCC_Admin_Notices {

        private static $_instance;
        private $admin_notices;
        const TYPES = 'error,warning,info,success';

        private function __construct() {
            $this->admin_notices = new stdClass();
            foreach ( explode( ',', self::TYPES ) as $type ) {
                $this->admin_notices->{$type} = array();
            }
            add_action( 'admin_init', array( &$this, 'action_admin_init' ) );
            add_action( 'admin_notices', array( &$this, 'action_admin_notices' ) );
            add_action( 'admin_enqueue_scripts', array( &$this, 'action_admin_enqueue_scripts' ) );
        }

        public static function get_instance() {
            if ( ! ( self::$_instance instanceof self ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        public function action_admin_init() {
            $dismiss_option = filter_input( INPUT_GET, 'bcc_dismiss', FILTER_SANITIZE_STRING );
            if ( is_string( $dismiss_option ) ) {
                update_option( "bcc_dismissed_$dismiss_option", true );
                wp_die();
            }
        }

        public function action_admin_enqueue_scripts() {
            wp_enqueue_script( 'jquery' );
            wp_enqueue_script(
                'bcc-notify',
                plugins_url( 'js/bcc-notify.js', __FILE__ ),
                array( 'jquery' )
            );
        }

        public function action_admin_notices() {
            foreach ( explode( ',', self::TYPES ) as $type ) {
                foreach ( $this->admin_notices->{$type} as $admin_notice ) {

                    $dismiss_url = add_query_arg( array(
                        'bcc_dismiss' => $admin_notice->dismiss_option
                    ), admin_url() );
                    $screen = get_current_screen();
                    if ( ! get_option( "bcc_dismissed_{$admin_notice->dismiss_option}" ) || strpos($screen->id, 'currency-bcc') !== false) {
                        ?><div class="notice is-dismissible bcc-notice notice-"<?php echo $type;
                            if ( $admin_notice->dismiss_option ) {
                                echo ' is-dismissible" data-dismiss-url="' . esc_url( $dismiss_url );
                            } ?>">
                            <div class="bcc-rate-notice-container">
                                <div class="logo-img">
                                    <img src="<?php echo plugins_url( 'img/rating_logo.png', __FILE__ );?>" style="width:70px;">
                                </div>
                                <div>
                                    <h2>Please rate our free currency plugin :)</h2>
                                    <p>Your valuable feedback will help us improve. It will only take a few minutes.</p>
                                    <p><a href="https://wordpress.org/support/plugin/currency-converter-widget/reviews/#new-post" target="_blank">Sure, I'll rate you now!</a></p>
                                </div>
                            </div>
                        </div>
                        <style>
                            .bcc-rate-notice-container {
                                display: flex;
                                padding: 10px 0;
                            }
                            .bcc-rate-notice-container .logo-img {
                                margin-right: 15px;
                            }
                            .bcc-rate-notice-container h2 {
                                margin: 0;
                            }
                            .bcc-rate-notice-container p {
                                padding: 0;
                                margin: 0;
                            }
                        </style><?php
                    }
                }
            }
        }

        public function error( $message, $dismiss_option = false ) {
            $this->notice( 'error', $message, $dismiss_option );
        }

        public function warning( $message, $dismiss_option = false ) {
            $this->notice( 'warning', $message, $dismiss_option );
        }

        public function success( $message, $dismiss_option = false ) {
            $this->notice( 'success', $message, $dismiss_option );
        }

        public function info( $message, $dismiss_option = false ) {
            $this->notice( 'info', $message, $dismiss_option );
        }

        private function notice( $type, $message, $dismiss_option ) {
            $notice = new stdClass();
            $notice->message = $message;
            $notice->dismiss_option = $dismiss_option;

            $this->admin_notices->{$type}[] = $notice;
        }

        public static function error_handler( $errno, $errstr, $errfile, $errline, $errcontext ) {
            if ( ! ( error_reporting() & $errno ) ) {
                // This error code is not included in error_reporting
                return;
            }

            $message = "errstr: $errstr, errfile: $errfile, errline: $errline, PHP: " . PHP_VERSION . " OS: " . PHP_OS;

            $self = self::get_instance();

            switch ($errno) {
                case E_USER_ERROR:
                    $self->error( $message );
                    break;

                case E_USER_WARNING:
                    $self->warning( $message );
                    break;

                case E_USER_NOTICE:
                default:
                    $self->notice( $message );
                    break;
            }

            // write to wp-content/debug.log if logging enabled
            error_log( $message );

            // Don't execute PHP internal error handler
            return true;
        }
    }
}
