<?php
/*
Plugin Name: Cookies for Comments
Plugin URI: http://ocaoimh.ie/cookies-for-comments/
Description: Sets a cookie that must exist for a comment to be allowed through
Version: 0.5.5
Author: Donncha O Caoimh
Author URI: http://ocaoimh.ie/

CHANGES
2009-02-18 - Store cfc key in sitemeta on WordPress MU sites
2008-08-23 - Add a random key to the css file url.
2008-08-21 - Set the cookie for a week
2008-07-15 - User can delete spam comments now, http://wordpress.org/support/topic/187810?replies=2
             Check that Akismet functions exist.
2008-07-07 - Make it work in sub directories too.
             Mark spam comments with a "Blocked by CFC" message.
2008-03-06 - First release
*/

function cfc_stylesheet_html() {
	$cfc_key = get_cfc_key();

	if ( $cfc_key == '' )
		return false;

	?><link rel="stylesheet" href="<?php echo plugins_url( "css.php?k={$cfc_key}&amp;t=" . mt_rand(), __FILE__ ); ?>" type="text/css" media="screen" /><?php
}

function cfc_img_html() {
	$cfc_key = get_cfc_key();

	if ( $cfc_key == '' )
		return false;

	?><img alt='css.php' src="<?php echo plugins_url( "css.php?k={$cfc_key}&amp;o=i&amp;t=" . mt_rand(), __FILE__ ); ?>" width='1' height='1' /><?php
}
if ( get_option( 'cfc_delivery' ) == 'css' ) {
	add_action( 'wp_head', 'cfc_stylesheet_html' );
} else {
	add_action( 'wp_footer', 'cfc_img_html' );
}

function get_cfc_key() {
	if( function_exists( 'get_site_option' ) ) {
		$cfc_key = get_site_option( 'cfc_key' );
	} else {
		$cfc_key = get_option( 'cfc_key' );
	}
	if( !$cfc_key ) {
		if( current_user_can('edit_plugins') ) {
			$cfc_key = md5( time() );
			if( function_exists( 'add_site_option' ) ) {
				$cfc_key = add_site_option( 'cfc_key', $cfc_key );
			} else {
				$cfc_key = add_option( 'cfc_key', $cfc_key );
			}
		} else {
			return;
		}
	}
	return $cfc_key;
}

function cfc_set_comment_style_cookie() {
	$cfc_key = get_cfc_key();
	if( !$cfc_key )
		return;

	if( strpos( $_SERVER[ 'REQUEST_URI' ], $cfc_key . '.css' ) ) {
                if ( !isset( $_COOKIE[ $cfc_key ] ) || ( isset( $_COOKIE[ $cfc_key ] ) && $_COOKIE[ $cfc_key ] == 1 ) )
                        @setcookie( $cfc_key, time(), time()+604800, '/' );
                header("Content-type: text/css");
		echo "/* Page generated by Cookies for Comments at http://ocaoimh.ie/cookies-for-comments/ */";
		define( 'DONOTCACHEPAGE', 1 ); // don't let wp-super-cache cache this page.
		die();
	}
	if( function_exists( 'akismet_auto_check_comment' ) ) {
		remove_filter( 'preprocess_comment', 'akismet_auto_check_comment', 1 );
		add_filter( 'preprocess_comment', 'akismet_auto_check_comment', 10 );
	}
}
add_action( 'init', 'cfc_set_comment_style_cookie' );

function cfc_check_comment_style_cookie( $comment ) {
	$cfc_key = get_cfc_key();
	if( !$cfc_key )
		return $comment;

	if ( is_user_logged_in() )
		return $comment;
	if ( $comment[ 'comment_type' ] != 'trackback' && $comment[ 'comment_type' ] != 'pingback' ) {
		if ( isset( $_COOKIE[ $cfc_key ] ) ) {
			$spam = 0;
			$cfc_speed = (int)get_site_option( 'cfc_speed' );
			if ( $cfc_speed > 0 && $_COOKIE[ $cfc_key ] > 1 && ( time() - $_COOKIE[ $cfc_key ] ) < $cfc_speed && !isset( $_COOKIE[ 'comment_author_' . COOKIEHASH ] ) ) {
				$spam = 1;
			}
		} else {
			$spam = 1;
		}

		if ( $spam == 1 ) {
			if( get_option( 'cfc_spam' ) == 'delete' ) {
				$msg = get_option( 'cfc_spam_message' );
				if ( !$msg ) {
					$msg = '<p>Sorry, your comment has not been accepted.<p>';
				}
				$msg .= "<p>Your comment: <form><input type='text' value='" . esc_attr( $comment[ 'comment_author' ] ) . "' /><br /><input type='text' value='" . esc_attr( $comment[ 'comment_author_email' ] ) . "' /><br /><input type='text' value='" . esc_attr( $comment[ 'comment_author_url' ] ) . "' /><br /><textarea rows=10 cols=40>" . esc_textarea( stripslashes( $comment[ 'comment_content' ] ) ) . "</textarea></form></p>";
				wp_die( $msg );
			} else {
				add_filter('pre_comment_approved', create_function('$a', 'return \'spam\';')); // thanks Akismet
			}
			if( function_exists( 'akismet_auto_check_comment' ) )
				remove_filter( 'preprocess_comment', 'akismet_auto_check_comment', 10 ); // remove Akismet, comment is spam!
		}
	}
	return $comment;
}
add_filter('preprocess_comment', 'cfc_check_comment_style_cookie', 1);

function cfc_config_page() {
	add_options_page('Cookies for Comments', 'Cookies for Comments', 'manage_options', 'cfc_config', 'cfc_conf');
}
add_action('admin_menu', 'cfc_config_page');

function cfc_conf() {
	if ( isset($_POST['submit']) ) {
		if ( function_exists('current_user_can') && !current_user_can('manage_options') )
			die(__('Cheatin&#8217; uh?'));

		check_admin_referer( 'cfc' );
		if( $_POST[ 'cfc_spam' ] == 'spam' || $_POST[ 'cfc_spam' ] == 'delete' ) {
			update_option( 'cfc_spam', $_POST[ 'cfc_spam' ] );
		}
		update_option( 'cfc_speed', (int)$_POST[ 'cfc_speed' ] );
		update_option( 'cfc_spam_message', stripslashes( $_POST[ 'cfc_spam_message' ] ) );
		if ( $_POST[ 'cfc_delivery' ] == 'css' || $_POST[ 'cfc_delivery' ] == 'img' )
			update_option( 'cfc_delivery', $_POST[ 'cfc_delivery' ] );
	}
	if( !get_option( 'cfc_spam' ) )
		update_option( 'cfc_spam', 'spam' );
	if ( !get_option( 'cfc_delivery' ) )
		add_option( 'cfc_delivery', 'img' );

	if ( !empty($_POST ) ) { 
		?> <div id="message" class="updated fade"><p><strong><?php _e('Options saved.') ?></strong></p></div> <?php 
	} 
	?>
<div class="wrap">
<h2><?php _e('Comments for Cookies Configuration'); ?></h2>
<div class="narrow">
<form action="" method="post" id="cfc-conf" style="margin: auto; width: 400px; ">
<?php wp_nonce_field('cfc') ?>
<label><h3>What should happen to comments caught by CFC?</h3> <select name='cfc_spam'><option value='delete' <?php echo ( get_option( 'cfc_spam' ) == 'delete' ? 'selected' : '' ); ?> /> Delete <option value='spam' <?php echo ( get_option( 'cfc_spam' ) == 'spam' ? 'selected' : '' ); ?> /> Spam</select></label><br />
<h3>Payload Delivery Mechanism</h3> 
<input type='radio' name='cfc_delivery' value='css' <?php checked( get_option( 'cfc_delivery' ), 'css' ) ?> /> CSS file.<br />
<input type='radio' name='cfc_delivery' value='img' <?php checked( get_option( 'cfc_delivery' ), 'img' ) ?> /> Image file. (recommended)<br />
<p>The CSS file loads at the top of the page, possibly slowing down how fast the page renders. The image loads at the end but if your server is very slow someone may have time to enter a comment before the image loads. Unlikely but it might happen.</p>
<h3>Speed Spammers</h3> 

<p>Some spammers visit your site, leave a real looking comment and disappear again. They'll do this quickly and then move on to the next target site.<br /> To stop them we check how long they spend on your site before leaving the comment. Any value above 0 will reject those comments but might catch legitimate comments too. Recommended values from 3 to 6 seconds and send comments to the spam folder.</p>
<input type='text' name='cfc_speed' size='3' value='<?php echo (int)get_option( 'cfc_speed' ) ?>' /> Seconds</label><br /> <br />

<h3>Rejection Message</h3>
<p>When a comment fails to be posted it's not always a spammer. Add a message here to be shown to those users. Be aware that real spammers will see this message too! The comment they made will be shown below your message.</p>
<textarea cols=40 rows=5 name='cfc_spam_message'><?php echo esc_textarea( get_option( 'cfc_spam_message' ) ); ?></textarea><br /><br />
<input type='submit' name='submit' value='Save Options' />
</form>
<?php
$cfc_key = get_cfc_key();
if( $cfc_key ) { ?>
<p>If you're feeling adventerous, you can add the following two lines <em>before</em> the regular WordPress mod_rewrite rules in your <tt>.htaccess</tt> file. They will stop comments from spambots before they reach the database or are executed in PHP:</p>
<pre>
RewriteCond %{HTTP_COOKIE} !^.*<?php echo $cfc_key; ?>.*$
RewriteRule ^wp-comments-post.php - [F,L]
</pre>
<?php 
}
global $wpmu_version;
if ( isset( $wpmu_version ) && $wpmu_version != '' ) {
	?><p>As you're using WordPress MU, copy these lines into your .htaccess file, making sure the paths match the location of the signup form.</p>
<pre>
RewriteCond %{HTTP_COOKIE} !^.*<?php echo $cfc_key; ?>.*$
RewriteRule ^wp-signup.php - [F,L]
</pre>
	<?php
}
?>
</div>
</div>
<?php
}

function cfc_plugin_actions( $links, $file ) {
	if( $file == 'cookies-for-comments/cookies-for-comments.php' && function_exists( "admin_url" ) ) {
		$settings_link = '<a href="' . admin_url( 'options-general.php?page=cfc_config' ) . '">' . __('Settings') . '</a>';
		array_unshift( $links, $settings_link ); // before other links
	}
	return $links;
}
add_filter( 'plugin_action_links', 'cfc_plugin_actions', 10, 2 );

function cfc_add_referrer_to_notification( $text, $comment_id ) {
	$cfc_key = get_cfc_key();
	if( !$cfc_key )
		return $text;
	if ( is_user_logged_in() )
		return $text;

	if ( $_COOKIE[ $cfc_key ] > 1 ) {
		$ttp = ( time() - $_COOKIE[ $cfc_key ] );
		$format = "seconds";
		if ( $ttp > 60 ) {
			$ttp = $ttp / 60;
			$format = "minutes";
		}
		if ( $ttp > 60 ) {
			$ttp = $ttp / 60;
			$format = "hours";
		}


		$text .= "\r\nTime to post comment: " . number_format( $ttp, 2 ) . " $format\r\n";
	}
	return $text;
}
add_filter( 'comment_notification_text', 'cfc_add_referrer_to_notification', 10, 2 );
add_filter( 'comment_moderation_text', 'cfc_add_referrer_to_notification', 10, 2 );
?>
