<?php
/**
 * Outputs the Settings screen, with markup that enables styling
 * to be applied to improve the UI.
 *
 * @package CKWC
 * @author ConvertKit
 */

?>

<div class="postbox">
	<h2><?php echo esc_html( $this->get_method_title() ); ?></h2>
	<?php echo wp_kses_post( wpautop( $this->get_method_description() ) ); ?>

	<div><input type="hidden" name="section" value="<?php echo esc_attr( $this->id ); ?>" /></div>

	<table class="form-table ckwc">
		<?php echo $this->generate_settings_html( $this->get_form_fields(), false ); // phpcs:ignore WordPress.Security.EscapeOutput ?>
	</table>

	<p class="submit">
		<button name="save" class="button-primary woocommerce-save-button" type="submit" value="<?php esc_attr_e( 'Save changes', 'woocommerce-convertkit' ); ?>">
			<?php esc_html_e( 'Save changes', 'woocommerce-convertkit' ); ?>
		</button>
	</p>
</div>

<div class="postbox">
	<h2><?php esc_html_e( 'Export', 'woocommerce-convertkit' ); ?></h2>

	<p>
		<?php esc_html_e( 'Downloads this plugin\'s configuration as a JSON file. This file includes sensitive API credentials. Use with caution.', 'woocommerce-convertkit' ); ?>
	</p>

	<p class="submit">
		<a href="<?php echo esc_attr( $export_url ); ?>" class="button button-primary" id="export">
			<?php esc_html_e( 'Export', 'woocommerce-convertkit' ); ?>
		</a>
	</p>
</div>

<div class="postbox">
	<h2><?php esc_html_e( 'Import', 'woocommerce-convertkit' ); ?></h2>

	<p>
		<?php esc_html_e( 'Imports a configuration file generated by this plugin. This will overwrite any existing settings stored on this installation.', 'woocommerce-convertkit' ); ?>
	</p>

	<div>
		<input type="file" name="woocommerce_ckwc_import" id="woocommerce_ckwc_import" />
	</div>

	<p class="submit">
		<button class="button button-primary" value="<?php esc_attr_e( 'Import', 'woocommerce-convertkit' ); ?>">
			<?php esc_html_e( 'Import', 'woocommerce-convertkit' ); ?>
		</button>
	</p>
</div>
