<?php
/**
 * Shortcode module
 *
 * @package Contextual_Related_Posts
 */

namespace WebberZone\Contextual_Related_Posts\Frontend;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Shortcodes class
 *
 * @since 3.5.0
 */
class Shortcodes {

	/**
	 * Constructor class.
	 *
	 * @since 3.3.0
	 */
	public function __construct() {
		add_shortcode( 'crp', array( $this, 'related_posts' ) );
	}

	/**
	 * Creates a shortcode [crp limit="5" heading="1" cache="1"].
	 *
	 * @param   array  $atts       Shortcode attributes.
	 * @param   string $content    Content.
	 * @return  string  Formatted list of posts generated by get_crp()
	 */
	public static function related_posts( $atts, $content = null ) { // phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.FoundAfterLastUsed
		$crp_settings = crp_get_settings();

		$defaults = array(
			'heading'           => 1,
			'is_shortcode'      => 1,
			'offset'            => 0,
			'include_cat_ids'   => '',
			'include_post_ids'  => null,
			'related_meta_keys' => '',
			'include_words'     => '',
			'manual_related'    => null,
		);

		/**
		 * Filters the shortcode defaults.
		 *
		 * @since 3.5.0
		 *
		 * @param array $defaults Default shortcode settings.
		 * @param array $atts     Shortcode attributes.
		 */
		$defaults = apply_filters( 'crp_shortcode_defaults', $defaults, $atts );

		$atts = shortcode_atts(
			array_merge( $crp_settings, $defaults ),
			$atts,
			'crp'
		);

		return get_crp( $atts );
	}
}
