<?php
#[\AllowDynamicProperties]
class installerCfs {
	static public $update_to_version_method = '';
	static private $_firstTimeActivated = false;
	static public function init( $isUpdate = false ) {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		$current_version = get_option($wpPrefix. CFS_DB_PREF. 'db_version', 0);
		if(!$current_version)
			self::$_firstTimeActivated = true;
		/**
		 * modules
		 */
		if (!dbCfs::exist("cfs_modules")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `code` varchar(32) NOT NULL,
			  `active` tinyint(1) NOT NULL DEFAULT '0',
			  `type_id` tinyint(1) NOT NULL DEFAULT '0',
			  `label` varchar(64) DEFAULT NULL,
			  `ex_plug_dir` varchar(255) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE INDEX `code` (`code`)
			) DEFAULT CHARSET=utf8;"));
		// 	dbCfs::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES
		// 		(NULL, 'adminmenu',1,1,'Admin Menu'),
		// 		(NULL, 'options',1,1,'Options'),
		// 		(NULL, 'user',1,1,'Users'),
		// 		(NULL, 'pages',1,1,'Pages'),
		// 		(NULL, 'templates',1,1,'templates'),
		// 		(NULL, 'supsystic_promo',1,1,'supsystic_promo'),
		// 		(NULL, 'admin_nav',1,1,'admin_nav'),
		//
		// 		(NULL, 'forms',1,1,'forms'),
		// 		(NULL, 'forms_widget',1,1,'forms_widget'),
		//
		// 		(NULL, 'statistics',1,1,'statistics'),
		// 		(NULL, 'membership',1,1,'membership'),
		// 		(NULL, 'mail',1,1,'mail');");


		$tableName = $wpdb->prefix . "cfs_modules";
		$wpdb->insert($tableName, array(
			'code' => 'adminmenu',
			'active' => 1,
			'type_id' => 1,
			'label' => 'Admin Menu',
		));
		$wpdb->insert($tableName, array(
			'code' => 'options',
			'active' => 1,
			'type_id' => 1,
			'label' => 'Options',
		));
		$wpdb->insert($tableName, array(
			'code' => 'user',
			'active' => 1,
			'type_id' => 1,
			'label' => 'Users',
		));
		$wpdb->insert($tableName, array(
			'code' => 'pages',
			'active' => 1,
			'type_id' => 1,
			'label' => 'Pages',
		));
		$wpdb->insert($tableName, array(
			'code' => 'templates',
			'active' => 1,
			'type_id' => 1,
			'label' => 'Templates',
		));
		$wpdb->insert($tableName, array(
			'code' => 'supsystic_promo',
			'active' => 1,
			'type_id' => 1,
			'label' => 'supsystic_promo',
		));
		$wpdb->insert($tableName, array(
			'code' => 'admin_nav',
			'active' => 1,
			'type_id' => 1,
			'label' => 'admin_nav',
		));
		$wpdb->insert($tableName, array(
			'code' => 'forms',
			'active' => 1,
			'type_id' => 1,
			'label' => 'forms',
		));
		$wpdb->insert($tableName, array(
			'code' => 'forms_widget',
			'active' => 1,
			'type_id' => 1,
			'label' => 'forms_widget',
		));
		$wpdb->insert($tableName, array(
			'code' => 'statistics',
			'active' => 1,
			'type_id' => 1,
			'label' => 'statistics',
		));
		$wpdb->insert($tableName, array(
			'code' => 'membership',
			'active' => 1,
			'type_id' => 1,
			'label' => 'membership',
		));
		$wpdb->insert($tableName, array(
			'code' => 'mail',
			'active' => 1,
			'type_id' => 1,
			'label' => 'mail',
		));

		}

		// if(count(dbCfs::get("SELECT id FROM `@__modules` WHERE code='membership'")) == 0) {
		// 	dbCfs::query("INSERT INTO `@__modules` (id, code, active, type_id, label) VALUES(NULL, 'membership',1,1,'membership')");
		// }
		/**
		 *  modules_type
		 */
		if(!dbCfs::exist("cfs_modules_type")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__modules_type` (
			  `id` smallint(3) NOT NULL AUTO_INCREMENT,
			  `label` varchar(32) NOT NULL,
			  PRIMARY KEY (`id`)
			) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;"));
			$tableName = $wpdb->prefix . "cfs_modules_type";
			$wpdb->insert($tableName, array(
					'id' => 1,
					'label' => 'system',
			));
			$wpdb->insert($tableName, array(
					'id' => 6,
					'label' => 'addons',
			));
		}
		/**
		 * Form table
		 */
		if (!dbCfs::exist("cfs_forms")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__forms` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`label` VARCHAR(255) NOT NULL,
				`active` TINYINT(1) NOT NULL DEFAULT '1',
				`original_id` INT(11) NOT NULL DEFAULT '0',
				`unique_id` VARCHAR(8) NOT NULL,

				`params` MEDIUMTEXT NOT NULL,
				`html` TEXT NOT NULL,
				`css` TEXT NOT NULL,
				`img_preview` VARCHAR(128) NULL DEFAULT NULL,

				`views` INT(11) NOT NULL DEFAULT '0',
				`unique_views` INT(11) NOT NULL DEFAULT '0',
				`actions` INT(11) NOT NULL DEFAULT '0',

				`sort_order` MEDIUMINT(5) NOT NULL DEFAULT '0',
				`is_pro`  TINYINT(1) NOT NULL DEFAULT '0',
				`ab_id`  INT(11) NOT NULL DEFAULT '0',

				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		self::initBaseForms();
		/**
		 * Contacts table
		 */
		if (!dbCfs::exist("cfs_contacts")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE IF NOT EXISTS `@__contacts` (
				`id` INT(11) NOT NULL AUTO_INCREMENT,
				`form_id` INT(11) NOT NULL,
				`fields` TEXT NOT NULL,
				`ip` varchar(16) DEFAULT NULL,
				`url` varchar(255) DEFAULT NULL,

				`date_created` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8;"));
		}
		/**
		* Plugin usage statistics
		*/
		if(!dbCfs::exist("cfs_usage_stat")) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__usage_stat` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `code` varchar(64) NOT NULL,
			  `visits` int(11) NOT NULL DEFAULT '0',
			  `spent_time` int(11) NOT NULL DEFAULT '0',
			  `modify_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			  UNIQUE INDEX `code` (`code`),
			  PRIMARY KEY (`id`)
			) DEFAULT CHARSET=utf8"));
			$tableName = $wpdb->prefix . "cfs_usage_stat";
			$wpdb->insert($tableName, array(
					'code' => 'installed',
					'visits' => 1,
			));
		}
		/**
		 * Statistics
		 */
		if (!dbCfs::exist("cfs_statistics")) {
			  dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__statistics` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`form_id` int(11) NOT NULL DEFAULT '0',
				`type` TINYINT(2) NOT NULL DEFAULT '0',
				`is_unique` TINYINT(1) NOT NULL DEFAULT '0',
				`date_created` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
		}
		/**
		 * Countries
		 */
		if (!dbCfs::exist("cfs_countries")) {
			  dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__countries` (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`name` varchar(128) NOT NULL,
				`iso_code_2` varchar(2) DEFAULT NULL,
				`iso_code_3` varchar(3) DEFAULT NULL,
				PRIMARY KEY (`id`)
			  ) DEFAULT CHARSET=utf8;"));
			  self::_insertCountries();
		}
		/**
		 * Membership
		 */
		if(!dbCfs::exist('cfs_membership_presets')) {
			dbDelta(dbCfs::prepareQuery("CREATE TABLE `@__membership_presets` (
				`form_id` int(11) NOT NULL,
			 	`allow_use` TINYINT(1) NOT NULL DEFAULT 0,
				PRIMARY KEY (`form_id`)
			) DEFAULT CHARSET=utf8"));
		}
		installerDbUpdaterCfs::runUpdate();
		if($current_version && !self::$_firstTimeActivated) {
			self::setUsed();
			// For users that just updated our plugin - don't need tp show step-by-step tutorial
			update_user_meta(get_current_user_id(), CFS_CODE . '-tour-hst', array('closed' => 1));
		}
		update_option($wpPrefix. CFS_DB_PREF. 'db_version', CFS_VERSION);
		add_option($wpPrefix. CFS_DB_PREF. 'db_installed', 1);
	}
	static public function setUsed() {
		update_option(CFS_DB_PREF. 'plug_was_used', 1);
	}
	static public function isUsed() {
		return true;	// No welcome page for now
		//return 0;
		return (int) get_option(CFS_DB_PREF. 'plug_was_used');
	}
	static public function delete() {
		self::_checkSendStat('delete');
		global $wpdb;
		$wpPrefix = $wpdb->prefix;
		$prepareQuery = $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}cfs_modules");
		$prepareQuery = $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}cfs_modules_type");
		$prepareQuery = $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}cfs_usage_stat");
		//$wpdb->query("DROP TABLE IF EXISTS `".$wpPrefix.CFS_DB_PREF."forms`");
		delete_option($wpPrefix. CFS_DB_PREF. 'db_version');
		delete_option($wpPrefix. CFS_DB_PREF. 'db_installed');
	}
	static public function deactivate() {
		self::_checkSendStat('deactivate');
	}
	static private function _checkSendStat($statCode) {
		if(class_exists('frameCfs')
			&& frameCfs::_()->getModule('supsystic_promo')
			&& frameCfs::_()->getModule('options')
		) {
			frameCfs::_()->getModule('supsystic_promo')->getModel()->saveUsageStat( $statCode );
			frameCfs::_()->getModule('supsystic_promo')->getModel()->checkAndSend( true );
		}
	}
	static public function update() {
		global $wpdb;
		$wpPrefix = $wpdb->prefix; /* add to 0.0.3 Versiom */
		$currentVersion = get_option($wpPrefix. CFS_DB_PREF. 'db_version', 0);
		if(!$currentVersion || version_compare(CFS_VERSION, $currentVersion, '>')) {
			self::init( true );
			update_option($wpPrefix. CFS_DB_PREF. 'db_version', CFS_VERSION);
		}
	}
	static private function _insertCountries() {
		$countriesArr = array(
		array(1, "Afghanistan", "AF", "AFG"),
		array(2, "Albania", "AL", "ALB"),
		array(3, "Algeria", "DZ", "DZA"),
		array(4, "American Samoa", "AS", "ASM"),
		array(5, "Andorra", "AD", "AND"),
		array(6, "Angola", "AO", "AGO"),
		array(7, "Anguilla", "AI", "AIA"),
		array(8, "Antarctica", "AQ", "ATA"),
		array(9, "Antigua and Barbuda", "AG", "ATG"),
		array(10, "Argentina", "AR", "ARG"),
		array(11, "Armenia", "AM", "ARM"),
		array(12, "Aruba", "AW", "ABW"),
		array(13, "Australia", "AU", "AUS"),
		array(14, "Austria", "AT", "AUT"),
		array(15, "Azerbaijan", "AZ", "AZE"),
		array(16, "Bahamas", "BS", "BHS"),
		array(17, "Bahrain", "BH", "BHR"),
		array(18, "Bangladesh", "BD", "BGD"),
		array(19, "Barbados", "BB", "BRB"),
		array(20, "Belarus", "BY", "BLR"),
		array(21, "Belgium", "BE", "BEL"),
		array(22, "Belize", "BZ", "BLZ"),
		array(23, "Benin", "BJ", "BEN"),
		array(24, "Bermuda", "BM", "BMU"),
		array(25, "Bhutan", "BT", "BTN"),
		array(26, "Bolivia", "BO", "BOL"),
		array(27, "Bosnia and Herzegowina", "BA", "BIH"),
		array(28, "Botswana", "BW", "BWA"),
		array(29, "Bouvet Island", "BV", "BVT"),
		array(30, "Brazil", "BR", "BRA"),
		array(31, "British Indian Ocean Territory", "IO", "IOT"),
		array(32, "Brunei Darussalam", "BN", "BRN"),
		array(33, "Bulgaria", "BG", "BGR"),
		array(34, "Burkina Faso", "BF", "BFA"),
		array(35, "Burundi", "BI", "BDI"),
		array(36, "Cambodia", "KH", "KHM"),
		array(37, "Cameroon", "CM", "CMR"),
		array(38, "Canada", "CA", "CAN"),
		array(39, "Cape Verde", "CV", "CPV"),
		array(40, "Cayman Islands", "KY", "CYM"),
		array(41, "Central African Republic", "CF", "CAF"),
		array(42, "Chad", "TD", "TCD"),
		array(43, "Chile", "CL", "CHL"),
		array(44, "China", "CN", "CHN"),
		array(45, "Christmas Island", "CX", "CXR"),
		array(46, "Cocos array(Keeling) Islands", "CC", "CCK"),
		array(47, "Colombia", "CO", "COL"),
		array(48, "Comoros", "KM", "COM"),
		array(49, "Congo", "CG", "COG"),
		array(50, "Cook Islands", "CK", "COK"),
		array(51, "Costa Rica", "CR", "CRI"),
		array(52, "Cote D\'Ivoire", "CI", "CIV"),
		array(53, "Croatia", "HR", "HRV"),
		array(54, "Cuba", "CU", "CUB"),
		array(55, "Cyprus", "CY", "CYP"),
		array(56, "Czech Republic", "CZ", "CZE"),
		array(57, "Denmark", "DK", "DNK"),
		array(58, "Djibouti", "DJ", "DJI"),
		array(59, "Dominica", "DM", "DMA"),
		array(60, "Dominican Republic", "DO", "DOM"),
		array(61, "East Timor", "TP", "TMP"),
		array(62, "Ecuador", "EC", "ECU"),
		array(63, "Egypt", "EG", "EGY"),
		array(64, "El Salvador", "SV", "SLV"),
		array(65, "Equatorial Guinea", "GQ", "GNQ"),
		array(66, "Eritrea", "ER", "ERI"),
		array(67, "Estonia", "EE", "EST"),
		array(68, "Ethiopia", "ET", "ETH"),
		array(69, "Falkland Islands array(Malvinas)", "FK", "FLK"),
		array(70, "Faroe Islands", "FO", "FRO"),
		array(71, "Fiji", "FJ", "FJI"),
		array(72, "Finland", "FI", "FIN"),
		array(73, "France", "FR", "FRA"),
		array(74, "France, Metropolitan", "FX", "FXX"),
		array(75, "French Guiana", "GF", "GUF"),
		array(76, "French Polynesia", "PF", "PYF"),
		array(77, "French Southern Territories", "TF", "ATF"),
		array(78, "Gabon", "GA", "GAB"),
		array(79, "Gambia", "GM", "GMB"),
		array(80, "Georgia", "GE", "GEO"),
		array(81, "Germany", "DE", "DEU"),
		array(82, "Ghana", "GH", "GHA"),
		array(83, "Gibraltar", "GI", "GIB"),
		array(84, "Greece", "GR", "GRC"),
		array(85, "Greenland", "GL", "GRL"),
		array(86, "Grenada", "GD", "GRD"),
		array(87, "Guadeloupe", "GP", "GLP"),
		array(88, "Guam", "GU", "GUM"),
		array(89, "Guatemala", "GT", "GTM"),
		array(90, "Guinea", "GN", "GIN"),
		array(91, "Guinea-bissau", "GW", "GNB"),
		array(92, "Guyana", "GY", "GUY"),
		array(93, "Haiti", "HT", "HTI"),
		array(94, "Heard and Mc Donald Islands", "HM", "HMD"),
		array(95, "Honduras", "HN", "HND"),
		array(96, "Hong Kong", "HK", "HKG"),
		array(97, "Hungary", "HU", "HUN"),
		array(98, "Iceland", "IS", "ISL"),
		array(99, "India", "IN", "IND"),
		array(100, "Indonesia", "ID", "IDN"),
		array(101, "Iran array(Islamic Republic of)", "IR", "IRN"),
		array(102, "Iraq", "IQ", "IRQ"),
		array(103, "Ireland", "IE", "IRL"),
		array(104, "Israel", "IL", "ISR"),
		array(105, "Italy", "IT", "ITA"),
		array(106, "Jamaica", "JM", "JAM"),
		array(107, "Japan", "JP", "JPN"),
		array(108, "Jordan", "JO", "JOR"),
		array(109, "Kazakhstan", "KZ", "KAZ"),
		array(110, "Kenya", "KE", "KEN"),
		array(111, "Kiribati", "KI", "KIR"),
		array(112, "Korea, Democratic People\'s Republic of", "KP", "PRK"),
		array(113, "Korea, Republic of", "KR", "KOR"),
		array(114, "Kuwait", "KW", "KWT"),
		array(115, "Kyrgyzstan", "KG", "KGZ"),
		array(116, "Lao People\'s Democratic Republic", "LA", "LAO"),
		array(117, "Latvia", "LV", "LVA"),
		array(118, "Lebanon", "LB", "LBN"),
		array(119, "Lesotho", "LS", "LSO"),
		array(120, "Liberia", "LR", "LBR"),
		array(121, "Libyan Arab Jamahiriya", "LY", "LBY"),
		array(122, "Liechtenstein", "LI", "LIE"),
		array(123, "Lithuania", "LT", "LTU"),
		array(124, "Luxembourg", "LU", "LUX"),
		array(125, "Macau", "MO", "MAC"),
		array(126, "Macedonia, The Former Yugoslav Republic of", "MK", "MKD"),
		array(127, "Madagascar", "MG", "MDG"),
		array(128, "Malawi", "MW", "MWI"),
		array(129, "Malaysia", "MY", "MYS"),
		array(130, "Maldives", "MV", "MDV"),
		array(131, "Mali", "ML", "MLI"),
		array(132, "Malta", "MT", "MLT"),
		array(133, "Marshall Islands", "MH", "MHL"),
		array(134, "Martinique", "MQ", "MTQ"),
		array(135, "Mauritania", "MR", "MRT"),
		array(136, "Mauritius", "MU", "MUS"),
		array(137, "Mayotte", "YT", "MYT"),
		array(138, "Mexico", "MX", "MEX"),
		array(139, "Micronesia, Federated States of", "FM", "FSM"),
		array(140, "Moldova, Republic of", "MD", "MDA"),
		array(141, "Monaco", "MC", "MCO"),
		array(142, "Mongolia", "MN", "MNG"),
		array(143, "Montenegro", "ME", "MNE"),
		array(144, "Montserrat", "MS", "MSR"),
		array(145, "Morocco", "MA", "MAR"),
		array(146, "Mozambique", "MZ", "MOZ"),
		array(147, "Myanmar", "MM", "MMR"),
		array(148, "Namibia", "NA", "NAM"),
		array(149, "Nauru", "NR", "NRU"),
		array(150, "Nepal", "NP", "NPL"),
		array(151, "Netherlands", "NL", "NLD"),
		array(152, "Netherlands Antilles", "AN", "ANT"),
		array(153, "New Caledonia", "NC", "NCL"),
		array(154, "New Zealand", "NZ", "NZL"),
		array(155, "Nicaragua", "NI", "NIC"),
		array(156, "Niger", "NE", "NER"),
		array(157, "Nigeria", "NG", "NGA"),
		array(158, "Niue", "NU", "NIU"),
		array(159, "Norfolk Island", "NF", "NFK"),
		array(160, "Northern Mariana Islands", "MP", "MNP"),
		array(161, "Norway", "NO", "NOR"),
		array(162, "Oman", "OM", "OMN"),
		array(163, "Pakistan", "PK", "PAK"),
		array(164, "Palau", "PW", "PLW"),
		array(165, "Panama", "PA", "PAN"),
		array(166, "Papua New Guinea", "PG", "PNG"),
		array(167, "Paraguay", "PY", "PRY"),
		array(168, "Peru", "PE", "PER"),
		array(169, "Philippines", "PH", "PHL"),
		array(170, "Pitcairn", "PN", "PCN"),
		array(171, "Poland", "PL", "POL"),
		array(172, "Portugal", "PT", "PRT"),
		array(173, "Puerto Rico", "PR", "PRI"),
		array(174, "Qatar", "QA", "QAT"),
		array(175, "Reunion", "RE", "REU"),
		array(176, "Romania", "RO", "ROM"),
		array(177, "Russian Federation", "RU", "RUS"),
		array(178, "Rwanda", "RW", "RWA"),
		array(179, "Saint Kitts and Nevis", "KN", "KNA"),
		array(180, "Saint Lucia", "LC", "LCA"),
		array(181, "Saint Vincent and the Grenadines", "VC", "VCT"),
		array(182, "Samoa", "WS", "WSM"),
		array(183, "San Marino", "SM", "SMR"),
		array(184, "Sao Tome and Principe", "ST", "STP"),
		array(185, "Saudi Arabia", "SA", "SAU"),
		array(186, "Senegal", "SN", "SEN"),
		array(187, "Serbia", "RS", "SRB"),
		array(188, "Seychelles", "SC", "SYC"),
		array(189, "Sierra Leone", "SL", "SLE"),
		array(190, "Singapore", "SG", "SGP"),
		array(191, "Slovakia array(Slovak Republic)", "SK", "SVK"),
		array(192, "Slovenia", "SI", "SVN"),
		array(193, "Solomon Islands", "SB", "SLB"),
		array(194, "Somalia", "SO", "SOM"),
		array(195, "South Africa", "ZA", "ZAF"),
		array(196, "South Georgia and the South Sandwich Islands", "GS", "SGS"),
		array(197, "Spain", "ES", "ESP"),
		array(198, "Sri Lanka", "LK", "LKA"),
		array(199, "St. Helena", "SH", "SHN"),
		array(200, "St. Pierre and Miquelon", "PM", "SPM"),
		array(201, "Sudan", "SD", "SDN"),
		array(202, "Suriname", "SR", "SUR"),
		array(203, "Svalbard and Jan Mayen Islands", "SJ", "SJM"),
		array(204, "Swaziland", "SZ", "SWZ"),
		array(205, "Sweden", "SE", "SWE"),
		array(206, "Switzerland", "CH", "CHE"),
		array(207, "Syrian Arab Republic", "SY", "SYR"),
		array(208, "Taiwan", "TW", "TWN"),
		array(209, "Tajikistan", "TJ", "TJK"),
		array(210, "Tanzania, United Republic of", "TZ", "TZA"),
		array(211, "Thailand", "TH", "THA"),
		array(212, "Togo", "TG", "TGO"),
		array(213, "Tokelau", "TK", "TKL"),
		array(214, "Tonga", "TO", "TON"),
		array(215, "Trinidad and Tobago", "TT", "TTO"),
		array(216, "Tunisia", "TN", "TUN"),
		array(217, "Turkey", "TR", "TUR"),
		array(218, "Turkmenistan", "TM", "TKM"),
		array(219, "Turks and Caicos Islands", "TC", "TCA"),
		array(220, "Tuvalu", "TV", "TUV"),
		array(221, "Uganda", "UG", "UGA"),
		array(222, "Ukraine", "UA", "UKR"),
		array(223, "United Arab Emirates", "AE", "ARE"),
		array(224, "United Kingdom", "GB", "GBR"),
		array(225, "United States", "US", "USA"),
		array(226, "United States Minor Outlying Islands", "UM", "UMI"),
		array(227, "Uruguay", "UY", "URY"),
		array(228, "Uzbekistan", "UZ", "UZB"),
		array(229, "Vanuatu", "VU", "VUT"),
		array(230, "Vatican City State array(Holy See)", "VA", "VAT"),
		array(231, "Venezuela", "VE", "VEN"),
		array(232, "Viet Nam", "VN", "VNM"),
		array(233, "Virgin Islands array(British)", "VG", "VGB"),
		array(234, "Virgin Islands array(U.S.)", "VI", "VIR"),
		array(235, "Wallis and Futuna Islands", "WF", "WLF"),
		array(236, "Western Sahara", "EH", "ESH"),
		array(237, "Yemen", "YE", "YEM"),
		array(238, "Zaire", "ZR", "ZAR"),
		array(239, "Zambia", "ZM", "ZMB"),
		array(240, "Zimbabwe", "ZW", "ZWE")
	);
	global $wpdb;
		foreach ($countriesArr as $arr) {
			$tableName = $wpdb->prefix . "cfs_countries";
				$wrongId = (int) $wpdb->get_var(
					$wpdb->prepare("SELECT id FROM {$wpdb->prefix}cfs_countries WHERE name = %s", $arr[1])
				);
				if (!$wrongId) {
					$wpdb->insert($tableName, array(
							'id' => $arr[0],
							'name' => $arr[1],
							'iso_code_2' => $arr[2],
							'iso_code_3' => $arr[3],
					));
				}
		};

	}
	/*
	 * Init base forms templates
	 */
	static public function initBaseForms() {
		if(function_exists('base64_encode')) {
			$data = array(
				'wefj2' => array('unique_id' => 'wefj2','label' => 'Base Contact','active' => '1','original_id' => '0','params' => 'YTo1OntzOjE5OiJlbmFibGVGb3JNZW1iZXJzaGlwIjtzOjE6IjAiO3M6MzoidHBsIjthOjQ2OntzOjU6IndpZHRoIjtzOjM6IjEwMCI7czoxMzoid2lkdGhfbWVhc3VyZSI7czoxOiIlIjtzOjk6ImJnX3R5cGVfMCI7czo0OiJub25lIjtzOjg6ImJnX2ltZ18wIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMCI7czo3OiIjODFkNzQyIjtzOjk6ImJnX3R5cGVfMSI7czo1OiJjb2xvciI7czo4OiJiZ19pbWdfMSI7czowOiIiO3M6MTA6ImJnX2NvbG9yXzEiO3M6NzoiIzMzMzMzMyI7czo5OiJiZ190eXBlXzIiO3M6NToiY29sb3IiO3M6ODoiYmdfaW1nXzIiO3M6MDoiIjtzOjEwOiJiZ19jb2xvcl8yIjtzOjc6IiMzMzMzMzMiO3M6OToiYmdfdHlwZV8zIjtzOjU6ImNvbG9yIjtzOjg6ImJnX2ltZ18zIjtzOjA6IiI7czoxMDoiYmdfY29sb3JfMyI7czo3OiIjMzMzMzMzIjtzOjE5OiJmaWVsZF9lcnJvcl9pbnZhbGlkIjtzOjA6IiI7czoxMzoiZm9ybV9zZW50X21zZyI7czoyODoiVGhhbmsgeW91IGZvciBjb250YWN0aW5nIHVzISI7czoxOToiZm9ybV9zZW50X21zZ19jb2xvciI7czo3OiIjNGFlOGVhIjtzOjE0OiJoaWRlX29uX3N1Ym1pdCI7czoxOiIxIjtzOjE4OiJyZWRpcmVjdF9vbl9zdWJtaXQiO3M6MDoiIjtzOjEwOiJ0ZXN0X2VtYWlsIjtzOjE0OiJhZG1pbkBtYWlsLmNvbSI7czoxMzoic2F2ZV9jb250YWN0cyI7czoxOiIxIjtzOjk6ImV4cF9kZWxpbSI7czoxOiI7IjtzOjE1OiJmYl9jb252ZXJ0X2Jhc2UiO3M6MDoiIjtzOjEzOiJwdWJfcG9zdF90eXBlIjtzOjQ6InBvc3QiO3M6MTU6InB1Yl9wb3N0X3N0YXR1cyI7czo3OiJwdWJsaXNoIjtzOjIzOiJyZWdfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czo4OiJzdWJfZGVzdCI7czoxMjoid3Bfc3Vic2NyaWJlIjtzOjIzOiJzdWJfd3BfY3JlYXRlX3VzZXJfcm9sZSI7czoxMDoic3Vic2NyaWJlciI7czoxODoic3ViX2FyX2Zvcm1fYWN0aW9uIjtzOjA6IiI7czoxMzoic3ViX2ZlZWRiX2tleSI7czowOiIiO3M6MTA6InN1Yl9zZ2FfaWQiO3M6MDoiIjtzOjE1OiJzdWJfc2dhX2xpc3RfaWQiO3M6MDoiIjtzOjIxOiJzdWJfc2dhX2FjdGl2YXRlX2NvZGUiO3M6MDoiIjtzOjIwOiJzdWJfdHh0X2NvbmZpcm1fc2VudCI7czo2NzoiQ29uZmlybWF0aW9uIGxpbmsgd2FzIHNlbnQgdG8geW91ciBlbWFpbCBhZGRyZXNzLiBDaGVjayB5b3VyIGVtYWlsISI7czoxNToic3ViX3R4dF9zdWNjZXNzIjtzOjI2OiJUaGFuayB5b3UgZm9yIHN1YnNjcmliaW5nISI7czoyMToic3ViX3R4dF9pbnZhbGlkX2VtYWlsIjtzOjIyOiJFbXB0eSBvciBpbnZhbGlkIGVtYWlsIjtzOjIwOiJzdWJfdHh0X2V4aXN0c19lbWFpbCI7czoyMjoiRW1wdHkgb3IgaW52YWxpZCBlbWFpbCI7czoxNjoic3ViX3JlZGlyZWN0X3VybCI7czowOiIiO3M6Mjg6InN1Yl90eHRfY29uZmlybV9tYWlsX3N1YmplY3QiO3M6MzQ6IkNvbmZpcm0gc3Vic2NyaXB0aW9uIG9uIFtzaXRlbmFtZV0iO3M6MjU6InN1Yl90eHRfY29uZmlybV9tYWlsX2Zyb20iO3M6MDoiIjtzOjI4OiJzdWJfdHh0X2NvbmZpcm1fbWFpbF9tZXNzYWdlIjtzOjE5NzoiWW91IHN1YnNjcmliZWQgb24gc2l0ZSA8YSBocmVmPVwiW3NpdGV1cmxdXCI+W3NpdGVuYW1lXTwvYT4uIEZvbGxvdyA8YSBocmVmPVwiW2NvbmZpcm1fbGlua11cIj50aGlzIGxpbms8L2E+IHRvIGNvbXBsZXRlIHlvdXIgc3Vic2NyaXB0aW9uLiBJZiB5b3UgZGlkIG5vdCBzdWJzY3JpYmUgaGVyZSAtIGp1c3QgaWdub3JlIHRoaXMgbWVzc2FnZS4iO3M6MzE6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX3N1YmplY3QiO3M6Mzc6IltzaXRlbmFtZV0gWW91ciB1c2VybmFtZSBhbmQgcGFzc3dvcmQiO3M6Mjg6InN1Yl90eHRfc3Vic2NyaWJlcl9tYWlsX2Zyb20iO3M6MDoiIjtzOjMxOiJzdWJfdHh0X3N1YnNjcmliZXJfbWFpbF9tZXNzYWdlIjtzOjY1OiJVc2VybmFtZTogW3VzZXJfbG9naW5dPGJyIC8+UGFzc3dvcmQ6IFtwYXNzd29yZF08YnIgLz5bbG9naW5fdXJsXSI7czoyNToic3ViX3JlZGlyZWN0X2VtYWlsX2V4aXN0cyI7czowOiIiO3M6MTM6ImZpZWxkX3dyYXBwZXIiO3M6NjE6IjxkaXYgW2ZpZWxkX3NoZWxsX2NsYXNzZXNdIFtmaWVsZF9zaGVsbF9zdHlsZXNdPltmaWVsZF08L2Rpdj4iO31zOjY6ImZpZWxkcyI7YTo3OntpOjA7YToxNzp7czo1OiJsYWJlbCI7czowOiIiO3M6MTE6InBsYWNlaG9sZGVyIjtzOjEwOiJGaXJzdCBOYW1lIjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6NDoibmFtZSI7czoxMDoiZmlyc3RfbmFtZSI7czoxMToiYnNfY2xhc3NfaWQiO3M6MToiNiI7czo3OiJkaXNwbGF5IjtzOjA6IiI7czo4OiJtaW5fc2l6ZSI7czowOiIiO3M6ODoibWF4X3NpemUiO3M6MDoiIjtzOjExOiJhZGRfY2xhc3NlcyI7czowOiIiO3M6MTA6ImFkZF9zdHlsZXMiO3M6MDoiIjtzOjg6ImFkZF9hdHRyIjtzOjA6IiI7czoxNDoidm5fb25seV9udW1iZXIiO3M6MToiMCI7czoxNToidm5fb25seV9sZXR0ZXJzIjtzOjE6IjAiO3M6MTA6InZuX3BhdHRlcm4iO3M6MToiMCI7czoxMToiZGVmX2NoZWNrZWQiO3M6MToiMCI7fWk6MTthOjE3OntzOjU6ImxhYmVsIjtzOjA6IiI7czoxMToicGxhY2Vob2xkZXIiO3M6OToiTGFzdCBOYW1lIjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6OToibWFuZGF0b3J5IjtzOjE6IjAiO3M6NDoibmFtZSI7czo5OiJsYXN0X25hbWUiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjE6IjYiO3M6NzoiZGlzcGxheSI7czowOiIiO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjE6IjAiO3M6MTE6ImRlZl9jaGVja2VkIjtzOjE6IjAiO31pOjI7YToxNzp7czo1OiJsYWJlbCI7czowOiIiO3M6MTE6InBsYWNlaG9sZGVyIjtzOjU6IkVtYWlsIjtzOjQ6Imh0bWwiO3M6NToiZW1haWwiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIxIjtzOjQ6Im5hbWUiO3M6NToiZW1haWwiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjI6IjEyIjtzOjc6ImRpc3BsYXkiO3M6Mzoicm93IjtzOjg6Im1pbl9zaXplIjtzOjA6IiI7czo4OiJtYXhfc2l6ZSI7czowOiIiO3M6MTE6ImFkZF9jbGFzc2VzIjtzOjA6IiI7czoxMDoiYWRkX3N0eWxlcyI7czowOiIiO3M6ODoiYWRkX2F0dHIiO3M6MDoiIjtzOjE0OiJ2bl9vbmx5X251bWJlciI7czoxOiIwIjtzOjE1OiJ2bl9vbmx5X2xldHRlcnMiO3M6MToiMCI7czoxMDoidm5fcGF0dGVybiI7czoxOiIwIjtzOjExOiJkZWZfY2hlY2tlZCI7czoxOiIwIjt9aTozO2E6MTc6e3M6NToibGFiZWwiO3M6MDoiIjtzOjExOiJwbGFjZWhvbGRlciI7czo3OiJTdWJqZWN0IjtzOjQ6Imh0bWwiO3M6NDoidGV4dCI7czo1OiJ2YWx1ZSI7czowOiIiO3M6OToibWFuZGF0b3J5IjtzOjE6IjEiO3M6NDoibmFtZSI7czo3OiJzdWJqZWN0IjtzOjExOiJic19jbGFzc19pZCI7czoyOiIxMiI7czo3OiJkaXNwbGF5IjtzOjM6InJvdyI7czo4OiJtaW5fc2l6ZSI7czowOiIiO3M6ODoibWF4X3NpemUiO3M6MDoiIjtzOjExOiJhZGRfY2xhc3NlcyI7czowOiIiO3M6MTA6ImFkZF9zdHlsZXMiO3M6MDoiIjtzOjg6ImFkZF9hdHRyIjtzOjA6IiI7czoxNDoidm5fb25seV9udW1iZXIiO3M6MToiMCI7czoxNToidm5fb25seV9sZXR0ZXJzIjtzOjE6IjAiO3M6MTA6InZuX3BhdHRlcm4iO3M6MToiMCI7czoxMToiZGVmX2NoZWNrZWQiO3M6MToiMCI7fWk6NDthOjE3OntzOjU6ImxhYmVsIjtzOjA6IiI7czoxMToicGxhY2Vob2xkZXIiO3M6NzoiTWVzc2FnZSI7czo0OiJodG1sIjtzOjg6InRleHRhcmVhIjtzOjU6InZhbHVlIjtzOjA6IiI7czo5OiJtYW5kYXRvcnkiO3M6MToiMSI7czo0OiJuYW1lIjtzOjc6Im1lc3NhZ2UiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjI6IjEyIjtzOjc6ImRpc3BsYXkiO3M6Mzoicm93IjtzOjg6Im1pbl9zaXplIjtzOjA6IiI7czo4OiJtYXhfc2l6ZSI7czowOiIiO3M6MTE6ImFkZF9jbGFzc2VzIjtzOjA6IiI7czoxMDoiYWRkX3N0eWxlcyI7czowOiIiO3M6ODoiYWRkX2F0dHIiO3M6MDoiIjtzOjE0OiJ2bl9vbmx5X251bWJlciI7czoxOiIwIjtzOjE1OiJ2bl9vbmx5X2xldHRlcnMiO3M6MToiMCI7czoxMDoidm5fcGF0dGVybiI7czoxOiIwIjtzOjExOiJkZWZfY2hlY2tlZCI7czoxOiIwIjt9aTo1O2E6MTc6e3M6NToibGFiZWwiO3M6NDoiU2VuZCI7czoxMToicGxhY2Vob2xkZXIiO3M6MDoiIjtzOjQ6Imh0bWwiO3M6Njoic3VibWl0IjtzOjU6InZhbHVlIjtzOjA6IiI7czo5OiJtYW5kYXRvcnkiO3M6MToiMCI7czo0OiJuYW1lIjtzOjQ6InNlbmQiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjE6IjYiO3M6NzoiZGlzcGxheSI7czowOiIiO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjE6IjAiO3M6MTE6ImRlZl9jaGVja2VkIjtzOjE6IjAiO31pOjY7YToxNzp7czo1OiJsYWJlbCI7czo1OiJSZXNldCI7czoxMToicGxhY2Vob2xkZXIiO3M6MDoiIjtzOjQ6Imh0bWwiO3M6NToicmVzZXQiO3M6NToidmFsdWUiO3M6MDoiIjtzOjk6Im1hbmRhdG9yeSI7czoxOiIwIjtzOjQ6Im5hbWUiO3M6NToicmVzZXQiO3M6MTE6ImJzX2NsYXNzX2lkIjtzOjE6IjYiO3M6NzoiZGlzcGxheSI7czowOiIiO3M6ODoibWluX3NpemUiO3M6MDoiIjtzOjg6Im1heF9zaXplIjtzOjA6IiI7czoxMToiYWRkX2NsYXNzZXMiO3M6MDoiIjtzOjEwOiJhZGRfc3R5bGVzIjtzOjA6IiI7czo4OiJhZGRfYXR0ciI7czowOiIiO3M6MTQ6InZuX29ubHlfbnVtYmVyIjtzOjE6IjAiO3M6MTU6InZuX29ubHlfbGV0dGVycyI7czoxOiIwIjtzOjEwOiJ2bl9wYXR0ZXJuIjtzOjE6IjAiO3M6MTE6ImRlZl9jaGVja2VkIjtzOjE6IjAiO319czo2OiJzdWJtaXQiO2E6MTp7aTowO2E6Nzp7czoyOiJ0byI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6NDoiZnJvbSI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MjoiY2MiO3M6MDoiIjtzOjU6InJlcGx5IjtzOjA6IiI7czo3OiJzdWJqZWN0IjtzOjE5OiJDb250YWN0IGZvcm0gc3VibWl0IjtzOjM6Im1zZyI7czo2OToiPHA+SGVsbG8hPC9wPjxwPlRoaXMgaXMgeW91ciBjb250YWN0IGZvcm0gZGF0YTo8L3A+PHA+W2Zvcm1fZGF0YV08L3A+IjtzOjY6ImVuYl9jYyI7czoxOiIwIjt9fXM6MTA6Im9wdHNfYXR0cnMiO2E6MTp7czo5OiJiZ19udW1iZXIiO3M6MToiNCI7fX0=','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button{\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 0.7)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}','sort_order' => '1','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'base-contact.jpg'),
				'foe42k' => array('unique_id' => 'foe42k','label' => 'Neon','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsFieldCol {\r\n	padding: 10px 5px\r\n}\r\n/*Glow effect*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 7px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	box-shadow: 0 0 5px 1px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck {\r\n    padding: 0 5px 5px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border-top: none;\r\n  	border-left: none;\r\n  	border-right: none;\r\n  	border-bottom: 2px solid [bg_color_1];\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.4s;\r\n  	font-style: italic;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] textarea {\r\n  	padding: 5px;\r\n	[if bg_type_1 == \'color\']\r\n  	border: 2px solid [bg_color_1];\r\n  	[endif]\r\n}\r\n/*Invalid input styles*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus:invalid,\r\n#[SHELL_ID] textarea:focus:invalid,\r\n#[SHELL_ID] .cfsListSelect:focus:invalid, \r\n#[SHELL_ID] .cfsCheck:focus:invalid {\r\n	border-color: #ff0004;\r\n  	box-shadow: none;\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	-moz-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	box-shadow: 0 7px 5px -3px #ff0004;\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus:invalid {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px #ff0004;\r\n 	-moz-box-shadow: 0 0 5px 1px #ff0004;\r\n 	box-shadow: 0 0 5px 1px #ff0004;\r\n	[endif]\r\n}\r\n/*Some interactions with inputs*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 9px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	box-shadow: 0 0 5px 3px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Buttons*/\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	width: auto;\r\n    text-transform: uppercase;\r\n  	font-size: 34px;\r\n  	padding: 10px 20px;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 2px solid [bg_color_2];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_2];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	box-shadow: 0 0 5px 1px [bg_color_2];\r\n  \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	border: 2px solid [bg_color_3];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_3];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	box-shadow: 0 0 5px 1px [bg_color_3];\r\n  \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}','sort_order' => '2','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'neon.jpg'),
				'uwi23o' => array('unique_id' => 'uwi23o','label' => 'Intransigent','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Form theme custom styles*/\r\n#[SHELL_ID] .cfsFieldShell:not([data-field-html=\"submit\"]):not([data-field-html=\"reset\"]):not([data-field-html=\"button\"]) {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 11)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"submit\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"reset\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"button\"] .cfsFieldInputEx input {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldExLabel {\r\n  	font-size: 14px;\r\n  	padding: 10px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button  {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 15px;\r\n    line-height: normal;\r\n  	border: none;\r\n  	border-radius: 0;\r\n  	hyphens: none;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.3s;\r\n  	[if bg_type_1 == \'color\']\r\n    color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: normal;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	width: auto;\r\n  	font-size: 20px;\r\n  	padding: 15px 25px;\r\n  	opacity: 0.7;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", -20)}};\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	opacity: 1;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}','sort_order' => '3','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'intransigent.jpg'),
				'vbn23a' => array('unique_id' => 'vbn23a','label' => 'Simple White','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #333;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsChec:focus {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 1px solid [bg_color_2];\r\n  	color: [bg_color_2];\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}','sort_order' => '4','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'simple-white.png'),
				'bso15i' => array('unique_id' => 'bso15i','label' => 'Time for tea','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;/**/\r\n	background-position: bottom right;\r\n  	[endif]\r\n	font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n}\r\n\r\n#[SHELL_ID] h3 {\r\n  	font-weight: bold;\r\n  	font-size: 24px;\r\n  	margin-top: 30px;\r\n  	margin-bottom: 15px;\r\n}\r\n\r\n#[SHELL_ID] label {\r\n  	font-weight: bold;\r\n}\r\n\r\n#[SHELL_ID] form {\r\n  	padding: 0 25px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n  	/*padding-left: 10px;/**/\r\n  	color: #FFF;\r\n	width: 100%;\r\n  	font-size: 14px;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	border: 1px solid #FFF;\r\n  	color: #FFF;\r\n    padding: 10px;\r\n    width: 100%;\r\n    line-height: normal;\r\n  	background-color: inherit;\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n\r\n#[SHELL_ID] .g-recaptcha {\r\n	min-height: 60px;\r\n}\r\n\r\n#[SHELL_ID] [type=\"submit\"] {\r\n  	margin-top: 40px !important;\r\n	width: 150px !important;\r\n  	font-size: 24px;\r\n  	text-transform: capitalize !important;\r\n  	border-radius: 25px !important;\r\n  	float: right;\r\n}','sort_order' => '5','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'tea-time.png'),
				'bjl17b' => array('unique_id' => 'bjl17b','label' => 'Opacity Grey','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Raleway\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_0]\", 0.85)}};\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: Raleway, sans-serif !important;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	color: [bg_color_2];\r\n  	background-color: #FFF;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID].cfsFormShell .row {\r\n	margin-left: 0;\r\n  	margin-right: 0;\r\n}','sort_order' => '6','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'opacity-grey.png'),
				'bjl17a' => array('unique_id' => 'bjl17a','label' => 'Spearmint','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Kaushan+Script\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 2px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID].cfsFormShell .row {\r\n	margin-left: 0;\r\n  	margin-right: 0;\r\n}','sort_order' => '7','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'light-grey.png'),
				'bjl17c' => array('unique_id' => 'bjl17c','label' => 'Support Service','active' => '1','original_id' => '0','params' => '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','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n  	[if bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	[else]\r\n  	background-color: #FFF;\r\n  	[endif]\r\n  	font-family: sans-serif;\r\n  	padding: 20px;\r\n  	width: 380px;\r\n}\r\n\r\n#[SHELL_ID] .about,\r\n#[SHELL_ID] p {\r\n  	margin: 0;\r\n	text-align: center;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n  	line-height: 1em;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell {\r\n	position: relative;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell select {\r\n	position: absolute;\r\n  	padding-left: 5px;\r\n  	top: 0;\r\n  	left: 0;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	box-sizing: border-box;\r\n  	font-family: sans-serif;\r\n  	font-size: 12px;\r\n  	color: #666059;\r\n}\r\n\r\n#[SHELL_ID] p.description {\r\n  	line-height: 18px;\r\n}\r\n\r\n#[SHELL_ID] .about div {\r\n	height: 100px;\r\n  	margin-bottom: 20px;\r\n  	margin-right: 40px;\r\n}\r\n\r\n#[SHELL_ID] div .name {\r\n	font-size: 30px;\r\n  	line-height: 1.8em;\r\n}\r\n\r\n#[SHELL_ID] div .role {\r\n    margin-top: -5px;\r\n}\r\n\r\n#[SHELL_ID] .about > img {\r\n  	width: 100px;\r\n  	height: 100px;\r\n  	margin-right: 20px;\r\n  	margin-bottom: 20px;\r\n  	float: left;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons {\r\n  	margin-top: 17px;\r\n	margin-left: 120px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a {\r\n  	font-size: 0;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a + a {\r\n  	padding-left: 3px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img {\r\n  	display: inline-block;\r\n	height: 16px;\r\n  	width: 16px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img:hover {\r\n  	opacity: 0.5;\r\n}\r\n\r\n\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_2 == \'color\']\r\n	border: 1px solid {{adjust_opacity(\"[bg_color_2]\", 0.5)}};\r\n  	[endif]\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[endif]\r\n  	[if bg_type_1 == \'color\']\r\n	color: [bg_color_1];\r\n  	[endif]  \r\n    hyphens: none;\r\n    border-radius: 3px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n    outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	width: 50%;\r\n  	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}','sort_order' => '8','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'kiwifruit.png'),
				'ajl17d' => array('unique_id' => 'ajl17d','label' => 'Ho Ho Ho','active' => '1','original_id' => '0','params' => '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','html' => '<link href=\"https://fonts.googleapis.com/css?family=Pacifico|Raleway|Raleway:800\" rel=\"stylesheet\"/>\r\n[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \"color\"]\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	font-family: \"Raleway\";\r\n	text-align: center;\r\n	\r\n	-webkit-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect select, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n	margin: 0;\r\n  	[if bg_type_1 == \"color\"]\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	hyphens: none;\r\n    border-radius: 2px;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \"Raleway\";\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsListSelect {\r\n	border: 1px solid transparent;\r\n	padding: 0px;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \"color\"]\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \"color\"]\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n/**/\r\n#[SHELL_ID] .csfForm {\r\n	display: inline-block;\r\n	text-align: left;\r\n    padding: 0 0 20px;\r\n    width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row {\r\n	width: 80%;\r\n	margin: 0 auto;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(2)  {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:first-of-type {\r\n    [if bg_type_4 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(\"[bg_color_4]\", 50) }}), color-stop(100%, [bg_color_4])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(\"[bg_color_4]\", 50) }}\", endColorstr=\"[bg_color_4]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_4 == \"img\"]\r\n	background-image: url(\"[bg_img_4]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n	[endif]\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:first-of-type .cfsFieldCol {\r\n	[if bg_type_5 == \"color\"]\r\n	background: {{ hex_to_rgba_str(\"[bg_color_5]\", 0.9) }};\r\n	[elseif bg_type_5 == \"img\"]\r\n	background-image: url(\"[bg_img_5]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n	[endif]\r\n	text-align: center;\r\n	position: relative;\r\n	width: 100%;\r\n	min-height: 329px;\r\n}\r\n/*\r\n#[SHELL_ID] .cfsImgWrench {\r\n	[if bg_type_6 == \"img\"]\r\n	background-image: url(\"[bg_img_6]\");\r\n	background-repeat: no-repeat;\r\n    background-size: 75% auto;\r\n    height: 130px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsImgSanta {\r\n	[if bg_type_7 == \"img\"]\r\n	background-image: url(\"[bg_img_7]\");\r\n	background-repeat: no-repeat;\r\n	background-size: 100% auto;\r\n    height: 235px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsNewYearBg > div {\r\n	vertical-align: middle;\r\n}*/\r\n\r\n#[SHELL_ID] .cfsWrapImgWrench {\r\n	margin-right: 130px;\r\n	text-align: center;\r\n	position: relative;\r\n	z-index: 100;\r\n	bottom: 67px;\r\n	width: 50%;\r\n}\r\n#[SHELL_ID] .cfsImgWrench {\r\n	position: absolute;\r\n	right: -65px;\r\n	\r\n	[if bg_type_6 == \"img\"]\r\n	background-image: url(\"[bg_img_6]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n    height: 130px;\r\n    width: 130px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsWrapImgSanta {\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#[SHELL_ID] .cfsImgSanta {\r\n	position: absolute;\r\n	top: -130px;\r\n	right: 0%;\r\n	[if bg_type_7 == \"img\"]\r\n	background-image: url(\"[bg_img_7]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n    height: 235px;\r\n    width: 189px;\r\n	[endif]\r\n}\r\n\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n	margin-bottom: 20px;\r\n	padding-bottom: 100px;\r\n	text-align: center;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) p {\r\n	text-align: center;\r\n	padding: 40px 0 0;\r\n	font-size: 20px;\r\n	font-family: \"Pacifico\";\r\n	color: #fff;\r\n	margin: 0px;\r\n	word-wrap: break-word;\r\n	display: inline-block;\r\n	width: 90%;\r\n	position: relative;\r\n    z-index: 100;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n	color: #fff;\r\n	text-align: center;\r\n	font-size: 70px;\r\n	font-weight: 800;\r\n	letter-spacing: -1px;\r\n	margin: 20px 0 0;\r\n	word-wrap: break-word;\r\n	display: block;\r\n	padding: 0;\r\n	position: relative;\r\n    z-index: 100;\r\n	line-height: 60px;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n	text-align: center;\r\n	font-size: 20px;\r\n	font-weight: normal;\r\n\r\n	margin: 15px 0 130px;\r\n	border: 2px solid #fff;\r\n	padding: 14px 20px;\r\n	-webkit-border-radius: 2px;\r\n	-moz-border-radius: 2px;\r\n	border-radius: 2px;\r\n	color: #fff;\r\n\r\n	word-wrap: break-word;\r\n	display: inline-block;\r\n	width: 90%;\r\n	position: relative;\r\n    z-index: 100;\r\n}\r\n#[SHELL_ID] .cfsSnow {\r\n	z-index: 0;\r\n	position: absolute;\r\n	top: 0;\r\n	left: 0;\r\n	height: 100%;\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsRight {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsContactMsg {\r\n	width: 100%;\r\n	text-align: center;\r\n}\r\n\r\n@media (max-width: 300px) {\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n		font-size: 33px;\r\n		line-height: 40px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n		padding-bottom: 50px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n		margin: 15px 0 70px;\r\n	}\r\n	#[SHELL_ID] .cfsImgSanta {\r\n		display: none;\r\n	}\r\n}\r\n@media (min-width: 300px) and (max-width: 768px) {\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n		font-size: 50px;\r\n		line-height: 50px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n		margin: 15px 0 70px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n		padding-bottom: 50px;\r\n	}\r\n	#[SHELL_ID] .cfsImgSanta {\r\n		display: none;\r\n	}\r\n}','sort_order' => '20','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'Ho-ho-ho-template-prev.png'),
				'cbrl7b' => array('unique_id' => 'cbrl7b','label' => 'Merry Christmas','active' => '1','original_id' => '0','params' => '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','html' => '<link href=\"https://fonts.googleapis.com/css?family=Raleway|Sacramento\" rel=\"stylesheet\">\r\n<div class=\"cfsWrapImgTopTop\">\r\n	[if bg_type_4 == \"img\"]\r\n	<img src=\"[bg_img_4]\" class=\"cfsImgTopTop\" alt=\"holiday wrench\"/>\r\n	[endif]\r\n</div>\r\n[form_start]\r\n[fields]\r\n[form_end]\r\n<div class=\"cfsWrapImgTopBtm\">\r\n	[if bg_type_5 == \"img\"]\r\n	<img src=\"[bg_img_5]\" class=\"cfsImgTopBtm\"/>\r\n	[endif]\r\n</div>','css' => '#[SHELL_ID] {\r\n	font-family: \"Raleway\";\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(\"[bg_color_0]\", 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(\"[bg_color_0]\", 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_0 == \"img\"]\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-repeat: no-repeat;\r\n	background-size: 100% 100%;\r\n	[endif]\r\n	-webkit-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n	text-align: center;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n	margin: 0 !important;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n#[SHELL_ID] .cfsCheckTbl label {\r\n	font-size: 12px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell > label {\r\n	font-size: 14px;\r\n}\r\n#[SHELL_ID] .cfsCheckTbl {\r\n	margin: 0;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect select, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n	margin: 0;\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: \"Raleway\" !important;\r\n  	height: auto;\r\n	\r\n	[if bg_type_1 == \"color\"]\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsListSelect select:not([multiple]) option {\r\n	color: #000;\r\n}\r\n#[SHELL_ID] .cfsListSelect {\r\n	border: 1px solid transparent;\r\n	padding: 0px;\r\n	display: block;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n	padding: 10px 10px 8px;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	color: #8C141A;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	color: #8C141A;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \"color\"]\r\n  	background: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsSubmitWidth {\r\n	display: block !important;\r\n	width: auto !important;\r\n	min-width: 50% !important;\r\n	margin: 0 auto !important;\r\n	-webkit-box-shadow: 1px 1px 5px #aaa;\r\n	-moz-box-shadow: 1px 1px 5px #aaa;\r\n	box-shadow: 1px 1px 5px #aaa;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n\r\n#[SHELL_ID] .csfForm  {\r\n	display: inline-block;\r\n	width: 100%;\r\n	text-align: left;\r\n}\r\n#[SHELL_ID] .cfsWrapImgTopTop {\r\n	padding: 0;\r\n	margin: 0;\r\n	line-height: 0;\r\n}\r\n#[SHELL_ID] .cfsImgTopTop {\r\n	/*width: 100%;*/\r\n}\r\n#[SHELL_ID] .cfsWrapImgTopBtm {\r\n	padding: 0;\r\n	margin: 0;\r\n	line-height: 0;\r\n}\r\n#[SHELL_ID] .cfsImgTopBtm  {\r\n	/*width: 100%;*/\r\n}\r\n#[SHELL_ID] .row:first-of-type {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .row {\r\n	margin: 0 auto;\r\n    width: 60%;\r\n}\r\n#[SHELL_ID] .row:first-of-type p {\r\n	color: #fff;\r\n	text-align: center;\r\n	line-height: 63px;\r\n	letter-spacing: -1px;\r\n	margin: 0px 0px;\r\n	word-wrap: break-word;\r\n	display: block;\r\n	position: relative;\r\n    z-index: 100;\r\n	font-size: 50px;\r\n	font-weight: 800;\r\n	padding: 0px;\r\n	font-family: \"Sacramento\";\r\n}\r\n#[SHELL_ID] .row:first-of-type h3 {\r\n	color: #fff;\r\n	margin: 0px;\r\n	z-index: 100;\r\n	position: relative;\r\n	word-wrap: break-word;\r\n	z-index: 100;\r\n	display: block;\r\n	padding: 0;\r\n	font-size: 25px;\r\n	font-family: \"Sacramento\";\r\n	font-weight: normal;\r\n}\r\n#[SHELL_ID] .cfsContactMsg {\r\n	width: 100%;\r\n	text-align: center;\r\n}','sort_order' => '21','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => '141-merry-cristmas-prev.png'),
			);
		} else {	//--not-base64--
			$data = array(
				'wefj2' => array('unique_id' => 'wefj2','label' => 'Base Contact','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|83|117|98|106|101|99|116|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|82|101|115|101|116|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|54|57|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button{\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 0.7)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.7);\r\n}','sort_order' => '1','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'base-contact.jpg'),
				'foe42k' => array('unique_id' => 'foe42k','label' => 'Neon','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|48|50|52|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|48|50|52|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|67|111|109|112|97|110|121|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|99|111|109|112|97|110|121|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|56|58|34|113|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsFieldCol {\r\n	padding: 10px 5px\r\n}\r\n/*Glow effect*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 7px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 7px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_1];\r\n 	box-shadow: 0 0 5px 1px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] textarea,\r\n#[SHELL_ID] .cfsListSelect, \r\n#[SHELL_ID] .cfsCheck {\r\n    padding: 0 5px 5px;\r\n    width: 100%;\r\n    font-size: 18px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border-top: none;\r\n  	border-left: none;\r\n  	border-right: none;\r\n  	border-bottom: 2px solid [bg_color_1];\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.4s;\r\n  	font-style: italic;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] textarea {\r\n  	padding: 5px;\r\n	[if bg_type_1 == \'color\']\r\n  	border: 2px solid [bg_color_1];\r\n  	[endif]\r\n}\r\n/*Invalid input styles*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus:invalid,\r\n#[SHELL_ID] textarea:focus:invalid,\r\n#[SHELL_ID] .cfsListSelect:focus:invalid, \r\n#[SHELL_ID] .cfsCheck:focus:invalid {\r\n	border-color: #ff0004;\r\n  	box-shadow: none;\r\n  	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	-moz-box-shadow: 0px 7px 5px -3px #ff0004;\r\n 	box-shadow: 0 7px 5px -3px #ff0004;\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus:invalid {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 1px #ff0004;\r\n 	-moz-box-shadow: 0 0 5px 1px #ff0004;\r\n 	box-shadow: 0 0 5px 1px #ff0004;\r\n	[endif]\r\n}\r\n/*Some interactions with inputs*/\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	-moz-box-shadow: 0px 9px 5px -3px [bg_color_1];\r\n 	box-shadow: 0 9px 5px -3px [bg_color_1];\r\n	[endif]\r\n}\r\n#[SHELL_ID] textarea:focus {\r\n	[if bg_type_1 == \'color\']\r\n	-webkit-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	-moz-box-shadow: 0 0 5px 3px [bg_color_1];\r\n 	box-shadow: 0 0 5px 3px [bg_color_1];\r\n	[endif]\r\n}\r\n/*Buttons*/\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	width: auto;\r\n    text-transform: uppercase;\r\n  	font-size: 34px;\r\n  	padding: 10px 20px;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 2px solid [bg_color_2];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_2];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_2];\r\n 	box-shadow: 0 0 5px 1px [bg_color_2];\r\n  \r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	border: 2px solid [bg_color_3];\r\n  	background-color: transparent;\r\n  	background-image: none;\r\n  	color: [bg_color_3];\r\n  \r\n  	-webkit-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	-moz-box-shadow: 0 0 5px 1px [bg_color_3];\r\n 	box-shadow: 0 0 5px 1px [bg_color_3];\r\n  \r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	color: #fff;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n  	font-style: italic;\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.8);\r\n  	font-style: italic;\r\n}','sort_order' => '2','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'neon.jpg'),
				'uwi23o' => array('unique_id' => 'uwi23o','label' => 'Intransigent','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|48|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|56|49|100|55|52|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|49|57|49|57|49|57|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|50|53|50|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|32|100|97|116|97|45|102|105|101|108|100|45|104|116|109|108|61|92|34|91|102|105|101|108|100|95|104|116|109|108|93|92|34|62|60|100|105|118|32|99|108|97|115|115|61|92|34|114|111|119|92|34|62|60|100|105|118|32|99|108|97|115|115|61|92|34|99|111|108|45|115|109|45|51|32|99|102|115|70|105|101|108|100|69|120|76|97|98|101|108|92|34|62|60|108|97|98|101|108|32|102|111|114|61|92|34|91|102|105|101|108|100|95|105|100|93|92|34|62|91|108|97|98|101|108|93|60|47|108|97|98|101|108|62|60|47|100|105|118|62|60|100|105|118|32|99|108|97|115|115|61|92|34|99|111|108|45|115|109|45|57|32|99|102|115|70|105|101|108|100|73|110|112|117|116|69|120|92|34|62|91|102|105|101|108|100|93|60|47|100|105|118|62|60|47|100|105|118|62|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|52|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|50|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Form theme custom styles*/\r\n#[SHELL_ID] .cfsFieldShell:not([data-field-html=\"submit\"]):not([data-field-html=\"reset\"]):not([data-field-html=\"button\"]) {\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 11)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"submit\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"reset\"] .cfsFieldInputEx input,\r\n#[SHELL_ID] .cfsFieldShell[data-field-html=\"button\"] .cfsFieldInputEx input {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldExLabel {\r\n  	font-size: 14px;\r\n  	padding: 10px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	[endif]\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button  {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 15px;\r\n    line-height: normal;\r\n  	border: none;\r\n  	border-radius: 0;\r\n  	hyphens: none;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	transition-duration: 0.3s;\r\n  	[if bg_type_1 == \'color\']\r\n    color: {{adjust_brightness(\"[bg_color_1]\", 109)}};\r\n  	background-color: [bg_color_1];\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: normal;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	width: auto;\r\n  	font-size: 20px;\r\n  	padding: 15px 25px;\r\n  	opacity: 0.7;\r\n  	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", -20)}};\r\n  	background-image: none;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	opacity: 1;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_brightness(\"[bg_color_1]\", 51)}};\r\n}','sort_order' => '3','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'intransigent.jpg'),
				'vbn23a' => array('unique_id' => 'vbn23a','label' => 'Simple White','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|99|100|99|100|99|100|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|99|100|99|100|99|100|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|55|97|102|57|55|99|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|102|102|56|48|55|99|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|83|117|98|106|101|99|116|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|82|101|115|101|116|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|114|101|115|101|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #333;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsChec:focus {\r\n	[if bg_type_2 == \'color\']\r\n  	border: 1px solid [bg_color_2];\r\n  	color: [bg_color_2];\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(51, 51, 51, 0.3);\r\n}','sort_order' => '4','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'simple-white.png'),
				'bso15i' => array('unique_id' => 'bso15i','label' => 'Time for tea','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|51|53|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|116|101|97|45|116|105|109|101|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|102|57|54|57|48|101|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|100|100|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|49|49|48|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|13|10|32|32|32|32|60|108|97|98|101|108|32|102|111|114|61|92|34|91|102|105|101|108|100|95|105|100|93|92|34|62|91|108|97|98|101|108|93|60|47|108|97|98|101|108|62|91|102|105|101|108|100|93|13|10|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|50|50|56|58|34|60|104|51|32|99|108|97|115|115|61|92|34|104|101|97|100|95|102|111|114|109|92|34|62|67|111|110|116|97|99|116|32|85|115|60|47|104|51|62|13|10|60|112|32|99|108|97|115|115|61|92|34|100|101|115|99|114|105|112|116|105|111|110|92|34|62|73|102|32|121|111|117|32|104|97|118|101|32|115|111|109|101|32|113|117|101|115|116|105|111|110|115|32|111|114|32|111|102|102|101|114|115|32|102|111|114|32|117|115|32|45|32|102|105|108|108|32|116|104|101|32|99|111|110|116|97|99|116|32|102|111|114|109|32|98|101|108|111|119|46|32|79|117|114|32|115|117|112|112|111|114|116|32|116|101|97|109|32|105|115|32|104|97|112|112|121|32|116|111|32|104|101|108|112|32|121|111|117|32|50|52|47|55|32|97|110|100|32|119|101|32|99|97|110|32|97|110|115|119|101|114|32|101|118|101|114|121|32|121|111|117|114|32|113|117|101|115|116|105|111|110|46|60|47|112|62|13|10|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|48|58|34|70|105|114|115|116|32|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|57|58|34|76|97|115|116|32|78|97|109|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|57|58|34|108|97|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|50|50|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|54|58|34|67|97|112|99|104|97|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|114|101|99|97|112|116|99|104|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|54|58|34|99|97|112|99|104|97|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|115|58|49|51|58|34|114|101|99|97|112|45|115|105|116|101|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|50|58|34|114|101|99|97|112|45|115|101|99|114|101|116|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|114|101|99|97|112|45|116|104|101|109|101|34|59|115|58|53|58|34|108|105|103|104|116|34|59|115|58|49|48|58|34|114|101|99|97|112|45|116|121|112|101|34|59|115|58|53|58|34|97|117|100|105|111|34|59|115|58|49|48|58|34|114|101|99|97|112|45|115|105|122|101|34|59|115|58|54|58|34|110|111|114|109|97|108|34|59|125|105|58|54|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|49|58|34|54|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;/**/\r\n	background-position: bottom right;\r\n  	[endif]\r\n	font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n}\r\n\r\n#[SHELL_ID] h3 {\r\n  	font-weight: bold;\r\n  	font-size: 24px;\r\n  	margin-top: 30px;\r\n  	margin-bottom: 15px;\r\n}\r\n\r\n#[SHELL_ID] label {\r\n  	font-weight: bold;\r\n}\r\n\r\n#[SHELL_ID] form {\r\n  	padding: 0 25px 25px;\r\n	[if bg_type_1 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n  	/*padding-left: 10px;/**/\r\n  	color: #FFF;\r\n	width: 100%;\r\n  	font-size: 14px;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	border: 1px solid #FFF;\r\n  	color: #FFF;\r\n    padding: 10px;\r\n    width: 100%;\r\n    line-height: normal;\r\n  	background-color: inherit;\r\n    hyphens: none;\r\n    border-radius: 4px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n\r\n#[SHELL_ID] .g-recaptcha {\r\n	min-height: 60px;\r\n}\r\n\r\n#[SHELL_ID] [type=\"submit\"] {\r\n  	margin-top: 40px !important;\r\n	width: 150px !important;\r\n  	font-size: 24px;\r\n  	text-transform: capitalize !important;\r\n  	border-radius: 25px !important;\r\n  	float: right;\r\n}','sort_order' => '5','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'tea-time.png'),
				'bjl17b' => array('unique_id' => 'bjl17b','label' => 'Opacity Grey','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|101|102|54|49|54|49|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|100|100|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|50|49|52|58|34|60|100|105|118|32|99|108|97|115|115|61|92|34|112|97|112|101|114|45|112|108|97|110|101|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|112|97|112|101|114|45|112|108|97|110|101|46|112|110|103|92|34|32|47|62|60|47|100|105|118|62|60|100|105|118|32|99|108|97|115|115|61|92|34|102|97|32|102|97|45|112|97|112|101|114|45|112|108|97|110|101|45|111|92|34|62|194|160|60|47|100|105|118|62|60|104|51|62|67|111|110|116|97|99|116|32|85|115|60|47|104|51|62|60|112|62|68|111|110|92|39|116|32|104|101|115|105|116|97|116|101|32|116|111|32|99|111|110|116|97|99|116|32|117|115|44|32|119|101|92|39|108|108|32|97|110|115|119|101|114|32|121|111|117|32|115|111|111|110|33|60|47|112|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|112|104|111|110|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Raleway\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_0]\", 0.85)}};\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: Raleway, sans-serif !important;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	color: [bg_color_2];\r\n  	background-color: #FFF;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: Raleway, sans-serif;\r\n}\r\n#[SHELL_ID].cfsFormShell .row {\r\n	margin-left: 0;\r\n  	margin-right: 0;\r\n}','sort_order' => '6','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'opacity-grey.png'),
				'bjl17a' => array('unique_id' => 'bjl17a','label' => 'Spearmint','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|57|57|57|57|57|57|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|48|53|102|99|98|50|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|49|101|55|51|98|101|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|53|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '@import url(\'https://fonts.googleapis.com/css?family=Kaushan+Script\'); \r\n\r\n#[SHELL_ID] {\r\n	[if bg_type_0 == \'color\']\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \'img\']\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n  	[if bg_type_1 == \'color\']\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: transparent;\r\n  	[elseif bg_type_1 == \'img\']\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n    hyphens: none;\r\n    border-radius: 2px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \'Kaushan Script\', sans-serif;\r\n}\r\n#[SHELL_ID].cfsFormShell .row {\r\n	margin-left: 0;\r\n  	margin-right: 0;\r\n}','sort_order' => '7','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'light-grey.png'),
				'bjl17c' => array('unique_id' => 'bjl17c','label' => 'Support Service','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|52|54|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|52|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|50|58|34|112|120|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|101|102|102|49|102|54|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|54|54|54|48|53|57|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|50|102|53|97|55|56|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|52|50|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|98|103|95|115|117|112|112|111|114|116|95|102|111|114|109|46|106|112|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|57|51|54|58|34|60|100|105|118|32|99|108|97|115|115|61|92|34|97|98|111|117|116|92|34|62|13|10|32|32|32|32|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|115|117|112|112|111|114|116|95|105|109|97|103|101|46|112|110|103|92|34|32|47|62|13|10|32|32|32|32|60|100|105|118|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|110|97|109|101|92|34|62|74|111|104|110|32|83|110|111|119|60|47|112|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|114|111|108|101|92|34|62|67|108|105|101|110|116|32|83|101|114|118|105|99|101|60|47|112|62|13|10|32|32|32|32|32|32|32|32|32|60|112|32|99|108|97|115|115|61|92|34|115|111|99|95|105|99|111|110|115|92|34|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|119|119|119|46|102|97|99|101|98|111|111|107|46|99|111|109|47|115|117|112|115|121|115|116|105|99|47|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|102|98|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|102|97|99|101|98|111|111|107|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|116|119|105|116|116|101|114|46|99|111|109|47|115|117|112|115|121|115|116|105|99|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|116|119|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|116|119|105|116|116|101|114|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|32|32|32|32|32|60|97|32|104|114|101|102|61|92|34|104|116|116|112|115|58|47|47|112|108|117|115|46|103|111|111|103|108|101|46|99|111|109|47|117|47|48|47|49|48|51|48|56|52|48|53|51|50|52|48|49|57|54|52|54|55|52|53|56|47|112|111|115|116|115|92|34|32|116|97|114|103|101|116|61|92|34|95|98|108|97|110|107|92|34|32|99|108|97|115|115|61|92|34|103|45|112|108|117|115|92|34|62|60|105|109|103|32|115|114|99|61|92|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|103|111|111|103|108|101|45|112|108|117|115|45|105|99|111|110|46|112|110|103|92|34|32|47|62|60|47|97|62|13|10|32|32|32|32|32|32|32|32|60|47|112|62|13|10|32|32|32|32|60|47|100|105|118|62|13|10|60|47|100|105|118|62|13|10|60|112|32|99|108|97|115|115|61|92|34|100|101|115|99|114|105|112|116|105|111|110|92|34|62|70|101|101|108|32|102|114|101|101|32|116|111|32|99|111|110|116|97|99|116|32|117|115|32|97|110|100|32|100|111|110|226|128|153|116|32|119|111|114|114|121|44|32|101|118|101|114|121|116|104|105|110|103|32|103|111|110|110|97|32|98|101|32|111|107|46|32|89|111|117|32|99|97|110|32|97|108|115|111|32|103|101|116|32|105|110|32|116|111|117|99|104|32|119|105|116|104|32|117|115|32|111|110|32|116|104|101|32|115|111|99|105|97|108|32|110|101|116|119|111|114|107|115|32|121|111|117|32|99|97|110|32|102|105|110|100|32|97|98|111|118|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|60|47|112|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|56|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|115|101|108|101|99|116|98|111|120|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|56|58|34|113|117|101|115|116|105|111|110|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|115|58|55|58|34|111|112|116|105|111|110|115|34|59|97|58|54|58|123|105|58|48|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|49|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|56|58|34|81|117|101|115|116|105|111|110|34|59|125|105|58|49|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|50|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|55|58|34|80|114|111|98|108|101|109|34|59|125|105|58|50|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|51|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|48|58|34|83|117|103|103|101|115|116|105|111|110|34|59|125|105|58|51|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|52|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|49|58|34|80|97|114|116|110|101|114|115|104|105|112|34|59|125|105|58|52|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|53|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|51|48|58|34|82|101|113|117|101|115|116|32|102|111|114|32|67|117|115|116|111|109|32|68|101|118|101|108|111|112|109|101|110|116|34|59|125|105|58|53|59|97|58|50|58|123|115|58|52|58|34|110|97|109|101|34|59|115|58|49|58|34|54|34|59|115|58|53|58|34|108|97|98|101|108|34|59|115|58|53|58|34|79|116|104|101|114|34|59|125|125|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|51|58|34|69|109|97|105|108|32|65|100|100|114|101|115|115|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|56|58|34|69|110|116|101|114|32|121|111|117|114|32|109|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|52|34|59|125|125:ORD_ENC','html' => '[form_start]\n[fields]\n[form_end]','css' => '#[SHELL_ID] {\r\n  	[if bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[elseif bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	[else]\r\n  	background-color: #FFF;\r\n  	[endif]\r\n  	font-family: sans-serif;\r\n  	padding: 20px;\r\n  	width: 380px;\r\n}\r\n\r\n#[SHELL_ID] .about,\r\n#[SHELL_ID] p {\r\n  	margin: 0;\r\n	text-align: center;\r\n  	color: #FFF;\r\n  	font-size: 14px;\r\n  	line-height: 1em;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell {\r\n	position: relative;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell select {\r\n	position: absolute;\r\n  	padding-left: 5px;\r\n  	top: 0;\r\n  	left: 0;\r\n  	width: 100%;\r\n  	height: 100%;\r\n  	box-sizing: border-box;\r\n  	font-family: sans-serif;\r\n  	font-size: 12px;\r\n  	color: #666059;\r\n}\r\n\r\n#[SHELL_ID] p.description {\r\n  	line-height: 18px;\r\n}\r\n\r\n#[SHELL_ID] .about div {\r\n	height: 100px;\r\n  	margin-bottom: 20px;\r\n  	margin-right: 40px;\r\n}\r\n\r\n#[SHELL_ID] div .name {\r\n	font-size: 30px;\r\n  	line-height: 1.8em;\r\n}\r\n\r\n#[SHELL_ID] div .role {\r\n    margin-top: -5px;\r\n}\r\n\r\n#[SHELL_ID] .about > img {\r\n  	width: 100px;\r\n  	height: 100px;\r\n  	margin-right: 20px;\r\n  	margin-bottom: 20px;\r\n  	float: left;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons {\r\n  	margin-top: 17px;\r\n	margin-left: 120px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a {\r\n  	font-size: 0;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons a + a {\r\n  	padding-left: 3px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img {\r\n  	display: inline-block;\r\n	height: 16px;\r\n  	width: 16px;\r\n}\r\n\r\n#[SHELL_ID] .soc_icons img:hover {\r\n  	opacity: 0.5;\r\n}\r\n\r\n\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n  	[if bg_type_2 == \'color\']\r\n	border: 1px solid {{adjust_opacity(\"[bg_color_2]\", 0.5)}};\r\n  	[endif]\r\n  	[if bg_type_0 == \'color\']\r\n	background-color: [bg_color_0];\r\n  	[endif]\r\n  	[if bg_type_1 == \'color\']\r\n	color: [bg_color_1];\r\n  	[endif]  \r\n    hyphens: none;\r\n    border-radius: 3px;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] input:focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n    outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \'color\']\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \'img\']\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	width: 50%;\r\n  	float: right;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \'img\']\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \'color\']\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \'img\']\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n}','sort_order' => '8','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'kiwifruit.png'),
				'ajl17d' => array('unique_id' => 'ajl17d','label' => 'Ho Ho Ho','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|53|56|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|57|57|57|57|57|57|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|102|50|48|102|48|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|102|50|48|102|48|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|52|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|52|34|59|115|58|51|57|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|50|48|49|54|95|104|116|95|49|95|98|103|46|106|112|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|52|34|59|115|58|55|58|34|35|102|102|48|102|48|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|53|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|53|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|53|34|59|115|58|55|58|34|35|102|50|48|102|48|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|54|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|54|34|59|115|58|53|51|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|50|48|49|54|95|104|116|95|49|95|99|114|105|115|116|95|119|114|101|110|99|104|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|54|34|59|115|58|48|58|34|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|55|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|55|34|59|115|58|52|54|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|50|48|49|54|95|104|116|95|49|95|115|97|110|116|97|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|55|34|59|115|58|48|58|34|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|49|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|55|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|49|52|55|58|34|60|112|62|72|111|32|72|111|32|72|111|32|77|101|114|114|121|32|67|104|114|105|115|116|109|97|115|33|60|47|112|62|13|10|60|104|51|62|67|79|78|84|65|67|84|32|85|83|60|47|104|51|62|13|10|60|104|52|62|73|102|32|121|111|117|32|104|97|118|101|32|97|110|121|32|113|117|101|115|116|105|111|110|115|32|102|101|101|108|32|102|114|101|101|32|116|111|32|99|111|110|116|97|99|116|32|117|115|33|60|47|104|52|62|13|10|60|100|105|118|32|99|108|97|115|115|61|92|34|99|102|115|83|110|111|119|92|34|62|60|47|100|105|118|62|13|10|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|49|53|52|58|34|60|100|105|118|32|99|108|97|115|115|61|92|34|99|102|115|87|114|97|112|73|109|103|87|114|101|110|99|104|92|34|62|13|10|9|60|100|105|118|32|99|108|97|115|115|61|92|34|99|102|115|73|109|103|87|114|101|110|99|104|92|34|62|60|47|100|105|118|62|13|10|60|47|100|105|118|62|13|10|60|100|105|118|32|99|108|97|115|115|61|92|34|99|102|115|87|114|97|112|73|109|103|83|97|110|116|97|92|34|62|13|10|9|60|100|105|118|32|99|108|97|115|115|61|92|34|99|102|115|73|109|103|83|97|110|116|97|92|34|62|60|47|100|105|118|62|13|10|60|47|100|105|118|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|54|59|97|58|49|56|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|49|48|58|34|67|111|110|116|97|99|116|32|85|115|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|56|58|34|99|102|115|82|105|103|104|116|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|50|58|34|118|97|108|117|101|95|112|114|101|115|101|116|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|56|34|59|125|125:ORD_ENC','html' => '<link href=\"https://fonts.googleapis.com/css?family=Pacifico|Raleway|Raleway:800\" rel=\"stylesheet\"/>\r\n[form_start]\r\n[fields]\r\n[form_end]','css' => '#[SHELL_ID] {\r\n	[if bg_type_0 == \"color\"]\r\n  	background-color: [bg_color_0];\r\n  	[elseif bg_type_0 == \"img\"]\r\n  	background-image: url(\"[bg_img_0]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	\r\n	font-family: \"Raleway\";\r\n	text-align: center;\r\n	\r\n	-webkit-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect select, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 14px;\r\n    line-height: normal;\r\n	margin: 0;\r\n  	[if bg_type_1 == \"color\"]\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.5)}};\r\n    color: {{adjust_opacity(\"[bg_color_1]\", 1)}};\r\n  	background-color: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	hyphens: none;\r\n    border-radius: 2px;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	font-family: \"Raleway\";\r\n  	height: auto;\r\n}\r\n#[SHELL_ID] .cfsListSelect {\r\n	border: 1px solid transparent;\r\n	padding: 0px;\r\n}\r\n\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	[if bg_type_2 == \"color\"]\r\n  	background-color: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n  	box-shadow: rgba(0, 0, 0, 0.0980392) 0px 4px 0px 0px inset;\r\n  	width: 150px;\r\n	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \"color\"]\r\n  	background-color: {{adjust_opacity(\"[bg_color_2]\", 0.7)}};\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(153, 153, 153, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n/**/\r\n#[SHELL_ID] .csfForm {\r\n	display: inline-block;\r\n	text-align: left;\r\n    padding: 0 0 20px;\r\n    width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row {\r\n	width: 80%;\r\n	margin: 0 auto;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(2)  {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:first-of-type {\r\n    [if bg_type_4 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(\"[bg_color_4]\", 50) }}), color-stop(100%, [bg_color_4])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(\"[bg_color_4]\", 50) }} 0%, [bg_color_4] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(\"[bg_color_4]\", 50) }}\", endColorstr=\"[bg_color_4]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_4 == \"img\"]\r\n	background-image: url(\"[bg_img_4]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n	[endif]\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:first-of-type .cfsFieldCol {\r\n	[if bg_type_5 == \"color\"]\r\n	background: {{ hex_to_rgba_str(\"[bg_color_5]\", 0.9) }};\r\n	[elseif bg_type_5 == \"img\"]\r\n	background-image: url(\"[bg_img_5]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n	[endif]\r\n	text-align: center;\r\n	position: relative;\r\n	width: 100%;\r\n	min-height: 329px;\r\n}\r\n/*\r\n#[SHELL_ID] .cfsImgWrench {\r\n	[if bg_type_6 == \"img\"]\r\n	background-image: url(\"[bg_img_6]\");\r\n	background-repeat: no-repeat;\r\n    background-size: 75% auto;\r\n    height: 130px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsImgSanta {\r\n	[if bg_type_7 == \"img\"]\r\n	background-image: url(\"[bg_img_7]\");\r\n	background-repeat: no-repeat;\r\n	background-size: 100% auto;\r\n    height: 235px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsNewYearBg > div {\r\n	vertical-align: middle;\r\n}*/\r\n\r\n#[SHELL_ID] .cfsWrapImgWrench {\r\n	margin-right: 130px;\r\n	text-align: center;\r\n	position: relative;\r\n	z-index: 100;\r\n	bottom: 67px;\r\n	width: 50%;\r\n}\r\n#[SHELL_ID] .cfsImgWrench {\r\n	position: absolute;\r\n	right: -65px;\r\n	\r\n	[if bg_type_6 == \"img\"]\r\n	background-image: url(\"[bg_img_6]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n    height: 130px;\r\n    width: 130px;\r\n	[endif]\r\n}\r\n#[SHELL_ID] .cfsWrapImgSanta {\r\n	position: relative;\r\n	z-index: 100;\r\n}\r\n#[SHELL_ID] .cfsImgSanta {\r\n	position: absolute;\r\n	top: -130px;\r\n	right: 0%;\r\n	[if bg_type_7 == \"img\"]\r\n	background-image: url(\"[bg_img_7]\");\r\n	background-repeat: no-repeat;\r\n	background-size: cover;\r\n    height: 235px;\r\n    width: 189px;\r\n	[endif]\r\n}\r\n\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n	margin-bottom: 20px;\r\n	padding-bottom: 100px;\r\n	text-align: center;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) p {\r\n	text-align: center;\r\n	padding: 40px 0 0;\r\n	font-size: 20px;\r\n	font-family: \"Pacifico\";\r\n	color: #fff;\r\n	margin: 0px;\r\n	word-wrap: break-word;\r\n	display: inline-block;\r\n	width: 90%;\r\n	position: relative;\r\n    z-index: 100;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n	color: #fff;\r\n	text-align: center;\r\n	font-size: 70px;\r\n	font-weight: 800;\r\n	letter-spacing: -1px;\r\n	margin: 20px 0 0;\r\n	word-wrap: break-word;\r\n	display: block;\r\n	padding: 0;\r\n	position: relative;\r\n    z-index: 100;\r\n	line-height: 60px;\r\n}\r\n#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n	text-align: center;\r\n	font-size: 20px;\r\n	font-weight: normal;\r\n\r\n	margin: 15px 0 130px;\r\n	border: 2px solid #fff;\r\n	padding: 14px 20px;\r\n	-webkit-border-radius: 2px;\r\n	-moz-border-radius: 2px;\r\n	border-radius: 2px;\r\n	color: #fff;\r\n\r\n	word-wrap: break-word;\r\n	display: inline-block;\r\n	width: 90%;\r\n	position: relative;\r\n    z-index: 100;\r\n}\r\n#[SHELL_ID] .cfsSnow {\r\n	z-index: 0;\r\n	position: absolute;\r\n	top: 0;\r\n	left: 0;\r\n	height: 100%;\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .cfsRight {\r\n	float: right;\r\n}\r\n#[SHELL_ID] .cfsContactMsg {\r\n	width: 100%;\r\n	text-align: center;\r\n}\r\n\r\n@media (max-width: 300px) {\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n		font-size: 33px;\r\n		line-height: 40px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n		padding-bottom: 50px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n		margin: 15px 0 70px;\r\n	}\r\n	#[SHELL_ID] .cfsImgSanta {\r\n		display: none;\r\n	}\r\n}\r\n@media (min-width: 300px) and (max-width: 768px) {\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h3 {\r\n		font-size: 50px;\r\n		line-height: 50px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(1) h4 {\r\n		margin: 15px 0 70px;\r\n	}\r\n	#[SHELL_ID] .csfForm  > .row:nth-of-type(2) .cfsFieldCol {\r\n		padding-bottom: 50px;\r\n	}\r\n	#[SHELL_ID] .cfsImgSanta {\r\n		display: none;\r\n	}\r\n}','sort_order' => '20','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => 'Ho-ho-ho-template-prev.png'),
				'cbrl7b' => array('unique_id' => 'cbrl7b','label' => 'Merry Christmas','active' => '1','original_id' => '0','params' => '97|58|53|58|123|115|58|49|57|58|34|101|110|97|98|108|101|70|111|114|77|101|109|98|101|114|115|104|105|112|34|59|115|58|49|58|34|48|34|59|115|58|51|58|34|116|112|108|34|59|97|58|53|50|58|123|115|58|53|58|34|119|105|100|116|104|34|59|115|58|51|58|34|49|48|48|34|59|115|58|49|51|58|34|119|105|100|116|104|95|109|101|97|115|117|114|101|34|59|115|58|49|58|34|37|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|48|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|48|34|59|115|58|52|53|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|98|103|47|115|99|102|45|114|101|100|45|98|97|99|107|103|114|111|117|110|100|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|48|34|59|115|58|55|58|34|35|51|51|51|51|51|51|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|49|34|59|115|58|52|58|34|110|111|110|101|34|59|115|58|56|58|34|98|103|95|105|109|103|95|49|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|49|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|50|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|50|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|50|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|51|34|59|115|58|53|58|34|99|111|108|111|114|34|59|115|58|56|58|34|98|103|95|105|109|103|95|51|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|51|34|59|115|58|55|58|34|35|102|102|102|102|102|102|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|52|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|52|34|59|115|58|52|57|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|115|99|102|45|116|111|112|45|105|109|103|45|115|110|111|119|45|49|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|52|34|59|115|58|48|58|34|34|59|115|58|57|58|34|98|103|95|116|121|112|101|95|53|34|59|115|58|51|58|34|105|109|103|34|59|115|58|56|58|34|98|103|95|105|109|103|95|53|34|59|115|58|52|57|58|34|91|67|70|83|95|65|83|83|69|84|83|95|85|82|76|93|105|109|103|47|105|109|97|103|101|115|47|115|99|102|45|116|111|112|45|105|109|103|45|115|110|111|119|45|50|46|112|110|103|34|59|115|58|49|48|58|34|98|103|95|99|111|108|111|114|95|53|34|59|115|58|48|58|34|34|59|115|58|49|57|58|34|102|105|101|108|100|95|101|114|114|111|114|95|105|110|118|97|108|105|100|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|34|59|115|58|50|56|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|99|111|110|116|97|99|116|105|110|103|32|117|115|33|34|59|115|58|49|57|58|34|102|111|114|109|95|115|101|110|116|95|109|115|103|95|99|111|108|111|114|34|59|115|58|55|58|34|35|52|97|101|56|101|97|34|59|115|58|49|52|58|34|104|105|100|101|95|111|110|95|115|117|98|109|105|116|34|59|115|58|49|58|34|48|34|59|115|58|49|56|58|34|114|101|100|105|114|101|99|116|95|111|110|95|115|117|98|109|105|116|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|116|101|115|116|95|101|109|97|105|108|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|49|51|58|34|115|97|118|101|95|99|111|110|116|97|99|116|115|34|59|115|58|49|58|34|49|34|59|115|58|57|58|34|101|120|112|95|100|101|108|105|109|34|59|115|58|49|58|34|59|34|59|115|58|49|53|58|34|102|98|95|99|111|110|118|101|114|116|95|98|97|115|101|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|112|117|98|95|112|111|115|116|95|116|121|112|101|34|59|115|58|52|58|34|112|111|115|116|34|59|115|58|49|53|58|34|112|117|98|95|112|111|115|116|95|115|116|97|116|117|115|34|59|115|58|55|58|34|112|117|98|108|105|115|104|34|59|115|58|50|51|58|34|114|101|103|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|56|58|34|115|117|98|95|100|101|115|116|34|59|115|58|49|50|58|34|119|112|95|115|117|98|115|99|114|105|98|101|34|59|115|58|50|51|58|34|115|117|98|95|119|112|95|99|114|101|97|116|101|95|117|115|101|114|95|114|111|108|101|34|59|115|58|49|48|58|34|115|117|98|115|99|114|105|98|101|114|34|59|115|58|49|56|58|34|115|117|98|95|97|114|95|102|111|114|109|95|97|99|116|105|111|110|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|115|117|98|95|102|101|101|100|98|95|107|101|121|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|115|117|98|95|115|103|97|95|105|100|34|59|115|58|48|58|34|34|59|115|58|49|53|58|34|115|117|98|95|115|103|97|95|108|105|115|116|95|105|100|34|59|115|58|48|58|34|34|59|115|58|50|49|58|34|115|117|98|95|115|103|97|95|97|99|116|105|118|97|116|101|95|99|111|100|101|34|59|115|58|48|58|34|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|115|101|110|116|34|59|115|58|54|55|58|34|67|111|110|102|105|114|109|97|116|105|111|110|32|108|105|110|107|32|119|97|115|32|115|101|110|116|32|116|111|32|121|111|117|114|32|101|109|97|105|108|32|97|100|100|114|101|115|115|46|32|67|104|101|99|107|32|121|111|117|114|32|101|109|97|105|108|33|34|59|115|58|49|53|58|34|115|117|98|95|116|120|116|95|115|117|99|99|101|115|115|34|59|115|58|50|54|58|34|84|104|97|110|107|32|121|111|117|32|102|111|114|32|115|117|98|115|99|114|105|98|105|110|103|33|34|59|115|58|50|49|58|34|115|117|98|95|116|120|116|95|105|110|118|97|108|105|100|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|50|48|58|34|115|117|98|95|116|120|116|95|101|120|105|115|116|115|95|101|109|97|105|108|34|59|115|58|50|50|58|34|69|109|112|116|121|32|111|114|32|105|110|118|97|108|105|100|32|101|109|97|105|108|34|59|115|58|49|54|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|117|114|108|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|52|58|34|67|111|110|102|105|114|109|32|115|117|98|115|99|114|105|112|116|105|111|110|32|111|110|32|91|115|105|116|101|110|97|109|101|93|34|59|115|58|50|53|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|99|111|110|102|105|114|109|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|49|57|55|58|34|89|111|117|32|115|117|98|115|99|114|105|98|101|100|32|111|110|32|115|105|116|101|32|60|97|32|104|114|101|102|61|92|34|91|115|105|116|101|117|114|108|93|92|34|62|91|115|105|116|101|110|97|109|101|93|60|47|97|62|46|32|70|111|108|108|111|119|32|60|97|32|104|114|101|102|61|92|34|91|99|111|110|102|105|114|109|95|108|105|110|107|93|92|34|62|116|104|105|115|32|108|105|110|107|60|47|97|62|32|116|111|32|99|111|109|112|108|101|116|101|32|121|111|117|114|32|115|117|98|115|99|114|105|112|116|105|111|110|46|32|73|102|32|121|111|117|32|100|105|100|32|110|111|116|32|115|117|98|115|99|114|105|98|101|32|104|101|114|101|32|45|32|106|117|115|116|32|105|103|110|111|114|101|32|116|104|105|115|32|109|101|115|115|97|103|101|46|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|115|117|98|106|101|99|116|34|59|115|58|51|55|58|34|91|115|105|116|101|110|97|109|101|93|32|89|111|117|114|32|117|115|101|114|110|97|109|101|32|97|110|100|32|112|97|115|115|119|111|114|100|34|59|115|58|50|56|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|102|114|111|109|34|59|115|58|48|58|34|34|59|115|58|51|49|58|34|115|117|98|95|116|120|116|95|115|117|98|115|99|114|105|98|101|114|95|109|97|105|108|95|109|101|115|115|97|103|101|34|59|115|58|54|53|58|34|85|115|101|114|110|97|109|101|58|32|91|117|115|101|114|95|108|111|103|105|110|93|60|98|114|32|47|62|80|97|115|115|119|111|114|100|58|32|91|112|97|115|115|119|111|114|100|93|60|98|114|32|47|62|91|108|111|103|105|110|95|117|114|108|93|34|59|115|58|50|53|58|34|115|117|98|95|114|101|100|105|114|101|99|116|95|101|109|97|105|108|95|101|120|105|115|116|115|34|59|115|58|48|58|34|34|59|115|58|49|51|58|34|102|105|101|108|100|95|119|114|97|112|112|101|114|34|59|115|58|54|49|58|34|60|100|105|118|32|91|102|105|101|108|100|95|115|104|101|108|108|95|99|108|97|115|115|101|115|93|32|91|102|105|101|108|100|95|115|104|101|108|108|95|115|116|121|108|101|115|93|62|91|102|105|101|108|100|93|60|47|100|105|118|62|34|59|125|115|58|54|58|34|102|105|101|108|100|115|34|59|97|58|54|58|123|105|58|48|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|57|58|34|104|116|109|108|100|101|108|105|109|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|49|48|56|58|34|60|112|62|77|101|114|114|121|32|67|104|114|105|115|116|109|97|115|33|60|47|112|62|13|10|60|104|51|62|73|102|32|121|111|117|32|104|97|118|101|32|115|111|109|101|32|113|117|101|115|116|105|111|110|115|32|111|114|32|111|102|102|101|114|115|32|102|111|114|32|117|115|32|45|32|102|105|108|108|32|116|104|101|32|99|111|110|116|97|99|116|32|102|111|114|109|32|98|101|108|111|119|46|60|47|104|51|62|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|49|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|52|58|34|78|97|109|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|49|48|58|34|102|105|114|115|116|95|110|97|109|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|50|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|53|58|34|69|109|97|105|108|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|101|109|97|105|108|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|51|59|97|58|49|56|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|49|50|58|34|80|104|111|110|101|32|78|117|109|98|101|114|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|52|58|34|116|101|120|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|53|58|34|112|104|111|110|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|50|58|34|118|97|108|117|101|95|112|114|101|115|101|116|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|52|59|97|58|49|55|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|55|58|34|77|101|115|115|97|103|101|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|56|58|34|116|101|120|116|97|114|101|97|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|49|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|55|58|34|109|101|115|115|97|103|101|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|51|58|34|114|111|119|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|48|58|34|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|105|58|53|59|97|58|49|56|58|123|115|58|53|58|34|108|97|98|101|108|34|59|115|58|52|58|34|83|101|110|100|34|59|115|58|49|49|58|34|112|108|97|99|101|104|111|108|100|101|114|34|59|115|58|48|58|34|34|59|115|58|52|58|34|104|116|109|108|34|59|115|58|54|58|34|115|117|98|109|105|116|34|59|115|58|53|58|34|118|97|108|117|101|34|59|115|58|48|58|34|34|59|115|58|57|58|34|109|97|110|100|97|116|111|114|121|34|59|115|58|49|58|34|48|34|59|115|58|52|58|34|110|97|109|101|34|59|115|58|52|58|34|115|101|110|100|34|59|115|58|49|49|58|34|98|115|95|99|108|97|115|115|95|105|100|34|59|115|58|50|58|34|49|50|34|59|115|58|55|58|34|100|105|115|112|108|97|121|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|105|110|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|56|58|34|109|97|120|95|115|105|122|101|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|97|100|100|95|99|108|97|115|115|101|115|34|59|115|58|49|52|58|34|99|102|115|83|117|98|109|105|116|87|105|100|116|104|34|59|115|58|49|48|58|34|97|100|100|95|115|116|121|108|101|115|34|59|115|58|48|58|34|34|59|115|58|56|58|34|97|100|100|95|97|116|116|114|34|59|115|58|48|58|34|34|59|115|58|49|52|58|34|118|110|95|111|110|108|121|95|110|117|109|98|101|114|34|59|115|58|49|58|34|48|34|59|115|58|49|53|58|34|118|110|95|111|110|108|121|95|108|101|116|116|101|114|115|34|59|115|58|49|58|34|48|34|59|115|58|49|48|58|34|118|110|95|112|97|116|116|101|114|110|34|59|115|58|49|58|34|48|34|59|115|58|49|50|58|34|118|97|108|117|101|95|112|114|101|115|101|116|34|59|115|58|48|58|34|34|59|115|58|49|49|58|34|100|101|102|95|99|104|101|99|107|101|100|34|59|115|58|49|58|34|48|34|59|125|125|115|58|54|58|34|115|117|98|109|105|116|34|59|97|58|49|58|123|105|58|48|59|97|58|55|58|123|115|58|50|58|34|116|111|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|52|58|34|102|114|111|109|34|59|115|58|49|52|58|34|97|100|109|105|110|64|109|97|105|108|46|99|111|109|34|59|115|58|50|58|34|99|99|34|59|115|58|48|58|34|34|59|115|58|53|58|34|114|101|112|108|121|34|59|115|58|48|58|34|34|59|115|58|55|58|34|115|117|98|106|101|99|116|34|59|115|58|49|57|58|34|67|111|110|116|97|99|116|32|102|111|114|109|32|115|117|98|109|105|116|34|59|115|58|51|58|34|109|115|103|34|59|115|58|55|51|58|34|60|112|62|72|101|108|108|111|33|60|47|112|62|13|10|60|112|62|84|104|105|115|32|105|115|32|121|111|117|114|32|99|111|110|116|97|99|116|32|102|111|114|109|32|100|97|116|97|58|60|47|112|62|13|10|60|112|62|91|102|111|114|109|95|100|97|116|97|93|60|47|112|62|34|59|115|58|54|58|34|101|110|98|95|99|99|34|59|115|58|49|58|34|48|34|59|125|125|115|58|49|48|58|34|111|112|116|115|95|97|116|116|114|115|34|59|97|58|49|58|123|115|58|57|58|34|98|103|95|110|117|109|98|101|114|34|59|115|58|49|58|34|54|34|59|125|125:ORD_ENC','html' => '<link href=\"https://fonts.googleapis.com/css?family=Raleway|Sacramento\" rel=\"stylesheet\">\r\n<div class=\"cfsWrapImgTopTop\">\r\n	[if bg_type_4 == \"img\"]\r\n	<img src=\"[bg_img_4]\" class=\"cfsImgTopTop\" alt=\"holiday wrench\"/>\r\n	[endif]\r\n</div>\r\n[form_start]\r\n[fields]\r\n[form_end]\r\n<div class=\"cfsWrapImgTopBtm\">\r\n	[if bg_type_5 == \"img\"]\r\n	<img src=\"[bg_img_5]\" class=\"cfsImgTopBtm\"/>\r\n	[endif]\r\n</div>','css' => '#[SHELL_ID] {\r\n	font-family: \"Raleway\";\r\n	[if bg_type_0 == \"color\"]\r\n	background: -moz-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* ff3.6+ */\r\n	background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, {{ adjust_brightness(\"[bg_color_0]\", 50) }}), color-stop(100%, [bg_color_0])); /* safari4+,chrome */\r\n	background:-webkit-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* safari5.1+,chrome10+ */\r\n	background: -o-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* opera 11.10+ */\r\n	background: -ms-radial-gradient(center, ellipse cover, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* ie10+ */\r\n	background:radial-gradient(ellipse at center, {{ adjust_brightness(\"[bg_color_0]\", 50) }} 0%, [bg_color_0] 100%); /* w3c */\r\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\"{{ adjust_brightness(\"[bg_color_0]\", 50) }}\", endColorstr=\"[bg_color_0]\",GradientType=1 ); /* ie6-9 */\r\n	[elseif bg_type_0 == \"img\"]\r\n	background-image: url(\"[bg_img_0]\");\r\n	background-repeat: no-repeat;\r\n	background-size: 100% 100%;\r\n	[endif]\r\n	-webkit-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	-moz-box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n	box-shadow: 0 0 7px rgba(0,0,0,0.5);\r\n  	color: #FFF;\r\n	text-align: center;\r\n}\r\n#[SHELL_ID] label {\r\n	width: 100%;\r\n	margin: 0 !important;\r\n}\r\n#[SHELL_ID] h3, #[SHELL_ID] p {\r\n  	margin: 10px 0;\r\n  	text-align: center;\r\n  	\r\n}\r\n#[SHELL_ID] .paper-plane {\r\n  	margin-top: 20px;\r\n  	height: 32px;\r\n  	text-align: center;\r\n}\r\n#[SHELL_ID] .cfsCheckTbl label {\r\n	font-size: 12px;\r\n}\r\n#[SHELL_ID] .cfsFieldShell > label {\r\n	font-size: 14px;\r\n}\r\n#[SHELL_ID] .cfsCheckTbl {\r\n	margin: 0;\r\n}\r\n/*Fields shell basic*/\r\n#[SHELL_ID] .cfsFieldShell input:not([type=\"checkbox\"]):not([type=\"radio\"]),\r\n#[SHELL_ID] .cfsFieldShell textarea,\r\n#[SHELL_ID] .cfsFieldShell .cfsListSelect select, \r\n#[SHELL_ID] .cfsFieldShell .cfsCheck,\r\n#[SHELL_ID] .cfsFieldShell button {\r\n    padding: 10px;\r\n    width: 100%;\r\n    font-size: 12px;\r\n    line-height: normal;\r\n	margin: 0;\r\n    hyphens: none;\r\n    border-radius: 0;\r\n    margin: 0;\r\n    max-width: 100%;\r\n    vertical-align: baseline;\r\n  	display: block;\r\n  	color: #FFF;\r\n  	font-family: \"Raleway\" !important;\r\n  	height: auto;\r\n	\r\n	[if bg_type_1 == \"color\"]\r\n  	border: 1px solid {{adjust_opacity(\"[bg_color_1]\", 0.1)}};\r\n  	background: {{adjust_brightness(\"[bg_color_1]\", 196)}};\r\n  	[elseif bg_type_1 == \"img\"]\r\n  	background-image: url(\"[bg_img_1]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[else]\r\n  	border: 1px solid transparent;\r\n  	border-bottom-color: #FFF;\r\n  	background: transparent;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsListSelect select:not([multiple]) option {\r\n	color: #000;\r\n}\r\n#[SHELL_ID] .cfsListSelect {\r\n	border: 1px solid transparent;\r\n	padding: 0px;\r\n	display: block;\r\n}\r\n#[SHELL_ID] input:not([type=\"checkbox\"]):not([type=\"radio\"]):focus,\r\n#[SHELL_ID] textarea:focus,\r\n#[SHELL_ID] .cfsListSelect:focus, \r\n#[SHELL_ID] .cfsCheck:focus {\r\n  	outline: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n	cursor: pointer;\r\n	padding: 10px 10px 8px;\r\n  	font-weight: 700;\r\n    border: 0 none;\r\n    color: #fff;\r\n    text-transform: uppercase;\r\n  	-webkit-appearance: none;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"], \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"],\r\n#[SHELL_ID] .cfsFieldShell button {\r\n  	/* text-transform: capitalize;/**/\r\n	[if bg_type_2 == \"color\"]\r\n  	background: [bg_color_2];\r\n  	background-image: none;\r\n  	[elseif bg_type_2 == \"img\"]\r\n  	background-image: url(\"[bg_img_2]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	color: #8C141A;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"submit\"]:hover, \r\n#[SHELL_ID] .cfsFieldShell input[type=\"button\"]:hover,\r\n#[SHELL_ID] .cfsFieldShell button:hover {\r\n  	[if bg_type_2 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"] {\r\n	[if bg_type_3 == \"color\"]\r\n  	background-color: [bg_color_3];\r\n  	background-image: none;\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	background-image: url(\"[bg_img_3]\");\r\n  	background-repeat: no-repeat;\r\n  	background-size: cover;\r\n  	[endif]\r\n	color: #8C141A;\r\n}\r\n#[SHELL_ID] .cfsFieldShell input[type=\"reset\"]:hover {\r\n	[if bg_type_3 == \"color\"]\r\n  	background: {{adjust_opacity(\"[bg_color_3]\", 0.7)}};\r\n  	[elseif bg_type_3 == \"img\"]\r\n  	opacity: 0.7;\r\n  	[endif]\r\n}\r\n#[SHELL_ID] .cfsSubmitWidth {\r\n	display: block !important;\r\n	width: auto !important;\r\n	min-width: 50% !important;\r\n	margin: 0 auto !important;\r\n	-webkit-box-shadow: 1px 1px 5px #aaa;\r\n	-moz-box-shadow: 1px 1px 5px #aaa;\r\n	box-shadow: 1px 1px 5px #aaa;\r\n}\r\n/* Placeholder text color -- selectors need to be separate to work. */\r\n#[SHELL_ID] ::-webkit-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] :-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n#[SHELL_ID] ::-moz-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n	opacity: 1; /* Since FF19 lowers the opacity of the placeholder by default */\r\n}\r\n#[SHELL_ID] :-ms-input-placeholder {\r\n	color: rgba(255, 255, 255, 0.5);\r\n  	font-family: \"Raleway\";\r\n}\r\n\r\n#[SHELL_ID] .csfForm  {\r\n	display: inline-block;\r\n	width: 100%;\r\n	text-align: left;\r\n}\r\n#[SHELL_ID] .cfsWrapImgTopTop {\r\n	padding: 0;\r\n	margin: 0;\r\n	line-height: 0;\r\n}\r\n#[SHELL_ID] .cfsImgTopTop {\r\n	/*width: 100%;*/\r\n}\r\n#[SHELL_ID] .cfsWrapImgTopBtm {\r\n	padding: 0;\r\n	margin: 0;\r\n	line-height: 0;\r\n}\r\n#[SHELL_ID] .cfsImgTopBtm  {\r\n	/*width: 100%;*/\r\n}\r\n#[SHELL_ID] .row:first-of-type {\r\n	width: 100%;\r\n}\r\n#[SHELL_ID] .row {\r\n	margin: 0 auto;\r\n    width: 60%;\r\n}\r\n#[SHELL_ID] .row:first-of-type p {\r\n	color: #fff;\r\n	text-align: center;\r\n	line-height: 63px;\r\n	letter-spacing: -1px;\r\n	margin: 0px 0px;\r\n	word-wrap: break-word;\r\n	display: block;\r\n	position: relative;\r\n    z-index: 100;\r\n	font-size: 50px;\r\n	font-weight: 800;\r\n	padding: 0px;\r\n	font-family: \"Sacramento\";\r\n}\r\n#[SHELL_ID] .row:first-of-type h3 {\r\n	color: #fff;\r\n	margin: 0px;\r\n	z-index: 100;\r\n	position: relative;\r\n	word-wrap: break-word;\r\n	z-index: 100;\r\n	display: block;\r\n	padding: 0;\r\n	font-size: 25px;\r\n	font-family: \"Sacramento\";\r\n	font-weight: normal;\r\n}\r\n#[SHELL_ID] .cfsContactMsg {\r\n	width: 100%;\r\n	text-align: center;\r\n}','sort_order' => '21','date_created' => '2016-05-03 15:01:03','is_pro' => '0','img_preview' => '141-merry-cristmas-prev.png'),
			);
		}
// 		foreach($data as $uid => $d) {
// 			self::installDataByUid('@__forms', $uid, $d);
// 		}
// 	}
// 	static public function installDataByUid($tbl, $uid, $data) {
// 		$id = (int) dbCfs::get("SELECT id FROM $tbl WHERE unique_id = '$uid' AND original_id = 0", 'one');
// 		$action = $id ? 'UPDATE' : 'INSERT INTO';
// 		$values = array();
// 		foreach($data as $k => $v) {
// 			$values[] = "$k = \"$v\"";
// 		}
// 		$valuesStr = implode(',', $values);
// 		$query = "$action $tbl SET $valuesStr";
// 		if($action == 'UPDATE')
// 			$query .= " WHERE unique_id = '$uid' AND original_id = 0";
// 		if(dbCfs::query($query)) {
// 			return $action == 'UPDATE' ? $id : dbCfs::insertID();
// 		}
// 		return false;
// 	}
// }

	foreach($data as $uid => $d) {
		self::installDataByUid('@__forms', $uid, $d);
	}
}
static public function installDataByUid($tbl, $uid, $data) {
	global $wpdb;
	//$id = (int) dbCfs::get("SELECT id FROM $tbl WHERE unique_id = '$uid' AND original_id = 0", 'one');
	$id = (int) $wpdb->get_var(
		$wpdb->prepare("SELECT id FROM {$wpdb->prefix}cfs_forms WHERE unique_id = %s AND original_id = 0", $uid)
	);
	$data['html'] = str_replace(array('\n', '\r', '\r\n'), '', $data['html']);
	$data['html'] = str_replace('\\', '', $data['html']);
	$action = $id ? 'UPDATE' : 'INSERT INTO';
	if($action == 'UPDATE') {
		$tableName = $wpdb->prefix . "cfs_forms";
		$data_update = array(
			'unique_id' => $data['unique_id'],
			'label' => $data['label'],
			'original_id' => $data['original_id'],
			'params' => $data['params'],
			'html' => $data['html'],
			'css' => $data['css'],
			'img_preview' => $data['img_preview'],
			'sort_order' => $data['sort_order'],
			'active' => $data['active'],
			'actions' => '',
			'is_pro' => $data['is_pro'],
			'date_created' => $data['date_created'],
		);
		$data_where = array('unique_id' => $uid, 'original_id' => 0);
		$res = $wpdb->update($tableName , $data_update, $data_where);
	} else {
		$tableName = $wpdb->prefix . "cfs_forms";
		$res = $wpdb->insert($tableName, array(
			'unique_id' => $data['unique_id'],
			'label' => $data['label'],
			'original_id' => $data['original_id'],
			'params' => $data['params'],
			'html' => $data['html'],
			'css' => $data['css'],
			'img_preview' => $data['img_preview'],
			'sort_order' => $data['sort_order'],
			'active' => $data['active'],
			'actions' => '',
			'is_pro' => $data['is_pro'],
			'date_created' => $data['date_created'],
		));
	}
	if($res) {
		$dataId = $action == 'UPDATE' ? $id : dbCfs::insertID();
		// Make sure that data - is really unique
		//$wrongId = (int) dbCfs::get("SELECT id FROM $tbl WHERE unique_id != '$uid' AND original_id = 0 AND label = '". $data['label']. "'", 'one');
		$wrongId = (int) $wpdb->get_var(
			$wpdb->prepare("SELECT id FROM {$wpdb->prefix}cfs_forms WHERE unique_id != %s AND original_id = 0 AND label = %s", $uid, $data['label'])
		);
		if($wrongId) {
			$tableName = $wpdb->prefix . "cfs_forms";
			$data_where = array('id' => $wrongId);
			$wpdb->delete( $tableName, $data_where);
			$data_update = array(
				'original_id' => $dataId,
			);
			$data_where = array('original_id' => $wrongId);
			$res = $wpdb->update($tableName , $data_update, $data_where);
		}
		return $dataId;
	}
	return false;
}
}
