<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


function vc_utm() {

	global $wpdb;

	$utms  = '?utm_source=ChimpmaticLite';
	$utms .= '&utm_campaign=w' . get_bloginfo( 'version' ) . '-' . mce_difer_dateact_date() . 'c' . WPCF7_VERSION . ( defined( 'WPLANG' ) && WPLANG ? WPLANG : 'en_US' ) . '';
	$utms .= '&utm_medium=cme-' . SPARTAN_MCE_VERSION . '';
	$utms .= '&utm_term=P' . PHP_VERSION . 'Sq' . $wpdb->db_version() . '-';

	return $utms;
}



function mce_panel_gen( $apivalid, $listdata, $cf7_mch, $form_tags_with_types, $mce_txcomodin ) {
	// Data container now rendered as outer wrapper (#cmatic_data.cmatic-inner).
	// See render_open()/render_close() calls in view.php.

	// Progressive disclosure class for field panel (self-contained).
	$disclosure_class = ( '1' === (string) $apivalid ) ? 'chmp-active' : 'chmp-inactive';
	?>

	<div class="mce-custom-fields <?php echo esc_attr( $disclosure_class ); ?>" id="cmatic-fields">

		<?php
		$merge_fields = isset( $cf7_mch['merge_fields'] ) ? $cf7_mch['merge_fields'] : array();

		$max_fields = CMATIC_LITE_MAX_FIELDS;

		for ( $i = 0; $i < $max_fields; $i++ ) {
			$field_index = $i + 3;
			$field_key   = 'field' . $field_index;
			$merge_field = isset( $merge_fields[ $i ] ) ? $merge_fields[ $i ] : null;

			$field_label = 'Field ' . $field_index;
			$field_type  = 'text';
			$is_required = false;
			$description = 'Map a form field to Mailchimp';

			if ( $merge_field ) {
				$field_tag          = $merge_field['tag'] ?? '';
				$field_name         = $merge_field['name'] ?? $field_tag;
				$field_type_from_mc = $merge_field['type'] ?? 'text';

				$field_label = $field_name . ' - *|' . $field_tag . '|* <span class="mce-type">' . esc_html( $field_type_from_mc ) . '</span>';

				if ( $field_tag === 'EMAIL' ) {
					$is_required = true;
					$field_type  = 'email';
					$description = 'MUST be an email tag <a href="' . CHIMPHELP_URL . '/mailchimp-required-email' . vc_utm() . 'MC-email" class="helping-field" target="_blank" title="get help with Subscriber Email:"> Learn More</a>';
				}
			}

			$container_style = ( $merge_field === null ) ? 'display: none;' : '';
			?>
			<div class="mcee-container" style="<?php echo esc_attr( $container_style ); ?>">
			<label for="wpcf7-mailchimp-<?php echo esc_attr( $field_key ); ?>">
				<?php echo $field_label; ?>
				<?php if ( $is_required ) : ?>
				<span class="mce-required">Required</span>
				<?php endif; ?>
			</label>
			<?php mce_render_field_dropdown( $field_key, $form_tags_with_types, $cf7_mch, $field_type ); ?>

			</div>

			<?php } ?>
	 
	</div>

	<?php include SPARTAN_MCE_PLUGIN_DIR . 'lib/pro-features.php'; ?>
<?php } ///end mce_panel_gen() ?>


<?php
// Render combined wrapper: #cmatic_data.cmatic-inner with data attributes.
// PRO inherits via class_exists() pattern.
if ( class_exists( 'Cmatic_Data_Container' ) ) {
	Cmatic_Data_Container::render_open( (int) $mce_txcomodin, (string) $apivalid );
} else {
	echo '<div class="cmatic-inner">';
}
?>

	<?php
	// Render the unified Chimpmatic header.
	if ( class_exists( 'Cmatic_Header' ) ) {
		$api_status = null;
		if ( isset( $apivalid ) && '1' == $apivalid ) {
			$api_status = 'connected';
		} elseif ( isset( $apivalid ) && '0' == $apivalid ) {
			$api_status = 'disconnected';
		}
		Cmatic_Header::output( array( 'api_status' => $api_status ) );
	}
	?>

	<div class="cmatic-content">

	<?php Cmatic_Api_Panel::render( $cf7_mch, (string) $apivalid ); ?>

	<?php
	// Render audiences panel (self-contained with own progressive disclosure).
	// LITE defines, PRO inherits via class_exists() pattern.
	if ( class_exists( 'Cmatic_Audiences' ) ) {
		Cmatic_Audiences::render( (string) $apivalid, $listdata, $cf7_mch );
	}
	?>

	<div id="chmp-new-user" class="new-user <?php echo ( ( $apivalid == 1 ) ? 'chmp-inactive' : 'chmp-active' ); ?>">
		<?php chmp_new_usr(); ?>
	</div>

	<?php
	// Field panel now self-contained with own progressive disclosure class.
	// Moved outside #mce_panel_ajagen for direct visibility control.
	mce_panel_gen( $apivalid, $listdata, $cf7_mch, $form_tags_with_types, $mce_txcomodin );
	?>


	<div id="cme-container" class="mce-custom-fields vc-advanced-settings">
		<?php require SPARTAN_MCE_PLUGIN_DIR . 'lib/tanu.php'; ?>
	</div>


	<p class="p-author"><a type="button" aria-expanded="false" class="vc-view-advanced a-support ">Show Advanced Settings</a> &nbsp; <a class="vc-view-logs cme-trigger-log a-support ">View Debug Logs</a></p>


	<div id="eventlog-sys" class="vc-logs" style="margin-top: 1em; margin-bottom: 1em;">
		<div class="mce-custom-fields">
		<button type="button" class="vc-clear-logs button">Clear Logs</button>
		<pre><code id="log_panel" >Click "View Debug Logs" to fetch the log content.</code></pre>
		</div>
	</div>


	<div class="vc-hidden-start dev-cta mce-cta welcome-panel">
		<div class="welcome-panel-content">
			<?php echo mce_set_welcomebanner(); ?>
		</div>
	</div>

	</div><!-- .cmatic-content -->

<?php
// Close combined wrapper.
if ( class_exists( 'Cmatic_Data_Container' ) ) {
	Cmatic_Data_Container::render_close();
} else {
	echo '</div>';
}
?>
