<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


function wpcf7_mce_form_tags() {
	if ( ! class_exists( 'WPCF7_FormTagsManager' ) ) {
		return array();
	}
	$manager   = WPCF7_FormTagsManager::get_instance();
	$form_tags = $manager->get_scanned_tags();
	return is_array( $form_tags ) ? $form_tags : array();
}

function mce_author() {
	$author_pre   = 'Contact form 7 Mailchimp extension by ';
	$author_name  = 'Renzo Johnson';
	$author_url   = '//renzojohnson.com';
	$author_title = 'Renzo Johnson - Web Developer';

	$mce_author  = '<p style="display: none !important">';
	$mce_author .= $author_pre;
	$mce_author .= '<a href="' . $author_url . '" ';
	$mce_author .= 'title="' . $author_title . '" ';
	$mce_author .= 'target="_blank">';
	$mce_author .= '' . $author_title . '';
	$mce_author .= '</a>';
	$mce_author .= '</p>' . "\n";

	return $mce_author;
}

function mce_referer() {
	if ( isset( $_SERVER['HTTP_REFERER'] ) ) {
		$mce_referer_url = esc_url( $_SERVER['HTTP_REFERER'] );
	} else {
		$mce_referer_url = esc_url( 'Direct Visit' );
	}

	$mce_referer  = '<p style="display: none !important"><span class="wpcf7-form-control-wrap referer-page">';
	$mce_referer .= '<input type="hidden" name="referer-page" ';
	$mce_referer .= 'value="' . $mce_referer_url . '" ';
	$mce_referer .= 'data-value="' . $mce_referer_url . '" ';
	$mce_referer .= 'class="wpcf7-form-control wpcf7-text referer-page" aria-invalid="false">';
	$mce_referer .= '</span></p>' . "\n";

	return $mce_referer;
}

function mce_getRefererPage( $form_tag ) {
	if ( $form_tag['name'] == 'referer-page' ) {
		$form_tag['values'][] = esc_url( $_SERVER['HTTP_REFERER'] );
	}
	return $form_tag;
}

if ( ! is_admin() ) {
	add_filter( 'wpcf7_form_tag', 'mce_getRefererPage' );
}

function mce_init_constants() {
	define( 'MCE_URL', '//chimpmatic.com/help' );
	define( 'MC_URL', '//chimpmatic.com/help' );
	define( 'MCE_AUTH', '//renzojohnson.com' );
	define( 'MCE_AUTH_COMM', '<!-- Chimpmatic -->' );
	define( 'MCE_NAME', 'MailChimp Contact Form 7 Extension' );
	define( 'MCE_SETT', admin_url( 'admin.php?page=wpcf7' ) );
	define( 'MCE_DON', 'https://www.paypal.me/renzojohnson' );
	define( 'CHIMPL_URL', '//chimpmatic.com' );
	define( 'CHIMPHELP_URL', '//chimpmatic.com/help' );
}
add_action( 'init', 'mce_init_constants' );

/**
 * Get the ID of the most recently created Contact Form 7 form.
 *
 * Used by plugin action links to provide quick access to Settings.
 *
 * @since 0.9.37
 * @return int|null Form ID or null if no forms exist.
 */
function cmatic_newest() {
	$forms = get_posts(
		array(
			'post_type'      => 'wpcf7_contact_form',
			'posts_per_page' => 1,
			'orderby'        => 'ID',
			'order'          => 'DESC',
			'post_status'    => 'publish',
			'fields'         => 'ids',
		)
	);

	return ! empty( $forms ) ? $forms[0] : null;
}

function mce_mail_tags() {
	// Get current contact form
	$contact_form = WPCF7_ContactForm::get_current();
	if ( ! $contact_form ) {
		return '';
	}

	// Use CF7's native scanning method - no guesswork!
	$mail_tags = $contact_form->collect_mail_tags();
	if ( empty( $mail_tags ) ) {
		return '';
	}

	// Build mail-tags display
	$tagInfo = '';
	foreach ( $mail_tags as $tag_name ) {
		if ( ! empty( $tag_name ) && $tag_name !== 'opt-in' ) {
			$tagInfo .= '<span class="mailtag code used">[' . esc_html( $tag_name ) . ']</span>';
		}
	}
	return $tagInfo;
}

function plugin_activation( $plugin ) {
	if ( ! function_exists( 'activate_plugin' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}
	if ( ! is_plugin_active( $plugin ) ) {
		activate_plugin( $plugin );
	}
}

if ( ! function_exists( 'chimpmatic_tags' ) ) {
	function chimpmatic_tags( $output, $name, $html ) {
		if ( '_domain' == $name ) {
			$output = chimpmatic_domain();
		}
		if ( '_formID' == $name ) {
			$output = chimpmatic_form_id();
		}
		return $output;
	}
}
add_filter( 'wpcf7_special_mail_tags', 'chimpmatic_tags', 10, 3 );

if ( ! function_exists( 'chimpmatic_add_form_tag_posts' ) ) {
	function chimpmatic_add_form_tag_posts() {
		wpcf7_add_form_tag( '_domain', 'chimpmatic_domain' );
		wpcf7_add_form_tag( '_formID', 'chimpmatic_form_id' );
	}
}
add_action( 'wpcf7_init', 'chimpmatic_add_form_tag_posts', 11 );

if ( ! function_exists( 'chimpmatic_domain' ) ) {
	function chimpmatic_domain() {
		$strToLower       = strtolower( trim( get_home_url() ) );
		$httpPregReplace  = preg_replace( '/^http:\/\//i', '', $strToLower );
		$httpsPregReplace = preg_replace( '/^https:\/\//i', '', $httpPregReplace );
		$wwwPregReplace   = preg_replace( '/^www\./i', '', $httpsPregReplace );
		$explodeToArray   = explode( '/', $wwwPregReplace );
		$finalDomainName  = trim( $explodeToArray[0] );
		return $finalDomainName;
	}
}

if ( ! function_exists( 'chimpmatic_form_id' ) ) {
	function chimpmatic_form_id() {
		if ( class_exists( 'WPCF7_ContactForm' ) && $wpcf7 = WPCF7_ContactForm::get_current() ) {
			return $wpcf7->id();
		}
		return 0;
	}
}


function mce_set_welcomebanner() {
	$default_panel = '<p class="about-description">Hello. My name is Renzo, I <span alt="f487" class="dashicons dashicons-heart red-icon"> </span> WordPress and I develop this free plugin to help users like you. I drink copious amounts of coffee to keep me running longer <span alt="f487" class="dashicons dashicons-smiley red-icon"> </span>. If you\'ve found this plugin useful, please consider making a donation.</p><br>
      <p class="about-description">Would you like to <a class="button-primary" href="http://bit.ly/cafe4renzo" target="_blank">buy me a coffee?</a> or <a class="button-primary" href="http://bit.ly/cafe4renzo" target="_blank">Donate with Paypal</a></p>';

	$banner = get_site_option( 'mce_conten_panel_welcome', $default_panel );
	return empty( trim( $banner ) ) ? $default_panel : $banner;
}


function mce_lateral_banner() {
	?>
	<div id="informationdiv_aux" class="postbox mce-move mc-lateral" style="display:none">
		<?php echo mce_set_lateralbanner(); ?>
	</div>
	<?php
}


function mce_set_lateralbanner() {
	$default_panel = '
      <div class="inside bg-f2"><h3>Upgrade to PRO</h3>
        <p>We have the the best tool to integrate <b>Contact Form 7</b> & <b>Mailchimp.com</b> mailing lists. We have new nifty features:</p>
        <ul>
          <li>Tag Existing Subscribers</li>
          <li>Group Existing Subscribers</li>
          <li>Email Verification</li>
          <li>AWESOME Support And more!</li>
        </ul>
      </div>
      <div class="promo-2022">
        <h1>40<span>%</span> Off!</h1>
        <p class="interesting">Submit your name and email and we\'ll send you a coupon for <b>40% off</b> your upgrade to the pro version.</p>
        <div class="cm-form" id="promo-form-container">
            <!-- Form will be injected by JavaScript after page load to prevent CF7 from stripping it -->
        </div>
      </div>';

	return $default_panel;
}