<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


$mch_tool_autoupdate = get_option( 'chimpmatic-update' );

if ( $mch_tool_autoupdate === '0' or $mch_tool_autoupdate === '1' ) {

	update_option( 'chimpmatic-update', $mch_tool_autoupdate );

} else {

	$deprecated = null;
	$autoload   = 'no';
	add_option( 'chimpmatic-update', '1', $deprecated, $autoload );
	$mch_tool_autoupdate = 1;

} ?>

	<table class="form-table mt0 description">
	<tbody>

		<tr>
		<th scope="row">Double Opt-in</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Double Opt-in</span></legend><label for="wpcf7-mailchimp-cfactive">
			<input type="checkbox" id="wpcf7-mailchimp-conf-subs" name="wpcf7-mailchimp[confsubs]" value="1"<?php echo ( isset( $cf7_mch['confsubs'] ) && '1' == $cf7_mch['confsubs'] ) ? ' checked="checked"' : ''; ?> />
			<?php echo esc_html( __( 'Prevents existing contact details from being updated on resubmission.', 'wpcf7' ) ); ?>  <a href="<?php echo MC_URL; ?>/help/mailchimp-opt-in-checkbox<?php echo vc_utm(); ?>MC-double-opt-in" class="helping-field" target="_blank" title="Get help with Double Opt-in"> Learn More </a></label>
			</fieldset>
		</td>
		</tr>



		<tr>
		<th scope="row">Required Consent</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Required Consent</span></legend>
			<label for="wpcf7-mailchimp-accept">
			<select class="chm-select" id="wpcf7-mailchimp-accept" name="wpcf7-mailchimp[accept]">
				<option value=" " <?php selected( isset( $cf7_mch['accept'] ) ? $cf7_mch['accept'] : ' ', ' ' ); ?>>
				<?php esc_html_e( 'Choose..', 'chimpmatic-lite' ); ?>
				</option>
				<?php foreach ( $checkbox_fields as $field ) : ?>
					<?php
					$field_value = '[' . $field['name'] . ']';
					$saved_value = isset( $cf7_mch['accept'] ) ? $cf7_mch['accept'] : ' ';
					?>
				<option value="<?php echo esc_attr( $field_value ); ?>" <?php selected( $saved_value, $field_value ); ?>>
					<?php echo esc_html( '[' . $field['name'] . ']' ); ?> - type: <?php echo esc_html( $field['basetype'] ); ?>
				</option>
				<?php endforeach; ?>
			</select>
			<br/>
			<small class="description">Select the consent field required for adding contacts to your audience.<a href="<?php echo MC_URL; ?>/help/mailchimp-opt-in-checkbox<?php echo vc_utm(); ?>MC-opt-in-checkbox" class="helping-field" target="_blank" title="Get help with Required Acceptance"> Learn More </a></small>
			</label>
			</fieldset>
		</td>
		</tr>

		<tr class="">
		<th scope="row">Unsubscribed</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Unsubscribed</span></legend><label for="wpcf7-mailchimp-cfactive">
			<input type="checkbox" id="wpcf7-mailchimp-addunsubscr" name="wpcf7-mailchimp[addunsubscr]" value="1"<?php echo ( isset( $cf7_mch['addunsubscr'] ) && '1' == $cf7_mch['addunsubscr'] ) ? ' checked="checked"' : ''; ?> />
			<?php echo esc_html( __( 'Marks submitted contacts as unsubscribed.', 'wpcf7' ) ); ?>  <a href="<?php echo MCE_URL; ?>/mailchimp-opt-in-addunsubscr<?php echo vc_utm(); ?>MC-double-addunsubscr" class="helping-field" target="_blank" title="get help with Custom Fields"> Learn More </a></label>
			</fieldset>
		</td>
		</tr>




		<tr>
		<th scope="row">Debug Logger</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Debug Logger</span></legend><label for="wpcf7-mailchimp-cfactive">
			<input type="checkbox"
				id="wpcf7-mailchimp-logfileEnabled"
				name="wpcf7-mailchimp[logfileEnabled]"
				value="1" <?php checked( $cf7_mch['logfileEnabled'] ?? '0', '1' ); ?>
			/>Enables activity logging to help troubleshoot form issues.</label>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Developer</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Developer</span></legend><label for="wpcf7-mailchimp-cfactive">
			<input type="checkbox" id="wpcf7-mailchimp-cf-support" name="wpcf7-mailchimp[cf-supp]" value="1"<?php echo ( isset( $cf7_mch['cf-supp'] ) && '1' == $cf7_mch['cf-supp'] ) ? ' checked="checked"' : ''; ?> />
			A backlink to my site, not compulsory, but appreciated</label>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Auto Update</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Auto Update</span></legend><label for="wpcf7-mailchimp-updates">
			<input type="checkbox" id="chimpmatic-update" name="chimpmatic-update" value="1"<?php echo ( $mch_tool_autoupdate == '1' ) ? ' checked="checked"' : ''; ?> />
			Auto Update Chimpmatic Lite</label>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">Help Us Improve</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>Help Us Improve Chimpmatic</span></legend><label for="cmatic-telemetry-enabled">
			<input type="checkbox" id="cmatic-telemetry-enabled" name="cmatic-telemetry-enabled" value="1"<?php echo ( mce_get_cmatic( 'telemetry.enabled', true ) ) ? ' checked="checked"' : ''; ?> />
			Help us improve Chimpmatic by sharing anonymous usage data</label>
			</fieldset>
		</td>
		</tr>

		<tr>
		<th scope="row">License Reset</th>
		<td>
			<fieldset><legend class="screen-reader-text"><span>License Reset</span></legend>
			<button type="button" id="cmatic-license-reset-btn" class="button">Reset License Data</button>
			<div id="cmatic-license-reset-message" style="margin-top: 10px;"></div>
			<br/>
			<small class="description">Clears all cached license data. Use this if you see "zombie activation" issues after deactivating your license.</small>
			</fieldset>
		</td>
		</tr>

	</tbody>
	</table>
