<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


/**
 * Mask API key: first 8 chars + bullets + last 4 chars
 */
function cmatic_mask_api_key( $key ) {
	if ( empty( $key ) || strlen( $key ) < 12 ) {
		return $key;
	}
	$prefix = substr( $key, 0, 8 );
	$suffix = substr( $key, -4 );
	return $prefix . str_repeat( '•', 20 ) . $suffix;
}


function generateHeader( $token ) {
	$api_key_part = explode( '-', sanitize_text_field( $token ) )[0] ?? '';
	$user_agent   = 'ChimpMaticLite/' . SPARTAN_MCE_VERSION . '; WordPress/' . get_bloginfo( 'version' );

	return array(
		'headers'   => array(
			'Content-Type'  => 'application/json',
			'Authorization' => 'apikey ' . $api_key_part,
			'User-Agent'    => $user_agent,
		),
		'timeout'   => 20,
		'sslverify' => true,
	);
}


function callApiGet( $token, $url ) {
	$args     = generateHeader( $token );
	$response = wp_remote_get( esc_url_raw( $url ), $args );
	if ( is_wp_error( $response ) ) {
		return array( false, $args, $response );
	}
	$body = wp_remote_retrieve_body( $response );
	return array( json_decode( $body, true ), $args, $response );
}

function callApiPut( $token, $url, $body ) {
	$args           = generateHeader( $token );
	$args['body']   = $body;
	$args['method'] = 'PUT';
	$response       = wp_remote_request( esc_url_raw( $url ), $args );
	if ( is_wp_error( $response ) ) {
		return array( false, $response );
	}
	$body = wp_remote_retrieve_body( $response );
	return array( json_decode( $body, true ), $response );
}
