<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;

class Cmatic_File_Logger {

	private $is_write_enabled = false;

	private $log_prefix;

	public function __construct( $context = 'ChimpMatic', $enabled = false ) {

		$this->is_write_enabled = (bool) $enabled && ( defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG );
		$this->log_prefix       = '[' . sanitize_key( $context ) . ']';
	}

	public function log( $level, $content, $object = null ) {
		if ( ! $this->is_write_enabled ) {
			return;
		}

		$level_str = is_numeric( $level ) ? $this->map_numeric_level_to_string( $level ) : strtoupper( $level );
		$message   = "[ChimpMatic Lite] {$this->log_prefix} [{$level_str}] " . trim( $content );

		if ( ! is_null( $object ) ) {
			$object_string = is_string( $object ) ? $object : print_r( $object, true );
			$message      .= ' | Data: ' . $object_string;
		}

		error_log( $message );
	}

	private function map_numeric_level_to_string( $numeric_level ) {
		switch ( (int) $numeric_level ) {
			case 1:
				return 'INFO';
			case 2:
				return 'DEBUG';
			case 3:
				return 'WARNING';
			case 4:
				return 'ERROR';
			case 5:
				return 'CRITICAL';
			default:
				return 'UNKNOWN';
		}
	}
}
