<?php
/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;


function cmatic_daily_disable_logging_job() {
	global $wpdb;
	// SEC-FIX: Used $wpdb->prepare() for security best practices.
	$option_names = $wpdb->get_col( $wpdb->prepare( "SELECT option_name FROM {$wpdb->options} WHERE option_name LIKE %s", 'cf7_mch_%' ) );

	foreach ( $option_names as $option_name ) {
		$config = get_option( $option_name );
		if ( is_array( $config ) && isset( $config['logfileEnabled'] ) ) {
			unset( $config['logfileEnabled'] );
			update_option( $option_name, $config );
		}
	}
}
add_action( 'cmatic_daily_cron', 'cmatic_daily_disable_logging_job' );


function cmatic_schedule_daily_cron() {
	if ( ! wp_next_scheduled( 'cmatic_daily_cron' ) ) {
		// Schedule to run once daily, at a low-traffic time.
		wp_schedule_event( strtotime( '03:00:00' ), 'daily', 'cmatic_daily_cron' );
	}
}
add_action( 'init', 'cmatic_schedule_daily_cron' );


function cmatic_clear_scheduled_events() {
	wp_clear_scheduled_hook( 'cmatic_daily_cron' );
}
register_deactivation_hook( SPARTAN_MCE_PLUGIN_FILE, 'cmatic_clear_scheduled_events' );
