<?php
/**
 * ClickSyncr Metrics - PSR-4 Autoloader
 *
 * Portable telemetry system for WordPress plugins.
 *
 * @package ClickSyncr\Metrics
 * @since 1.0.0
 * @version 1.0.0
 */

/*
 * This file is part of Contact Form 7 Extension For Mailchimp.
 *
 * Copyright (C) 2010-2025, Renzo Johnson (email: renzo.johnson at gmail.com)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code, or visit:
 * https://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit;

spl_autoload_register(
	function ( $class ) {
		// Project-specific namespace prefix.
		$prefix = 'ClickSyncr\\Metrics\\';

		// Base directory for the namespace prefix.
		$base_dir = __DIR__ . '/';

		// Does the class use the namespace prefix?
		$len = strlen( $prefix );
		if ( strncmp( $prefix, $class, $len ) !== 0 ) {
			// No, move to the next registered autoloader.
			return;
		}

		// Get the relative class name.
		$relative_class = substr( $class, $len );

		// Replace the namespace prefix with the base directory, replace namespace
		// separators with directory separators in the relative class name, append
		// with .php.
		$file = $base_dir . str_replace( '\\', '/', $relative_class ) . '.php';

		// If the file exists, require it.
		if ( file_exists( $file ) ) {
			require $file;
		}
	}
);
